<?php
namespace ahura\app;
use ahura\app\elementor\Ahura_Elementor_Builder;
use ahura\app\traits\Singleton;

class mw_metabox
{
    use Singleton;
    public function __construct()
    {
        add_action('add_meta_boxes_testimonial', [$this, 'testimonial_init']);
        add_action('save_post_testimonial', [$this, 'store_testimonial_metabox']);
        add_action('add_meta_boxes_page', [$this, 'pages_init']);
        add_action('add_meta_boxes', [$this, 'posts_init']);
        add_action('save_post_page', [$this, 'store_page_metaboxes_data']);
        add_action('save_post', [$this, 'hide_thumbnail_save'] );
        add_action('save_post', [$this, 'ahura_fonts_variations_box_save'] );
        add_action('save_post', [$this, '_custom_meta_box_save']);
    }

    public function testimonial_init()
    {
        add_meta_box('testimonial_author', __("Author", 'ahura'), [__CLASS__, 'testimonial_author'], 'testimonial', 'side');
    }
    public function pages_init()
    {
        add_meta_box('ahura_header', __('Header Options', 'ahura'), [__CLASS__, 'header_metabox_c'], 'page', 'side');
        add_meta_box('ahura_page_breadcrumb', __("Breadcrumb", 'ahura'), [__CLASS__, 'page_breadcrumb_c'], 'page', 'side');
        add_meta_box('ahura_footer', __('Footer Options', 'ahura'), [__CLASS__, 'footer_metabox_c'], 'page', 'side');
    }
    public function posts_init()
    {
        add_meta_box('hide_thumbnail_box', __("Hide Thumbnail", 'ahura'), [__CLASS__, 'hide_thumbnail'], 'post');
        add_meta_box('ahura_fonts_variations_box', __("Font Variations", 'ahura'), [__CLASS__, 'ahura_fonts_variations_box'], 'ahura_fonts');
        add_meta_box('portfolio_meta_box', __("Portfolio Information", 'ahura'), [__CLASS__, 'portfolio_meta_box'], 'portfolio');
        add_meta_box('team_member_meta_box', __("Team Member Information", 'ahura'), [__CLASS__, 'team_member_meta_box'], 'team');

        if(mw_options::is_movie_theme_mode()){
            add_meta_box('movie-meta-box', __('Movie Meta Box', 'ahura'), [__CLASS__, 'handle_movie_meta_box_content'], 'post');
        }
        if(mw_options::is_estate_theme_mode()){
            add_meta_box('estate-meta-box', __('Real Estate Meta Box', 'ahura'), [__CLASS__, 'handle_estate_meta_box_content'], 'post');
        }
    }
    static function testimonial_author($post)
    {
        $username = \ahura\app\mw_options::get_testimonial_username($post->ID);
        $sitename = \ahura\app\mw_options::get_testimonial_sitename($post->ID);
        ?>
        <p>
            <label for="mw_testimonial_username"><?php _e("User Displayname:", 'ahura');?></label>
        </p>
        <p>
            
            <input id="mw_testimonial_username" value="<?php echo $username ? $username : false?>" type="text" placeholder="e.g. John Doe" name="mw_testimonial_username">
        </p>
        <p>
            <label for="mw_testimonial_user_sitename"><?php _e("User Site Name:", 'ahura');?></label>
        </p>
        <p>
            <input type="text" value="<?php echo $sitename ? $sitename : '';?>" id="mw_testimonial_user_sitename" placeholder="e.g. Mihan Wordpress" name="mw_testimonial_user_sitename">
        </p>
        <?php
    }
    static function header_metabox_c($post)
    {
        $pid = $post->ID;
        $header_template_id = mw_options::get_page_custom_header_template($pid);
        $footer_template_id = mw_options::get_page_custom_footer_template($pid);
        $is_sticky_mode = mw_options::get_page_is_sticky_header($pid);
        $is_transparent_mode = mw_options::get_page_is_transparent_header($pid);
        $is_float_mode = mw_options::get_page_is_float_mode_header($pid);
        $is_header_bg_filter = mw_options::get_page_is_header_bg_filter($pid);

        $headers = [];
        $section_list = null;
        if (\ahura\app\mw_options::is_ahura_builder_accessible()){
            $sectionBuilder = new \ahura\app\elementor\Ahura_Elementor_Builder();
            $section_list = $sectionBuilder->getHeaders(get_theme_mod('custom_header'));
        }
        if($section_list){
            foreach($section_list as $section) {
                $headers[$section->ID] = $section->post_title;
            }
        } else {
            $headers[1] = esc_html__('Nothing found', 'ahura');
        }
        ?>
        <div id="ahura-page-header-options">
            <div class="ahura_header_select_template">
                <label for="ahura_custom_header_template"><?php _e("Header template", 'ahura');?></label>
                <select id="ahura_custom_header_template" name="ahura_custom_header_template">
                    <option value="0"><?php echo esc_html__('None', 'ahura'); ?></option>
                    <?php foreach($headers as $id => $header): ?>
                        <option value="<?php echo $id; ?>"<?php echo $header_template_id == $id ? ' selected' : ''; ?>>
                            <?php echo $header; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div id="ahura_header_sticky_options" class="ah-header-sticky">
                <h3><?php esc_html_e('Sticky mode', 'ahura')?></h3>
                <p>
                    <input checked type="radio" name="ahura_sticky_header" id="ahura_sticky_header_default" value="0">
                    <label for="ahura_sticky_header_default"><?php _e("Default", 'ahura');?></label>
                </p>
                <p>
                    <input <?php checked(1, $is_sticky_mode)?> type="radio" name="ahura_sticky_header" id="ahura_sticky_header_active" value="active">
                    <label for="ahura_sticky_header_active"><?php _e("Active", 'ahura');?></label>
                </p>
                <p>
                    <input <?php checked(2, $is_sticky_mode)?> type="radio" name="ahura_sticky_header" id="ahura_sticky_header_inactive" value="inactive">
                    <label for="ahura_sticky_header_inactive"><?php _e("Inactive", 'ahura');?></label>
                </p>
            </div>
            <div id="ahura_header_transparency_options" class="ah-header-transparent">
                <h3><?php esc_html_e('Transparency', 'ahura')?></h3>
                <p>
                    <input checked type="radio" name="ahura_transparent_header" value="0" id="ahura_transparent_header_default">
                    <label for="ahura_transparent_header_default"><?php esc_html_e('Default', 'ahura')?></label>
                </p>
                <p>
                    <input <?php checked(1, $is_transparent_mode)?> type="radio" name="ahura_transparent_header" id="ahura_transparent_header_active" value="active">
                    <label for="ahura_transparent_header_active"><?php _e("Active", 'ahura');?></label>
                </p>
                <p>
                    <input <?php checked(2, $is_transparent_mode)?> type="radio" name="ahura_transparent_header" id="ahura_transparent_header_deactive" value="deactive">
                    <label for="ahura_transparent_header_deactive"><?php _e("Inactive", 'ahura');?></label>
                </p>
            </div>
            <div id="ahura_header_float_mode" class="ah-header-float-mode">
                <h3><?php esc_html_e('Float Mode', 'ahura')?></h3>
                <p>
                    <input <?php checked($is_float_mode, 0);?> type="radio" id="ahura_float_mode_header_inactive" value="0" name="ahura_float_mode_header">
                    <label for="ahura_float_mode_header_inactive"><?php esc_html_e('Inactive', 'ahura')?></label>
                </p>
                <p>
                    <input <?php checked($is_float_mode, 1);?> type="radio" name="ahura_float_mode_header" id="ahura_float_mode_header_active" value="active">
                    <label for="ahura_float_mode_header_active"><?php esc_html_e('Active', 'ahura')?></label>
                </p>
            </div>
            <div id="ahura_header_bg_filter" class="ah-header-bg-filter" style="display:<?php echo $is_sticky_mode == 1 && $is_float_mode == 1 && $is_transparent_mode == 1 ? 'block' : 'none' ?>">
                <h3><?php esc_html_e('Filter Header Background on Scroll', 'ahura')?></h3>
                <p>
                    <input <?php checked($is_header_bg_filter, 0);?> type="radio" id="ahura_float_mode_header_inactive" value="0" name="ahura_bg_filter_header">
                    <label for="ahura_bg_filter_header_inactive"><?php esc_html_e('Inactive', 'ahura')?></label>
                </p>
                <p>
                    <input <?php checked($is_header_bg_filter, 1);?> type="radio" id="ahura_bg_filter_header_active" value="active" name="ahura_bg_filter_header">
                    <label for="ahura_bg_filter_header_active"><?php esc_html_e('Active', 'ahura')?></label>
                </p>
                <p class="description"><?php echo __('When the user scrolls, for better readability of the content, the background of the header disappears or its color changes (note: the header must be without background or transparent).', 'ahura') ?></p>
            </div>
        </div>
        <?php
    }
    static function footer_metabox_c($post)
    {
        $pid = $post->ID;
        $footer_template_id = mw_options::get_page_custom_footer_template($pid);

        $footers = [];
        $section_list = null;
        if (\ahura\app\mw_options::is_ahura_builder_accessible()){
            $sectionBuilder = new \ahura\app\elementor\Ahura_Elementor_Builder();
            $section_list = $sectionBuilder->getFooters(get_theme_mod('custom_footer'));
        }
        if($section_list){
            foreach($section_list as $section) {
                $footers[$section->ID] = $section->post_title;
            }
        } else {
            $footers[1] = esc_html__('Nothing found', 'ahura');
        }
        ?>
        <div id="ahura-page-footer-options">
            <div class="ahura_footer_select_template">
                <label for="ahura_custom_footer_template"><?php _e("Footer template", 'ahura');?></label>
                <select id="ahura_custom_footer_template" name="ahura_custom_footer_template">
                    <option value="0">
                        <?php echo esc_html__('None', 'ahura'); ?>
                    </option>
                    <?php foreach($footers as $id => $footer): ?>
                        <option value="<?php echo $id; ?>"<?php echo $footer_template_id == $id ? ' selected' : ''; ?>>
                            <?php echo $footer; ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </div>
        <?php
    }
    static function hide_thumbnail()
    {
        ?>
        <p>
            <input type="checkbox" id="hide_thumbnail" name="hide_thumbnail" value="check_hide_thumbnail" <?php if ( get_post_meta(get_the_ID(),'hide_thumbnail') !== null ){checked( get_post_meta(get_the_ID(),'hide_thumbnail',true), 'no' );} ?> >
            <label for="hide_thumbnail"><?php echo __('Hide Post Thumbnail','ahura')?></label>
        </p>
        <?php
    }
    public function hide_thumbnail_save($post_id) {
        if( isset( $_POST[ 'hide_thumbnail' ] ) ) {
            update_post_meta( $post_id, 'hide_thumbnail', 'no' );
        } else {
            update_post_meta( $post_id, 'hide_thumbnail', 'yes' );
        }
    }
    static function page_breadcrumb_c($post)
    {
        $current = mw_options::get_page_breadcrumb_status($post->ID);
        ?>
        <p>
            <select name="page_breadcrumb" id="page_breadcrumb">
                <option value="0"><?php _e('Default Settings', 'ahura'); ?></option>
                <option <?php selected('show', $current); ?> value="show"><?php _e('Show Breadcrumb', 'ahura'); ?></option>
                <option <?php selected('hide', $current); ?> value="hide"><?php _e('Hide Breadcrumb', 'ahura');?></option>
            </select>
        </p>
        <?php
    }
    static function ahura_fonts_variations_box(){
        $items = get_post_meta(get_the_ID(), 'font_variations');
        ?>
        <div id="variations">
            <?php
            if($items && array_key_exists(0, $items) && is_array($items[0])):
                foreach($items[0] as $key => $item):
                    $woff = $item['woff']['url'] ?? '';
                    $woff2 = $item['woff2']['url'] ?? '';
                    $ttf = $item['ttf']['url'] ?? '';
                    $svg = $item['svg']['url'] ?? '';
                    $eot = $item['eot']['url'] ?? '';
                ?>
            <div class="var-item" data-num="<?= $key ?>">
                <div class="head">
                    <div class="opt">
                        <label for="font_face[<?= $key ?>][font_weight]"><?= esc_html__('Weight', 'ahura') ?></label>
                        <select name="font_face[<?= $key ?>][font_weight]">
                            <option <?php selected($item['font_weight'], 'normal') ?> value="normal"><?= esc_html__('Normal', 'ahura') ?></option>
                            <option <?php selected($item['font_weight'], 'bold') ?> value="bold"><?= esc_html__('Bold', 'ahura') ?></option>
                            <option <?php selected($item['font_weight'], '100') ?> value="100">100</option>
                            <option <?php selected($item['font_weight'], '200') ?> value="200">200</option>
                            <option <?php selected($item['font_weight'], '300') ?> value="300">300</option>
                            <option <?php selected($item['font_weight'], '400') ?> value="400">400</option>
                            <option <?php selected($item['font_weight'], '500') ?> value="500">500</option>
                            <option <?php selected($item['font_weight'], '600') ?> value="600">600</option>
                            <option <?php selected($item['font_weight'], '700') ?> value="700">700</option>
                            <option <?php selected($item['font_weight'], '800') ?> value="800">800</option>
                            <option <?php selected($item['font_weight'], '900') ?> value="900">900</option>
                        </select>
                    </div>
                    <div class="btns">
                        <a href="#" class="var-action" data-type="edit"><span class="dashicons dashicons-edit"></span> <?= esc_html__('Edit', 'ahura') ?></a>
                        <a href="#" class="var-action var-delete" data-type="delete"><span class="dashicons dashicons-trash"></span> <?= esc_html__('Delete', 'ahura') ?></a>
                    </div>
                </div>
                <div class="vars-list" style="display: none">
                    <div class="vars">
                        <div class="item">
                            <input type="hidden" name="font_face[<?= $key ?>][woff][url]" value="<?= $woff ?>">
                            <span class="dashicons dashicons-no-alt empty-var-field" style="display:<?= ($woff) ? 'inline' : 'none' ?>"></span>
                            <button type="button" class="ahura-font-upload <?= ($woff) ? 'success' : '' ?>">
                                <?= esc_html__('Select WOFF File', 'ahura') ?>
                            </button>
                        </div>
                        <div class="item">
                            <input type="hidden" name="font_face[<?= $key ?>][woff2][url]" value="<?= $woff2 ?>">
                            <span class="dashicons dashicons-no-alt empty-var-field" style="display:<?= ($woff2) ? 'inline' : 'none' ?>"></span>
                            <button type="button" class="ahura-font-upload <?= ($woff2) ? 'success' : '' ?>">
                                <?= esc_html__('Select WOFF2 File', 'ahura') ?>
                            </button>
                        </div>
                        <div class="item">
                            <input type="hidden" name="font_face[<?= $key ?>][ttf][url]" value="<?= $ttf ?>">
                            <span class="dashicons dashicons-no-alt empty-var-field" style="display:<?= ($ttf) ? 'inline' : 'none' ?>"></span>
                            <button type="button" class="ahura-font-upload <?= ($ttf) ? 'success' : '' ?>">
                                <?= esc_html__('Select TTF File', 'ahura') ?>
                            </button>
                        </div>
                        <div class="item">
                            <input type="hidden" name="font_face[<?= $key ?>][svg][url]" value="<?= $svg ?>">
                            <span class="dashicons dashicons-no-alt empty-var-field" style="display:<?= ($svg) ? 'inline' : 'none' ?>"></span>
                            <button type="button" class="ahura-font-upload <?= ($svg) ? 'success' : '' ?>">
                                <?= esc_html__('Select SVG File', 'ahura') ?>
                            </button>
                        </div>
                        <div class="item">
                            <input type="hidden" name="font_face[<?= $key ?>][eot][url]" value="<?= $eot ?>">
                            <span class="dashicons dashicons-no-alt empty-var-field" style="display:<?= ($eot) ? 'inline' : 'none' ?>"></span>
                            <button type="button" class="ahura-font-upload <?= ($eot) ? 'success' : '' ?>">
                                <?= esc_html__('Select EOT File', 'ahura') ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
                <?php
                endforeach;
            endif; ?>
        </div>
        <button type="button" class="button add-font-variation"><?= esc_html__('Add Font Variation', 'ahura') ?></button>
        <?php
    }
    public function ahura_fonts_variations_box_save($post_id){
        update_post_meta($post_id, 'font_variations', ($_POST['font_face'] ?? ''));
    }
    public function store_testimonial_metabox($post_id)
    {
        $username = isset($_POST['mw_testimonial_username']) && $_POST['mw_testimonial_username'] ? sanitize_text_field($_POST['mw_testimonial_username']) : false;
        $sitename = isset($_POST['mw_testimonial_user_sitename']) && $_POST['mw_testimonial_user_sitename'] ? sanitize_text_field($_POST['mw_testimonial_user_sitename']) : false;
        if($username)
        {
            \ahura\app\mw_options::set_testimonial_username($post_id, $username);
        }else{
            \ahura\app\mw_options::remove_testimonial_username($post_id);
        }
        if($sitename)
        {
            \ahura\app\mw_options::set_testimonial_sitename($post_id, $sitename);
        }else{
            \ahura\app\mw_options::remove_testimonial_sitename($post_id);
        }
    }
    public function store_page_metaboxes_data($pid)
    {
        self::store_page_header_metabox($pid);
        self::store_page_breadcrumb_metabox($pid);
        self::store_page_footer_metabox($pid);
    }
    static function store_page_header_metabox($pid)
    {
        if(isset($_SERVER['HTTP_REFERER']) && ahura_str_contains($_SERVER['HTTP_REFERER'], 'action=elementor')){
            return false;
        }
        
        $custom_header_template_id = isset($_POST['ahura_custom_header_template']) && $_POST['ahura_custom_header_template'] ? $_POST['ahura_custom_header_template'] : false;
        if($custom_header_template_id) {
            mw_options::set_page_custom_header_template($pid, $custom_header_template_id);
        } else {
            mw_options::remove_page_custom_header_template($pid);
        }

        $is_sticky_mode = isset($_POST['ahura_sticky_header']) && $_POST['ahura_sticky_header'] ? $_POST['ahura_sticky_header'] : false;
        if($is_sticky_mode) {
            $is_sticky_mode_status = $is_sticky_mode == 'active' ? 1 : 2;
            mw_options::set_page_is_sticky_header($pid, $is_sticky_mode_status);
        } else {
            mw_options::remove_page_is_sticky_header($pid);
        }

        $is_transparent_mode = isset($_POST['ahura_transparent_header']) && $_POST['ahura_transparent_header'] ? $_POST['ahura_transparent_header'] : false;
        if($is_transparent_mode) {
            $transparency_status = $is_transparent_mode == 'active' ? 1 : 2;
            mw_options::set_page_is_transparent_header($pid, $transparency_status);
        } else {
            mw_options::remove_page_is_transparent_header($pid);
        }

        $is_float_mode = isset($_POST['ahura_float_mode_header']) && $_POST['ahura_float_mode_header'] ? $_POST['ahura_float_mode_header'] : false;
        if($is_float_mode) {
            mw_options::set_page_is_float_mode_header($pid);
        } else {
            mw_options::remove_page_is_float_mode_header($pid);
        }

        $is_bg_filter_header = isset($_POST['ahura_bg_filter_header']) && $_POST['ahura_bg_filter_header'] ? $_POST['ahura_bg_filter_header'] : false;
        if($is_bg_filter_header){
            mw_options::set_page_is_header_bg_filter($pid);
        } else {
            mw_options::remove_page_is_header_bg_filter($pid);
        }
    }
    static function store_page_breadcrumb_metabox($pid)
    {
        $page_breadcrumb = isset($_POST['page_breadcrumb']) ? $_POST['page_breadcrumb'] : false;
        if(!$page_breadcrumb)
        {
            // set deafult mode
            mw_options::remove_page_show_breadcrumb($pid);

        }
        if($page_breadcrumb == 'show')
        {
            mw_options::set_page_show_breadcrumb($pid);
        }elseif($page_breadcrumb == 'hide'){
            mw_options::set_page_hide_breadcrumb($pid);
        }
    }
    static function store_page_footer_metabox($pid)
    {
        if(isset($_SERVER['HTTP_REFERER']) && ahura_str_contains($_SERVER['HTTP_REFERER'], 'action=elementor')){
            return false;
        }
        
        $custom_footer_template_id = isset($_POST['ahura_custom_footer_template']) && $_POST['ahura_custom_footer_template'] ? $_POST['ahura_custom_footer_template'] : false;
        if($custom_footer_template_id) {
            mw_options::set_page_custom_footer_template($pid, $custom_footer_template_id);
        } else {
            mw_options::remove_page_custom_footer_template($pid);
        }
    }

    /**
     * 
     * Portfolio post type meta box
     * 
     */
    public static function portfolio_meta_box($post){
        $path = get_theme_file_path("template-parts/admin/meta-boxs/portfolio.php");
        if(file_exists($path) && is_readable($path)){
            include($path);
        }
    }

    public static function team_member_meta_box($post){
        $path = get_theme_file_path("template-parts/admin/meta-boxs/team.php");
        if(file_exists($path) && is_readable($path)){
            include($path);
        }
    }

    public static function handle_movie_meta_box_content($post)
    {
        $post_id = $post->ID;
        $subtitle = Post_Meta::get_post_subtitle($post_id);
        $large_cover = Post_Meta::get_post_large_cover($post_id);
        $download_status = Post_Meta::is_active_download_box($post_id);
        $download_items = Post_Meta::get_download_items($post_id);
        $files_password = Post_Meta::get_files_password($post_id);
        ?>
        <div class="ahura-post-meta-box">
            <div class="meta-item">
                <label for="_subtitle"><?php echo __('Sub Title', 'ahura') ?></label>
                <input type="text" name="_subtitle" id="sub_title" value="<?php echo $subtitle ?>">
            </div>
            <div class="meta-item">
                <label for="_subtitle"><?php echo __('Large Cover', 'ahura') ?></label>
                <?php
                mw_tools::render_uploader_field([
                    'type' => 'image',
                    'name' => '_large_cover',
                    'value' => $large_cover,
                    'return_type' => 'url',
                    'box_atts' => [
                        'style' => 'max-width:600px;min-height:300px;'
                    ]
                ]);
                ?>
                <p><?php echo __('It is used in cases such as background and large sliders.', 'ahura') ?></p>
            </div>
            <div class="meta-item">
                <label for="_download_box_status">
                    <input type="checkbox" name="_download_box_status" id="_download_box_status" value="1" <?php checked($download_status, 1) ?>>
                    <?php echo __('Active Download Box', 'ahura') ?>
                </label>
                <div class="meta-item">
                    <label for="_files_password"><?php echo __('Files Password', 'ahura') ?></label>
                    <input type="text" name="_files_password" id="_files_password" value="<?php echo $files_password ?>" list="recommended-passwords">
                    <datalist id="recommended-passwords">
                        <option value="<?php echo $_SERVER['SERVER_NAME'] ?>">
                    </datalist>
                </div>
                <div class="repeater-items ahura-repeater-items">
                    <?php if (!empty($download_items)): ?>
                        <?php foreach ($download_items as $key => $item): ?>
                            <div class="repeater-item" data-item-id="<?php echo $key ?>">
                                <div class="repeater-action-buttons">
                                    <a href="#" class="add-repeater-item">+</a>
                                    <a href="#" class="remove-repeater-item">-</a>
                                </div>
                                <label for="field-<?php echo $key ?>"><?php echo __('Title', 'ahura') ?></label>
                                <input type="text" name="_download_items[<?php echo $key ?>][title]" id="field-<?php echo $key ?>" value="<?php echo $item['title'] ?>">
                                <label for="field-<?php echo $key ?>"><?php echo __('Link', 'ahura') ?></label>
                                <input type="url" name="_download_items[<?php echo $key ?>][link]" id="field-<?php echo $key ?>" value="<?php echo $item['link'] ?>">
                            </div>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <div class="repeater-item" data-item-id="0">
                            <div class="repeater-action-buttons">
                                <a href="#" class="add-repeater-item">+</a>
                                <a href="#" class="remove-repeater-item">-</a>
                            </div>
                            <label for=""><?php echo __('Title', 'ahura') ?></label>
                            <input type="text" name="_download_items[0][title]">
                            <label for=""><?php echo __('Link', 'ahura') ?></label>
                            <input type="url" name="_download_items[0][link]">
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php
    }

    public static function handle_estate_meta_box_content($post)
    {
        $post_id = $post->ID;
        $address = Post_Meta::get_item_address($post_id);
        $price = Post_Meta::get_item_price($post_id);
        $monthly_price = Post_Meta::get_item_monthly_price($post_id);
        $bedrooms = Post_Meta::get_bedrooms($post_id);
        $has_elevator = Post_Meta::has_elevator($post_id);
        $feature_list = Post_Meta::get_features_list($post_id);
        $active_features = Post_Meta::is_active_features_box($post_id);
        $type = Post_Meta::get_estate_type($post_id);
        ?>
        <div class="ahura-post-meta-box">
            <div class="meta-item">
                <div class="ah-note"><?php _e('It is possible to change the currency unit from Customization > General Settings.', 'ahura') ?></div>
                <label for="_item_address"><?php echo __('Type', 'ahura') ?></label>
                <div class="meta-item-input">
                    <select name="_item_estate_type" id="_item_estate_type">
                        <option <?php selected($type, 'sale') ?> value="sale"><?php _e('Sale', 'ahura') ?></option>
                        <option <?php selected($type, 'rent') ?> value="rent"><?php _e('Rent', 'ahura') ?></option>
                    </select>
                </div>
            </div>
            <div class="meta-item">
                <label for="_item_price"><?php echo __('Price', 'ahura') ?> (<?php echo mw_options::get_theme_currency_unit() ?>)</label>
                <div class="meta-item-input">
                    <input type="number" dir="ltr" min="1" name="_item_price" id="_item_price" value="<?php echo $price ?>">
                </div>
            </div>
            <hr>
            <div class="meta-item">
                <label for="_item_monthly_price"><?php echo __('Monthly Price', 'ahura') ?> (<?php echo mw_options::get_theme_currency_unit() ?>)</label>
                <div class="meta-item-input">
                    <input type="number" dir="ltr" min="1" name="_item_monthly_price" id="_item_monthly_price" value="<?php echo $monthly_price ?>">
                </div>
            </div>
            <hr>
            <div class="meta-item">
                <label for="_item_address"><?php echo __('Address', 'ahura') ?></label>
                <div class="meta-item-input">
                    <textarea name="_item_address" id="_item_address"><?php echo $address ?></textarea>
                </div>
            </div>
            <div class="meta-item">
                <label for="_item_bedrooms"><?php echo __('Bedroom', 'ahura') ?></label>
                <div class="meta-item-input">
                    <input type="number" dir="ltr" min="1" step="1" name="_item_bedrooms" id="_item_bedrooms" value="<?php echo $bedrooms ?>">
                </div>
            </div>
            <div class="meta-item">
                <label for="_has_elevator">
                    <input type="checkbox" name="_has_elevator" id="_has_elevator" value="1" <?php checked($has_elevator, 1) ?>>
                    <?php echo __('Elevator', 'ahura') ?>
                </label>
            </div>
            <div class="meta-item">
                <label for="_features_box_status">
                    <input type="checkbox" name="_features_box_status" id="__features_box_status" value="1" <?php checked($active_features, 1) ?>>
                    <?php echo __('Features Box', 'ahura') ?>
                </label>
            </div>
            <div class="repeater-items ahura-repeater-items">
                <?php if (!empty($feature_list)): ?>
                    <?php foreach ($feature_list as $key => $item): ?>
                        <div class="repeater-item" data-item-id="<?php echo $key ?>">
                            <div class="repeater-action-buttons">
                                <a href="#" class="add-repeater-item">+</a>
                                <a href="#" class="remove-repeater-item">-</a>
                            </div>
                            <label for="field-<?php echo $key ?>"><?php echo __('Title', 'ahura') ?></label>
                            <input type="text" name="_features_list[<?php echo $key ?>][title]" id="field-<?php echo $key ?>" value="<?php echo $item['title'] ?>">
                            <label for="field-<?php echo $key ?>"><?php echo __('Value', 'ahura') ?></label>
                            <input type="text" name="_features_list[<?php echo $key ?>][value]" id="field-<?php echo $key ?>" value="<?php echo $item['value'] ?>">
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <div class="repeater-item" data-item-id="0">
                        <div class="repeater-action-buttons">
                            <a href="#" class="add-repeater-item">+</a>
                            <a href="#" class="remove-repeater-item">-</a>
                        </div>
                        <label for=""><?php echo __('Title', 'ahura') ?></label>
                        <input type="text" name="_features_list[0][title]">
                        <label for=""><?php echo __('Value', 'ahura') ?></label>
                        <input type="text" name="_features_list[0][value]">
                    </div>
                <?php endif; ?>
            </div>
        </div>
    <?php
    }

    public function _custom_meta_box_save($post_id){
        $metas = array(
            '_gallery_images' => [],
            '_gallery_videos' => [],
            '_portfolio_customer_name' => [],
            '_portfolio_website' => [],
            '_portfolio_year' => [],

            '_team_subtitle' => [],
            '_team_video_url' => [],
            '_team_options' => ['type' => 'array'],
            '_team_socials' => ['type' => 'array'],
        );

        if(mw_options::is_movie_theme_mode()){
            $metas = array_merge($metas, [
                '_subtitle' => [],
                '_large_cover' => [],
                '_download_box_status' => ['type' => 'checkbox'],
                '_files_password' => [],
                '_download_items' => ['type' => 'array'],
            ]);
        }

        if(mw_options::is_estate_theme_mode()){
            $metas = array_merge($metas, [
                '_item_estate_type' => [],
                '_item_address' => [],
                '_item_price' => [],
                '_item_monthly_price' => [],
                '_item_bedrooms' => [],
                '_has_elevator' => ['type' => 'checkbox'],
                '_features_box_status' => ['type' => 'checkbox'],
                '_features_list' => ['type' => 'array'],
            ]);
        }

        foreach ($metas as $meta_key => $options){
            $type = isset($options['type']) ? $options['type'] : false;
            $value = isset($_POST[$meta_key]) ? (empty($type) || $type != 'array' ? sanitize_text_field($_POST[$meta_key]) : $_POST[$meta_key]) : false;
            if($type == 'checkbox'){
                if($value){
                    update_post_meta($post_id, $meta_key, $value);
                } else {
                    delete_post_meta($post_id, $meta_key);
                }
            } else {
                update_post_meta($post_id, $meta_key, $value);
            }
        }
    }

    public static function isFirstTimeLicenseActivation()
    {
        $licenseStatus = get_option('ahura_license_key', null);
        $licenseExpire = get_option('ahura_license_expiration_date', null);
        $activationTime = get_option('ahura_first_activation_time', null);
        return is_null($activationTime) && is_null($licenseExpire) && is_null($licenseStatus);
    }
}