<?php
namespace ahura\app\elementor\settings;

use Elementor\Controls_Manager;
use ahura\app\elementor\Ahura_Elements_Settings;

class Additional_Controls extends Ahura_Elements_Settings
{
    const TAB_NAME = 'ahura-element-settings';
    const SECTION_PREFIX = 'ahura_element_settings_';

    public function __construct() {
        parent::__construct();
        $this->register_elementor_settings('ah_element_additional_settings');
    }

    public function register_section($element) {
        if($element->get_type() == 'widget'){
            $element->start_controls_section(
                self::TAB_NAME . '_additional_settings',
                [
                    'tab'   => Controls_Manager::TAB_CONTENT,
                    'label' => __('Additional Settings (ahura)', 'ahura'),
                ]
            );

            $element->add_control(
                self::SECTION_PREFIX . 'filter_dark_text_notice',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'raw' => __('You can use this option to apply a dark mode filter on the text of other elements.', 'ahura'),
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
                ]
            );

            $element->add_control(
                self::SECTION_PREFIX . 'filter_text_dark_mode',
                [
                    'label'          => __('Filter text in dark mode', 'ahura'),
                    'type'           => Controls_Manager::SWITCHER,
                    'label_on'       => __( 'Yes', 'ahura' ),
                    'label_off'      => __( 'No', 'ahura' ),
                    'default'        => 'no',
                    'return_value'   => 'yes',
                    'prefix_class'   => 'ahura-dark-mode-filter-texts-',
                ]
            );

            $element->end_controls_section();
        }
    }
}
