<?php
namespace ahura\app;

class Studio {
    /**
     * Demo Studio page filter tabs
     *
     * @return array
     */
    public static function get_filter_tabs(){
        $items = get_option('ahura_demo_categories');
        return ahura_is_json($items) ? json_decode($items, 1) : null;
    }

    /**
     * 
     * Get demo api base url
     * 
     * @return string|boolean
     */
    public static function get_base_url(){
        $license_key = license::get_license_key();
        return mw_tools::getRemoteServerByLicenseKey($license_key);
    }

    /**
     *
     * Check is studio page
     *
     * @return boolean
     */
    public static function is_studio(){
        return (isset($_GET['page']) && in_array($_GET['page'], ['studio', 'ahura_studio'])) || isset($_GET['step']) && $_GET['step'] === 'content';
    }

    public static function save_filter_tabs_from_server()
    {
        $items = Demo_Manager::getCategories();

        if (!empty($items))
            return update_option('ahura_demo_categories', json_encode($items));

        return false;
    }
}