<?php
$image = get_field('about_img', 'option');
$about_small_img = get_field('about_small_img', 'option');
$top_title = get_field('top_title', 'option');
$main_title = get_field('main_title', 'option');
$title = get_field('about_title', 'option');
$text = get_field('about_text', 'option');
$button = get_field('about_btn', 'option');
?>
<section class="about-section" id="about">
    <div class="container">
        <div class="row master-heading">
            <div class="col-12 col-md-10 col-lg-7 mx-auto text-center">
                <?php if ($top_title != '') { ?>
                    <div class="pre-heading">
                        <?php echo $top_title; ?>
                    </div>
                <?php }
                if ($main_title != '') {
                    ?>
                    <h2 class="main-heading">
                        <?php echo $main_title; ?>
                        <span class="accent-color">.</span>
                    </h2>
                <?php } ?>
            </div>
        </div>
        <div class="row align-items-center">
            <div class="col-12 col-md-6 col-lg-5">
                <div class="about-content">
                    <?php
                    if ($title != '') {
                        ?>
                        <h1 class="title line wow fadeInUp" data-wow-delay="0.25s"><?php echo $title; ?></h1>
                    <?php }
                    if ($text != '') {
                        ?>
                        <div class="text mb-5 wow fadeInUp" data-wow-delay="0.5s">
                            <p><?php echo $text; ?></p>
                        </div>
                    <?php }
                    if ($button['link'] != '') {
                        echo '<a href="' . $button['link'] . '" class="theme-button">' . $button['title'] . '<i class="icon-arrow-left"></i></a>';
                    }
                    ?>
                </div>
            </div>

            <!-- Images Column -->
            <div class="col-12 col-md-6 col-lg-7">
                <div class="inner-column position-relative">
                   <?php
                    if ($about_small_img) { ?>
                        <div class="on-image parallax">
                            <img
                                    src="<?php echo $about_small_img['url']; ?>"
                                    width="<?php echo $about_small_img['width']; ?>"
                                    height="<?php echo $about_small_img['height']; ?>"
                                    alt="<?php echo $about_small_img['alt']; ?>"/>
                        </div>
                    <?php }
                    if ($image) { ?>
                        <div class="image">
                            <img
                                    src="<?php echo $image['url']; ?>"
                                    width="<?php echo $image['width']; ?>"
                                    height="<?php echo $image['height']; ?>"
                                    alt="<?php echo $image['alt']; ?>"/>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
</section>
