<?php
add_action( 'plugins_loaded', function () {
add_action( 'jet-engine/register-macros', function(){ 
	
    if ( ! function_exists( 'WC' ) ) {
        return;
    }
  
    class Products_On_Sale_Macro extends \Jet_Engine_Base_Macros {

        public function macros_tag() {
            return 'wc_products_on_sale';
        }

        public function macros_name() {
            return 'WC Products on Sale';
        }

        public function macros_args() {
            return array();
        }

        public function macros_callback( $args = array() ) {

            $on_sale = array_merge( array( 0 ), wc_get_product_ids_on_sale() );
			
            return implode( ',', $on_sale );
				
        }
    }

    new Products_On_Sale_Macro();
    
} );

function display_product_discount_percentage() { 
    // Ensure WooCommerce is active 
    if ( ! class_exists( 'WooCommerce' ) ) { 
        return 'WooCommerce is not active'; 
    } 
 
global $post; 
 
// Get the product ID from the global post object 
$product_id = $post->ID; 
 
// Get the product object 
$product = wc_get_product( $product_id ); 
 
if ( ! $product ) { 
    return false; // Invalid product ID 
} 
 
$discount_percentage = 0; 
 
if ( $product->is_type( 'variable' ) ) { 
    // For variable products, find the min and max discount among variations 
    $min_discount = PHP_INT_MAX; 
    $max_discount = 0; 
    foreach ( $product->get_children() as $variation_id ) { 
        $variation = wc_get_product( $variation_id ); 
        $regular_price = (float) $variation->get_regular_price(); 
        $sale_price = (float) $variation->get_sale_price(); 
 
        if ( $regular_price > 0 && $sale_price > 0 && $regular_price > $sale_price ) { 
            $discount = ( ( $regular_price - $sale_price ) / $regular_price ) * 100; 
            if ( $discount < $min_discount ) { 
                $min_discount = $discount; 
            } 
            if ( $discount > $max_discount ) { 
                $max_discount = $discount; 
            } 
        } 
    } 
    if ( $min_discount == PHP_INT_MAX ) { 
        return false; // No discount available 
    } else { 
        return round( $min_discount ) . '% - ' . round( $max_discount ) . '%'; 
    } 
} elseif ( $product->is_type( 'grouped' ) ) { 
    // For grouped products, find the min and max discount among grouped items 
    $min_discount = PHP_INT_MAX; 
    $max_discount = 0; 
    foreach ( $product->get_children() as $child_id ) { 
        $child_product = wc_get_product( $child_id ); 
        $regular_price = (float) $child_product->get_regular_price(); 
        $sale_price = (float) $child_product->get_sale_price(); 
 
        if ( $regular_price > 0 && $sale_price > 0 && $regular_price > $sale_price ) { 
            $discount = ( ( $regular_price - $sale_price ) / $regular_price ) * 100; 
            if ( $discount < $min_discount ) { 
                $min_discount = $discount; 
            } 
            if ( $discount > $max_discount ) { 
                $max_discount = $discount; 
            } 
        } 
    } 
    if ( $min_discount == PHP_INT_MAX ) { 
        return false; // No discount available 
    } else { 
        return round( $min_discount ) . '% - ' . round( $max_discount ) . '%'; 
    } 
} else { 
    // For simple products 
    $regular_price = (float) $product->get_regular_price(); 
    $sale_price = (float) $product->get_sale_price(); 
 
    if ( $regular_price > 0 && $sale_price > 0 && $regular_price > $sale_price ) { 
        $discount_percentage = ( ( $regular_price - $sale_price ) / $regular_price ) * 100; 
    } 
 
    if ( $discount_percentage > 0 ) { 
        return round( $discount_percentage ) . '%'; 
    } else { 
        return false; // No discount available 
    } 
} 
} 
 
// Register the shortcode 
add_shortcode( 'discount_percentage', 'display_product_discount_percentage' );



// Define the shortcode function
function get_search_query_string() {
    // Check if the 's' parameter exists in the URL query string
    if ( isset( $_GET['s'] ) ) {
        // Return the value of the 's' parameter as a sanitized string
        return sanitize_text_field( $_GET['s'] );
    }
    // If the 's' parameter does not exist, return an empty string or perform another action
    return '';
}

// Add the shortcode 'search_query_string'
add_shortcode( 'search_query_string', 'get_search_query_string' );




function custom_empty_orders_js() {
    if (is_account_page() && is_wc_endpoint_url('orders')) {
        ?>
        <style>
            .woocommerce-MyAccount-content {
                display: none;
            }
        </style>
        <script type="text/javascript">
            document.addEventListener("DOMContentLoaded", function() {
                const woocommerceInfo = document.querySelector(".woocommerce-info");
                const woocommerceInfoBtn = woocommerceInfo?.querySelector("a.woocommerce-Button");

                if (woocommerceInfo) {
                    woocommerceInfo.innerText = "کاربر گرامی شما تا کنون هیچ نوبتی رزرو نکرده اید :)";
                    
                    const baseurl = "<?php echo esc_url(home_url('/')); ?>";

                    if (woocommerceInfoBtn) {
                        woocommerceInfoBtn.innerText = "رزرو نوبت";   
                        woocommerceInfoBtn.setAttribute('href', baseurl + "appointment-reservation/");   
                    }
                    
                    woocommerceInfo.appendChild(woocommerceInfoBtn);
                }

                const content = document.querySelector('.woocommerce-MyAccount-content');
                if (content) {
                    content.style.display = 'block';
                }
            });
        </script>
        <?php
    }
}
add_action('wp_footer', 'custom_empty_orders_js');


}, 9999 );