# Demo Modal

![Demo Modal](https://img.shields.io/badge/Version-1.0-green) ![WordPress](https://img.shields.io/badge/WordPress-5.0%2B-brightgreen)

## Description

The **Demo Modal** plugin is designed to notify users that a website is for demo purposes only and does not involve actual sales. It displays a modal with a warning message on specific pages of your WooCommerce store, helping to prevent misunderstandings.

## Features

- Displays a modal warning message using SweetAlert2.
- Shows a notification message on WooCommerce cart, checkout, and thank you pages.
- Adds a message to WooCommerce emails to inform customers that purchases are for demo purposes only.
- The modal is triggered every three visits.
- Fully customizable text for the modal and notices.
- Admin notice about plugin is enabled

## Installation

1. **Download the Plugin:**
   - Download the latest version of the **Demo Modal** plugin.

2. **Upload the Plugin:**
   - Unzip the downloaded file.
   - Upload the `demo-modal` folder to your WordPress plugins directory, typically located at `wp-content/plugins/`.

3. **Activate the Plugin:**
   - Go to the **Plugins** menu in WordPress.
   - Locate the **Demo Modal** plugin in the list and click **Activate**.

## Usage

Once the plugin is activated, it will automatically start displaying the modal and notifications based on the configured frequency.

### Customizing Messages

You can customize the modal and notification messages by editing the localization files located in the `/languages/` directory of the plugin. The default text can be found in the main class file.

### Example Modal Message
- **Title**: Notice
- **Text**: This site is for demo purposes only and has no actual sales.
- **Confirm Button Text**: OK

## Compatibility

- WordPress version: 5.0 or higher
- Compatible with WooCommerce

## Development

To contribute to this project, you can fork the repository and submit a pull request. For local development, ensure you have a WordPress environment set up.


## Acknowledgments

- Thanks to [SweetAlert2](https://sweetalert2.github.io/) for the amazing modal library.
- Thanks to the WordPress community for their continuous support and development.


## Copyright

&copy; 2024 [abzarwp.com](https://abzarwp.com). All rights reserved.