<?php

/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @package 	WooCommerce/Templates
 * @version     3.9.0
 */

if (!defined('ABSPATH')) {
	exit;
}

if ($related_products) : ?>
	<div class="col-12 pad_700_res" style="margin-top: 1rem!important;">
		<section class="woo-list-slider-owl woo_upsells">
			<header>
				<span><?php esc_html_e('Related products', 'woocommerce'); ?></span>
			</header>
			<div class="wo-box">
				<div class="swiper-container">
					<div class="swiper-wrapper">
						<div class="owl-one owl-carousel owl-theme sec-promotions" style=" width: 100%;">
							<?php foreach ($related_products as $related_product) :

								$post_object = get_post($related_product->get_id());

								setup_postdata($GLOBALS['post'] = &$post_object);

								wc_get_template_part('content', 'product'); ?>

							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</section>
	</div>
<?php endif;
wp_reset_postdata();
