<?php


// Required File

class Plugin {

	private static $_instance = null;

	public static function instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	public function widget_scripts() {
		wp_register_script( 'widget', plugins_url( '/assets/js/widget.js', __FILE__ ), [ 'jquery' ], false, true );
	}
  public function widget_styles() {

	}
	private function include_widgets_files() {
		// Include Widget files shop
		require_once( __DIR__ . '/widgets/product/amazing-offer.php' );
		require_once( __DIR__ . '/widgets/product/product-amazon-cat-box.php' );
		require_once( __DIR__ . '/widgets/product/product-amazon_slid.php' );
		require_once( __DIR__ . '/widgets/product/amazon-cat-slid.php' );
		require_once( __DIR__ . '/widgets/product/head-slid.php' );
		require_once( __DIR__ . '/widgets/product/image-boxx.php' );
		require_once( __DIR__ . '/widgets/product/questions.php' );
		require_once( __DIR__ . '/widgets/product/products-list.php' );
		require_once( __DIR__ . '/widgets/product/product-select.php' );
		require_once( __DIR__ . '/widgets/product/product-slide.php' );
		require_once( __DIR__ . '/widgets/product/products-categories.php' );
		require_once( __DIR__ . '/widgets/product/product-widget.php' );
		require_once( __DIR__ . '/widgets/product/random.php' );
		// Include Widget files blog
		require_once( __DIR__ . '/widgets/blog/list-item-mega.php' );
		require_once( __DIR__ . '/widgets/blog/header-box.php' );
		require_once( __DIR__ . '/widgets/blog/article-1.php' );
		require_once( __DIR__ . '/widgets/blog/article-2.php' );
		require_once( __DIR__ . '/widgets/blog/article-3.php' );
		require_once( __DIR__ . '/widgets/blog/article-4.php' );
		require_once( __DIR__ . '/widgets/blog/article-5.php' );
		require_once( __DIR__ . '/widgets/blog/slider.php' );
		require_once( __DIR__ . '/widgets/blog/contact.php' );


	}
	public function EWB_add_widget_categories() {

		$elements_manager = Elementor\Plugin::instance()->elements_manager;
		$elements_manager->add_category(
			'elementor-widget-be',
			[
				'title' => __( 'Widget Be Elements blog', 'denver' ),
				'icon'  => 'eicon-font',
			],
			1
		);
	}
	public function SEWB_add_widget_categories() {

		$elements_manager = Elementor\Plugin::instance()->elements_manager;
		$elements_manager->add_category(
			'elementor-widget-be-shop',
			[
				'title' => __( 'Widget Be Elements shop', 'denver' ),
				'icon'  => 'eicon-font',
			],
			1
		);
	}
	public function SEWM_add_widget_categories() {

		$elements_manager = Elementor\Plugin::instance()->elements_manager;
		$elements_manager->add_category(
			'mega-menu',
			[
				'title' => __( 'Mega Menu', 'denver' ),
				'icon'  => 'eicon-font',
			],
			1
		);
	}

	public function register_widgets() {
		// Its is now safe to include Widgets files
		$this->include_widgets_files();
		// Register Widgets shop
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Amazing_Offer() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Product_Amazon_Cat_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Product_Amazon_SLID() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Amazon_Cat_Slid() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Head_Slid() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Background_Image_Written() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Random() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Questions() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Products_Iist() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Selected_Products() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Products_Categories() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Product_Slide() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Product__Widget() );
		// Register widget blog
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \list_Item_Mega() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Header_Box() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Article_1() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Article_2() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Article_3() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Article_4() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Article_5() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Slider() );
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Contact() );
	}

	public function __construct() {
		// Register widget categories mega menu
		add_action( 'elementor/elements/categories_registered', array( $this, 'SEWM_add_widget_categories' ) );
		// Register widget categories shop
		add_action( 'elementor/elements/categories_registered', array( $this, 'SEWB_add_widget_categories' ) );
		// Register widget categories blog
		add_action( 'elementor/elements/categories_registered', array( $this, 'EWB_add_widget_categories' ) );
		// Register widget styles
      	add_action( 'elementor/frontend/after_enqueue_styles', [ $this, 'widget_styles' ] );
		// Register widget scripts
		add_action( 'elementor/frontend/after_register_scripts', [ $this, 'widget_scripts' ] );
		// Register widgets
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}
}
function my_plugin_taxonomy_list( $taxonomy = 'product_cat' ){
    $terms = get_terms( array(
        'taxonomy' => $taxonomy,
        'hide_empty' => true,
    ));
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
        foreach ( $terms as $term ) {
            $options[ $term->slug ] = $term->name;
        }
        return $options;
    }
}

// Instantiate Class
Plugin::instance();
