<?php


require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';


class CLOUD_SSHKEYS_ADMIN
{

    public static function  GetList($token,$idc)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT skid as Keyid,sk_name as name ,sk_prvkey as privatekey , sk_pubkey as publickey from " . 
        $GLOBALS["cloud_sshkey_tablename"] . " where " . $GLOBALS['sk_uid_fk'] . "=" . $uid." and " . $GLOBALS['sk_idcid_fk'] . "=" . $idc;;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => $listOfRecordType];
    }
    public static function GetRandomHash($token)
    {
        $rsa = new Crypt_RSA();
        $rsa->setPublicKeyFormat(CRYPT_RSA_PUBLIC_FORMAT_OPENSSH);
        extract($rsa->createKey());
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => ["publickey" => $publickey, "privatekey" => $privatekey]];
    }
    public static function  GetOneByID($token, $skid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT sk_name as name ,sk_prvkey as privatekey , sk_pubkey as publickey ,sk_serverid as hashkey,sk_idcid_fk as idc
         from " . $GLOBALS["cloud_sshkey_tablename"] . " where " . $GLOBALS['sk_uid_fk'] . "=" . $uid . " and " . $GLOBALS['skid'] . "=" . $skid;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",  ];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success","message"=>"اطلاعات با موفقیت دریافت شد","data"=> mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function RemoveKey($token,$id)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $sshkeys=self::GetOneByID($token, $id);
        if($sshkeys["status"] !="success"){
            return ["status"=>"error","message"=>"اطلاعات ارسالی نامعتبر است"];
        }
         
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail=$usersDetails["userdetail"][0]["umail"];
        $m=str_replace("@","",$mail);
        $m=str_replace(".","",$m);
       
        
         $sql = "DELETE FROM " . $GLOBALS["cloud_sshkey_tablename"] . " WHERE skid='" .$id."'";
        $conn = GetConnection();
        $conn->query($sql);
        $id = API_CLOUD_SSHKEY_ADMIN::RunRemoveSSHKEY($sshkeys["data"][0]["hashkey"],$m,$sshkeys["data"][0]["idc"]);
       $conn->close();
        
        return [  "status" => "success", "message" => "اطلاعات با موفقیت ثبت شد" ];
    }
    public static function AddSSHKEY($token, $pubkey, $prvkey, $name,$idc)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail=$usersDetails["userdetail"][0]["umail"];
        $m=str_replace("@","",$mail);
        $m=str_replace(".","",$m);
        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        $expsession = date("Y/m/d H:i:s");  
        $sid=md5($name. $expsession);
        $sql = "INSERT INTO " . $GLOBALS["cloud_sshkey_tablename"] . " VALUES (0,'" . $prvkey 
        . "','" . $pubkey . "','" . $uid . "','" . $name . "','".$sid."','".$idc."')";
        $conn = GetConnection();
        $conn->query($sql);
        $id = API_CLOUD_SSHKEY_ADMIN::RunCreateAPISSHKEY( $sid,$pubkey,$m,$idc);
        $conn->close();
        
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد",];
    }
}
