<?php


require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';


class CLOUD_PRIVATENETWORKS_ADMIN
{

    public static function  GetList($token, $nid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT cvid as id,cvname as name, cv_iprange as rangeip,cv_gateway as gateway_enabled,cv_gateaway_ip as gatewayip,
        cv_dhcppool as dhcp_pool ,cv_dns as dns from "
            . $GLOBALS["cloud_networks_tablename"] . "," . $GLOBALS["cloud_privatenetwork_tablename"]
            . " where " . $GLOBALS['cnid'] . "=" . $GLOBALS['cv_cnid_fk'] . " and " . $GLOBALS['cv_uid_fk'] . "=" . $uid . "
             and " . $GLOBALS['cn_idcid_fk'] . "=" . $nid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => $listOfRecordType];
    }
    public static function  GetListByIDC($token, $idc)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT cvid as id,cvname as name, cv_iprange as rangeip,IF(cv_gateway = 0, 'false', 'true') as gateway_enabled,cv_gateaway_ip as gatewayip,
        cv_dhcppool as dhcp_pool ,cv_dns as dns from "
            . $GLOBALS["cloud_privatenetwork_tablename"]
            . " where   " . $GLOBALS['cv_uid_fk'] . "=" . $uid . "
             and " . $GLOBALS['cv_idcid_fk'] . "=" . $idc;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "success", "message" => "شما تاکنون شبکه ای ایجاد نکرده اید ", "code" => "201", $sql];
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "code" => "200", "data" => $listOfRecordType];
        }
        return  $listOfRecordType; //["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد ", "data" => $listOfRecordType];
    }
    public static function CheckNetworkNameDuplicated($uid, $idc, $name)
    {
        $sql = "SELECT cvname as name  from "
            . $GLOBALS["cloud_privatenetwork_tablename"] . " where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " and "
            . $GLOBALS['cv_idcid_fk'] . "=" . $idc . " and " .
            $GLOBALS['cvname'] . "='" . $name . "'";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "add"];
        } else {
            $listOfRecordType = ["status" => "duplicated"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function  GetOneByID($token, $cnid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT * from "
            . $GLOBALS["cloud_privatenetwork_tablename"] . " where " .
            $GLOBALS['cv_uid_fk'] . "=" . $uid . " and " . $GLOBALS['cvid'] . "=" . $cnid;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است", $sql];
            return $result;
        } else {
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
            ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedNetwork($rangeIP, $idc, $uid)
    {
        $sql = "SELECT cvname as name  from "
            . $GLOBALS["cloud_privatenetwork_tablename"] . " where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " and "
            . $GLOBALS['cv_idcid_fk'] . "=" . $idc . " and "
            . $GLOBALS['cv_iprange'] . " LIKE '%" . $rangeIP . "%'";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "add"];
        } else {
            $listOfRecordType = ["status" => "duplicated"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckNetworkNameDuplicatedWithoutOwn($uid, $idc, $name, $id)
    {
        $sql = "SELECT cvname as name  from "
            . $GLOBALS["cloud_privatenetwork_tablename"] . " where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " and "
            . $GLOBALS['cv_idcid_fk'] . "=" . $idc . " and " .
            $GLOBALS['cvname'] . "='" . $name . "' and " . $GLOBALS['cvid'] . "!=" . $id;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "add"];
        } else {
            $listOfRecordType = ["status" => "duplicated"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedNetworkWithoutOwn($rangeIP, $idc, $uid, $id)
    {
        $sql = "SELECT cvname as name  from "
            . $GLOBALS["cloud_privatenetwork_tablename"] . " where " . $GLOBALS['cv_uid_fk'] . "=" . $uid . " and "
            . $GLOBALS['cv_idcid_fk'] . "=" . $idc . " and "
            . $GLOBALS['cv_iprange'] . " LIKE '%" . $rangeIP . "%' and " . $GLOBALS['cvid'] . "!=" . $id;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "add"];
        } else {
            $listOfRecordType = ["status" => "duplicated"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToPrivateNetwork($uid, $pnid)
    {
        $sql = "SELECT * from "
            . $GLOBALS['cloud_privatenetwork_tablename'] . " where " .
            $GLOBALS['cv_uid_fk'] . "=" . $uid . " and " . $GLOBALS['cvid'] . "=" . $pnid;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddPrivateNetwork($token, $name, $idc, $iprange, $gateway, $gatewayip, $dhcpool, $dns)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        if (self::CheckDuplicatedNetwork($iprange, $idc, $uid)["status"] != "add") {
            return ["status" => "error", "message" => "شما پیش از این از این رنج IP در ایجاد شبکه خصوصی استفاده نموده اید "];
        }

        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {

            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        if (self::CheckNetworkNameDuplicated($uid, $idc, $name)["status"] == "duplicated") {
            return ["status" => "error", "message" => " نام ارسالی برای شبکه تکراری است"];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $prefixlen = 24;
        if (strpos($iprange, "/")) {
            $ipr = explode("/", $iprange);
            if ($ipr[1] < 24) {
                return ["status" => "error", "message" => "حداکثر رنج IP قابل استفاده در این بخش /24 است "];
            }
            if (TOOLS_ADMIN::ip_is_private($ipr[0]) == "Error") {
                return ["status" => "error", "message" => "رنج IP ارسالی شما اشتباه است یا در بازه IP های لوکال قرار ندارد"];
            }
            $prefixlen = $ipr[1];
        } else {
            return ["status" => "error", "message" => "رنج IP ارسالی شما اشتباه است "];
        }
        $validgateway_status = ["true", "false"];
        if (!in_array($gateway, $validgateway_status)) {
            return ["status" => "error", "message" => " وضعیت ارسالی شما برای Gateway اشتباه است"];
        }
        if (TOOLS_ADMIN::ipCIDRCheck($gatewayip, $iprange) == "false") {
            return ["status" => "error", "message" => " IP gateway ارسالی شما در مجدوده رنج IP درخواستی شما نیست "];
        }
        if (!strpos($dhcpool, ",")) {
            if (!strpos($dhcpool, "-")) {
                return ["status" => "error", "message" => "IP درج شده شما در DHCP اشتباه است "];
            }
            $dchparr = explode("-", $dhcpool);
            foreach ($dchparr as $a) {
                if (TOOLS_ADMIN::ipCIDRCheck($a, $iprange) == "false") {
                    return ["status" => "error", "message" => "IP درج شده شما در DHCP POOL شما خارج از مجدوده مجاز است "];
                }
            }
        } else {
            $dchparr = explode(",", $dhcpool);
            foreach ($dchparr as $a) {
                if (!strpos($a, "-")) {
                    return ["status" => "error", "message" => "IP درج شده شما در DHCP اشتباه است "];
                }
                $v = explode("-", $a);
                foreach ($v as $x) {
                    if (TOOLS_ADMIN::ipCIDRCheck($x, $iprange) == "false") {
                        return ["status" => "error", "message" => "IP درج شده شما در DHCP POOL شما خارج از مجدوده مجاز است "];
                    }
                }
            }
        }

        if (strpos($dns, "-")) {
            $dnservers = explode("-", $dns);
            foreach ($dnservers as $d) {
                if (!filter_var($d, FILTER_VALIDATE_IP)) {
                    return ["status" => "error", "message" => "IP درج شده شما برای DNS SERVER اشتباه است  "];
                }
            }
        } else {
            if (!filter_var($dns, FILTER_VALIDATE_IP)) {
                return ["status" => "error", "message" => "IP درج شده شما برای DNS SERVER اشتباه است  "];
            }
        }


        $sql = "INSERT INTO " . $GLOBALS["cloud_privatenetwork_tablename"] . " VALUES (0,'" . $name . "','" . $iprange . "','" . $gateway . "','" .
            $gatewayip . "','" . $dhcpool . "','" . $dns . "','0','" . $uid . "','" . $idc . "','')";
        $conn = GetConnection();
        $conn->query($sql);
        $id =  $conn->insert_id;
        $conn->close();
        $dns_nameservers = [];
        if (strpos($dns, "-")) {
            $d = explode("-", $dns);
            foreach ($d as $a) {
                array_push($dns_nameservers, $a);
            }
        } else {
            array_push($dns_nameservers, $dns);
        }
        $allocation_pools = [];

        if (strpos($dhcpool, ",")) {


            $n = explode(",", $dhcpool);
            for ($i = 0; $i < count($n); $i++) {
                $h = explode("-", $n[$i]);
                $allocation_pools[$i]["start"] = $h[0];
                $allocation_pools[$i]["end"] = $h[1];
            }
        } else {
            if (strpos($dhcpool, "-")) {
                $n = explode("-", $dhcpool);
                $allocation_pools[0]["start"] = $n[0];
                $allocation_pools[0]["end"] = $n[1];
            }
        }

        $apiout = API_CLOUD_PRIVATENETWORKS_ADMIN::RunCreateAPINETWORK(
            $m,
            $name,
            $prefixlen,
            $iprange,
            $gatewayip,
            $dhcpool,
            $dns,
            $gateway,
            $idc,
            $allocation_pools,
            $dns_nameservers
        );
        if ($apiout["status"] == "error") {
            return ["status" => "error", "message" => "خطا در مقادیر ارسالی"];
        }
        CLOUD_PRIVATENETWORKS_ADMIN::UpdateIDFromAPI($id, $apiout["data"]);
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function UpdateIDFromAPI($id, $sid)
    {
        $sql = "UPDATE " . $GLOBALS['cloud_privatenetwork_tablename'] . " SET " . $GLOBALS['cv_serverid'] . "='" . $sid . "' WHERE " .
            $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $id =  $conn->insert_id;
        $conn->close();
        return $sql;
    }
    public static function UpdatePrivateNetwork($token, $id, $name, $idc, $iprange, $gateway, $gatewayip, $dhcpool, $dns)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        if (self::CheckDuplicatedNetworkWithoutOwn($iprange, $idc, $uid, $id)["status"] != "add") {
            return ["status" => "error", "message" => "شما پیش از این از این رنج IP در ایجاد شبکه خصوصی استفاده نموده اید "];
        }
        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {

            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        if (CLOUD_PRIVATENETWORKS_ADMIN::CheckNetworkNameDuplicatedWithoutOwn($uid, $idc, $name, $id)["status"] == "duplicated") {
            return [
                "status" => "error", "message" => " نام ارسالی برای شبکه تکراری است",
                CLOUD_PRIVATENETWORKS_ADMIN::CheckNetworkNameDuplicatedWithoutOwn($uid, $idc, $name, $id)
            ];
        }
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $prefixlen = 24;
        if (strpos($iprange, "/")) {
            $ipr = explode("/", $iprange);
            if ($ipr[1] < 24) {
                return ["status" => "error", "message" => "حداکثر رنج IP قابل استفاده در این بخش /24 است "];
            }
            if (TOOLS_ADMIN::ip_is_private($ipr[0]) == "Error") {
                return ["status" => "error", "message" => "رنج IP ارسالی شما اشتباه است یا در بازه IP های لوکال قرار ندارد"];
            }
            $prefixlen = $ipr[1];
        } else {
            return ["status" => "error", "message" => "رنج IP ارسالی شما اشتباه است "];
        }
        $validgateway_status = ["true", "false"];
        if (!in_array($gateway, $validgateway_status)) {
            return ["status" => "error", "message" => " وضعیت ارسالی شما برای Gateway اشتباه است"];
        }
        if (TOOLS_ADMIN::ipCIDRCheck($gatewayip, $iprange) == "false") {
            return ["status" => "error", "message" => " IP gateway ارسالی شما در مجدوده رنج IP درخواستی شما نیست "];
        }
        $dchparr = explode("-", $dhcpool);
        foreach ($dchparr as $a) {
            if (TOOLS_ADMIN::ipCIDRCheck($a, $iprange) == "false") {
                return ["status" => "error", "message" => "IP درج شده شما در DHCP POOL شما خارج از مجدوده مجاز است "];
            }
        }
        if (strpos($dns, "-")) {
            $dnservers = explode("-", $dns);
            foreach ($dnservers as $d) {
                if (!filter_var($d, FILTER_VALIDATE_IP)) {
                    return ["status" => "error", "message" => "IP درج شده شما برای DNS SERVER اشتباه است  "];
                }
            }
        } else {
            if (!filter_var($dns, FILTER_VALIDATE_IP)) {
                return ["status" => "error", "message" => "IP درج شده شما برای DNS SERVER اشتباه است  "];
            }
        }
        $acc = CLOUD_PRIVATENETWORKS_ADMIN::UserCanAccessToPrivateNetwork($uid, $id);
        if ($acc["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این شبکه را ندارید"];
        }

        $sql = "UPDATE " . $GLOBALS["cloud_privatenetwork_tablename"] . " SET " . $GLOBALS['cvname'] . "='" . $name . "'
        ," . $GLOBALS['cv_gateway'] . "='" . $gateway . "'," .
            $GLOBALS['cv_gateaway_ip'] . "='" . $gatewayip . "',
        " . $GLOBALS['cv_dhcppool'] . "='" . $dhcpool . "',"
            . $GLOBALS['cv_dns'] . "='" . $dns . "'
         WHERE " . $GLOBALS['cvid'] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        $dns_nameservers = [];
        if (strpos(",", $dns)) {
            $d = explode(",", $dns);
            foreach ($d as $a) {
                array_push($dns_nameservers, $a);
            }
        }

        $allocation_pools = [];
        if (strpos("-", $dhcpool)) {
            $n = explode("-", $dhcpool);
            for ($i = 0; $i < count($n); $i++) {
                $allocation_pools[$i]["start"] = $n[$i][0];
                $allocation_pools[$i]["end"] = $n[$i][1];
            }
        }

        $apiout = API_CLOUD_PRIVATENETWORKS_ADMIN::RunUpdateAPINETWORK(
            $m,
            $name,
            $prefixlen,
            $iprange,
            $gatewayip,
            $dhcpool,
            $dns,
            $gateway,
            $idc,
            $allocation_pools,
            $dns_nameservers,
            $acc["data"][0]["cv_serverid"]
        );
        return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
    }
    public static function RemoveNetwrok($token, $privateid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $c = self::UserCanAccessToPrivateNetwork($uid, $privateid);
        if ($c["status"] == "error") {
            return $c;
        }
        $idcid = $c["data"][0]["cv_idcid_fk"];
        $serverid = $c["data"][0]["cv_serverid"];

        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $apiResponse = API_CLOUD_PRIVATENETWORKS_ADMIN::RunDeleteSubnet($m, $serverid, $idcid);
        if ($apiResponse["status"] == "error") {
            return ["status" => "error", "message" => "شما امکان حذف این شبکه را ندارید "];
        }
        $sql="DELETE FROM ".$GLOBALS['cloud_privatenetwork_tablename']." WHERE ".$GLOBALS['cvid']."=".$privateid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد "];
    }
}
