<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/sms.php';

class USERCHANGETEMP_ADMIN
{
    public static function  CheckEmailDirect($token, $vfcode)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            $r = [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "
            ];
            return $r;
        } else {
            $uid = $usersDetails["userdetail"][0]["uid"];
            $sql = "SELECT * from " . $GLOBALS['changetemp_tablename'] . " WHERE " .
                $GLOBALS['ctuid_fk'] . "=" . $uid . " and " . $GLOBALS['ctcode'] . "=" . $vfcode
                . " and " . $GLOBALS['ct_field'] . "=1";
            $conn = GetConnection();
            $result = mysqli_query($conn, $sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $result = ["status" => "error", "message" => "اطلاعات درخواستی شما نامعتبر است"];
                return $result;
            } else {


                $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
                $v = USERS_ADMIN::UpdateVerifiedUserEmail($uid, $listOfRecordType[0]["ct_new_field"]);
                self::DeleteRecord($uid, 1);;
            }
            $result->free_result();
        }
        $conn->close();
        return ["status" => "success", "message" => "درخواست شما انجام شد "];
    }
    public static function  CheckMobile($vfcode, $token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);

        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            $r = [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "
            ];
            return $r;
        } else {
            $uid = $usersDetails["userdetail"][0]["uid"];

            $sql = "SELECT * from " . $GLOBALS['changetemp_tablename'] . " WHERE " .
                $GLOBALS['ctuid_fk'] . "=" . $uid . " and " . $GLOBALS['ctcode'] . "=" . $vfcode
                . " and " . $GLOBALS['ct_field'] . "=2";
            $conn = GetConnection();
            $result = mysqli_query($conn, $sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $result = ["status" => "error", "message" => "اطلاعات درخواستی شما نامعتبر است"];
                return $result;
            } else {
                $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
                $v = USERS_ADMIN::UpdateVerifiedUserMobile($uid, $listOfRecordType[0]["ct_new_field"]);
                self::DeleteRecord($uid, 2);;
            }
            $result->free_result();

            $conn->close();
            return ["status" => "success", "message" => "درخواست شما انجام شد "];
        }
    }
    public static function  CheckEmail($uid, $vfcode)
    {
        $sql = "SELECT * from " . $GLOBALS['changetemp_tablename'] . " WHERE " .
            $GLOBALS['ctuid_fk'] . "=" . $uid . " and " . $GLOBALS['ctcode'] . "=" . $vfcode
            . " and " . $GLOBALS['ct_field'] . "=1";
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات درخواستی شما نامعتبر است"];
            return $result;
        } else {


            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $v = USERS_ADMIN::UpdateVerifiedUserEmail($uid, $listOfRecordType[0]["ct_new_field"]);
            self::DeleteRecord($uid, 1);;
        }
        $result->free_result();

        $conn->close();
        return ["status" => "success", "message" => "درخواست شما انجام شد "];
    }
    public static function  CheckMobileDirect($uid, $vfcode)
    {
        $sql = "SELECT * from " . $GLOBALS['changetemp_tablename'] . " WHERE " .
            $GLOBALS['ctuid_fk'] . "=" . $uid . " and " . $GLOBALS['ctcode'] . "=" . $vfcode
            . " and " . $GLOBALS['ct_field'] . "=2";
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات درخواستی شما نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $v = USERS_ADMIN::UpdateVerifiedUserMobile($uid, $listOfRecordType[0]["ct_new_field"]);
            self::DeleteRecord($uid, 2);;
        }
        $result->free_result();

        $conn->close();
        return ["status" => "success", "message" => "درخواست شما انجام شد "];
    }
    public static function  GetList($uid, $field)
    {
        $sql = "SELECT * from " . $GLOBALS['changetemp_tablename'] . " WHERE " .
            $GLOBALS['ctuid_fk'] . "=" . $uid . " and " . $GLOBALS['ct_field'] . "=" . $field;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();

        $conn->close();
        return ["status" => "success", "data" => $listOfRecordType];
    }

    public static function  AddRecord($uid, $field, $fieldvalue, $currentValue)
    {
        $recordExist = self::GetList($uid, $field);
        if ($recordExist["status"] == "error") {
            $conn = GetConnection();
            $sql = "INSERT INTO " . $GLOBALS['changetemp_tablename']
                . "(" . $GLOBALS['ctid'] . "," .
                $GLOBALS['ctuid_fk'] . "," . $GLOBALS['ctcode'] . "," .
                $GLOBALS['ct_new_field'] . "," . $GLOBALS['ct_field'] . "," . $GLOBALS['ct_datetime']
                . ") VALUES ('%s','%s','%s','%s','%s','%s')";
            $codeverify = rand(1000, 9999);
            $now = jDateTime::date("Y-m-d H:i:s");
            $sql = sprintf($sql, 0, $uid, $codeverify, $fieldvalue, $field, $now);
            if ($conn->query($sql) === TRUE) {
                $a = [];
                if ($field == "1") {
                    //SEND EMAIL
                    $html = "ابر میزبان<br /><br />
                    کد تایید شما : " . $codeverify . "
                    <br /><br />" .
                        "<a href='" . $GLOBALS["apidomain"] . "/verify/verifyemail.php?code=" .
                        TOOLS_ADMIN::encrypt($codeverify . "-" . $uid)
                        . "'
                      target='_blank' >اینجا کلیک نمایید </a>";
                    $a = EMAILCLASS::SendEmail($currentValue, $html);
                } else {
                    //SENDSMS 
                    SMSCLASS::SendSMSForVerifyUser(
                        $currentValue,
                        'MizbanCDNVerifyUser',
                        $codeverify."   ".
                         $GLOBALS["apidomain"] . "mizban/verify/verify-mobile.php?code=" .
                        TOOLS_ADMIN::encrypt($codeverify . "-" . $uid)
                    );
                }
                $response = [
                    "status" => "success",
                    "message" => "درخواست شما انجام شد جهت تکمیل عملیات لطفا مد دریافتی را وارد نمایید"
                ];
                $conn->close();
                return $response;
            } else {

                $response = ["status" => "error", "message" =>  " " .  $conn->error];
                $conn->close();
                return $response;
            }
        } else {
            self::DeleteRecord($uid, $field);
            return  self::AddRecord($uid, $field, $fieldvalue, $currentValue);
        }
    }
    public static function  ChangeUserStatus($status, $uid)
    {
        $now = jDateTime::date("Y-m-d H:i:s");

        $sql = "UPDATE  " . $GLOBALS["userverification_tablename"] .
            " SET " . $GLOBALS['uvmobile_status'] . "=" . $status . "," .
            $GLOBALS['uv_mobile_date_verify'] . "='" . $now
            . "'," . $GLOBALS['uv_email_date_verify'] . "='" . $now . "' WHERE " .
            $GLOBALS['uid'] . "=" . $uid;
        $conn = GetConnection();

        if ($conn->query($sql) === TRUE) {
            return "New record Updated  successfully";
        } else {
            return  "  " . $sql . "<br>" .  $conn->error;
        }

        $conn->close();
    }

    public static function CheckSMSVerifyCode($token, $vfcode)
    {
        $usExist = USERS_ADMIN::GetOneByToken($token);

        if ($usExist["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(401);
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "توکن ارسالی اشتباه است لطفا مجدد وارد شوید"];
        } else {
            $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);
            $dbcode = ($vfc["data"][0]["uvmobile_code"]);
            if ($dbcode == $vfcode) {
                USERS_ADMIN::ChangeUserStatus(1, $usExist["userdetail"][0]["uid"]);
                USERSVERIFICATION_ADMIN::ChangeUserStatus(1, $usExist["userdetail"][0]["uid"]);
                VARS_ADMIN::ReturnHeadersState(200);
                VARS_ADMIN::ReturnHeaders(200);
                self::DeleteRecord($usExist["userdetail"][0]["uid"]);
                return ["status" => "success", "message" => "اطلاعات ارسالی صحیح بود و کاربر تایید شد ", "data"
                => $usExist];
            } else {
                VARS_ADMIN::ReturnHeadersState(302);
                VARS_ADMIN::ReturnHeaders(200);
                return ["status" => "error", "message" => "کد وارد شده اشتباه است"];
            }
        }
    }
    public static function DeleteRecord($uid, $field)
    {
        $sql = "DELETE FROM   " . $GLOBALS["changetemp_tablename"] .
            " WHERE " .
            $GLOBALS['ctuid_fk'] . "=" . $uid . " and " . $GLOBALS['ct_field'] . "=" . $field;

        $conn = GetConnection();

        if ($conn->query($sql) === TRUE) {
            return "New record Updated  successfully";
        } else {
            return  "  " . $sql . "<br>" .  $conn->error;
        }

        $conn->close();
    }
    public static function ResendSMS($token)
    {
        $usExist = USERS_ADMIN::GetOneByToken($token);
        $now = jDateTime::date("Y-m-d H:i:s");

        if ($usExist["userdetail"][0]["ustatus"] == "error") {
            VARS_ADMIN::ReturnHeaders(401);
            return ["status" => "error", "message" => "توکن ارسالی اشتباه است لطفا مجدد وارد شوید"];
        } else {
            if ($usExist["userdetail"][0]["ustatus"] == 0) {

                $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);

                if ($vfc["status"] == "error") {
                    $s = self::AddRecord($usExist["userdetail"][0]["uid"], "q", "q");
                    $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);

                    $codeverify = $vfc["data"][0]["uvmobile_code"];
                    SMSCLASS::SendSMSForVerifyUser(
                        $usExist["userdetail"][0]["umobile"],
                        'MizbanCDNVerifyUser',
                        $codeverify
                    );
                    return [
                        "status" => "success",
                        "message" => "پیامک به شماره ثبت شده در پنل کاربری ارسال شد"
                    ];
                }

                if ($vfc[0]["uv_expire_date_verify"] > $now) {
                    VARS_ADMIN::ReturnHeaders(400);
                    return ["status" => "error", "message" => "حداقل فاصله زمانی دو ارسال پیامک 2دقیقه است"];
                } else {
                    $conn = GetConnection();
                    $sql = "UPDATE " . $GLOBALS['userverification_tablename'] . " SET " . $GLOBALS['uvmobile_code'] . "='%s'," .
                        $GLOBALS['uv_expire_date_verify'] . "='%s'     WHERE  " . $GLOBALS['uvid'] . "=%s";
                    $codeverify = rand(1000, 9999);

                    $datetime = jDateTime::date("Y/m/d H:i:s", strtotime("+1 minutes"));

                    $sql = sprintf($sql, $codeverify, $datetime, $vfc["data"][0]["uvid"]);
                    $conn->query($sql);
                    SMSCLASS::SendSMSForVerifyUser(
                        $usExist["userdetail"][0]["umobile"],
                        'MizbanCDNVerifyUser',
                        $codeverify
                    );
                    VARS_ADMIN::ReturnHeaders(200);
                    return ["status" => "success", "message" => "پیامک به شماره ثبت شده در پنل کاربری ارسال شد"];
                }
            } else {
                VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "کاربر مورد نظر قبلا تایید شده است "];
            }
        }
    }
}
