from rest_framework import serializers
from .models import Users, Roles, Permissions, PermissionUsers, PermissionRoles, DailyNotes
import environ
import json
import os
from mysgi_api.settings.base import BASE_DIR
from rest_framework_simplejwt.tokens import AccessToken, RefreshToken
from rest_framework_simplejwt.token_blacklist.models import OutstandingToken
from django.db.models import F, Value, Q
from django.db.models import CharField
from django.db.models.functions import Concat
from django.utils import timezone
from django.db import transaction
from pagination import custom_pagination
import logging
from permissions import check_admin_permission
from insurance.models import *
from ticket.models import *
from notification.models import InternalPhones
from rest_framework_simplejwt.exceptions import TokenError



env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))


class MessageDoneSerializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = serializers.CharField()
    
    
class FailedMessageSerializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = serializers.CharField()


class PaginateParamSerializer(serializers.Serializer):
    count = serializers.IntegerField()
    page_number = serializers.IntegerField()


class FailedMessageResponseAccessSerializer(serializers.Serializer):
    
    result = serializers.BooleanField()
    message = serializers.CharField()

class ResponseSerialized(serializers.Serializer):
    result = serializers.CharField()
    message = serializers.BooleanField()


class LoginMessageFieldsSerializer(serializers.Serializer):
    access = serializers.CharField()
    refresh = serializers.CharField()
    user_name = serializers.CharField()
    first_name = serializers.CharField()
    last_name = serializers.CharField()
    is_admin = serializers.BooleanField()
    user_id = serializers.IntegerField()

class AuthenticationResponseSerializer(serializers.Serializer):
    result = serializers.BooleanField()
    message = LoginMessageFieldsSerializer()

class UserLogin(serializers.Serializer):
    
    
    user_name = serializers.CharField(max_length=125)
    password = serializers.CharField(max_length=125)
    is_guest = serializers.BooleanField(default=False)
    
    def authenticate_user(self, validated_data) -> list:
        return Users.objects.check_login(validated_data)
    
    class Meta:
        model = Users
        fields = ['user_name', 'password']


class LogoutSerializer(serializers.Serializer):
    
    refresh_token = serializers.CharField(max_length=10000)
    
    def clear_tokens(self, validated_data, request_meta):
        
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]

        try:
            refresh_token = RefreshToken(validated_data['refresh_token'])
            refresh_token.blacklist()
        except Exception:
            pass
        return [True, 'انجام شد']


class GuestUserSerializer(serializers.Serializer):
    
    user_name = serializers.CharField(max_length=125)
    first_name = serializers.CharField(max_length=125)
    last_name = serializers.CharField(max_length=125)
    password = serializers.CharField(max_length=125)
    national_code = serializers.CharField(max_length=125)
    mobile = serializers.CharField(max_length=11)
    
    def register_guest(self, validated_data):
        return Users.objects.create_guest(validated_data)
        
    class Meta:
        model = Users
        fields = ['user_name', 'first_name','last_name', 'password', 'national_code', 'mobile']


class GetUsersDataSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    user_name = serializers.CharField()
    first_name = serializers.CharField()
    last_name = serializers.CharField()
    personnel_code = serializers.CharField()
    mobile = serializers.CharField()
    email = serializers.CharField()
    job_title = serializers.CharField()
    department = serializers.CharField()
    office_name = serializers.CharField()
    national_code = serializers.CharField()
    is_active = serializers.BooleanField()
    is_guest = serializers.BooleanField()
    group_permission = serializers.BooleanField()
    last_login = serializers.DateTimeField()
    birthday = serializers.DateTimeField()
    role = serializers.IntegerField()
class GetUsersSerializer(serializers.Serializer):
    datas = GetUsersDataSerializer(many=True)
    has_next = serializers.BooleanField()
    has_previous = serializers.BooleanField()
    page_number = serializers.IntegerField()
    next_url = serializers.CharField()
    previous_url = serializers.CharField()
    total_page = serializers.IntegerField()



class GetRoleUsersMessageResponseSerializers(serializers.Serializer):
    
    id = serializers.IntegerField()
    first_name = serializers.CharField()
    last_name = serializers.CharField()
    personnel_code = serializers.CharField()
    job_title = serializers.CharField()
    department = serializers.CharField()

class GetRoleUsersResponseSerializers(serializers.Serializer):
    
    result = serializers.CharField()
    message = GetRoleUsersMessageResponseSerializers(many=True)


class GetRoleUsersSerializers(serializers.Serializer):
    
    def get_role_users(self, validated_data, role, request) -> list:
        
        role_obj = Roles.objects.filter(name=role)
        if role_obj.count() == 0:
            return [False, 'نقش یافت نشد']
        if request.GET.get('filter') == None:
            users = Users.objects.filter(role_id=role_obj.values_list('id', flat=True)[0]).values('id','user_name', 'first_name', 'last_name', 'personnel_code', 'job_title', 'department')
        else:
            users = Users.objects.filter(role_id=role_obj.values_list('id', flat=True)[0]).filter(
                Q(user_name__icontains=request.GET.get('filter')) |
                Q(first_name__icontains=request.GET.get('filter')) |
                Q(last_name__icontains=request.GET.get('filter')) |
                Q(personnel_code__icontains=request.GET.get('filter')) |
                Q(mobile__icontains=request.GET.get('filter')) |
                Q(email__icontains=request.GET.get('filter')) |
                Q(job_title__icontains=request.GET.get('filter')) |
                Q(department__icontains=request.GET.get('filter')) |
                Q(office_name__icontains=request.GET.get('filter')) |
                Q(national_code__icontains=request.GET.get('filter'))
            ).values('id','user_name', 'first_name', 'last_name', 'personnel_code', 'job_title', 'department')
        datas = custom_pagination(users, request.GET.get('count', 100000), request.GET.get('page_number', 1))
        return [True, datas]


class GetRolePermissionsSerializers(serializers.Serializer):
    
    def get_role_permission(self, validated_data, role) -> list:
        
        role_obj = Roles.objects.filter(name=role)
        if role_obj.count() == 0:
            return [False, 'نقش یافت نشد']
        permissions = PermissionRoles.objects.filter(role_id=role_obj.values_list('id', flat=True)[0]).values(permission_name=F('permission__name'))
        last = list()
        for perm in permissions:
            last.append(perm['permission_name'])
        return [True, last]


class GetRolesSeializer(serializers.ModelSerializer):
    
    class Meta:
        model = Roles
        fields = '__all__'


class AddRoleSeializer(serializers.Serializer):
    
    name = serializers.CharField(max_length=125, required=True)
    parent_id = serializers.IntegerField()
    permissions = serializers.ListField()
    
    def add_role(self, validated_data, request_meta) -> list:
        
        role = Roles.objects.filter(name=validated_data['name']).values_list('name', flat=True)
        if validated_data['parent_id'] == 0:
            parentid = None
        else:
            if Roles.objects.filter(id=validated_data['parent_id']).count() == 0:
                return [False, 'Parent not exist']
            parentid = validated_data['parent_id']

        if role.count() > 0:
            return [False, 'Role Exist']
        print(0000)
        try:
            with transaction.atomic():
                roleobj = Roles.objects.create(
                    name=validated_data['name'], parent_id=parentid
                )
                roleid = roleobj.id
                if isinstance(validated_data['permissions'], list):
                    permission_list = validated_data['permissions']
                else:
                    permission_list = validated_data['permissions'].split(',')
                for permission in permission_list:
                    try:
                        permissionid = Permissions.objects.filter(name__exact=permission).values_list('id', flat=True)[0]
                        PermissionRoles.objects.create(role_id=roleid, permission_id=permissionid)
                    except:
                        return [False, "Permission not found"]
                return [True, 'Role Added']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']


class UpdateRoleSeializer(serializers.Serializer):
    
    new_name = serializers.CharField(max_length=125)
    new_parent = serializers.IntegerField()
    
    def update(self, validated_data, pk) -> list:
        role_object = Roles.objects.filter(id=pk)
        if role_object.count() > 0:
            check_parent = Roles.objects.filter(parent_id=validated_data['new_parent'])
            if check_parent.count() == 0:
                return [True, "parent id not exist"]
            role_object.update(name=validated_data['new_name'], parent_id=validated_data['new_parent'])
            return [True, "Role Updated"]
        else:
            return [False, "Role Not Exist"]
    
    class Meta:
        model = Roles
        fields = ['name']


class DeleteRoleSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        role_object = Roles.objects.filter(id=pk)
        if role_object.count() > 0:
            role_object.delete()
            return [True, "Role Deleted"]
        else:
            return [False, "Role Not Exist"]
    
    class Meta:
        model = Roles
        fields = ['name']


class RoleAssignSerializer(serializers.Serializer):
    
    user_name = serializers.CharField(max_length=125)
    role_name = serializers.CharField(max_length=125)
    group_permission = serializers.BooleanField(default=True)
    
    def create(self, validated_data):
        # assign admin role
        if validated_data['role_name'] == 'ادمین':
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            user_object.update(is_admin=True)
            return [True, "User Role Updated"]
        user_object = Users.objects.filter(user_name=validated_data['user_name'])
        role_object = Roles.objects.filter(name=validated_data['role_name'])
        if user_object.count() == 0:
            return [False, "User Not Exist"]
        if role_object.count() == 0:
            return [False, "Role Not Exist"]
        if validated_data['group_permission'] == "true":
            gpermission = True
        elif validated_data['group_permission'] == "false":
            gpermission = False
        
        roleid = role_object.values_list('id', flat=True)
        user_object.update(role_id=roleid[0], group_permission=gpermission)
        return [True, "User Role Updated"]




class GetPermissionSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = Permissions
        fields = '__all__'


class AddPermissionSerializer(serializers.Serializer):

    name = serializers.CharField(max_length=125, required=True)
    parent_id = serializers.IntegerField()
    
    def create(self, validated_data) -> list:
        role = Permissions.objects.filter(name=validated_data['name']).values_list('name', flat=True)
        if role.count() > 0:
            return [False, 'Role Exist']
        if validated_data['parent_id'] == 0:
            parentid=None
        else:
            parentid=Permissions.objects.get(id=validated_data['parent_id'])
        Permissions.objects.create(
            name=validated_data['name'], parent=parentid
        )
        return [True, "Role Added"]

    class Meta:
        model = Permissions
        fields = ['name', 'parent']


class UpdatePermissionSeializer(serializers.Serializer):
    
    new_name = serializers.CharField(max_length=125)
    new_parent = serializers.IntegerField()
    
    def update(self, validated_data, pk) -> list:
        permission_object = Permissions.objects.filter(id=pk)
        if permission_object.count() > 0:
            check_parent = Permissions.objects.filter(parent_id=validated_data['new_parent'])
            if check_parent.count() == 0:
                return [True, "parent id not exist"]
            permission_object.update(name=validated_data['new_name'], parent_id=validated_data['new_parent'])
            return [True, "Permission Updated"]
        else:
            return [False, "Permission Not Exist"]
    
    class Meta:
        model = Permissions
        fields = ['name']


class DeletePermissionSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        permission_object = Permissions.objects.filter(id=pk)
        if permission_object.count() > 0:
            permission_object.delete()
            return [True, "Permission Deleted"]
        else:
            return [False, "Permission Not Exist"]
    
    class Meta:
        model = Permissions
        fields = ['name']


class PermissionAssignUserSerializer(serializers.Serializer):
    
    user_name = serializers.CharField(max_length=125)
    group_permission = serializers.BooleanField(default=False, required=False)
    permissions = serializers.ListField()

    def assign_permission(self, validated_data) -> list:
        
        user_object = Users.objects.filter(user_name__exact=validated_data['user_name'])
        
        if user_object.count() == 0:
            return [False, "User Not Exist"]
        
        # permissions_dict_object = json.loads(validated_data['permissions'])
        if validated_data['group_permission'] == "false":
            
            user_object.update(group_permission=False)
            userid = user_object.values_list('id', flat=True)[0]
            PermissionUsers.objects.filter(user__exact=userid).delete()
            if isinstance(validated_data['permissions'], list):
                pass
                permission_list = validated_data['permissions']
            else:
                permission_list = validated_data['permissions'].split(',')
            print(len(permission_list))
            for permission in permission_list:
                try:
                    permissionid = Permissions.objects.filter(name__exact=permission).values_list('id', flat=True)[0]
                    PermissionUsers.objects.create(user_id=userid, permission_id=permissionid)
                except:
                    return [False, "Permission not found"]
            return [True, "User's Access Level Updated"]
        
        else:
        
            user_object.update(group_permission=True)
            return [True, "User's Access Level Updated"]


    @staticmethod
    def get_examples():
        examples = {
            "user_name": "m.sajedi",
            "permissions": ["role-manager", "roles-create", "roles-update", "roles-delete", "roles-assign"]
        }


class PermissionAssignRoleSerializer(serializers.Serializer):
    
    role_name = serializers.CharField(max_length=125)
    permissions = serializers.ListField()

    def assign_permission_roles(self, validated_data) -> list:
        role_object = Roles.objects.filter(name__exact=validated_data['role_name'])
        
        if role_object.count() == 0:
            return [False, "User Not Exist"]
        

        roleid = role_object.values_list('id', flat=True)[0]
        PermissionRoles.objects.filter(role_id__exact=roleid).delete()
        if isinstance(validated_data['permissions'], list):
            permission_list = validated_data['permissions']
        else:
            permission_list = validated_data['permissions'].split(',')
        for permission in permission_list:
            print(permission)
            try:
                permissionid = Permissions.objects.filter(name__exact=permission).values_list('id', flat=True)[0]
                PermissionRoles.objects.create(role_id=roleid, permission_id=permissionid)
            except:
                return [False, "Permission not found"]
            
        return [True, "Role's Access Level Updated"]


    @staticmethod
    def get_examples():
        examples = {
            "user_name": "m.sajedi",
            "permissions": ["role-manager", "roles-create", "roles-update", "roles-delete", "roles-assign"]
        }


class ResponseGetUsersAccesslevelSerializer(serializers.Serializer):
    result = serializers.BooleanField()
    message = serializers.ListField()

class GetUsersAccesslevelSerializer(serializers.Serializer):
    
    def get_user_access(self, validated_data, uid) -> list:
        user_object = Users.objects.filter(user_name__exact=uid)
        
        if user_object.count() == 0:
            return [False, "User Not Exist"]
        
        check_group_permission = user_object.values_list('group_permission', flat=True)
        if check_group_permission[0]:
            user_role_id = user_object.values_list('role', flat=True)
            if user_role_id.count() == 0:
                return [False, "User has no role!"]
            permission_ids = PermissionRoles.objects.filter(role_id__exact=user_role_id[0]).values_list('permission', flat=True)
            user_access = list()
            for permission_id in permission_ids:
                user_access.append(Permissions.objects.filter(id=permission_id).values_list('name', flat=True)[0])
            return [True, user_access]
        
        else:
            user_id = user_object.values_list('id', flat=True)[0]
            permission_ids = PermissionUsers.objects.filter(user_id__exact=user_id).values_list('permission', flat=True)
            user_access = list()
            for permission_id in permission_ids:
                user_access.append(Permissions.objects.filter(id=permission_id).values_list('name', flat=True)[0])
            return [True, user_access]
        
    class Meta:
        model = Permissions
        fields = ['name']
        

class GetSidebarItemsResponseSerializer(serializers.Serializer):
    
    result = serializers.BooleanField()
    message = serializers.JSONField()
 
class GetSidebarItemsSerializer(serializers.Serializer):
    
    def get_menu_items(self, validated_data, request_meta) -> list:
        
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        
        permission_mapping = {
            "users": "کاربران",
            "roles": "گروه های کاربری",
            "it_requests": "درخواست فاوا",
            "meeting_requests": "رزرو اتاق جلسات",
            "furniture_requests": "تامین تجهیزات پشتیبانی",
            "announcements": "اعلانات",
            "it_equipment_requests": "تامین تجهیزات IT",
            "insurance_documents": "بیمه تکمیلی",
            "insurance_contracts": "مدیریت بیمه تکمیلی",
            "insurance_periods": "مدیریت دوره ها",
            "filter_requests": "گزارش درخواست",
            "relationships": "نسبت ها",
            "gaming_room_requests": "رزرو اتاق بازی",
            "user_phone": "دفترچه تلفن",
        }
        user_object = Users.objects.filter(id=user_id).values_list('id', 'group_permission', 'role_id')
        translated_permissions = dict()
        last = []
        if user_object[0][1]:
            perm_users = PermissionRoles.objects.filter(role_id__exact=user_object[0][2]).annotate(permission_name=F('permission__name')).values('permission_name')
            for permission in perm_users:
                if permission['permission_name'] in permission_mapping:
                    if permission['permission_name'] not in last:
                        last.append(permission['permission_name'])
                    # translated_permissions[permission_mapping[permission['permission_name']]] = permission['permission_name']

            return [True, last]
        else:
            perm_users = PermissionUsers.objects.filter(user_id__exact=user_id).annotate(permission_name=F('permission__name')).values('permission_name')
            for permission in perm_users:
                if permission['permission_name'] in permission_mapping:
                    if permission['permission_name'] not in last:
                        last.append(permission['permission_name'])
                    # translated_permissions[permission_mapping[permission['permission_name']]] = permission['permission_name']
            return [True, last]


class GetInnerPageSerializer(serializers.Serializer):
    
    def get_menu_items(self, validated_data, request_meta, pagename) -> list:
        
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        
        role_id = user_object.values_list('role_id', flat=True)[0]
        user_object = Users.objects.filter(id=user_id).values_list('id', 'group_permission', 'role_id')
        print(role_id)
        try:
            last = list()
            def find_common_elements(list1, list2):
                return list(set(list1) & set(list2))
            if user_object[0][1]:
                all_role_permissions = list(PermissionRoles.objects.filter(role_id=role_id).annotate(name=F('permission__name')).values_list('name', flat=True))
                parent_permission_id = Permissions.objects.filter(name=pagename).values_list('parent_id', flat=True)[0]
                all_parent_permission = Permissions.objects.filter(parent_id=parent_permission_id).values_list('name', flat=True)
                last = find_common_elements(all_role_permissions, all_parent_permission)
            else:
                parent_permission_id = Permissions.objects.filter(name=pagename).values_list('parent_id', flat=True)[0]
                all_menu_permissions = Permissions.objects.filter(parent_id=parent_permission_id).values_list('name', flat=True)
                user_permissions = PermissionUsers.objects.filter(user_id__exact=user_id).annotate(permission_name=F('permission__name')).values_list('permission__name', flat=True)
                print(user_permissions)
                for perm in user_permissions:
                    if perm in all_menu_permissions:
                        if perm not in last:
                            last.append(perm)
            
            return [True, last]
        except:
            return [False, 'ارور رخ داده است']
        

class GetSidebarBadgeSerializer(serializers.Serializer):
    
    def get_items(self, validated_data, request_meta) -> list:
        jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
        access_token = AccessToken(jwt_token)
        user_id = access_token['user_id']
        user_object = Users.objects.filter(id=user_id)

        ## check bime takmili
        is_insurance_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        if is_insurance_admin :
            active_contract = InsuranceContracts.objects.filter(is_active=True)
            if active_contract.count() == 0:
                insurance_new_requests = 0
            else:
                docs = InsuranceDocuments.objects.filter(insurance_contract_id=active_contract.values_list('id', flat=True)[0])
                insurance_new_requests = 0
                for doc in docs:
                    insurance_new_requests += InsuranceRequests.objects.filter(flag_id=10004, document_id=doc).count()
        else:
            insurance_new_requests = 0
        
        ## check fava 
        is_fava_admin = check_admin_permission(user_id, user_object, 'it_requests-manage')
        if is_fava_admin:
            fava_new_requests = Ticket.objects.filter(department__department_name='خدمات فاوا', status_id__in=[1,2]).count()
        else:
            fava_new_requests = 0
        
        ## check it equipments
        is_it_equipment_admin = check_admin_permission(user_id, user_object, 'it_equipment_requests-manage')
        if is_it_equipment_admin:
            it_equipment_new_requests = ITEquipmentRequests.objects.filter(status_id__in=[1,2]).count()
        else:
            it_equipment_new_requests = 0
            
        ## check meeting request
        is_meeting_admin = check_admin_permission(user_id, user_object, 'meeting_requests-manage')
        if is_meeting_admin:
            meeting_new_requests = MeetingRequest.objects.filter(status_id__in=[1,2]).count()
        else:
            meeting_new_requests = 0
            
        ## check furniture request
        is_furniture_admin = check_admin_permission(user_id, user_object, 'furniture_requests-manage')
        if is_furniture_admin:
            furniture_new_requests = FurnitureRequests.objects.filter(status_id__in=[1,2]).count()
        else:
            furniture_new_requests = 0
                      
        return [True, [{"title": "it_requests", "new_requests": fava_new_requests}, {"title": "it_equipment_requests", "new_requests": it_equipment_new_requests}, {"title": "meeting_requests", "new_requests": meeting_new_requests}, {"title": "insurance_documents", "new_requests": insurance_new_requests}, {"title": "furniture_requests", "new_requests": furniture_new_requests}]]


class GetNoteResponseMessageSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    user_id = serializers.IntegerField()
    note = serializers.CharField()
    note_date = serializers.DateField()
    created_at = serializers.DateTimeField()
    updated_at = serializers.DateTimeField()
class GetNoteResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetNoteResponseMessageSerializer(many=True)

class GetNoteSerializer(serializers.Serializer):
    
    def get_item(self, validated_data, request_meta, start_date, end_date):
        
        if 'user' in validated_data and ( validated_data['user'] != '' ):
            user_object = Users.objects.filter(email__exact=validated_data['user'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        else:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        
        notes = DailyNotes.objects.filter(user_id=user_id, note_date__gte=start_date, note_date__lte=end_date).values()
        return [True, notes]


class AddNoteSerializer(serializers.Serializer):
    
    note = serializers.CharField(max_length=1000000, required=True)
    note_date = serializers.DateField(required=True)
    
    def add_item(self, validated_data, request_meta):
        
        if 'user' in validated_data and ( validated_data['user'] != '' ):
            user_object = Users.objects.filter(email__exact=validated_data['user'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        else:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
            
        logger = logging.getLogger('usermanagement.views')
        logger.error('note_date is '+str(validated_data['note_date']))
        
        ## check user have note on specific date or not
        note_obj = DailyNotes.objects.filter(user_id=user_id, note_date=validated_data['note_date'])
        logger.error('note_date exist '+str(note_obj.count()))
        if note_obj.count() > 0:
            return [False, 'یادداشت برای این روز وجود دارد']
        
        
        DailyNotes.objects.create(user_id=user_id, note_date=validated_data['note_date'], note=validated_data['note'])
        return [True, 'یادداشت جدید اضافه شد']


class UpdateNoteSerializer(serializers.Serializer):
    
    note = serializers.CharField(max_length=1000000, required=True)
    
    def update_item(self, validated_data, request_meta, id):
        if 'user' in validated_data and ( validated_data['user'] != '' ):
            user_object = Users.objects.filter(email__exact=validated_data['user'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        else:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
            
        note_obj = DailyNotes.objects.filter(user_id=user_id, id=id)
        if note_obj.count() == 0:
            return [False, 'یادداشت یافت نشد']
        
        note_obj.update(note=validated_data['note'])
        return [True, 'به روزرسانی انجام شد']
        

class DeleteNoteSerializer(serializers.Serializer):
    
    def delete_item(self, validated_data, request_meta, id):
        if 'user' in validated_data and ( validated_data['user'] != '' ):
            user_object = Users.objects.filter(email__exact=validated_data['user'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        else:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
            
        note_obj = DailyNotes.objects.filter(user_id=user_id, id=id)
        if note_obj.count() == 0:
            return [False, 'یادداشت یافت نشد']
        
        note_obj.delete()
        return [True, 'یادداشت حذف شد']




class MessageDoneSerializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = serializers.CharField()


class ListPhoneSerializer(serializers.Serializer):
    
    def get_list(self, validated_data, request):
        
        items = []
        if request.GET.get('filter') == None:
            phones = InternalPhones.objects.all().values('id', 'name', 'number').order_by('-id')
        else:
            phones = InternalPhones.objects.all().filter(
                Q(id__icontains=request.GET.get('filter')) |
                Q(name__icontains=request.GET.get('filter')) |
                Q(number__icontains=request.GET.get('filter'))
            ).values('id', 'name', 'number').order_by('-id')
  
        for phone in phones:
            items.append(
                {
                    'id': phone['id'],
                    'user_name': phone['name'],
                    'phone': phone['number']
                }
            )
        datas = custom_pagination(items, request.GET.get('count', 10), request.GET.get('page_number', 1))
        return [True, datas]


class AddPhoneSerializer(serializers.Serializer):
    username = serializers.CharField(max_length=255, required=True)
    phone = serializers.CharField(max_length=255, required=True)

    def add_phone(self, validated_data, request_meta):
        
        try:
            with transaction.atomic():
                InternalPhones.objects.create(
                    name=validated_data['username'],
                    number=validated_data['phone'],
                )
                return [True, 'شماره تلفن اضافه شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']


class GetPhoneSerializer(serializers.Serializer):
    
    def get_phone(self, id):
        phone_object = InternalPhones.objects.filter(id=id)
        if phone_object.count() == 0:
            return [False, 'شماره تلفن یافت نشد']
        
        item = {}
        values = phone_object.values('name', 'number')
        for val in values:
            item['user_name'] = val['name']
            item['phone'] = val['number']
        return [True, item]


class EditPhoneSerializer(serializers.Serializer):
    
    username = serializers.CharField(max_length=255, required=True)
    phone = serializers.CharField(max_length=255, required=True)

    def edit_phone(self, validated_data, request_meta, id):
        
        phone_object = InternalPhones.objects.filter(id=id)
        if phone_object.count() == 0:
            return [False, 'شماره تلفن یافت نشد']
        
        try:
            with transaction.atomic():
                phone_object.update(
                    name=validated_data['username'],
                    number=validated_data['phone'],
                )
                return [True, 'شماره تلفن ویرایش شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']


class DeletePhoneSerializer(serializers.Serializer):
    
    def delete_phone(self, validated_data, id):
        
        phone_object = InternalPhones.objects.filter(id=id)
        if phone_object.count() == 0:
            return [False, 'شماره تلفن یافت نشد']
        
        try:
            with transaction.atomic():
                phone_object.delete(
                )
                return [True, 'شماره تلفن حذف شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']




class AuthorizationCheckerSerializer(serializers.Serializer):
    
    auth_token = serializers.CharField(max_length=255)
    permission_name = serializers.CharField(max_length=255)
    is_admin = serializers.BooleanField(required=False)
    
    def check_authorization(self, validated_data, request_meta):
        
        access_token = validated_data['auth_token']
        perm_name = validated_data['permission_name']
        if access_token:
            try:
                access_token = AccessToken(access_token)
                user_id = access_token['user_id']
            except (ValueError, KeyError, TokenError) as e:
                return [False, 'Authorization Failed']
        else:
            return [False, 'false']
        
        if validated_data['is_admin'] == 'true' or validated_data['is_admin'] == True:
            user_object = user_object.values_list('id', 'group_permission', 'role_id', 'personnel_code')
            permissionid = Permissions.objects.filter(name__exact=perm_name).values_list('id', flat=True)
            if user_object[0][1]:
                perm_user = PermissionRoles.objects.filter(permission_id__exact=permissionid[0], role_id__exact=user_object[0][2])
                if perm_user.count() > 0:
                    return [True, user_object[0][3]]
            else:
                perm_user = PermissionUsers.objects.filter(user_id__exact=user_id, permission_id__exact=permissionid[0])
                if perm_user.count() > 0:
                    return [True, user_object[0][3]]
            return [False, 'Authorization Failed']
        else:
            user_object = Users.objects.filter(id=user_id).values_list('id', 'group_permission', 'role_id', 'personnel_code')
            userid = user_object[0][0]
            user_group_permission = user_object[0][1]
            user_department = user_object[0][2]
            permissionid = Permissions.objects.filter(name__exact=perm_name).values_list('id', flat=True)
            if user_group_permission:
                perm_user = PermissionRoles.objects.filter(permission_id__exact=permissionid[0], role_id__exact=user_department)
                if perm_user.count() > 0:
                    return [True, user_object[0][3]]
            else:
                perm_user = PermissionUsers.objects.filter(user_id__exact=userid, permission_id__exact=permissionid[0])
                if perm_user.count() > 0:
                    [True, user_object[0][3]]
            return [False, 'Authorization Failed']

        
        
    
