from .jalali import Persian
import ldap3
from ldap3.core.exceptions import LDAPCommunicationError, LDAPBindError, LDAPInvalidDnError
from django.utils import timezone
import environ
from django.contrib.auth.base_user import BaseUserManager
from django.utils.translation import gettext as _
from django.contrib.auth.hashers import make_password, check_password
from rest_framework_simplejwt.tokens import AccessToken, RefreshToken
import os
from mysgi_api.settings.base import BASE_DIR


env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))


class CustomUsersManager(BaseUserManager):
    """
    Custom sgi Users Model Manager
    """

    def check_login(self, validated_data) -> list:
        '''
        Check Guest Login
        '''
        if validated_data['is_guest'] == "true":
            userdata = self.filter(user_name__exact=validated_data['user_name'], is_guest=True).values_list('password', 'national_code', 'user_name', 'first_name', 'last_name')
            if userdata.count() == 0:
                return [False, "User Not Exist"]
            user = userdata[0][2]
            if user == validated_data['user_name']:
                if check_password(validated_data['password'], userdata[0][0]) == True:
                    answer = {
                        "user_name": userdata[0][2],
                        "first_name": userdata[0][3],
                        "last_name": userdata[0][4],
                        "national_code": userdata[0][1]
                    }
                    return [True, answer]
                else:
                    answer = "Wrong Credentials"
                    return [False, answer]
            else:
                return [False, "user not exist"]
        
        '''
        Check LDAP Members
        '''
        server = ldap3.Server(env('AUTH_LDAP_SERVER_URI'), use_ssl=False)
        try:
            conn = ldap3.Connection(
                server, 
                user=env('AUTH_LDAP_ADMIN_USER'), 
                password=env('AUTH_LDAP_ADMIN_PASSWORD'), 
                auto_bind=True
            )
        except LDAPCommunicationError:
            return [False, 'مشکل اتصال به سرور LDAP']
        try:
            if not conn.bind():
                return [False, 'ارور در اتصال به اکتیو دایرکتوری']
        except LDAPBindError:
            return [False, 'Exception in binding']
        
        '''
        check if user enter mail address 
        '''
        if '@' in validated_data['user_name']:
            if '@sgi.ir' in validated_data['user_name']:
                email_address = validated_data['user_name']
                entered_user = validated_data['user_name'].split('@')[0]
                search_filter = '(sAMAccountName=%s)' % (entered_user)
            else:
                return [False, 'ایمیل نامعتبر وارد کردید']
        else:
            email_address = validated_data['user_name'] + '@sgi.ir'
            entered_user = validated_data['user_name']
            search_filter = '(sAMAccountName=%s)' % (entered_user)
        try:
            conn.search(env('AUTH_LDAP_SEARCH_BASE'), search_filter, attributes=['*'])
            if not conn.entries:
                return [False, 'کاربر یافت نشد']
        except LDAPInvalidDnError:
            return [False, 'ارور در جستجوی کاربر']
        
        
        '''
        rebind method need CN as user_name
        '''
        ldap_data = conn.entries[0]
        user_name = ldap_data['cn'][0]
        if not conn.rebind(user=email_address, password=validated_data['password']):
            return [False, 'نام کاربری یا کلمه عبور اشتباه می‌باشد']
        else:
            result = self.sync_ldap_db(validated_data, ldap_data, entered_user)
            if result:
                user = self.get(user_name=entered_user)
                is_admin = user.is_admin
                datas = {
                    "access": str(AccessToken.for_user(user)), 
                    "refresh": str(RefreshToken.for_user(user)),
                    "user_name": entered_user,
                    "first_name": ldap_data['givenname'][0] if 'givenname' in ldap_data else '',
                    "last_name": ldap_data['sn'][0] if 'sn' in ldap_data else '',
                    "is_admin": is_admin,
                    "user_id": user.id
                }
                return [True, datas]
            else:
                return [False, 'کاربر فعال نمیباشد']
    
    
    def birthday_to_miladi(self, shamsidate):
        year = str(shamsidate)[0:4]
        if len(str(shamsidate)) == 6:
            month = str(shamsidate)[4]
            day = str(shamsidate)[5]
        elif len(str(shamsidate)) == 7:
            if int(shamsidate[4]) == 0:
                month = str(shamsidate)[4:5]
                day = str(shamsidate)[6]
            else:
                month = str(shamsidate)[4]
                day = str(shamsidate)[5:]
        elif len(str(shamsidate)) == 8:
            month = str(shamsidate)[4:6]
            day = str(shamsidate)[6:]
        return Persian(year, month, day).gregorian_datetime()
        
    
    def sync_ldap_db(self, validated_data, entries, entered_user) -> list:
        check_user = self.filter(user_name=entered_user).values_list('user_name', 'is_active')
        if 'st' not in entries:
            birth_day=None
        else:
            birth_day=self.birthday_to_miladi(entries['st'])
        if entries['userAccountControl'][0] == 66048:
            isactive = True
        else:
            isactive = False
            return False
        
        if check_user.count() > 0:
            check_user.update(
                user_name=entered_user, first_name=entries['givenname'][0],
                last_name=entries['sn'][0] if 'sn' in entries else '', personnel_code=entries['description'][0] if 'description' in entries else '',
                national_code=entries['postalCode'][0] if 'postalCode' in entries else '', mobile=entries['telephoneNumber'][0] if 'telephoneNumber' in entries else '',
                job_title=entries['title'][0] if 'title' in entries else '', department=entries['department'][0] if 'department' in entries else '',
                office_name=entries['physicalDeliveryOfficeName'] if 'physicalDeliveryOfficeName' in entries else '', birthday=birth_day,
                last_login=timezone.now(), is_active=True, password=make_password(validated_data['password']),
                email=entries['mail'] if 'mail' in entries else ''
            )
        else:
            check_user.create(
                user_name=entered_user, first_name=entries['givenname'][0],
                last_name=entries['sn'][0] if 'sn' in entries else '', personnel_code=entries['description'][0] if 'description' in entries else '',
                national_code=entries['postalCode'][0] if 'postalCode' in entries else '', mobile=entries['telephoneNumber'][0] if 'telephoneNumber' in entries else '',
                job_title=entries['title'][0] if 'title' in entries else '', department=entries['department'][0] if 'department' in entries else '',
                office_name=entries['physicalDeliveryOfficeName'] if 'physicalDeliveryOfficeName' in entries else '', birthday=birth_day,
                last_login=timezone.now(), is_active=isactive, password=make_password(validated_data['password']),
                email=entries['mail'] if 'mail' in entries else ''
            )
        return True


    def create_guest(self, validated_data) -> list:
        try:
            user = self.filter(user_name=validated_data['user_name']).values_list('user_name', flat=True)
            if user.count() > 0:
                return [False, 'user_name Exist']
            self.create(
                user_name=validated_data['user_name'], first_name=validated_data['first_name'], 
                last_name=validated_data['last_name'], password=make_password(validated_data['password']), 
                national_code=validated_data['national_code'], is_active=True, is_guest=True,
                mobile=validated_data['mobile'], last_login=timezone.now()
            )
            return [True, "User Added"]
        except:
            return [False, "Problem"]
