from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Ticket
from notification.models import Notification
from django.dispatch import Signal



ticket_created = Signal()
ticket_status_changed = Signal()

@receiver(ticket_created)
def handle_ticket_created(sender, ticket, department_name, **kwargs):
    if department_name == 'خدمات فاوا':
        dname = 'it_requests'
    elif department_name == 'تامین تجهیزات پشتیبانی':
        dname = 'furniture_requests'
    elif department_name == 'رزرو اتاق جلسه':
        dname = 'meeting_requests'
    elif department_name == 'تامین تجهیزات IT':
        dname = 'it_equipment_requests'
    Notification.objects.create(
        user=ticket.user,
        message=f"درخواست جدیدی در بخش {department_name} ایجاد کردید",
        department=dname
    )

@receiver(ticket_status_changed)
def handle_ticket_status_changed(sender, ticket, old_status, new_status, department_name, **kwargs):
    if department_name == 'خدمات فاوا':
        dname = 'it_requests'
    elif department_name == 'تامین تجهیزات پشتیبانی':
        dname = 'furniture_requests'
    elif department_name == 'رزرو اتاق جلسه':
        dname = 'meeting_requests'
    elif department_name == 'تامین تجهیزات IT':
        dname = 'it_equipment_requests'
    Notification.objects.create(
        user=ticket.user,
        message=f"وضعیت درخواستتان در {department_name} تغییر یافت",
        department=dname
    )
