from django.core.paginator import Paginator, InvalidPage



def custom_pagination(queryset: list, count: int, page_number: int) -> dict:
    
    last = dict()
    if len(queryset) == 0:
        last['datas'] = []
        last['has_next'] = False
        last['has_previous'] = False
        last['page_number'] = 0
        last['next_url'] = None
        last['previous_url'] = None
        last['total_page'] = 0
        last['total_items'] = 0
    try:
        paginator = Paginator(queryset, count)
        page = paginator.page(page_number)
        last['datas'] = list(page)
        last['has_next'] = page.has_next()
        last['has_previous'] = page.has_previous()
        last['page_number'] = page_number
        last['next_url'] = '/?page='+str(int(page_number)+1)+'&count='+str(count) if page.has_next() else None
        last['previous_url'] = '/?page='+str(int(page_number)-1)+'&count='+str(count) if page.has_previous() else None
        last['total_page'] = paginator.num_pages
        last['total_items'] = len(queryset)
    except InvalidPage:
        last['datas'] = []
        last['has_next'] = False
        last['has_previous'] = False
        last['page_number'] = 0
        last['next_url'] = None
        last['previous_url'] = None
        last['total_page'] = 0
        last['total_items'] = 0
    return last


