from django.urls import path
from . import views

urlpatterns = [
    path('announcement/get-categories/', views.GetCategoryAnnouncementView.as_view()),
    path('announcement/add/', views.AddAnnouncementView.as_view()),
    path('announcement/list/', views.ListAnnouncementView.as_view()),
    path('announcement/get/<int:aid>/', views.GetOneAnnouncementView.as_view()),
    path('announcement/update/<int:aid>/', views.UpdateAnnouncementView.as_view()),
    path('announcement/delete/<int:aid>/', views.DeleteAnnouncementView.as_view()),
    path('announcement/dashboard/<int:count>/', views.GetCountAnnouncementView.as_view()),
    
    path('internal_phones/', views.GetInternalphonesView.as_view()),
    path('internal_phones/search/<str:search_string>/', views.SearchInternalphonesView.as_view()),
    
    path('internet_usage/get/<str:email>/', views.GetInternetUsageView.as_view()),
    
    path('get_notifications/', views.GetNotificationView.as_view()),
    path('update_notifications/', views.UpdateNotificationView.as_view()),
]