import os
from mysgi_api.settings.base import BASE_DIR
import environ
from rest_framework import serializers
from .models import *
from django.utils import timezone
from rest_framework_simplejwt.tokens import AccessToken, RefreshToken
from usermanagement.models import Users
from permissions import check_admin_permission
from django.db import transaction
from django.db.models import F, Value, Case, When, IntegerField, CharField, ExpressionWrapper, Q
from django.db.models.functions import Concat
import json
from pagination import custom_pagination
import logging
from itertools import chain
import jdatetime



env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))


class MessageDoneSerializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = serializers.CharField()


class FailedMessageSerializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = serializers.CharField()


class GetInsuranceMemberSeializer(serializers.ModelSerializer):
    
    class Meta:
        model = InsuranceMembers
        fields = '__all__'


class AddInsuranceMemberSerializer(serializers.Serializer):
    
    first_name = serializers.CharField(max_length=255)
    last_name = serializers.CharField(max_length=255)
    father_name = serializers.CharField(max_length=255)
    gender = serializers.CharField(max_length=255)
    identity_number = serializers.CharField(max_length=255, required=False)
    national_code = serializers.CharField(max_length=255)
    insurance_code = serializers.CharField(max_length=255)
    relationship = serializers.CharField(max_length=255)
    birth_date = serializers.DateTimeField()
    parent_id = serializers.IntegerField()
    
    def create(self, validated_data) -> list:
        relationship_object = Relationship.objects.filter(title__exact=validated_data['relationship'])
        if relationship_object.count() == 0:
            return [False, "Relationship not exist"]
        else:
            relationsip_id = relationship_object.values_list('id', flat=True)[0]
        try:
            identity_number=validated_data['identity_number']
        except:
            identity_number=''
        try:
            parent_id=validated_data['parent_id']
        except:
            parent_id=''
        try:
            birth_date=validated_data['birth_date']
        except:
            birth_date=''
        try:
            insurance_code=validated_data['insurance_code']
        except:
            insurance_code=''
        try:
            national_code=validated_data['national_code']
        except:
            national_code=''
        
        InsuranceMembers.objects.create(
            first_name=validated_data['first_name'], last_name=validated_data['last_name'],
            father_name=validated_data['father_name'], gender=validated_data['gender'],
            identity_number=identity_number, national_code=national_code,
            insurance_code=insurance_code, relationship_id=relationsip_id,
            birth_date=birth_date, parent_id=parent_id
        )
        return [True, "Member Added"]
    
    class Meta:
        model = InsuranceMembers
        fields = ['name']


class UpdateInsuranceMemberSerializer(serializers.Serializer):
    
    first_name = serializers.CharField(max_length=255)
    last_name = serializers.CharField(max_length=255)
    father_name = serializers.CharField(max_length=255)
    gender = serializers.CharField(max_length=255)
    identity_number = serializers.CharField(max_length=255, required=False)
    national_code = serializers.CharField(max_length=255)
    insurance_code = serializers.CharField(max_length=255)
    relationship = serializers.CharField(max_length=255)
    birth_date = serializers.DateTimeField()
    parent_id = serializers.IntegerField()

    def update(self, validated_data, pk) -> list:
        
        member_object = InsuranceMembers.objects.filter(id=pk)
        if member_object.count() == 0:
            return [False, "Member not exist"]
        else:
            
            relationship_object = Relationship.objects.filter(title__exact=validated_data['relationship'])
            if relationship_object.count() == 0:
                return [False, "Relationship not exist"]
            else:
                relationsip_id = relationship_object.values_list('id', flat=True)[0]
                
            try:
                identity_number=validated_data['identity_number']
            except:
                identity_number=''
            try:
                parent_id=validated_data['parent_id']
            except:
                parent_id=''
            try:
                birth_date=validated_data['birth_date']
            except:
                birth_date=''
            try:
                insurance_code=validated_data['insurance_code']
            except:
                insurance_code=''
            try:
                national_code=validated_data['national_code']
            except:
                national_code=''
            
            member_object.update(
                first_name=validated_data['first_name'], last_name=validated_data['last_name'],
                father_name=validated_data['father_name'], gender=validated_data['gender'],
                identity_number=identity_number, national_code=national_code,
                insurance_code=insurance_code, relationship_id=relationsip_id,
                birth_date=birth_date, parent_id=parent_id
            )
            return [True, "Member Updated"]
    
    class Meta:
        model = InsuranceMembers
        fields = ['name']
        

class DeleteInsuranceMemberSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        member_object = InsuranceMembers.objects.filter(id=pk)
        if member_object.count() > 0:
            member_object.delete()
            return [True, "InsuranceMembers Deleted"]
        else:
            return [False, "InsuranceMembers Not Exist"]
    
    class Meta:
        model = InsuranceMembers
        fields = ['name']




class ListContractsDataSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    company = serializers.CharField()
    title = serializers.CharField()
    number = serializers.CharField()
    start_date = serializers.DateTimeField()
    end_date = serializers.DateTimeField()
    is_active = serializers.BooleanField()
    description = serializers.CharField()
    close = serializers.IntegerField()
    created_at = serializers.DateTimeField()
    updated_at = serializers.DateTimeField()
class ListContractsSerializer(serializers.Serializer):
    
    datas = ListContractsDataSerializer(many=True)
    has_next = serializers.BooleanField()
    has_previous = serializers.BooleanField()
    next_url = serializers.CharField()
    previous_url = serializers.CharField()
    total_page = serializers.IntegerField()
    total_items = serializers.IntegerField()


class GetInsuranceContractsSeializer(serializers.Serializer):
    
    def get_contract_detail(self, validated_data, cid):
        all_docs = InsuranceDocuments.objects.filter(insurance_contract_id=cid).values('id').order_by("-created_at")
        last = {'costs': 0, 'payments': 0, 'damages': 0, }
        for doc in all_docs:
            doc_requests = InsuranceRequests.objects.filter(document_id=doc['id'])
            last['damages'] += len(doc_requests)
            for request in doc_requests.values():
                if request['claimed_fee'] is not None:
                    last['costs'] += request['claimed_fee']
                if request['benefit'] is not None:
                    last['payments'] += request['benefit']
            
            
        
        members = InsuranceContractMembers.objects.filter(insurance_contract_id=cid)
        periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid)
        last['count_members'] = len(members)
        last['count_periods'] = len(periods)
        return [True, last]


class AddInsuranceContractsSerializer(serializers.Serializer):
    
    company = serializers.CharField(max_length=255, required=True)
    title = serializers.CharField(max_length=255, required=True)
    number = serializers.CharField(max_length=255, required=True)
    start_date = serializers.DateTimeField(required=False)
    end_date = serializers.DateTimeField(required=False)
    is_active = serializers.BooleanField(required=True)
    description = serializers.CharField(max_length=255, required=False)
    close = serializers.IntegerField(required=False)
    
    def add_contract(self, validated_data) -> list:
        try:
            number=validated_data['number']
        except:
            number=''  
        try:
            start_date=validated_data['start_date']
        except:
            start_date=timezone.now()
        try:
            end_date=validated_data['end_date']
        except:
            end_date=timezone.now()
        try:
            description=validated_data['description']
        except:
            description='' 
        try:
            close=validated_data['close']
        except:
            close=False
        if validated_data['is_active'] == "true":
            is_active = True
        else:
            is_active = False
        
        if is_active:
            if InsuranceContracts.objects.filter(is_active=True).count() != 0:
                return [False, 'یک قرار داد فعال وجود دارد']
        InsuranceContracts.objects.create(
            company=validated_data['company'], title=validated_data['title'],
            number=number, start_date=start_date,
            end_date=end_date, description=description,
            close=close, is_active=is_active
        )
        return [True, "Insurace Contract Added"]


class UpdateInsuranceContractsSerializer(serializers.Serializer):
    
    company = serializers.CharField(max_length=255, required=True)
    title = serializers.CharField(max_length=255, required=True)
    number = serializers.CharField(max_length=255, required=True)
    start_date = serializers.DateTimeField(required=False)
    end_date = serializers.DateTimeField(required=False)
    is_active = serializers.BooleanField(required=True)
    description = serializers.CharField(required=False)
    close = serializers.IntegerField()
    
    def update_contract(self, validated_data, pk) -> list:
        
        contract_obj = InsuranceContracts.objects.filter(id=pk)
        if contract_obj.count() == 0:
            return [False, 'Contract not exist']
        try:
            number=validated_data['number']
        except:
            number=''  
        try:
            start_date=validated_data['start_date']
        except:
            start_date='' 
        try:
            end_date=validated_data['end_date']
        except:
            end_date='' 
        try:
            description=validated_data['description']
        except:
            description='' 
        try:
            close=validated_data['close']
        except:
            close=''
        if validated_data['is_active'] == "true" or validated_data['is_active'] == True:
            is_active = True
        else:
            is_active = False
        if is_active:
            if InsuranceContracts.objects.filter(is_active=1).count() != 0:
                return [False, 'یک قرار داد فعال وجود دارد']
        
        try:
            contract_obj.update(
                company=validated_data['company'], title=validated_data['title'],
                number=number, start_date=start_date,
                end_date=end_date, description=description,
                close=close, is_active=is_active
            )
            return [True, "Insurace Contracts Updated"]
        except:
            return [False, 'خطایی رخ داده است']
    
    class Meta:
        model = InsuranceContracts
        fields = ['company', 'title', 'number']
        

class DeleteInsuranceContractsSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        contract_object = InsuranceContracts.objects.filter(id=pk)
        if contract_object.count() > 0:
            contract_object.delete()
            return [True, "Insurace Contracts Deleted"]
        else:
            return [False, "Insurace Contracts Not Exist"]
    
    class Meta:
        model = InsuranceContracts
        fields = ['name']




class GetInsuranceContractMemeberSeializer(serializers.Serializer):
    
    def get_items(self, validated_data, request_meta, cid, request) -> list:
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        
        contract_obj = InsuranceContracts.objects.filter(id=cid)
        if contract_obj.count() == 0:
            return [False, 'قرارداد یافت نشد']
        if request.GET.get('filter') == None:
            members = InsuranceContractMembers.objects.filter(insurance_contract_id=cid).annotate(
                member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), 
                first_name=F('insurance_member__first_name'),
                last_name=F('insurance_member__last_name'),
                relation_name=F('insurance_member__relationship__title'),
                father_name=F('insurance_member__father_name'),
                relationshop=F('insurance_member__relationship__title'),
                gender=F('insurance_member__gender'),
                identity_number=F('insurance_member__identity_number'),
                national_code=F('insurance_member__national_code'),
                birth_date=F('insurance_member__birth_date'),
                insurance_code=F('insurance_member__insurance_code'),
                parent_id=F('insurance_member__parent_id')
            ).values('id', 'insurance_member_id', 'insurance_contract_id', 'member_name', 'first_name', 'last_name', 'relation_name', 'father_name', 'relationshop', 'gender', 'identity_number', 'national_code', 'birth_date', 'insurance_code', 'parent_id').order_by("-created_at")
        else:
            members = InsuranceContractMembers.objects.filter(insurance_contract_id=cid).filter(
                    Q(insurance_member__first_name__icontains=request.GET.get('filter')) |
                    Q(insurance_member__last_name__icontains=request.GET.get('filter')) |
                    Q(insurance_member__gender__icontains=request.GET.get('filter')) |
                    Q(insurance_member__national_code__icontains=request.GET.get('filter')) |
                    Q(insurance_member__insurance_code__icontains=request.GET.get('filter')) |
                    Q(insurance_member__relationship__title__icontains=request.GET.get('filter'))
                ).annotate(
                member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), 
                first_name=F('insurance_member__first_name'),
                last_name=F('insurance_member__last_name'),
                relation_name=F('insurance_member__relationship__title'),
                father_name=F('insurance_member__father_name'),
                relationshop=F('insurance_member__relationship__title'),
                gender=F('insurance_member__gender'),
                identity_number=F('insurance_member__identity_number'),
                national_code=F('insurance_member__national_code'),
                birth_date=F('insurance_member__birth_date'),
                insurance_code=F('insurance_member__insurance_code'),
                parent_id=F('insurance_member__parent_id')
            ).values('id', 'insurance_member_id', 'insurance_contract_id', 'member_name', 'first_name', 'last_name', 'relation_name', 'father_name', 'relationshop', 'gender', 'identity_number', 'national_code', 'birth_date', 'insurance_code', 'parent_id').order_by("-created_at")
        member_list = list()
        for member in members:
            if member['parent_id'] is None:
                member_list.append(
                    {
                        'id': member['id'], 
                        'insurance_member_id': member['insurance_member_id'], 
                        'insurance_contract_id': member['id'], 
                        'member_name': member['member_name'], 
                        'first_name': member['first_name'], 
                        'last_name': member['last_name'], 
                        'relation_name': member['relation_name'], 
                        'father_name': member['father_name'], 
                        'relationshop': member['relationshop'], 
                        'gender': member['gender'], 
                        'identity_number': member['identity_number'], 
                        'national_code': member['national_code'], 
                        'birth_date': member['birth_date'], 
                        'insurance_code': member['insurance_code'], 
                        'parent_name': member['member_name']
                    }
                )
            else:
                parent_name = InsuranceMembers.objects.filter(id=member['parent_id']).values_list('first_name', 'last_name')[0]
                member_list.append(
                    {
                        'id': member['id'], 
                        'insurance_member_id': member['insurance_member_id'], 
                        'insurance_contract_id': member['id'], 
                        'member_name': member['member_name'], 
                        'first_name': member['first_name'], 
                        'last_name': member['last_name'], 
                        'relation_name': member['relation_name'], 
                        'father_name': member['father_name'], 
                        'relationshop': member['relationshop'], 
                        'gender': member['gender'], 
                        'identity_number': member['identity_number'], 
                        'national_code': member['national_code'], 
                        'birth_date': member['birth_date'], 
                        'insurance_code': member['insurance_code'], 
                        'parent_name': parent_name[0] + ' ' +parent_name[1]
                    }
                )
        
        datas = custom_pagination(member_list, request.GET.get('count', 10), request.GET.get('page_number', 1))
        last = {
            'contract': contract_obj.values_list('title', flat=True)[0],
            # 'member_list': member_list
            'member_list': datas
        }
        return [True, last, contract_obj.values_list('is_active', flat=True)[0]]


class AddInsuranceContractMemeberSerializer(serializers.Serializer):
    
    first_name = serializers.CharField(max_length=255, required=True)
    last_name = serializers.CharField(max_length=255, required=True)
    father_name = serializers.CharField(max_length=255, required=True)
    gender = serializers.CharField(max_length=255, required=True)
    national_code = serializers.CharField(max_length=255, required=True)
    birth_date = serializers.DateField(required=True)
    insurance_code = serializers.CharField(max_length=255, required=False)
    identity_number  = serializers.CharField(max_length=255, required=False)
    parent_id = serializers.IntegerField( required=False)
    relationship = serializers.IntegerField()
    
    def add_member(self, validated_data, request_meta, cid) -> list:
        '''
        check contract exist
        '''
        contract_obj = InsuranceContracts.objects.filter(id=cid)
        if contract_obj.count() == 0:
            return [False, 'قرارداد یافت نشد']
        
        if validated_data['parent_id'] is None or validated_data['parent_id'] == '':
            parentid = None
        else:
            parentid = validated_data['parent_id']
        relation_obj = Relationship.objects.filter(id=validated_data['relationship'])
        if relation_obj.count() == 0:
            return [False, 'رابطه یافت نشد']
        try:
            member_obj = InsuranceMembers.objects.create(
                first_name=validated_data['first_name'], last_name=validated_data['last_name'], father_name=validated_data['father_name'],
                gender=validated_data['gender'], national_code=validated_data['national_code'], birth_date=validated_data['birth_date'],
                insurance_code=validated_data['insurance_code'], identity_number=validated_data['identity_number'], parent_id=parentid,
                relationship_id=validated_data['relationship']
            )
            InsuranceContractMembers.objects.create(
                insurance_contract_id=cid, insurance_member_id=member_obj.id
            )
            return [True, 'کاربر اضافه شد']
        except:
            return [False, 'ارور رخ داده است']
        

class GetContractServicesSerializer(serializers.Serializer):
    
    def get_item(self, validated_data, request_meta, cid, request) -> list:
        
        contract_obj = InsuranceContracts.objects.get(id=cid)
        if request.GET.get('filter') == None:
            contract_services_obj = InsuranceContractServices.objects.filter(insurance_contract_id=cid).annotate(service_title=F('insurance_service__title'), contract_title=F('insurance_contract__title')).values('id', 'service_title', 'contract_title')
        else:
            contract_services_obj = InsuranceContractServices.objects.filter(insurance_contract_id=cid).filter(
                Q(insurance_service__title__icontains=request.GET.get('filter'))
            ).annotate(service_title=F('insurance_service__title'), contract_title=F('insurance_contract__title')).values('id', 'service_title', 'contract_title')
        if contract_services_obj.count() == 0:
            answer = {"datas": [], "has_next": False, "has_previous": False, "page_number": 0, "next_url": None, "previous_url": None, "total_page": 0, "total_items": 0}
            return [True, answer, None, contract_obj.is_active]
        datas = custom_pagination(contract_services_obj, request.GET.get('count', 10), request.GET.get('page_number', 1))
        for contract in datas['datas']:
            contract_title = contract['contract_title']
        
        return [True, datas, contract_title, contract_obj.is_active]


class AddContractServicesSerializer(serializers.Serializer):
    title = serializers.CharField(max_length=255, required=True)
    
    def add_item(self, validated_data, request_meta, cid) -> list:
        
        contracts_obj = InsuranceContracts.objects.filter(id=cid)
        if contracts_obj.count() == 0:
            return [False, 'قرارداد یافت نشد']
        service_obj = InsuranceServices.objects.create(
            title=validated_data['title']
        )
        InsuranceContractServices.objects.create(
            insurance_contract_id=cid,
            insurance_service_id=service_obj.id
        )
        return [True, 'سرویس به قرارداد اضافه شد']


class GetOneContractServicesSerializer(serializers.Serializer):

    def get_item(self, validated_data, request_meta, csid) -> list:
        
        contract_service_obj = InsuranceContractServices.objects.filter(id=csid).annotate(
            service_title=F('insurance_service__title')
        ).values('id', 'service_title')
        if contract_service_obj.count() == 0:
            return [False, 'یافت نشد']
        return [True, contract_service_obj]


class UpdateContractServicesSerializer(serializers.Serializer):
    
    title = serializers.CharField(max_length=255, required=True)
    
    def update_item(self, validated_data, request_meta, csid) -> list:
        
        contract_service_obj = InsuranceContractServices.objects.filter(id=csid).annotate(
            service_title=F('insurance_service__title')
        ).values('id', 'service_title', 'insurance_service_id')
        if contract_service_obj.count() == 0:
            return [False, 'یافت نشد']
        service_id = contract_service_obj[0]['insurance_service_id']
        InsuranceServices.objects.filter(id=service_id).update(
            title=validated_data['title']
        )
        return [True, 'سرویس به روزرسانی شد']


class DeleteContractServicesSerializer(serializers.Serializer):
    
    def delete_item(self, validated_data, request_meta, csid) -> list:
        
        contract_service_obj = InsuranceContractServices.objects.filter(id=csid).annotate(
            service_title=F('insurance_service__title')
        )
        if contract_service_obj.count() == 0:
            return [False, 'یافت نشد']
        contract_service_obj.delete()
        return [True, 'سرویس حذف شد']


class UpdateInsuranceContractMemeberGetMessageResponseSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    insurance_contract_id = serializers.IntegerField()
    insurance_member_id = serializers.IntegerField()

class UpdateInsuranceContractMemeberGetResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = UpdateInsuranceContractMemeberGetMessageResponseSerializer()

class UpdateInsuranceContractMemeberGetSerializer(serializers.Serializer):
    
    def get_member(self, validated_data, request_meta, cid, mid) -> list:
        
        contract_member_object = InsuranceContractMembers.objects.filter(insurance_contract_id=cid, insurance_member_id=mid)
        if contract_member_object.count() == 0:
            return [False, 'کاربری در این قرار داد یافت نشد']
        member = contract_member_object.annotate(
            first_name=F('insurance_member__first_name'), last_name=F('insurance_member__last_name'), father_name=F('insurance_member__father_name'),
            relation_name=F('insurance_member__relationship__title'), birthday=F('insurance_member__birth_date'), gender=F('insurance_member__gender'),
            identity_number=F('insurance_member__identity_number'), national_code=F('insurance_member__national_code'), insurance_code=F('insurance_member__insurance_code')
        ).values('first_name', 'last_name', 'father_name', 'relation_name')[0]
        return [True, member]
        

class UpdateInsuranceContractMemeberUpdateSerializer(serializers.Serializer):
    
    first_name = serializers.CharField(max_length=255, required=True)
    last_name = serializers.CharField(max_length=255, required=True)
    father_name = serializers.CharField(max_length=255, required=True)
    gender = serializers.CharField(max_length=255, required=True)
    national_code = serializers.CharField(max_length=255, required=True)
    birth_date = serializers.DateField(required=True)
    insurance_code = serializers.CharField(max_length=255, required=False)
    identity_number  = serializers.CharField(max_length=255, required=False)
    parent_id = serializers.IntegerField()
    relationship = serializers.IntegerField()
    
    def update_item(self, validated_data, request_meta, cid, mid):
        
        member_obj = InsuranceMembers.objects.filter(id=mid)
        if member_obj.count() == 0:
            return [False, 'کاربر یافت نشد']
        
        if validated_data['parent_id'] is None or validated_data['parent_id'] == '':
            parentid = None
        else:
            parentid = validated_data['parent_id']
        
        relation_obj = Relationship.objects.filter(id=validated_data['relationship'])
        if relation_obj.count() == 0:
            return [False, 'رابطه یافت نشد']
        
        member_obj.update(
            first_name=validated_data['first_name'], last_name=validated_data['last_name'], father_name=validated_data['father_name'],
            gender=validated_data['gender'], national_code=validated_data['national_code'], birth_date=validated_data['birth_date'],
            insurance_code=validated_data['insurance_code'], identity_number=validated_data['identity_number'], parent_id=parentid,
            relationship_id=validated_data['relationship']
        )
        return [True, 'کاربر به روزرسانی شد']
        


class DeleteInsuranceContractMemeberSerializer(serializers.Serializer):
    
    def delete(self, validated_data, cid, mid) -> list:
        member_object = InsuranceContractMembers.objects.filter(insurance_contract_id=cid, insurance_member_id=mid)
        if member_object.count() > 0:
            member_object.delete()
            InsuranceMembers.objects.filter(id=mid).delete()
            return [True, "Insurace ContractMember Deleted"]
        else:
            return [False, "Insurace ContractMember Not Exist"]
    
    class Meta:
        model = InsuranceContractMembers
        fields = ['name']


class ContractParentMemberSerializer(serializers.Serializer):
    
    def get_parent(self, validated_data, request_meta, cid):
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]

        if InsuranceContracts.objects.filter(id=cid).count() == 0:
            return [False, 'قرار داد یافت نشد']
        last = []
        contract_members = InsuranceContractMembers.objects.filter(insurance_contract_id=cid).annotate(
            member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()),
            relationship=F('insurance_member__relationship__title'),
            member_id=F('insurance_member__id')
        ).values('member_name', 'relationship', 'member_id')
        for val in contract_members:
            if val['relationship'] == 'اصلی':
                last.append({'member_name': val['member_name'], 'member_id': val['member_id']})
        return [True, last]

        
        
        


class GetContractPeriodResponseMessageSerializer(serializers.Serializer):
    username = serializers.CharField()
    period_number = serializers.IntegerField()
    period_date = serializers.DateTimeField()
    damages = serializers.IntegerField()
    costs = serializers.IntegerField()
    payments = serializers.IntegerField()
    period_id = serializers.IntegerField()

class GetContractPeriodResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetContractPeriodResponseMessageSerializer(many=True)

class GetContractPeriodSerializer(serializers.Serializer):
    
    def get_period(self, validated_data, request_meta, request) -> list:
        
        active_contract_obj = InsuranceContracts.objects.filter(is_active=True)
        active_contract_id = active_contract_obj.values_list('id', flat=True)[0]
        if active_contract_obj.count() == 0:
            return [False, 'قرار داد فعالی یافت نشد']
        if request.GET.get('filter') == None:
            periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=active_contract_id).annotate(
                period_number=F('insurance_period__period_number'),
                period_date=F('insurance_period__period_date'),
                user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
                period_id=F('insurance_period__id'),
            ).values('period_number', 'period_date', 'user_name', 'insurance_contract_id', 'id', 'period_id').order_by("-created_at")
        else:
            if request.GET.get('filter').isnumeric():
                periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=active_contract_id).filter(
                    Q(insurance_period__period_number__icontains=request.GET.get('filter'))
                )
            else:
                periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=active_contract_id).filter(
                    Q(insurance_period__user__last_name__icontains=request.GET.get('filter')) |
                    Q(insurance_period__user__first_name__icontains=request.GET.get('filter')) |
                    Q(insurance_period__user__user_name__icontains=request.GET.get('filter'))
                )
            periods = periods.annotate(
                period_number=F('insurance_period__period_number'),
                period_date=F('insurance_period__period_date'),
                user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
                period_id=F('insurance_period__id'),
            ).values('period_number', 'period_date', 'user_name', 'insurance_contract_id', 'id', 'period_id').order_by("-created_at")
        
        damage_count = 0
        total_costs = 0
        total_payments = 0
        for period in periods:
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).values()
            for req in requests_of_documents:
                if req['claimed_fee'] is not None:
                    total_costs += req['claimed_fee']
                if req['benefit'] is not None:
                    total_payments += req['benefit']
            damage_count += len(requests_of_documents)
            
        datas = custom_pagination(periods, request.GET.get('count', 100000), request.GET.get('page_number', 1))
        
        datas['damage_count'] = damage_count
        datas['total_costs'] = total_costs
        datas['total_payments'] = total_payments
        for period in datas['datas']:
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).values()
            period['costs'] = 0
            period['payments'] = 0
            for req in requests_of_documents:
                if req['claimed_fee'] is not None:
                    period['costs'] += req['claimed_fee']
                if req['benefit'] is not None:
                    period['payments'] += req['benefit']
            period['damages'] = len(requests_of_documents)
            period['username'] = period['user_name']
            period['period_number'] = period['period_number']
            period['period_date'] = period['period_date']
            period['period_id'] = period['period_id']
            
        return [True, datas]


class GetOneContractPeriodSerializer(serializers.Serializer):
    
    def get_period(self, validated_data, request_meta, cid, request) -> list:
        contract_id = InsuranceContracts.objects.filter(id=cid).values_list('id', flat=True)[0]
        if request.GET.get('filter') == None:
            periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=contract_id).annotate(
                period_number=F('insurance_period__period_number'),
                period_date=F('insurance_period__period_date'),
                user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
                period_id=F('insurance_period__id'),
            ).values('period_number', 'period_date', 'user_name', 'insurance_contract_id', 'id', 'period_id').order_by("-created_at")
        else:
            if request.GET.get('filter').isnumeric():
                periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=contract_id).filter(
                    Q(insurance_period__period_number__icontains=request.GET.get('filter'))
                )
            else:
                periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=contract_id).filter(
                    Q(insurance_period__user__last_name__icontains=request.GET.get('filter')) |
                    Q(insurance_period__user__first_name__icontains=request.GET.get('filter')) |
                    Q(insurance_period__user__user_name__icontains=request.GET.get('filter'))
                )
            periods = periods.annotate(
                period_number=F('insurance_period__period_number'),
                period_date=F('insurance_period__period_date'),
                user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
                period_id=F('insurance_period__id'),
            ).values('period_number', 'period_date', 'user_name', 'insurance_contract_id', 'id', 'period_id').order_by("-created_at")
        
        damage_count = 0
        total_costs = 0
        total_payments = 0
        for period in periods:
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).values()
            for req in requests_of_documents:
                if req['claimed_fee'] is not None:
                    total_costs += req['claimed_fee']
                if req['benefit'] is not None:
                    total_payments += req['benefit']
            damage_count += len(requests_of_documents)
        
        datas = custom_pagination(periods, request.GET.get('count', 100000), request.GET.get('page_number', 1))
        
        datas['damage_count'] = damage_count
        datas['total_costs'] = total_costs
        datas['total_payments'] = total_payments
        for period in datas['datas']:
            period['costs'] = 0
            period['payments'] = 0
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).values()
            for req in requests_of_documents:
                if req['claimed_fee'] is not None:
                    period['costs'] += req['claimed_fee']
                if req['benefit'] is not None:
                    period['payments'] += req['benefit']
            period['damages'] = len(requests_of_documents)
            period['username'] = period['user_name']
            period['period_number'] = period['period_number']
            period['period_date'] = period['period_date']
            period['period_id'] = period['period_id']
        return [True, datas]


class GetRequestsContractPeriodResponseSerializer(serializers.Serializer):
    member_name = serializers.CharField()
    request_id = serializers.IntegerField()
    document_number = serializers.IntegerField()
    relationship = serializers.CharField()
    claimed_fee = serializers.CharField()
    service_name = serializers.CharField()
    benefit = serializers.IntegerField()
    result = serializers.CharField()
    parent_name = serializers.CharField()
class GetRequestsContractPeriodResponseSerializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = GetRequestsContractPeriodResponseSerializer(many=True)

class GetRequestsContractPeriodSerializer(serializers.Serializer):
    
    def get_requests(self, validated_data, request_meta, cid, pid, request) -> list:
        if request.GET.get('filter') == None:
            periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid, insurance_period_id=pid).annotate(
                period_number=F('insurance_period__period_number'),
                period_date=F('insurance_period__period_date'),
                user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
                period_id=F('insurance_period__id'),
            ).values('id', 'period_id')
        else:
            periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid, insurance_period_id=pid).filter(
                Q(insurance_contract__company__icontains=request.GET.get('filter')) |
                Q(insurance_contract__title__icontains=request.GET.get('filter')) |
                Q(insurance_contract__number__icontains=request.GET.get('filter')) |
                Q(insurance_period__user__user_name__icontains=request.GET.get('filter')) |
                Q(insurance_period__user__first_name__icontains=request.GET.get('filter')) |
                Q(insurance_period__user__last_name__icontains=request.GET.get('filter'))
            ).annotate(
                period_number=F('insurance_period__period_number'),
                period_date=F('insurance_period__period_date'),
                user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
                period_id=F('insurance_period__id'),
            ).values('id', 'period_id')
        
        last = list()
        for period in periods:
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                document_number=F('document_id__id'), relationship=F('member__relationship__title'),
                parent_id=F('member__parent_id'),
                service_name=F('service__title')
            ).values('member_name', 'document_number', 'relationship', 'parent_id', 'claimed_fee', 'service_name', 'benefit', 'result', 'id')
            for req in requests_of_documents:
                if req['parent_id'] is None:
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'],
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': req['member_name']
                    }
                else:
                    parent_name = InsuranceMembers.objects.filter(id=req['parent_id']).values_list('first_name', 'last_name')[0]
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'], 
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': parent_name[0] + ' ' +parent_name[1]
                    }
                last.append(req_dict)
        
        datas = custom_pagination(last, request.GET.get('count', 10), request.GET.get('page_number', 1))
        
        return [True, datas]
        

class GetContractPeriodResponseMessageSerializer(serializers.Serializer):
    username = serializers.CharField()
    period_number = serializers.IntegerField()
    period_date = serializers.DateTimeField()
    damages = serializers.IntegerField()
    costs = serializers.IntegerField()
    payments = serializers.IntegerField()

class AddContractPeriodResponseGetMethodSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetContractPeriodResponseMessageSerializer(many=True)
    last_period_number = serializers.IntegerField()

class GetVerfiedDocumentsOfContracts(serializers.Serializer):
    
    def get_requests(self, validated_data, request_meta, cid) -> list:
        contract_obj = InsuranceContracts.objects.filter(id=cid)
        if contract_obj.count() == 0:
            return [False, 'قرار داد یافت نشد']
        
        last_period_number = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid).last()
        last_period_number = last_period_number.insurance_period.period_number
        
        documents = InsuranceDocuments.objects.filter(insurance_contract_id=cid).values('id')
        all = []
        for doc in documents:
            requests_obj = InsuranceRequests.objects.filter(document_id=doc['id'], flag_id=10011, period_id=None).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                service_name=F('service__title'),
                status_name=F('flag__name')
            ).values('member_name', 'service_name', 'result', 'benefit', 'claimed_date', 'claimed_fee', 'status_name')
            for req in requests_obj:
                all.append(
                    {
                        'member_name': req['member_name'],
                        'service_name': req['service_name'],
                        'result': req['result'],
                        'benefit': req['benefit'],
                        'claimed_date': req['claimed_date'],
                        'claimed_fee': req['claimed_fee'],
                        'status_name': req['status_name'],
                    }
                )
        
        return [True, all, last_period_number]


class AddContractPeriodGetResponseMessageSerializer(serializers.Serializer):
    request_id = serializers.IntegerField()
    member_name = serializers.CharField()
    service_name = serializers.CharField()
    benefit = serializers.IntegerField()
    claimed_fee = serializers.CharField()
    relation = serializers.CharField()
    parent_name = serializers.CharField()
    
class AddContractPeriodGetResponseSerializer(serializers.Serializer):
    result = serializers.BooleanField()
    message = AddContractPeriodGetResponseMessageSerializer(many=True)
    last_period_number = serializers.IntegerField()
    all_ids = serializers.ListField()

class AddContractPeriodGetSerializer(serializers.Serializer):
    
    def get_requests(self, validated_data, request_meta, cid, request) -> list:
        contract_obj = InsuranceContracts.objects.filter(id=cid)
        if contract_obj.count() == 0:
            return [False, 'قرار داد یافت نشد']
        
        
        last_period_number = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid)
        if last_period_number.count() == 0:
            last_period_number = 0
        else:
            last_period_number = last_period_number.last()
            last_period_number = last_period_number.insurance_period.period_number
        
        documents = InsuranceDocuments.objects.filter(insurance_contract_id=cid).values('id')
        all = []
        all_ids = []
        for doc in documents:
            requests_obj = InsuranceRequests.objects.filter(document_id=doc['id'], flag_id=10011, period_id=None).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                service_name=F('service__title'),
                relation_name=F('member__relationship__title'),
                parent_id=F('member__parent_id')
            ).values('id', 'member_name', 'service_name', 'benefit', 'claimed_fee', 'relation_name', 'parent_id')
            for req in requests_obj:
                if req['parent_id'] is None or req['parent_id'] == '':
                    all.append(
                        {
                            'request_id': req['id'],
                            'member_name': req['member_name'],
                            'service_name': req['service_name'],
                            'benefit': req['benefit'],
                            'claimed_fee': req['claimed_fee'],
                            'relation': req['relation_name'],
                            'parent_name': req['member_name']
                        }
                    )
                    all_ids.append(req['id'])
                else:
                    parent_name = InsuranceMembers.objects.filter(id=req['parent_id']).values_list('first_name', 'last_name')[0]
                    all.append(
                        {
                            'request_id': req['id'],
                            'member_name': req['member_name'],
                            'service_name': req['service_name'],
                            'benefit': req['benefit'],
                            'claimed_fee': req['claimed_fee'],
                            'relation': req['relation_name'],
                            'parent_name': parent_name[0] + ' ' +parent_name[1]
                        }
                    )
                    all_ids.append(req['id'])
        datas = custom_pagination(all, request.GET.get('count', 10), request.GET.get('page_number', 1))
        
        return [True, datas, last_period_number, all_ids]


class AddContractPeriodSerializer(serializers.Serializer):
    
    user = serializers.CharField(max_length=255, required=True)
    period_number = serializers.CharField(max_length=255, required=True)
    period_date = serializers.DateTimeField()
    requests_id = serializers.ListField()
    
    def add_item(self, validated_data, request_meta, cid) -> list:
        
        user_obj = Users.objects.filter(user_name=validated_data['user'])
        if user_obj.count() == 0:
            return [False, 'کاربر با این ایمیل یافت نشد']
        
        same_periods_number = InsurancePeriods.objects.filter(period_number=validated_data['period_number']).values('id')
        for period in same_periods_number:
            if InsuranceContractPeriods.objects.filter(insurance_contract_id=cid, insurance_period_id=period['id']).exists():
                return [False, 'دوره با این شماره وجود دارد']
        
        
        try:
            with transaction.atomic():
                period_obj = InsurancePeriods.objects.create(
                    user_id=user_obj.values_list('id', flat=True)[0], period_number=validated_data['period_number'],
                    period_date=validated_data['period_date']
                )
                InsuranceContractPeriods.objects.create(
                    insurance_contract_id=cid, insurance_period_id=period_obj.id
                )
                requestids = validated_data['requests_id'].split(',')
                for req in requestids:
                    request_obj = InsuranceRequests.objects.filter(id=req,flag_id=10011)
                    if request_obj.exists():
                        request_obj.update(period_id=period_obj.id, flag_id=10009)
                    else:
                        transaction.rollback()
                        return [False, 'درخواست بیمه یافت نشد']
                    
            return [True, 'دوره اضافه شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']
        

class DeleteContractPeriodSerializer(serializers.Serializer):
    
    def delete_period(self, validaed_data, request_meta, pid):
        
        try:
            with transaction.atomic():
                InsuranceRequests.objects.filter(period_id=pid).update(period_id=None, flag_id=10011)
                InsuranceContractPeriods.objects.filter(insurance_period_id=pid).delete()
                InsurancePeriods.objects.filter(id=pid).delete()
                return [True, 'دوره حذف شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']



class AddContractPeriodGetResponseMessageSerializer(serializers.Serializer):
    request_id = serializers.IntegerField()
    member_name = serializers.CharField()
    service_name = serializers.CharField()
    benefit = serializers.IntegerField()
    claimed_fee = serializers.CharField()
    relation = serializers.CharField()
    parent_name = serializers.CharField()
    
class UpdateContractPeriodGetResponseSerializer(serializers.Serializer):
    result = serializers.BooleanField()
    message = AddContractPeriodGetResponseMessageSerializer(many=True)
    last_period_number = serializers.IntegerField()
    current_period_date = serializers.DateTimeField()
    current_period_number = serializers.DateTimeField()


class UpdateContractPeriodGetSerializer(serializers.Serializer):
    
    def get_requests(self, validated_data, request_meta, cid, pid, request) -> list:
        contract_obj = InsuranceContracts.objects.filter(id=cid)
        if contract_obj.count() == 0:
            return [False, 'قرار داد یافت نشد']
        
        last_period = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid).last()
        last_period_number = last_period.insurance_period.period_number
        current_period = InsuranceContractPeriods.objects.filter(insurance_period_id=pid).annotate(
            period_number=F('insurance_period__period_number'),
            period_date=F('insurance_period__period_date'),
        ).values('period_number', 'period_date')[0]
        current_period_date = current_period['period_date']
        current_period_number = current_period['period_number']
        
        all = []
        requests_obj = InsuranceRequests.objects.filter(period_id=pid).annotate(
            member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
            service_name=F('service__title'),
            relation_name=F('member__relationship__title'),
            parent_id=F('member__parent_id')
        ).values('id', 'member_name', 'service_name', 'benefit', 'claimed_fee', 'relation_name', 'parent_id')
        for req in requests_obj:
            if req['parent_id'] is None or req['parent_id'] == '':
                all.append(
                    {
                        'request_id': req['id'],
                        'member_name': req['member_name'],
                        'service_name': req['service_name'],
                        'benefit': req['benefit'],
                        'claimed_fee': req['claimed_fee'],
                        'relation': req['relation_name'],
                        'parent_name': req['member_name']
                    }
                )
            else:
                parent_name = InsuranceMembers.objects.filter(id=req['parent_id']).values_list('first_name', 'last_name')[0]
                all.append(
                    {
                        'request_id': req['id'],
                        'member_name': req['member_name'],
                        'service_name': req['service_name'],
                        'benefit': req['benefit'],
                        'claimed_fee': req['claimed_fee'],
                        'relation': req['relation_name'],
                        'parent_name': parent_name[0] + ' ' +parent_name[1]
                    }
                )
        
        datas = custom_pagination(all, request.GET.get('count', 100000), request.GET.get('page_number', 1))
        
        return [True, datas, last_period_number, current_period_date, current_period_number]


class UpdateContractPeriodSerializer(serializers.Serializer):
    
    user = serializers.CharField(max_length=255, required=True)
    period_number = serializers.CharField(max_length=255, required=False)
    period_date = serializers.DateTimeField(required=False)
    requests_id = serializers.ListField()
    
    def update_item(self, validated_data, request_meta, cid, pid) -> list:
        
        period_obj = InsurancePeriods.objects.filter(id=pid)
        if period_obj.count() == 0:
            return [False, 'دوره مربوطه یافت نشد']
        
        user_obj = Users.objects.filter(user_name=validated_data['user'])
        if user_obj.count() == 0:
            return [False, 'کاربر با این ایمیل یافت نشد']
        else:
            period_obj.update(
                user_id=user_obj.values_list('id', flat=True)[0]
            )
        
        if validated_data['period_number'] is not None or validated_data['period_number'] != '':
            same_periods_number = InsurancePeriods.objects.filter(period_number=validated_data['period_number']).values('id')
            for period in same_periods_number:
                if InsuranceContractPeriods.objects.filter(insurance_contract_id=cid, insurance_period_id=period['id']).exists():
                    return [False, 'دوره با این شماره وجود دارد']
            period_obj.update(
                period_number=validated_data['period_number']
            )
        period_obj.update(
            period_date=validated_data['period_date']
        )
        
        try:
            with transaction.atomic():
                
                requestids = validated_data['requests_id'].split(',')
                current_requests_in_period = InsuranceRequests.objects.filter(period_id=pid).values('id')
                for req in current_requests_in_period:
                    if req['id'] not in requestids:
                        InsuranceRequests.objects.filter(id=req['id']).update(
                            period_id = None
                        )
                    
            return [True, 'به روزرسانی شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']


class DeleteRequestsPeriodSerializer(serializers.Serializer):
    
    requests_id = serializers.ListField()
    period_date = serializers.DateTimeField(required=False)
    period_number = serializers.IntegerField(required=False)
    
    def delete_items(self, validated_data, request_meta, pid):
        
        period_obj = InsurancePeriods.objects.filter(id=pid)
        if period_obj.count() == 0:
            return [False, 'دوره مربوطه یافت نشد']
        
        if validated_data['period_number'] != '' or validated_data['period_number'] is not None:
            period_obj.update(
                period_number=validated_data['period_number']
            )
        
        if validated_data['period_date'] != '' or validated_data['period_date'] is not None:
            period_obj.update(
                period_date=validated_data['period_date']
            )
        try:
            with transaction.atomic():
                for req in validated_data['requests_id'].split(','):
                    logger = logging.getLogger('insurance.views')
                    logger.error('req id is '+str(req))
                    InsuranceRequests.objects.filter(id=req).update(period_id=None, flag_id=10011)
                return [True, 'انجام شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']




class GetInsuranceDocumentsContractMessageResponseSeializer(serializers.Serializer):
    id =serializers.IntegerField()
    insurance_contract_id = serializers.IntegerField()
    insurance_member_id = serializers.IntegerField()
    created_at = serializers.DateTimeField()
    updated_at = serializers.DateTimeField()
    user_name= serializers.CharField()
    member_name = serializers.CharField()
    department_name = serializers.CharField()
    total_costs = serializers.IntegerField()
    total_payments = serializers.IntegerField()
    damage_count = serializers.IntegerField()

class GetInsuranceDocumentsContractContractResponseSeializer(serializers.Serializer):
    id =serializers.IntegerField()
    company = serializers.CharField()
    title = serializers.CharField()
    number = serializers.CharField()

class GetInsuranceDocumentsContractResponseErrorSeializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = GetInsuranceDocumentsContractMessageResponseSeializer(many=True)
    contract = GetInsuranceDocumentsContractContractResponseSeializer()

class GetInsuranceDocumentsMessageResponseSeializer(serializers.Serializer):
    id =serializers.IntegerField()
    insurance_contract_id = serializers.IntegerField()
    insurance_member_id = serializers.IntegerField()
    created_at = serializers.DateTimeField()
    updated_at = serializers.DateTimeField()
    user_name= serializers.CharField()
    member_name = serializers.CharField()
    department_name = serializers.CharField()
    total_costs = serializers.IntegerField()
    total_payments = serializers.IntegerField()
    damage_count = serializers.IntegerField()
    count_new_items = serializers.IntegerField()
    
class GetInsuranceDocumentsResponseSeializer(serializers.Serializer):
    
    result = serializers.CharField()
    message = GetInsuranceDocumentsMessageResponseSeializer(many=True)

class GetInsuranceDocumentsResponseErrorSeializer(serializers.Serializer):
    result = serializers.CharField()
    message = serializers.CharField()

class GetInsuranceDocumentsSeializer(serializers.Serializer):
    
    def get_items(self, validated_data, request_meta, request):
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد', None]
            else:
                user_id = user_object.values_list('id', flat=True)[0]    
        
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        current_active_contract = InsuranceContracts.objects.filter(is_active=True).values_list('id',flat=True)[0]
        
        print(user_object.values_list('national_code',flat=True)[0])
        if is_admin == False:
            '''
            find member id
            '''
            member_obj = InsuranceMembers.objects.filter(national_code=user_object.values_list('national_code',flat=True)[0], parent_id=None)
            print(member_obj)
            if member_obj.count() == 0:
                return [False, 'کاربر در لیست بیمه یافت نشد', None]
            member_obj_id = member_obj.values_list('id', flat=True).order_by('-created_at')[0]
            '''
            Check user exist in this contract or not
            '''
            insurance_member_obj = InsuranceContractMembers.objects.filter(insurance_contract_id=current_active_contract, insurance_member_id=member_obj_id)
            if insurance_member_obj.count() == 0:
                return [False, 'کاربر در این قرار داد یافت نشد', None]
        
        if is_admin:
            if request.GET.get('filter') == None:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=current_active_contract).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
            else:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=current_active_contract).filter(
                        Q(id__icontains=request.GET.get('filter')) |
                        Q(user__last_name__icontains=request.GET.get('filter')) |
                        Q(user__first_name__icontains=request.GET.get('filter')) |
                        Q(user__department__icontains=request.GET.get('filter')) |
                        Q(insurance_member__last_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__first_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__father_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__identity_number__icontains=request.GET.get('filter')) |
                        Q(insurance_member__national_code__icontains=request.GET.get('filter')) |
                        Q(insurance_member__insurance_code__icontains=request.GET.get('filter'))
                    ).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
                
        else:
            if request.GET.get('filter') == None:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=current_active_contract, insurance_member_id=member_obj_id).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
            else:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=current_active_contract, insurance_member_id=member_obj_id).filter(
                        Q(id__icontains=request.GET.get('filter')) |
                        Q(user__last_name__icontains=request.GET.get('filter')) |
                        Q(user__first_name__icontains=request.GET.get('filter')) |
                        Q(user__department__icontains=request.GET.get('filter')) |
                        Q(insurance_member__last_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__first_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__father_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__identity_number__icontains=request.GET.get('filter')) |
                        Q(insurance_member__national_code__icontains=request.GET.get('filter')) |
                        Q(insurance_member__insurance_code__icontains=request.GET.get('filter'))
                    ).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
        
        datas = custom_pagination(documents, request.GET.get('count', 10), request.GET.get('page_number', 1))
        
        for doc in datas['datas']:
            req_obj = InsuranceRequests.objects.filter(document_id=doc['id'])
            price = 0
            benefit = 0 
            for req in req_obj.values():
                if req['claimed_fee'] is not None and req['claimed_fee'] != '':
                    price += int(req['claimed_fee'])
                if req['benefit'] is not None and req['benefit'] != '':
                    benefit += int(req['benefit'])
            doc['total_costs'] = price
            doc['total_payments'] = benefit
            doc['damage_count'] = len(req_obj)
            doc['count_new_items'] = req_obj.filter(flag_id=10004).count()
        
        datas['total_costs'] = 0
        datas['total_payments'] = 0
        datas['damage_count'] = 0
        for doc in documents.values():
            req_obj = InsuranceRequests.objects.filter(document_id=doc['id'])
            price = 0
            benefit = 0 
            for req in req_obj.values():
                if req['claimed_fee'] is not None and req['claimed_fee'] != '':
                    price += int(req['claimed_fee'])
                if req['benefit'] is not None and req['benefit'] != '':
                    benefit += int(req['benefit'])
            datas['total_costs'] += price
            datas['total_payments'] += benefit
            datas['damage_count'] += len(req_obj)
        contract = InsuranceContracts.objects.filter(is_active=True).values('id', 'company', 'title', 'number')[0]
        return [True, datas, contract]


class GetInsuranceDocumentsContractSeializer(serializers.Serializer):
    
    def get_items(self, validated_data, request_meta, cid, request):
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]  
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        '''
        find member id
        '''
        member_obj = InsuranceMembers.objects.filter(national_code=user_object.values_list('national_code',flat=True)[0], parent_id=None)
        if is_admin == False:
            if member_obj.count() == 0:
                return [False, 'کاربر در لیست بیمه یافت نشد']
            member_obj_id = member_obj.values_list('id', flat=True)
            member_id = 0
            '''
            Check user exist in this contract or not
            '''
            for member in member_obj_id:
                insurance_member_obj = InsuranceContractMembers.objects.filter(insurance_contract_id=cid, insurance_member_id=member)
                if insurance_member_obj.count() != 0:
                    member_id = member
            
            if member_id == 0:
                return [False, 'کاربر در این قرار داد یافت نشد']
        
        # print(member_id)
        if is_admin:
            if request.GET.get('filter') == None:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=cid).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
            else:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=cid).filter(
                        Q(id__icontains=request.GET.get('filter')) |
                        Q(user__last_name__icontains=request.GET.get('filter')) |
                        Q(user__first_name__icontains=request.GET.get('filter')) |
                        Q(user__department__icontains=request.GET.get('filter')) |
                        Q(insurance_member__last_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__first_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__father_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__identity_number__icontains=request.GET.get('filter')) |
                        Q(insurance_member__national_code__icontains=request.GET.get('filter')) |
                        Q(insurance_member__insurance_code__icontains=request.GET.get('filter'))
                    ).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
        else:
            if request.GET.get('filter') == None:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=cid, insurance_member_id=member_id).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")
            else:
                documents = InsuranceDocuments.objects.filter(insurance_contract_id=cid, insurance_member_id=member_id).filter(
                        Q(id__icontains=request.GET.get('filter')) |
                        Q(user__last_name__icontains=request.GET.get('filter')) |
                        Q(user__first_name__icontains=request.GET.get('filter')) |
                        Q(user__department__icontains=request.GET.get('filter')) |
                        Q(insurance_member__last_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__first_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__father_name__icontains=request.GET.get('filter')) |
                        Q(insurance_member__identity_number__icontains=request.GET.get('filter')) |
                        Q(insurance_member__national_code__icontains=request.GET.get('filter')) |
                        Q(insurance_member__insurance_code__icontains=request.GET.get('filter'))
                    ).annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), department_name=F('user__department')).values('id', 'user_name', 'member_name', 'department_name', 'insurance_member_id', 'created_at', 'insurance_contract_id').order_by("-created_at")

        datas = custom_pagination(documents, request.GET.get('count', 10), request.GET.get('page_number', 1))
        
        for doc in datas['datas']:
            doc['editable'] = False
            doc['deleteable'] = True
            req_obj = InsuranceRequests.objects.filter(document_id=doc['id'])
            price = 0
            benefit = 0 
            for req in req_obj.values():
                print(req)
                if req['flag_id'] != 10004:
                    doc['deleteable'] = False
                if req['flag_id'] == 10004:
                    doc['editable'] = True
                if req['claimed_fee'] is not None and req['claimed_fee'] != '':
                    price += int(req['claimed_fee'])
                if req['benefit'] is not None and req['benefit'] != '':
                    benefit += int(req['benefit'])
            doc['total_costs'] = price
            doc['total_payments'] = benefit
            doc['damage_count'] = len(req_obj)
            doc['count_new_items'] = req_obj.filter(flag_id=10004).count()
        
        datas['total_costs'] = 0
        datas['total_payments'] = 0
        datas['damage_count'] = 0
        for doc in documents.values():
            req_obj = InsuranceRequests.objects.filter(document_id=doc['id'])
            price = 0
            benefit = 0 
            for req in req_obj.values():
                
                if req['claimed_fee'] is not None and req['claimed_fee'] != '':
                    price += int(req['claimed_fee'])
                if req['benefit'] is not None and req['benefit'] != '':
                    benefit += int(req['benefit'])
            datas['total_costs'] += price
            datas['total_payments'] += benefit
            datas['damage_count'] += len(req_obj)
        
        return [True, datas]


class GetDocumentRequestsResponseMessageDetailSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    claimed_date = serializers.DateTimeField()
    claimed_fee = serializers.IntegerField()
    benefit = serializers.IntegerField()
    result = serializers.CharField()
    member_name = serializers.CharField()
    service_name = serializers.CharField()
    status_name = serializers.CharField()
    deleteable = serializers.BooleanField()
    editable = serializers.BooleanField()
    
    
class GetDocumentRequestsResponseMessageGeneralSerializer(serializers.Serializer):
    created_at = serializers.DateTimeField()
    id = serializers.IntegerField()
    insurance_contract_id = serializers.IntegerField()
    member_name= serializers.CharField()
    user_name = serializers.CharField()

class GetDocumentRequestsResponseMessageSerializer(serializers.Serializer):
    general = GetDocumentRequestsResponseMessageGeneralSerializer()
    detail = GetDocumentRequestsResponseMessageDetailSerializer(many=True)

class GetDocumentRequestsResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetDocumentRequestsResponseMessageSerializer()

class GetDocumentRequestsSerializer(serializers.Serializer):
    
    def get_items(self, validated_data, request_meta, mid, did, request):
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]  
        
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        '''
        Check Document Exist
        '''
        doc_obj = InsuranceDocuments.objects.filter(id=did)
        if doc_obj.count() == 0:
            return [False, 'سند موجود نمیباشد']

        '''
        Check Is User Owner of Doc or not
        '''
        if is_admin == False:
            doc_obj = InsuranceDocuments.objects.filter(id=did, insurance_member_id=mid)
            if doc_obj.count() == 0:
                return [False, 'کاربر مالک این سند نمیباشد']

        if is_admin:
            requests = InsuranceRequests.objects.filter(document_id=did).annotate(member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()), service_name=F('service__title'), status_name=F('flag__name'), period_number=F('period__period_number')).values('id', 'member_name', 'service_name', 'claimed_date', 'claimed_fee', 'benefit', 'status_name', 'result', 'member_id', 'description', 'period_number')
        else:
            requests = InsuranceRequests.objects.filter(document_id=did).annotate(member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()), service_name=F('service__title'), status_name=F('flag__name')).values('id', 'member_name', 'service_name', 'claimed_date', 'claimed_fee', 'benefit', 'status_name', 'result', 'member_id', 'description')
        
        datas = custom_pagination(requests, request.GET.get('count', 10), request.GET.get('page_number', 1))
        
        last = {}
        for req in datas['datas']:
            
            if req['status_name'] == "درخواست جدید":
                req['editable'] = True
                req['deleteable'] = False
        
        documents = InsuranceDocuments.objects.filter(id=did).annotate(member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), )
        for req in documents.values('member_name', 'user_name', 'created_at', 'id', 'insurance_contract_id'):
            last["general"] = req
        
        last["detail"] = datas
        return [True, last]
        


class AddInsuranceDocumentsSerializer(serializers.Serializer):
    
    insurance_contract = serializers.CharField(max_length=255, required=True)
    insurance_request_detail = serializers.CharField(max_length=100000, required=True)
    user_id = serializers.CharField(max_length=255, required=True)
    
    def add_document(self, validated_data) -> list:
        
        try:
            with transaction.atomic():
                print(validated_data['insurance_request_detail'])
                
                print(type(validated_data['insurance_request_detail']))
                for req in json.loads(validated_data['insurance_request_detail']):
                    print(req)
                    parent_id = InsuranceMembers.objects.filter(id=req['member']).values_list('parent_id', flat=True)[0]
                    if parent_id is None or parent_id == '':
                        main_member_id = req['member']
                        print(main_member_id)
                        break
                    else:
                        main_member_id = parent_id
                        break
                print(main_member_id)
                doc_obj = InsuranceDocuments.objects.create(
                    insurance_contract_id=validated_data['insurance_contract'], insurance_member_id=main_member_id,
                    user_id=validated_data['user_id']
                )
                print(2222)
                for req in json.loads(validated_data['insurance_request_detail']):
                    if req['date_for_payment'] == '' or req['date_for_payment'] is None:
                        pay_date=timezone.now()
                    else:
                        pay_date=req['date_for_payment']
                    InsuranceRequests.objects.create(
                        user_id=validated_data['user_id'], document_id=doc_obj.id,
                        member_id=req['member'],service_id=req['service'],
                        flag_id=10004, claimed_date=pay_date,
                        description=req['description'], claimed_fee=req['amount'],
                    )
        
            return [True, "اضافه شد"]
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']


class UpdateInsuranceDocumentsSerializer(serializers.Serializer):
    
    insurance_request_detail = serializers.JSONField()

    def update_item(self, validated_data, request_meta, mid, did) -> list:
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        '''
        Check Document Exist
        '''
        doc_obj = InsuranceDocuments.objects.filter(id=did)
        if doc_obj.count() == 0:
            return [False, 'سند موجود نمیباشد']

        '''
        Check Is User Owner of Doc or not
        '''
        if is_admin == False:
            doc_obj = InsuranceDocuments.objects.filter(id=did, insurance_member_id=mid)
            if doc_obj.count() == 0:
                return [False, 'کاربر مالک این سند نمیباشد']
        try:
            with transaction.atomic():
                for req in json.loads(validated_data['insurance_request_detail']):
                    if req['date_for_payment'] == '' or req['date_for_payment'] is None:
                        pay_date=timezone.now()
                    else:
                        pay_date=req['date_for_payment']
                    if req['id'] == 'new':
                        InsuranceRequests.objects.create(
                            member_id=req['member'],service_id=req['service'],
                            flag_id=10004, claimed_date=pay_date,
                            description=req['description'], claimed_fee=req['amount'],
                            document_id=did
                        )
                    else:
                        InsuranceRequests.objects.filter(id=req['id']).update(
                            member_id=req['member'],service_id=req['service'],
                            flag_id=10004, claimed_date=pay_date,
                            description=req['description'], claimed_fee=req['amount'],
                            document_id=did
                        )
                    print(3333)
        
            return [True, "به روزرسانی شد"]
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']
        

class DeleteInsuranceDocumentsResponseSerializer(serializers.Serializer):
    result = serializers.BooleanField()
    message = serializers.CharField()

class DeleteInsuranceDocumentsSerializer(serializers.Serializer):
    
    def delete(self, validated_data, request_meta, mid, did) -> list:
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]
        
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        '''
        Check Document Exist
        '''
        doc_obj = InsuranceDocuments.objects.filter(id=did)
        if doc_obj.count() == 0:
            return [False, 'سند موجود نمیباشد']

        '''
        Check Is User Owner of Doc or not
        '''
        if is_admin == False:
            doc_obj = InsuranceDocuments.objects.filter(id=did, insurance_member_id=mid)
            if doc_obj.count() == 0:
                return [False, 'کاربر مالک این سند نمیباشد']
        
        try:
            with transaction.atomic():
                InsuranceDocuments.objects.filter(id=did).delete()
                InsuranceRequests.objects.filter(document_id=did).delete()
        
            return [True, "سند و درخواستهای مربوطه آن شد"]
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']


class ExportDocumentSerializer(serializers.Serializer):
    
    pass


class GetDocumentMemberMessageMemberListResponseSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    insurance_member_id = serializers.IntegerField()
    insurance_contract_id = serializers.IntegerField()
    member_name = serializers.CharField()
    first_name = serializers.CharField()
    last_name = serializers.CharField()
    relation_name = serializers.CharField()
    father_name = serializers.IntegerField()
    relationshop = serializers.IntegerField()
    gender = serializers.IntegerField()
    identity_number = serializers.IntegerField()
    national_code = serializers.IntegerField()
    birth_date = serializers.DateTimeField()
    insurance_code = serializers.IntegerField()
    parent_name = serializers.IntegerField()

class GetDocumentMemberMessageResponseSerializer(serializers.Serializer):
    contract = serializers.CharField()
    member_list = GetDocumentMemberMessageMemberListResponseSerializer(many=True)

class GetDocumentMemberResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetDocumentMemberMessageResponseSerializer(many=True)
    is_active = serializers.BooleanField()

class GetDocumentMemberSerializer(serializers.Serializer):
    
    def get_members(self, validated_data, request_meta, cid) -> list:
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]  
        
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        member_obj = InsuranceMembers.objects.filter(national_code=user_object.values_list('national_code',flat=True)[0], parent_id=None)
        if is_admin == False:
            if member_obj.count() == 0:
                return [False, 'کاربر در لیست بیمه یافت نشد']
            member_obj_id = member_obj.values_list('id', flat=True)
            mid = 0
            '''
            Check user exist in this contract or not
            '''
            for member in member_obj_id:
                insurance_member_obj = InsuranceContractMembers.objects.filter(insurance_contract_id=cid, insurance_member_id=member)
                if insurance_member_obj.count() != 0:
                    mid = member
            
            if mid == 0:
                return [False, 'کاربر در این قرار داد یافت نشد']
        
        if is_admin:
            members = InsuranceContractMembers.objects.filter(insurance_contract_id=cid).annotate(
                member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), 
                relation_name=F('insurance_member__relationship__title'),
                parent_id=F('insurance_member__parent_id')
            ).values('id', 'insurance_member_id', 'insurance_contract_id', 'member_name', 'relation_name', 'parent_id')
            for member in members:
                if member['relation_name'] == 'اصلی':
                    pass
                else:
                    parent_name = InsuranceMembers.objects.filter(id=member['parent_id']).annotate(
                        member_name=Concat(Value(member['relation_name']), Value(' '), F('first_name'), Value(' '), F('last_name'), output_field=CharField())
                    ).values('member_name')
                    print(parent_name)
                    member['relation_name'] = parent_name[0]['member_name']
        else:
            members_of_parent = InsuranceMembers.objects.filter(parent_id=mid).values('id')
            last = list()
            # add parent member to list
            last.append(insurance_member_obj.annotate(
                    member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), 
                    relation_name=F('insurance_member__relationship__title')
                ).values('id', 'insurance_member_id', 'insurance_contract_id', 'member_name', 'relation_name')[0])
            for mem in members_of_parent:
                last.append(InsuranceContractMembers.objects.filter(insurance_contract_id=cid, insurance_member_id=mem['id']).annotate(
                    member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()), 
                    relation_name=F('insurance_member__relationship__title')
                ).values('id', 'insurance_member_id', 'insurance_contract_id', 'member_name', 'relation_name')[0])
            members = last
        return [True, members]


class GetDocumentServiceMessageResponseSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    insurance_service_id = serializers.IntegerField()
    insurance_contract_id = serializers.IntegerField()
    service_name = serializers.CharField()

class GetDocumentServiceResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetDocumentMemberMessageResponseSerializer(many=True)


class GetDocumentServiceSerializer(serializers.Serializer):
    
    def get_services(self, validated_data, request_meta, cid) -> list:
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]  
        
        '''
        check user has manager permission or not
        '''
        is_admin = check_admin_permission(user_id, user_object, 'insurance_documents-manage')
        
        member_obj = InsuranceMembers.objects.filter(national_code=user_object.values_list('national_code',flat=True)[0], parent_id=None)
        if is_admin == False:
            if member_obj.count() == 0:
                return [False, 'کاربر در لیست بیمه یافت نشد']
            member_obj_id = member_obj.values_list('id', flat=True)
            mid = 0
            '''
            Check user exist in this contract or not
            '''
            for member in member_obj_id:
                insurance_member_obj = InsuranceContractMembers.objects.filter(insurance_contract_id=cid, insurance_member_id=member)
                if insurance_member_obj.count() != 0:
                    mid = member
            
            if mid == 0:
                return [False, 'کاربر در این قرار داد یافت نشد']
        

        services = InsuranceContractServices.objects.filter(insurance_contract_id=cid).annotate(
            service_name=F('insurance_service__title')
        ).values('id', 'insurance_service_id', 'insurance_contract_id', 'service_name')
        
        return [True, services]


class DocumentsFilterSerializer(serializers.Serializer):
    
    document_ids = serializers.ListField(required=False)
    requests_date = serializers.CharField(required=False, max_length=10000)
    requester_name = serializers.ListField(required=False)
    department_name = serializers.ListField(required=False)
    insured_member = serializers.ListField(required=False)
    total_of_payments = serializers.ListField(required=False)
    total_of_claimed_fees = serializers.ListField(required=False)
    services = serializers.ListField(required=False)
    statuses = serializers.ListField(required=False)
    contract_ids = serializers.ListField(required=False)
    
    def search_in_tables(self, validated_data, request_meta, request):
        
        list_of_ids = []
        if validated_data['document_ids'] != '' and 'document_ids' in validated_data:
            doc_ids = validated_data['document_ids'].split(',')
            document_query = InsuranceRequests.objects.filter(
                Q(document_id__in=doc_ids)
            )
            list_of_ids.append(list(document_query.values_list('id', flat=True)))
        
        if validated_data['requester_name'] != '' and 'requester_name' in validated_data:
            requesters = validated_data['requester_name'].split(',')
            # names = []
            # families = []
            # for mem in requesters:
            #     names.append(mem.split(' ')[0])
            #     full_family = ''
            #     family_length = mem.split(' ')[1:]
            #     counter = 1
            #     for sec in family_length:
            #         full_family += sec
            #         if counter == len(family_length):
            #             pass
            #         else:
            #             full_family += ' '
            #         counter += 1
            #     families.append(full_family)
            # try:
            #     requester_names_query |= InsuranceRequests.objects.filter(
            #         Q(user__first_name__icontains=names) |
            #         Q(user__last_name__icontains=families)
            #     )
            # except NameError:
            #     requester_names_query = InsuranceRequests.objects.filter(
            #         Q(user__first_name__icontains=names) |
            #         Q(user__last_name__icontains=families)
            #     )
            try:
                requester_names_query |= InsuranceRequests.objects.filter(
                    Q(user_id__in=requesters)
                )
            except:
                requester_names_query = InsuranceRequests.objects.filter(
                    Q(user_id__in=requesters)
                )
            
            list_of_ids.append(list(requester_names_query.values_list('id', flat=True)))
            
        if validated_data['department_name'] != '' and 'department_name' in validated_data:
            department_names = validated_data['department_name'].split(',')
            try:
                department_names_query |= InsuranceRequests.objects.filter(
                    Q(user__department__in=department_names)
                )
            except:
                department_names_query = InsuranceRequests.objects.filter(
                    Q(user__department__in=department_names)
                )
            list_of_ids.append(list(department_names_query.values_list('id', flat=True)))
            
        if validated_data['insured_member'] != '' and 'insured_member' in validated_data:
            insured_members = validated_data['insured_member'].split(',')
            # names = []
            # families = []
            # for mem in insured_members:
            #     names.append(mem.split(' ')[0])
            #     full_family = ''
            #     family_length = mem.split(' ')[1:]
            #     counter = 1
            #     for sec in family_length:
            #         full_family += sec
            #         if counter == len(family_length):
            #             pass
            #         else:
            #             full_family += ' '
            #         counter += 1
            #     families.append(full_family)
            # try:
            #     insured_members_query |= InsuranceRequests.objects.filter(
            #         Q(member__first_name__in=names) |
            #         Q(member__last_name__in=families)
            #     )
            # except NameError:
            #     insured_members_query = InsuranceRequests.objects.filter(
            #         Q(member__first_name__in=names) |
            #         Q(member__last_name__in=families)
            #     )
            try:
                insured_members_query |= InsuranceRequests.objects.filter(
                    Q(member_id__in=insured_members)
                )
            except NameError:
                insured_members_query = InsuranceRequests.objects.filter(
                    Q(member_id__in=insured_members)
                )
            list_of_ids.append(list(insured_members_query.values_list('id', flat=True)))
        
        if validated_data['total_of_payments'] != '' and 'total_of_payments' in validated_data:
            tpayments = validated_data['total_of_payments'].split(',')
            for one_pay in tpayments:
                try:
                    total_payments_query |= InsuranceRequests.objects.filter(
                        Q(benefit__gte=one_pay.split('-')[0], benefit__lt=one_pay.split('-')[1])
                    )
                except NameError:
                    total_payments_query = InsuranceRequests.objects.filter(
                        Q(benefit__gte=one_pay.split('-')[0], benefit__lt=one_pay.split('-')[1])
                    )
            list_of_ids.append(list(total_payments_query.values_list('id', flat=True)))
            
        if validated_data['total_of_claimed_fees'] != '' and 'total_of_claimed_fees' in validated_data:
            tclaimes = validated_data['total_of_claimed_fees'].split(',')
            for one_claim in tclaimes:
                try:
                    total_claimeds_query |= InsuranceRequests.objects.filter(
                        Q(claimed_fee__gte=one_claim.split('-')[0], claimed_fee__lt=one_claim.split('-')[1])
                    )
                except NameError:
                    total_claimeds_query = InsuranceRequests.objects.filter(
                        Q(claimed_fee__gte=one_claim.split('-')[0], claimed_fee__lt=one_claim.split('-')[1])
                    )
            list_of_ids.append(list(total_claimeds_query.values_list('id', flat=True)))
            
        if validated_data['services'] != '' and 'services' in validated_data:
            services = validated_data['services'].split(',')
            try:
                services_query |= InsuranceRequests.objects.filter(
                    Q(service__title__in=services)
                )
            except NameError:
                services_query = InsuranceRequests.objects.filter(
                    Q(service__title__in=services)
                )
            list_of_ids.append(list(services_query.values_list('id', flat=True)))
        
        if validated_data['statuses'] != '' and 'statuses' in validated_data:
            statuses = validated_data['statuses'].split(',')
            try:
                statuses_query |= InsuranceRequests.objects.filter(
                    Q(flag__name__in=statuses)
                )
            except NameError:
                statuses_query = InsuranceRequests.objects.filter(
                    Q(flag__name__in=statuses)
                )
            list_of_ids.append(list(statuses_query.values_list('id', flat=True)))
            
        if validated_data['requests_date'] != '' and 'requests_date' in validated_data:
            request_dates = validated_data['requests_date'].split(',')
            if len(request_dates) > 0:
                counter = 0
                for rng in request_dates:
                    one_date = rng.split('~')
                    if counter == 0:
                        try:
                            inresult = InsuranceRequests.objects.filter(
                                Q(created_at__gte=one_date[0], created_at__lte=one_date[1])
                            )
                        except NameError:
                            inresult = InsuranceRequests.objects.filter(
                                Q(created_at__gte=one_date[0], created_at__lte=one_date[1])
                            )
                    else:
                        try:
                            inresult |= InsuranceRequests.objects.filter(
                                Q(created_at__gte=one_date[0], created_at__lte=one_date[1])
                            )
                        except NameError:
                            inresult |= InsuranceRequests.objects.filter(
                                Q(created_at__gte=one_date[0], created_at__lte=one_date[1])
                            )
                    counter += 1
                try:
                    request_dates_query |= inresult
                except NameError:
                    request_dates_query = inresult
                list_of_ids.append(list(request_dates_query.values_list('id', flat=True)))
        
        if validated_data['contract_ids'] != '' and 'contract_ids' in validated_data:
            contracts = validated_data['contract_ids'].split(',')
            for contract in contracts:
                try:
                    contracts_query |= InsuranceRequests.objects.filter(
                        Q(document__insurance_contract__id=contract)
                    )
                except NameError:
                    contracts_query = InsuranceRequests.objects.filter(
                        Q(document__insurance_contract__id=contract)
                    )
            list_of_ids.append(list(contracts_query.values_list('id', flat=True)))

            
        def find_common_ids(*id_lists):
            if len(id_lists) == 1:
                return list(id_lists[0])
            if len(id_lists) < 2:
                return []
            
            set_lists = [set(ids) for ids in id_lists]
            common_ids = set_lists[0].intersection(*set_lists[1:])
            result_list = list(common_ids)
            return result_list
        
        if len(list_of_ids) > 0:
            result = find_common_ids(*list_of_ids)
            if len(result) == 0:
                return [True, {"datas":[], "has_next": False, "has_previous": False, "page_number": 1, "next_url": None, "previous_url": None, "total_page": 0, "total_items": 0}, [], []]
            for resid in result:
                try:
                    last_query |= InsuranceRequests.objects.filter(id=resid).annotate(
                        member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()), 
                        department_name=F('user__department'), service_name=F('service__title'), status__name=F('flag__name'),
                    ).values('id', 'member_name', 'department_name', 'service_name', 'status__name', 'claimed_fee', 'claimed_date', 'result', 'benefit', 'description', 'document')
                except:
                    last_query = InsuranceRequests.objects.filter(id=resid).annotate(
                        member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()), 
                        department_name=F('user__department'), service_name=F('service__title'), status__name=F('flag__name'),
                    ).values('id', 'member_name', 'department_name', 'service_name', 'status__name', 'claimed_fee', 'claimed_date', 'result', 'benefit', 'description', 'document')
        else:
            last_query = InsuranceRequests.objects.filter().annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()), 
                department_name=F('user__department'), service_name=F('service__title'), status__name=F('flag__name'),
            ).values('id', 'member_name', 'department_name', 'service_name', 'status__name', 'claimed_fee', 'claimed_date', 'result', 'benefit', 'description', 'document')

  

        last = []
        list_ids = []
        services_object = {}
        for item in last_query.values():
            one = {}
            one['id'] = item['id']
            one['member_name'] = item['member_name']
            one['department_name'] = item['department_name']
            one['service_name'] = item['service_name']
            one['status__name'] = item['status__name']
            one['claimed_fee'] = item['claimed_fee']
            one['claimed_date'] = item['claimed_date']
            one['result'] = item['result']
            one['benefit'] = item['benefit']
            one['description'] = item['description']
            one['document_id'] = item['document_id']
            last.append(item)
            list_ids.append(item['id'])
            if item['service_name'] in services_object:
                services_object[item['service_name']] = services_object[item['service_name']] + 1
            else:
                services_object[item['service_name']] = 1
                
        list_services = []
        for service in services_object:
            list_services.append({'label': service, 'value': services_object[service]})
        
        datas = custom_pagination(last, request.GET.get('count', 10), request.GET.get('page_number', 1))
        
        return [True, datas, list_ids, list_services]




class GetRelationshipSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = Relationship
        fields = '__all__'


class AddRelationshipSerializer(serializers.Serializer):
    
    title = serializers.CharField(max_length=255)
    
    def create(self, validated_data) -> list:
        relationship = Relationship.objects.filter(title=validated_data['title']).values_list('title', flat=True)
        if relationship.count() > 0:
            return [False, 'Relationship Exist']
        Relationship.objects.create(
            title=validated_data['title']
        )
        return [True, "Relationship Added"]
    
    class Meta:
        model = Relationship
        fields = ['title']


class UpdateRelationshipSerializer(serializers.Serializer):
    
    new_title = serializers.CharField(max_length=125)
    
    def update(self, validated_data, pk) -> list:
        relationship_object = Relationship.objects.filter(id=pk)
        if relationship_object.count() > 0:
            relationship_object.update(title=validated_data['new_title'])
            return [True, "Relationship Updated"]
        else:
            return [False, "Relationship Not Exist"]
        
    class Meta:
        model = Relationship
        fields = ['title']


class DeleteRelationshipSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        relationship_object = Relationship.objects.filter(id=pk)
        if relationship_object.count() > 0:
            relationship_object.delete()
            return [True, "Relationship Deleted"]
        else:
            return [False, "Relationship Not Exist"]
    
    class Meta:
        model = Relationship
        fields = ['title']




class GetFlagsSerializer(serializers.ModelSerializer):
    
    class Meta:
        model = Flags
        fields = '__all__'


class AddFlagsSerializer(serializers.Serializer):

    name = serializers.CharField(max_length=255)
    color = serializers.CharField(max_length=255, required=False)
    
    def create(self, validated_data) -> list:
        flags = Flags.objects.filter(name=validated_data['name']).values_list('name', flat=True)
        if flags.count() > 0:
            return [False, 'Flags Exist']
        Flags.objects.create(
            name=validated_data['name'], color=validated_data['color']
        )
        return [True, "Flags Added"]
    
    class Meta:
        model = Flags
        fields = ['name']


class UpdateFlagsSerializer(serializers.Serializer):
    
    new_name = serializers.CharField(max_length=125)
    new_color = serializers.CharField(max_length=255, required=False)
    
    def update(self, validated_data, pk) -> list:
        flags_object = Flags.objects.filter(id=pk)
        if flags_object.count() > 0:
            flags_object.update(name=validated_data['new_name'], color=validated_data['new_color'])
            return [True, "Flags Updated"]
        else:
            return [False, "Flags Not Exist"]
        
    class Meta:
        model = Flags
        fields = ['name']


class DeleteFlagsSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        flags_object = Flags.objects.filter(id=pk)
        if flags_object.count() > 0:
            flags_object.delete()
            return [True, "Flags Deleted"]
        else:
            return [False, "Flags Not Exist"]
    
    class Meta:
        model = Flags
        fields = ['name']




class GetRequestsResponseMessageSerializer(serializers.Serializer):
    id = serializers.IntegerField()
    user_name = serializers.CharField()
    service_name = serializers.CharField()
    member_name = serializers.CharField()
    flag_name= serializers.CharField()
    claimed_service = serializers.CharField()
    claimed_fee = serializers.CharField()
    claimed_date = serializers.DateField()
    benefit = serializers.CharField()
    description = serializers.CharField()
    result = serializers.CharField()

class GetRequestsResponseSerializer(serializers.Serializer):
    result = serializers.CharField()
    message = GetRequestsResponseMessageSerializer()

class GetRequestsSerializer(serializers.Serializer):
    
    def get_detail(self, validated_data, request_meta, rid, mid) -> list:
        
        request_obj = InsuranceRequests.objects.filter(member_id=mid, id=rid)
        if request_obj.count()== 0:
            return [False, 'درخواست یافت نشد']
        
        request = request_obj.annotate(user_name=Concat(F('user__first_name'), Value(' '), F('user__last_name'), output_field=CharField()), service_name=F('service__title'), member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()), flag_name=F('flag__name'), ).values('id', 'user_name', 'service_name', 'member_name', 'flag_name', 'claimed_service', 'claimed_fee', 'claimed_date', 'benefit', 'description', 'result')[0]
        return [True, request]


class AddRequestsSerializer(serializers.Serializer):

    user = serializers.CharField(max_length=255, required=True)
    document = serializers.CharField(max_length=255, required=False)
    member = serializers.CharField(max_length=255, required=True)
    service = serializers.CharField(max_length=255, required=True)
    period = serializers.CharField(max_length=255, required=False)
    flag = serializers.CharField(max_length=255, required=True)
    claimed_service = serializers.CharField(max_length=255, required=False)
    claimed_date = serializers.DateTimeField(required=False)
    claimed_fee = serializers.IntegerField(required=False)
    benefit = serializers.IntegerField(required=False)
    description = serializers.CharField(required=False)
    attachments = serializers.FileField(write_only=True, required=False)
    result = serializers.CharField(required=False)
    
    def create(self, validated_data) -> list:
        
        user_obj = Users.objects.filter(user_name__exact=validated_data['user'])
        if user_obj.count() == 0:
            return [False, "User Does Not Exist"]
        member_obj = InsuranceMembers.objects.filter(national_code__exact=validated_data['member'])
        if member_obj.count() == 0:
            return [False, "Member Does Not Exist"]
        service_obj = InsuranceServices.objects.filter(title__exact=validated_data['service'])
        if service_obj.count() == 0:
            return [False, "Service Does Not Exist"]
        flag_obj = Flags.objects.filter(name__exact=validated_data['flag'])
        if flag_obj.count() == 0:
            return [False, "Flag Does Not Exist"]
        if 'document' in validated_data:
            if validated_data['document'] is not None or validated_data['document'] != '':
                InsuranceDocuments.objects.filter()
        else:
            validated_data['document'] = None
        if 'period' in validated_data:
            if validated_data['period'] is not None or validated_data['period'] != '':
                InsurancePeriods.objects.filter()
        else:
            validated_data['period'] = None
        if 'attachments' in validated_data:
            pass
        else:
            validated_data['attachments'] = None
        if 'result' in validated_data:
            pass
        else:
            validated_data['result'] = None
        if 'description' in validated_data:
            pass
        else:
            validated_data['description'] = None
        if 'benefit' in validated_data:
            pass
        else:
            validated_data['benefit'] = None
        if 'claimed_fee' in validated_data:
            pass
        else:
            validated_data['claimed_fee'] = None
        if 'claimed_date' in validated_data:
            pass
        else:
            validated_data['claimed_date'] = None
        if 'claimed_service' in validated_data:
            pass
        else:
            validated_data['claimed_service'] = None
        
        InsuranceRequests.objects.create(
            user_id=user_obj.values_list('id', flat=True)[0], member_id=member_obj.values_list('id', flat=True)[0],
            service_id=service_obj.values_list('id', flat=True)[0], flag_id=flag_obj.values_list('id', flat=True),
            document=validated_data['document'], period=validated_data['period'],
            claimed_service=validated_data['claimed_service'], claimed_date=validated_data['claimed_date'],
            claimed_fee=validated_data['claimed_fee'], benefit=validated_data['benefit'],
            description=validated_data['description'], attachments=validated_data['attachments'],
            result=validated_data['result'], created_at=timezone.now()
        )
        return [True, "Insurance Requests Added"]
    
    class Meta:
        model = InsuranceRequests
        fields = ['id', 'user', 'member', 'service', 'document', 'flag', 'period', 'attachments', 'result', 'description', 'benefit', 'claimed_fee', 'claimed_date', 'claimed_service']


class UpdateRequestsSerializer(serializers.Serializer):
    
    service_name = serializers.CharField(max_length=255, required=True)
    flag_name = serializers.CharField(max_length=255, required=True)
    claimed_service = serializers.CharField(max_length=255, required=False, allow_blank=True)
    claimed_fee = serializers.CharField(max_length=255, required=False, allow_blank=True)
    claimed_date = serializers.DateField(required=False)
    benefit = serializers.CharField(max_length=255, required=False, allow_blank=True)
    description = serializers.CharField(max_length=255, required=False, allow_blank=True)
    result = serializers.CharField(max_length=255, required=False, allow_blank=True)
    
    def update_item(self, validated_data, request_meta, rid, mid) -> list:
        
        request_obj = InsuranceRequests.objects.filter(member_id=mid, id=rid)
        if request_obj.count()== 0:
            return [False, 'درخواست یافت نشد']
        service_obj = InsuranceServices.objects.filter(title=validated_data['service_name'])
        if service_obj.count() == 0:
            return [False, 'سرویس مربوطه یافت نشد']
        
        flag_obj = Flags.objects.filter(name=validated_data['flag_name'])
        if flag_obj.count() == 0:
            return [False, 'وضعیت مربوطه یافت نشد']
        
        if validated_data['claimed_service'] is None or validated_data['claimed_service'] == '':
            clservice = None
        else:
            clservice = validated_data['claimed_service']
            
        if validated_data['claimed_fee'] is None or validated_data['claimed_fee'] == '':
            clfee = None
        else:
            clfee = validated_data['claimed_fee']
            
        if validated_data['claimed_date'] is None or validated_data['claimed_date'] == '':
            cldate = None
        else:
            cldate = validated_data['claimed_date']
            
        if validated_data['benefit'] is None or validated_data['benefit'] == '':
            benefit = None
        else:
            benefit = validated_data['benefit']
            
        if validated_data['description'] is None or validated_data['description'] == '':
            descr = None
        else:
            descr = validated_data['description']
            
        if validated_data['result'] is None or validated_data['result'] == '':
            res = None
        else:
            res = validated_data['result']
        
        try:
            request_obj.update(
                service_id=service_obj.values_list('id', flat=True)[0], flag_id=flag_obj.values_list('id', flat=True)[0],
                claimed_service=clservice, claimed_fee=clfee,
                claimed_date=cldate, benefit=benefit,
                description=descr, result=res
            )
            return[True, 'به روزرسانی انجام شد']
        except:
            return[False, 'ارور رخ داده است']
        

class UpdateServicesSerializer(serializers.Serializer):
    
    user = serializers.CharField(max_length=255, required=True)
    document = serializers.CharField(max_length=255, required=False)
    member = serializers.CharField(max_length=255, required=True)
    service = serializers.CharField(max_length=255, required=True)
    period = serializers.CharField(max_length=255, required=False)
    flag = serializers.CharField(max_length=255, required=True)
    claimed_service = serializers.CharField(max_length=255, required=False)
    claimed_date = serializers.DateTimeField(required=False)
    claimed_fee = serializers.IntegerField(required=False)
    benefit = serializers.IntegerField(required=False)
    description = serializers.CharField(required=False)
    attachments = serializers.FileField(write_only=True, required=False)
    result = serializers.CharField(required=False)
    
    def update(self, validated_data, pk) -> list:
        
        requests_object = InsuranceRequests.objects.filter(id=pk)
        if requests_object.count() == 0:
            return [False, "Request Does Not Exist"]
        
        user_obj = Users.objects.filter(user_name__exact=validated_data['user'])
        if user_obj.count() == 0:
            return [False, "User Does Not Exist"]
        member_obj = InsuranceMembers.objects.filter(national_code__exact=validated_data['member'])
        if member_obj.count() == 0:
            return [False, "Member Does Not Exist"]
        service_obj = InsuranceServices.objects.filter(title__exact=validated_data['service'])
        if service_obj.count() == 0:
            return [False, "Service Does Not Exist"]
        flag_obj = Flags.objects.filter(name__exact=validated_data['flag'])
        if flag_obj.count() == 0:
            return [False, "Flag Does Not Exist"]
        if 'document' in validated_data:
            if validated_data['document'] is not None or validated_data['document'] != '':
                InsuranceDocuments.objects.filter()
        else:
            validated_data['document'] = None
        if 'period' in validated_data:
            if validated_data['period'] is not None or validated_data['period'] != '':
                InsurancePeriods.objects.filter()
        else:
            validated_data['period'] = None
        if 'attachments' in validated_data:
            pass
        else:
            validated_data['attachments'] = None
        if 'result' in validated_data:
            pass
        else:
            validated_data['result'] = None
        if 'description' in validated_data:
            pass
        else:
            validated_data['description'] = None
        if 'benefit' in validated_data:
            pass
        else:
            validated_data['benefit'] = None
        if 'claimed_fee' in validated_data:
            pass
        else:
            validated_data['claimed_fee'] = None
        if 'claimed_date' in validated_data:
            pass
        else:
            validated_data['claimed_date'] = None
        if 'claimed_service' in validated_data:
            pass
        else:
            validated_data['claimed_service'] = None
        
        requests_object.update(
            user_id=user_obj.values_list('id', flat=True)[0], member_id=member_obj.values_list('id', flat=True)[0],
            service_id=service_obj.values_list('id', flat=True)[0], flag_id=flag_obj.values_list('id', flat=True),
            document=validated_data['document'], period=validated_data['period'],
            claimed_service=validated_data['claimed_service'], claimed_date=validated_data['claimed_date'],
            claimed_fee=validated_data['claimed_fee'], benefit=validated_data['benefit'],
            description=validated_data['description'], attachments=validated_data['attachments'],
            result=validated_data['result'], updated_at=timezone.now()
        )
        return [True, "Insurance Requests Added"]
        
    class Meta:
        model = InsuranceRequests
        fields = ['id', 'user', 'member', 'service', 'document', 'flag', 'period', 'attachments', 'result', 'description', 'benefit', 'claimed_fee', 'claimed_date', 'claimed_service']


class DeleteServicesSerializer(serializers.Serializer):
    
    def delete(self, validated_data, pk) -> list:
        services_object = InsuranceServices.objects.filter(id=pk)
        if services_object.count() > 0:
            services_object.delete()
            return [True, "insurance service Deleted"]
        else:
            return [False, "insurance service Not Exist"]
    
    class Meta:
        model = InsuranceServices
        fields = ['title']




class GetExcelRequestsPeriodsSerializer(serializers.Serializer):
    
    def get_requests(self, validated_data, request_meta, cid, pid) -> list:
        periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid, insurance_period_id=pid).annotate(
            period_number=F('insurance_period__period_number'),
            period_date=F('insurance_period__period_date'),
            user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
            period_id=F('insurance_period__id'),
        ).values('id', 'period_date', 'period_number', 'period_id')
        last = list()
        for period in periods:
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                document_number=F('document_id__id'), relationship=F('member__relationship__title'),
                parent_id=F('member__parent_id'),
                service_name=F('service__title'),
                national_code=F('member__national_code')
            ).values('member_name', 'document_number', 'relationship', 'parent_id', 'claimed_fee', 'service_name', 'benefit', 'result', 'id', 'claimed_date', 'description', 'national_code')
            for req in requests_of_documents:
                if req['parent_id'] is None:
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'],
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': req['member_name'],
                        'claimed_date': req['claimed_date'],
                        'period_date': period['period_date'],
                        'period_number': period['period_number'],
                        'description': req['description'],
                        'national_code': req['national_code'],
                        'parent_national_code': req['national_code']
                    }
                else:
                    parent_name = InsuranceMembers.objects.filter(id=req['parent_id']).values_list('first_name', 'last_name', 'national_code')[0]
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'], 
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': parent_name[0] + ' ' +parent_name[1],
                        'claimed_date': req['claimed_date'],
                        'period_date': period['period_date'],
                        'period_number': period['period_number'],
                        'description': req['description'],
                        'national_code': req['national_code'],
                        'parent_national_code': parent_name[2]
                    }
                last.append(req_dict)
        
        return [True, last]




class ExportInsuranceMembersSerializer(serializers.Serializer):
    
    def get_members(self,validated_data, request_meta, cid):
        member_ids = InsuranceContractMembers.objects.filter(insurance_contract_id=cid).values('insurance_member_id')
        last = []
        for memid in member_ids:
            member_object = InsuranceMembers.objects.filter(id=memid['insurance_member_id']).annotate(
                user_name=Concat('first_name', Value(' '), 'last_name'),
                ralation_name=F('relationship__title'),
            ).values('user_name', 'ralation_name', 'father_name', 'gender', 'identity_number', 'national_code', 'birth_date', 'insurance_code')
            last.append(member_object[0])
        return [True, last]


class UpdateRequestsPeriodsSerializer(serializers.Serializer):
    
    request_list = serializers.JSONField()
    
    def update_item(self, validated_data, request_meta) -> list:
        req_list = json.loads(validated_data['request_list'])
        
        try:
            with transaction.atomic():
                for request in req_list:
                    request_obj = InsuranceRequests.objects.filter(id=request['request_id'])
                    if request_obj.count()== 0:
                        return [False, 'درخواست یافت نشد']
                        
                    if request['benefit'] is None or request['benefit'] == '':
                        benefit = None
                        flagid = 10009
                    else:
                        benefit = request['benefit']
                        flagid = 10010
                        
                    if request['result'] is None or request['result'] == '':
                        res = None
                    else:
                        res = request['result']
    
                    request_obj.update(
                        benefit=benefit, result=res, flag_id=flagid
                    )
                    
            return [True, 'به روزرسانی دوره انجام شد']
        except Exception as e:
            transaction.rollback()
            return [False, 'ارور رخ داده است']
  

class GetPeriodsSerializer(serializers.Serializer):
    
    def get_item(self, cid, pid):
        
        periods = InsuranceContractPeriods.objects.filter(insurance_contract_id=cid, insurance_period_id=pid).annotate(
            period_number=F('insurance_period__period_number'),
            period_date=F('insurance_period__period_date'),
            user_name=Concat(F('insurance_period__user__first_name'), Value(' '), F('insurance_period__user__last_name'), output_field=CharField()),
            period_id=F('insurance_period__id'),
        ).values('period_number', 'period_date', 'user_name', 'insurance_contract_id', 'id', 'period_id').order_by("-created_at")
        # last = list()
        for period in periods:
            period_dict = {'damages': 0, 'costs': 0, 'payments': 0}
            requests_of_documents = InsuranceRequests.objects.filter(period_id=period['period_id']).values()
            for req in requests_of_documents:
                if req['claimed_fee'] is not None:
                    period_dict['costs'] += req['claimed_fee']
                if req['benefit'] is not None:
                    period_dict['payments'] += req['benefit']
                period_dict['damages'] += 1
            period_dict['username'] = period['user_name']
            period_dict['period_number'] = period['period_number']
            period_dict['period_date'] = period['period_date']
            period_dict['period_id'] = period['period_id']
            # last.append(period_dict)
        return [True, period_dict]
        


class ExportInsuranceSerializer(serializers.Serializer):
    
    timerange = serializers.CharField(max_length=255, required=True)
    

class GeneratePDFForDocumentSerializer(serializers.Serializer):
    
    requests_id = serializers.ListField(required=False)
    
    def get_requests(self, validated_data, did):
        
        print(validated_data['requests_id'])
        if validated_data['requests_id'] == "":
            requestids = []
        else:
            requestids = validated_data['requests_id'].split(',')
        doc_obj = InsuranceDocuments.objects.filter(id=did)
        if doc_obj.count() == 0:
            return [False, 'سند یافت نشد']
        print(requestids, len(requestids))
        if len(requestids) == 0:
            reqs = InsuranceRequests.objects.filter(document_id=did).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                service_name=F('service__title'),
                national_code=F('member__national_code')
            ).values('member_name', 'service_name', 'national_code', 'claimed_date', 'benefit', 'claimed_fee')
        else:
            reqs = []
            for reqid in requestids:
                one_req = InsuranceRequests.objects.filter(id=reqid).annotate(
                    member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                    service_name=F('service__title'),
                    national_code=F('member__national_code')
                ).values('member_name', 'service_name', 'national_code', 'claimed_date', 'benefit', 'claimed_fee')
                reqs.append(one_req[0])
        
        member_detail = doc_obj.annotate(
            member_name=Concat(F('insurance_member__first_name'), Value(' '), F('insurance_member__last_name'), output_field=CharField()),
            national_code=F('insurance_member__national_code'),
            contract_number=F('insurance_contract__number')
        ).values('member_name', 'national_code', 'created_at', 'contract_number')
        
        
        return [True, reqs, member_detail[0]]
            
            
            

class ImportInsuranceMembers(serializers.Serializer):
    
    contract_id = serializers.IntegerField(required=True)
    excel_file = serializers.FileField(write_only=True, required=False)
    
    


class GenerateExcelRequestsSerializer(serializers.Serializer):
    
    requests_id = serializers.ListField(required=True)

    def get_requests(self, validated_data, request_meta):
        
        last = []
        requestids = validated_data['requests_id'].split(',')
        for reqid in requestids:
            insurance_request = InsuranceRequests.objects.filter(id=reqid).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                document_number=F('document_id__id'), relationship=F('member__relationship__title'),
                parent_id=F('member__parent_id'),
                service_name=F('service__title'),
                national_code=F('member__national_code'),
                period_date=F('period__period_date'),
                period_number=F('period__period_number'),
                status=F('flag__name')
            ).values('status', 'member_name', 'document_number', 'relationship', 'parent_id', 'claimed_fee', 'service_name', 'benefit', 'result', 'id', 'claimed_date', 'description', 'national_code', 'period_date', 'period_number')
            for req in insurance_request:
                if req['period_date'] is not None:
                    pcd = req['period_date']
                    pdate = jdatetime.date.fromgregorian(day=pcd.day, month=pcd.month, year=pcd.year)
                else:
                    pdate = ""
                if req['claimed_date'] is not None:
                    ccd = req['claimed_date']
                    cdate = jdatetime.date.fromgregorian(day=ccd.day, month=ccd.month, year=ccd.year)
                else:
                    cdate = ""
                if req['parent_id'] is None:
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'],
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': req['member_name'],
                        'claimed_date': str(cdate),
                        'period_date': str(pdate),
                        'period_number': req['period_number'],
                        'description': req['description'],
                        'national_code': req['national_code'],
                        'parent_national_code': req['national_code'],
                        'status': req['status']
                    }
                else:
                    parent_name = InsuranceMembers.objects.filter(id=req['parent_id']).values_list('first_name', 'last_name', 'national_code')[0]
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'], 
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': parent_name[0] + ' ' +parent_name[1],
                        'claimed_date': str(cdate),
                        'period_date': str(pdate),
                        'period_number': req['period_number'],
                        'description': req['description'],
                        'national_code': req['national_code'],
                        'parent_national_code': parent_name[2],
                        'status': req['status']
                    }
                last.append(req_dict)
        return [True, last]



class GeneratePDFRequestsSerializer(serializers.Serializer):
    
    requests_id = serializers.ListField(required=False)
    
    def get_requests(self, validated_data):
        
        last = []
        requestids = validated_data['requests_id'].split(',')
        for reqid in requestids:
            insurance_request = InsuranceRequests.objects.filter(id=reqid).annotate(
                member_name=Concat(F('member__first_name'), Value(' '), F('member__last_name'), output_field=CharField()),
                document_number=F('document_id__id'), relationship=F('member__relationship__title'),
                parent_id=F('member__parent_id'),
                service_name=F('service__title'),
                national_code=F('member__national_code'),
                period_date=F('period__period_date'),
                period_number=F('period__period_number'),
            ).values('member_name', 'document_number', 'relationship', 'parent_id', 'claimed_fee', 'service_name', 'benefit', 'result', 'id', 'claimed_date', 'description', 'national_code', 'period_date', 'period_number')
            for req in insurance_request:
                if req['parent_id'] is None:
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'],
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': req['member_name'],
                        'claimed_date': req['claimed_date'],
                        'period_date': req['period_date'],
                        'period_number': req['period_number'],
                        'description': req['description'],
                        'national_code': req['national_code'],
                        'parent_national_code': req['national_code']
                    }
                else:
                    parent_name = InsuranceMembers.objects.filter(id=req['parent_id']).values_list('first_name', 'last_name', 'national_code')[0]
                    req_dict = {
                        'member_name': req['member_name'], 
                        'request_id': req['id'], 
                        'document_number': req['document_number'], 
                        'relationship': req['relationship'], 
                        'claimed_fee': req['claimed_fee'], 
                        'service_name': req['service_name'], 
                        'benefit': req['benefit'], 
                        'result': req['result'],
                        'parent_name': parent_name[0] + ' ' +parent_name[1],
                        'claimed_date': req['claimed_date'],
                        'period_date': req['period_date'],
                        'period_number': req['period_number'],
                        'description': req['description'],
                        'national_code': req['national_code'],
                        'parent_national_code': parent_name[2]
                    }
                last.append(req_dict)
        return [True, last]



class GetAllServicesSerializer(serializers.Serializer):
    
    def get_services(self, validated_data, request_meta) -> list:
        if 'user_name' not in validated_data or validated_data['user_name'] == '' or validated_data['user_name'] is None:
            jwt_token = request_meta.get('HTTP_AUTHORIZATION', '').split(' ')[1]
            access_token = AccessToken(jwt_token)
            user_id = access_token['user_id']
            user_object = Users.objects.filter(id=user_id)
        else:
            user_object = Users.objects.filter(user_name=validated_data['user_name'])
            if user_object.count() < 1:
                return [False, 'کاربر با این نام کاربری وجود ندارد']
            else:
                user_id = user_object.values_list('id', flat=True)[0]  
        
        '''
        check user has manager permission or not
        '''
        

        services = InsuranceContractServices.objects.all().annotate(
            service_name=F('insurance_service__title')
        ).values('id', 'insurance_service_id', 'insurance_contract_id', 'service_name')
        
        all_services = []
        all_keys = []
        for serv in services:
            if serv['service_name'] in all_keys:
                pass
            else:
                all_services.append(serv)
            all_keys.append(serv['service_name'])
        return [True, all_services]



class GetAllUsersSerializer(serializers.Serializer):
    
    def get_users(self, validated_data, request_meta, request) -> list:
        
        users = Users.objects.all().order_by("created_at").annotate(
            member_name=Concat(F('first_name'), Value(' '), F('last_name'), output_field=CharField()), 
        ).values('id', 'member_name')
        datas = custom_pagination(users, request.GET.get('count', 100000), request.GET.get('page_number', 1))
        return [True, datas]

