<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class VOD_WATERMARK_ADMIN
{

    public static function GetList($token)
    {
        /**
         * بررسی Token کاربر و نمایش لیست واترمارک ها و زیر فولدرها
         *
         *   ورودی : Token
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         *                    data : آرایه ای از فولدر ها
         */
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"];
        }
        if ($lv["status"] == "error") {
            return ["status" => "success", "message" => "شما دامنه ای انتخاب نکرده اید"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["vod_watermark_tablename"] . " WHERE " . $GLOBALS['vw_domainid'] . "=" . $lv["data"][0]["vdid"];
        $conn = GetConnection();
        $result = $conn->query($sql);
        $uid = $u["userdetail"][0]["uid"];
        $output =  "/vod/watermarks/" . $uid."/";


        $arr = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $listOfRecordType = [
            "status" => "success",
            "message" => "اطلاعات با موفقیت دریافت شد",
            "data" => $arr,
            "basepath"=>$output
        ];
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedName($domainid, $name)
    {
        /**
         *  بررسی تکراری بودن نام واترمارک ها
         *
         *   ورودی : domainid
         *            name
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_watermark_tablename"] . " WHERE " .
            $GLOBALS['vw_filename'] . "='" . $name .
            "' AND " .
            $GLOBALS['vw_domainid'] . "=" . $domainid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOne($token, $wid, $domainid)
    {
        /**
         *   دریافت اطلاعات یک watermark
         *
         *   ورودی :Token - watermark ID
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         *                    data : آرایه ای از اطلاعات watermark
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["vod_watermark_tablename"] . " WHERE " . $GLOBALS['vwid'] . "=" . $wid . " and " .
            $GLOBALS['vw_domainid'] . "=" . $domainid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
            return $result;
        }
        $conn->close();
        $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        return $listOfRecordType;
    }
    public static function GetOneWithoutToken($wid)
    {
        /**
         *   دریافت اطلاعات یک watermark
         *
         *   ورودی : watermark ID
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         *                    data : آرایه ای از اطلاعات watermark
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_watermark_tablename"] . " WHERE " . $GLOBALS['wid'] . "=" . $wid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
            return $result;
        }
        $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];

        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }

    public static function AddWatermark($token, $watermark,$title,$description, $domainid)
    {
        /**
         *   افزودن watermark جدید
         *
         *   ورودی :  string  Token,
         *            int     domainID,
         *            file    watermark,
         *            string  title
         *            string  description,
         *
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         *                    data   : list of watermarks
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }


        $uid =    $u["userdetail"][0]["uid"];

        if (VOD_DOMAIN_ADMIN::UserCanAccessToStreamDomain($uid, $domainid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
        };
        $size   =   $watermark["size"];
        $name   =   strtolower($watermark["name"]);
        $ext    =   pathinfo($name, PATHINFO_EXTENSION);

        if(self::CheckDuplicatedName($domainid, $name)["status"]=="error"){
            return ["status"=>"error","message"=>"نام فایل درخواستی شما تکراری است"];
        }

        $resp = [];
        $output = $GLOBALS["RootFiles"] . "/vod/watermarks/" . $uid;
        if (!file_exists($output)) {
            mkdir($output, 777, true);
            return ["created"];
        }

        $allowed = array('gif', 'jpeg', 'jpg', 'png', 'bmp');
        if (!in_array(strtolower($ext), $allowed)) {
            $response = ["status" => "error", "message" => "فرمت فایل ارسالی نامعتبر است ", "filename" => $name];
            return $response;
        }
        if ((number_format($size / 1048576, 2)) > 4) {
            $response = ["status" => "error", "message" => "حداکثر حجم فایل برای آپلود 4مگابایت است", "filename" => $name];
            return $response;
        }
        if (move_uploaded_file($watermark["tmp_name"], $output . '/' . strtolower($name))) {
                $sqlins = "INSERT INTO " . $GLOBALS["vod_watermark_tablename"] . " VALUES (0,'"
                . strtolower($name) . "'," . $domainid . ",'".$title."','".$description."')";
            $conn = GetConnection();
            $conn->query($sqlins);
            $listOfRecordType = [
                "status" => "success",
                "message" => "اطلاعات با موفقیت ثبت شد",
                "id" => $conn->insert_id
            ];
            $conn->close();
            return $listOfRecordType;
        }
    }
    public static function RemoveWatermark($token, $wid,$domaindid)
    {
        /**
         *   حذف یک watermark
         *
         *   ورودی : string Token,
         *            int    wid
         *            int    domainid
         *   خروجی : Array :
         *                    status : وضعیت درخواست
         */
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }

        $watermarkinfo=self::GetOne($token, $wid, $domaindid);
        if ($watermarkinfo["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این فایل  را ندارید"];
        }
        $uid = $u["userdetail"][0]["uid"];
        $output = $GLOBALS["RootFiles"] . "/vod/watermarks/" . $uid;

        unlink($output."/".$watermarkinfo["data"][0]["vw_filename"]);
        $sqlins = "DELETE FROM  " . $GLOBALS["vod_watermark_tablename"] . " WHERE " . $GLOBALS["vwid"] . "=" . $wid;
        $conn = GetConnection();
        $conn->query($sqlins);
        $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت حذف شد"];
        $conn->close();
        return $listOfRecordType;
    }
    public static function UserCanAccessToParentID($uid, $parentid)
    {
        /**
         *   بررسی دسترسی یک کاربر به والد یک فولدر
         *
         *   ورودی :
         *              int    uid,
         *              int    parentid
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست
         */
        $sql = "SELECT * FROM " . $GLOBALS["vod_folders_tablename"] . "," . $GLOBALS["vod_domain_tablename"] . "," . $GLOBALS["users_tablename"] . " WHERE " . $GLOBALS['vfid'] . "=" . $parentid . " AND " .
            $GLOBALS['uid'] . "=" . $uid . " AND " . $GLOBALS['vf_cidfk'] . "=" . $GLOBALS['vdid'] . " AND " . $GLOBALS['uid'] . "=" . $GLOBALS['vd_uid_fk'];
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetFolderAndUpFolders($vfid, $olname, $r)
    {
        /**
         *   دریافت یک فولدر و وارد آن
         *
         *   ورودی :
         *              int    vfid,
         *              string olname
         *              int    r //parentID
         *   خروجی :
         *              Array :
         *                    status : وضعیت درخواست
         *                    output : آرایه ای از فولدرها
         */
        $m = [];
        $vf = VOD_FOLDERS_ADMIN::GetOneWithoutToken($vfid, "", 0);
        if ($r == 0)
            array_push($m, $vf["data"][0]);

        while ($vf["data"][0]["vf_parentid"] != "0") {
            $vf = VOD_FOLDERS_ADMIN::GetOneWithoutToken($vf["data"][0]["vf_parentid"], $olname, 1);
            array_push($m, $vf["data"][0]);
        }
        $ouput = [];
        $ouputfoldername = "";
        if ($vf["data"][0]["vf_parentid"] == "0") {
            foreach ($m as $l) {
                array_push($ouput, $l["vfname"]);
            }
            $o = array_reverse($ouput);
            $ouputfoldername = implode(",", $o);
            return $ouputfoldername;
        }
        return $m;
    }
}
