<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';



class VOD_CHANNELS_ADMIN
{
    public static function GetList($token)
    {
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"];
        }

        $sql = "SELECT vc_id as id ,vc_name as name ,vc_did_fk as domainid from " . $GLOBALS["vod_channels_tablename"] . " WHERE " . $GLOBALS['vc_did_fk'] . "=" . $lv["data"][0]["vdid"];
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما دامنه ای انتخاب نکرده اید"];
            return $result;
        } else {
            $arr=mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",   "data" =>$arr ];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckDuplicatedName($domainid,$name)
    {

        $sql = "SELECT * FROM " . $GLOBALS["vod_channels_tablename"] . " WHERE " . $GLOBALS['vc_name'] . "='" . $name . "' AND ".$GLOBALS['vc_did_fk']."=".$domainid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOne($token,$fid)
    {
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $sql="SELECT * FROM " . $GLOBALS["vod_channels_tablename"] . " WHERE ".$GLOBALS['vc_id']."=".$fid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این دامنه را ندارید"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateChannelName($token,$fid,$nm)
    {
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $name = TOOLS_ADMIN::seo_friendly_url($nm);
        $ufaccess=VOD_CHANNELS_ADMIN::GetOne($token,$fid);
        if($ufaccess["status"]=="error"){
            return $ufaccess;
        }

        if (VOD_CHANNELS_ADMIN::CheckDuplicatedName($lv["data"][0]["vdid"],$name)["status"] == "error") {
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }

        $sqlins = "UPDATE " . $GLOBALS["vod_channels_tablename"] . " SET " . $GLOBALS['vc_name'] . "='". $name . "' WHERE " . $GLOBALS["vc_id"] . "=".$fid;
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddChannel($token, $domainid,$nm)
    {
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        $name = TOOLS_ADMIN::seo_friendly_url($nm);
        if (VOD_CHANNELS_ADMIN::CheckDuplicatedName($domainid,$name)["status"] == "error") {
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }

        $sqlins = "INSERT INTO " . $GLOBALS["vod_channels_tablename"] . "(" . $GLOBALS['vc_name'] . "," . $GLOBALS['vc_did_fk'] . " ) VALUES ('"
            . $name . "'," . $domainid . ")";
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function RemoveChannel($token,$channelid)
    {
        $lv = VOD_DOMAIN_ADMIN::GetList($token);
        if ($lv["status"] == "error") {
            return $lv;
        }
        $u = USERS_ADMIN::GetOneByToken($token);
        if ($u["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است", "code" => "301"];
        }
        //CHECK CHANNEL CONTAINS FOLDERS
        if(VOD_FOLDERS_ADMIN::CheckChannelContainsFolder($channelid)["status"]=="error"){
            return ["status" => "error", "message" => "شما امکان حذف این کانال را ندارید لطفا ابتدا فولدر و فایل های زیر مجموعه آن را حذف نمایید و سپس اقدام به حذف کانال نمایید ", "code" => "301"];
        }
        $sqlins = "DELETE FROM " . $GLOBALS["vod_channels_tablename"] . " WHERE " . $GLOBALS["vc_id"] . "=".$channelid." AND ".$GLOBALS['vc_did_fk']."=".$lv["data"][0]["vdid"];
        $conn = GetConnection();

        if ($conn->query($sqlins) === TRUE) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
        } else {
            $listOfRecordType = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
        }

        $conn->close();
        return $listOfRecordType;
    }
}
