<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");

require_once '../../include/vars.php';

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

function returnCurlResult($url, $action, $time, $domain)
{
    $r = API_REPORT_ADMIN::RunErrorLog($domain, $time, $action);
    return  $r;
}
// TotalBytes,TotalCachedBytes
$validtimerange = ["3h" => "3", "6h" => "6", "12h" => "12", "1d" => "24", "1w" => "7d", "1m" => "30d"];
if (!isset($validtimerange[$_POST["timerange"]])) {
    echo json_encode([ "status" => "error", $dtse, "message" => "زمان درخواستی شما نامعتبر است" ]);
    return;
}

$domain = $_POST["domain"];
if ($_POST["website"] != $domain) {
    $domain = $_POST["website"] . "." . $_POST["domain"];
}

if (WEBSITES_ADMIN::CheckPlan($_POST["token"], $_POST["websiteid"],"errorlogs")["status"] == "error") {
    echo json_encode(["status" => "error", "message" => "شما امکان دسترسی به این بخش ندارید"]);
    
    return;
}




if (!file_exists("errorlogs/" . $domain))
    mkdir("errorlogs/" . $domain);

$fp = "errorlogs/" . $domain . "/" . $validtimerange[$_POST["timerange"]] . ".report";

if (file_exists($fp)) {
    $response = file_get_contents($fp);

    $now = date("Y/m/d H:i:s");
    $rep = json_decode($response, true);
    $expire = $rep["expire"];

    if ($now > $expire) {
        $response = returnCurlResult('', "errorlog", $validtimerange[$_POST["timerange"]], $domain);
        $r = json_decode($response, true);
        $det = [];
        foreach ($r["timerange"] as $s => $k) {
            // echo json_encode($k);
            if (count($r["timerange"][$s]) > 0) {
                // echo json_encode($r["timerange"][$s]);
                foreach ($r["timerange"][$s] as $p => $m) {
                    if (!array_key_exists($p, $det)) {
                        //   echo json_encode($k);
                        //   $det[$k]=[];
                        $det[$p] = $m;
                    } else {
                        foreach ($m as $n => $b) {
                            if (!array_key_exists($n, $det[$p])) {
                                // array_push($det[$p],$n);
                                $det[$p][$n] = $b;
                            } else {
                                $det[$p][$n] = $det[$p][$n] + $b; // $det[$p][$m]=$det[$p][$m]+$m;
                            }
                        }
                    }
                }
            }
        }
        $q = ["timerange" => json_decode($response, true)["timerange"], "detail" => $det];

        $output = [ "status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" => [ $q ] ];
        $expire = date("Y/m/d H:" . TOOLS_ADMIN::returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

        $dtss = ["expire" => $expire, "data" => $output];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
        fwrite($myfile, $dmns);
        fclose($myfile);
        echo json_encode($output);
    } else {
        $rep = $rep["data"];
        echo json_encode($rep);
    }
} else {
    $response = returnCurlResult('', "errorlog", $validtimerange[$_POST["timerange"]], $domain);
    $r = json_decode($response, true);
    $det = [];
    foreach ($r["timerange"] as $s => $k) {
        // echo json_encode($k);
        if (count($r["timerange"][$s]) > 0) {
            // echo json_encode($r["timerange"][$s]);
            foreach ($r["timerange"][$s] as $p => $m) {
                if (!array_key_exists($p, $det)) {
                    //   echo json_encode($k);
                    //   $det[$k]=[];
                    $det[$p] = $m;
                } else {
                    foreach ($m as $n => $b) {
                        if (!array_key_exists($n, $det[$p])) {
                            // array_push($det[$p],$n);
                            $det[$p][$n] = $b;
                        } else {
                            $det[$p][$n] = $det[$p][$n] + $b; // $det[$p][$m]=$det[$p][$m]+$m;
                        }
                    }
                }
            }
        }
    }
    $q = ["timerange" => json_decode($response, true)["timerange"], "detail" => $det];

    $output = [ "status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" => [ $q ] ];
    $expire = date("Y/m/d H:" . TOOLS_ADMIN::returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

    $dtss = ["expire" => $expire, "data" => $output];
    $dmns = json_encode($dtss);
    $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
    fwrite($myfile, $dmns);
    fclose($myfile);
    echo json_encode($output);
}
