<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN
{
    public static function GetListByInvoiceTreeID($treeID)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoicedetails_byhour"] . " WHERE " .
         $GLOBALS['fid_itid_fk'] . "=" . $treeID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetListByServiceID($ServiceID)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoicedetails_byhour"] . " WHERE " .
            $GLOBALS['fid_sid_fk'] . "=" . $ServiceID . " ORDER BY " . $GLOBALS['fid_calculateditem'] . " asc ," .
            $GLOBALS['fid_starttime'] . " asc";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetListByServiceIDWithDateRange($ServiceID,$start,$end,$treeid)
    {
        $calc="";
        $a=array_keys($treeid);
        for($i=0;$i<count($a);$i++)
        {
            if($i==0){
                $calc.="'".$a[$i]."',";
            }
            else if ($i==count($a)-1){
                $calc.="'".$a[$i]."'";
            }
            else{
                $calc.="'".$a[$i]."',";
            }
        }
        $sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoicedetails_byhour"] . " WHERE " .
        $GLOBALS['fid_starttime'].">='".$start."' AND ".$GLOBALS['fid_endtime']."<='".$end."' AND ".
            $GLOBALS['fid_sid_fk'] . "=" . $ServiceID .
            " AND ".  $GLOBALS['fid_calculateditem']." IN (".$calc.")".
            " ORDER BY " . $GLOBALS['fid_calculateditem'] . " asc ," .
            $GLOBALS['fid_starttime'] . " asc";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return [$sql , "status" => "success",
        "message" => "اطلاعات با موفقیت دریافت شد",
        "data" => $listOfRecordType];
    }
    public static function GetLastItem($serviceid, $field, $start)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoicedetails_byhour"] . " WHERE " .
            $GLOBALS['fid_sid_fk'] . "=" . $serviceid . " AND " . $GLOBALS['fid_calculateditem'] . "='" .
            $field . "' AND " . $GLOBALS['fid_starttime'] . "='" . $start . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            return ["status" => "error", "message" => "first hour"];
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $conn->close();
            return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
        }
    }
    public static function AddInvoiceDetails($invoicetreeid, $details, $price, $calculateditem, $count, $sid,$startfix=null,$endfix=null)
    {
        $starttime = $startfix;
        $end = $endfix;
        if($startfix==null)
            $starttime =  jDateTime::date("Y/m/d H:00:00");
        if($endfix==null)
            $end =  jDateTime::date("Y/m/d H:00:00");
        // $end = jDateTime::date("Y/m/d H:00:00", time() + 3600);
        $a=self::CheckRecordDuplicated($invoicetreeid, $calculateditem,$starttime, $end, $details);

        if($a["status"] == "error") {
            return $a;
        }
        $updated=0;
        $lst=self::GetLastItem($sid, $calculateditem, $starttime);

        if($lst["status"]=="success"){
            if($lst["data"][0]["fid_count"]!=$count){
                $updated=1;
            }
        }
        // echo "$starttime\t$end\t$calculateditem\t$invoicetreeid\t$details\t$price\t$count\t$sid\t$updated\n";
        $sql = "INSERT INTO  " . $GLOBALS["tbl_financial_invoicedetails_byhour"] . " VALUES(0,'" . $starttime . "','" .
        $end . "','" . $calculateditem . "','" . $invoicetreeid . "','" . $details . "','" .
        $price . "','" . $count . "','" . $sid . "','" . $updated . "')";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",$sql];
    }
    public static function GetByTimeForTreeID($invoicetreeid, $calculateditem, $starttime, $endtime)
    {
        $sql = "SELECT * FROM  " . $GLOBALS['tbl_financial_invoicedetails_byhour'] . " WHERE " . $GLOBALS["fid_starttime"] . " ='" . $starttime . "'
        and  " . $GLOBALS['fid_endtime'] . "='" . $endtime . "' and  " . $GLOBALS['fid_calculateditem'] . "='" . $calculateditem .
            "' and  " . $GLOBALS['fid_itid_fk'] . "='" . $invoicetreeid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function CheckRecordDuplicated($invoicetreeid, $calculateditem, $starttime, $endtime, $details)
    {
        $sql = "SELECT Count(fidid) as Cnt FROM " . $GLOBALS['tbl_financial_invoicedetails_byhour']
            . " WHERE " . $GLOBALS["fid_starttime"] . " ='" . $starttime
            . "' AND " . $GLOBALS['fid_endtime'] . "='" . $endtime
            . "' AND " . $GLOBALS['fid_calculateditem'] . "='" . $calculateditem
            . "' AND " . $GLOBALS['fid_itid_fk'] . "='" . $invoicetreeid
            . "' AND " . $GLOBALS['fid_details'] . "='" . $details . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        if ($listOfRecordType[0]["Cnt"] == "0") {
            return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
        } else {
            return ["status" => "error","data"=>$listOfRecordType];
        }
    }
    public static function FindAllGaps()
    {
		$sql = <<< SQL
			SELECT {$GLOBALS['fid_endtime']} AS `missing_start`, (
				SELECT {$GLOBALS['fid_starttime']} FROM {$GLOBALS['tbl_financial_invoicedetails_byhour']}
				WHERE {$GLOBALS['fid_starttime']} > `missing_start`
				ORDER BY {$GLOBALS['fid_starttime']} ASC LIMIT 1
			) AS `missing_end` FROM {$GLOBALS['tbl_financial_invoicedetails_byhour']}
			WHERE ({$GLOBALS['fid_endtime']} NOT IN (SELECT {$GLOBALS['fid_starttime']} FROM {$GLOBALS['tbl_financial_invoicedetails_byhour']}))
			AND ({$GLOBALS['fid_starttime']} > (SELECT MIN({$GLOBALS['fid_starttime']}) FROM {$GLOBALS['tbl_financial_invoicedetails_byhour']}))
			AND ({$GLOBALS['fid_endtime']} < (SELECT MAX({$GLOBALS['fid_endtime']}) FROM {$GLOBALS['tbl_financial_invoicedetails_byhour']}))
			GROUP BY {$GLOBALS['fid_starttime']}, {$GLOBALS['fid_endtime']}
			ORDER BY {$GLOBALS['fid_starttime']} ASC, {$GLOBALS['fid_endtime']} ASC
		SQL;

        $conn = GetConnection();
        $result = $conn->query($sql);
        $rows = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $rows;
    }
	public static function GetRangeOfInvoiceDates($starttime = '', $endtime = '')
	{
		$sql = <<< SQL
			SELECT MIN({$GLOBALS['fid_starttime']}) AS `min_start`,
			MAX({$GLOBALS['fid_endtime']}) AS `max_end`
			FROM {$GLOBALS['tbl_financial_invoicedetails_byhour']}
		SQL;

		$conditions = [];

		if ( !empty($starttime) ) $conditions []= "{$GLOBALS['fid_starttime']} >= '$starttime'";
		if ( !empty($endtime) ) $conditions []= "{$GLOBALS['fid_endtime']} <= '$endtime'";

		if ( !empty($conditions) ) $sql .= "\nWHERE (" . implode(' AND ', array_map(fn($x) => "($x)", $conditions)) . ")";

        $conn = GetConnection();
        $result = $conn->query($sql);
        $row = mysqli_fetch_array($result);
        $conn->close();

        return $row;
	}
}
