<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class FINANCIAL_INVOICEBYHOURFIX_ADMIN
{
	public static function GetInvoicesForDay($start, $end, $category = "cloud")
	{

		$sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_byhour'] . " WHERE "
			.   $GLOBALS['istarttime'] . " >='" . $start . "' AND "
			.   $GLOBALS['iendtime'] . " <= '" . $end . "'
                 order by " . $GLOBALS['i_uid_fk'] . " desc , " . $GLOBALS['istarttime'] . " asc";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return [
				"status" => "error", $sql,
				"message" => "اطلاعات با موفقیت دریافت شد"
			];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			foreach ($listOfRecordType as $l) {
				$m = FINANCIAL_INVOICETREEHOUR_ADMIN::GetPriceListWithByCategory(1);
			}
			$conn->close();
			return [
				"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
				$sql, "data" => $listOfRecordType
			];
		}
	}

	public static function GetListByInvoiceByUser($token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoice_byhour"] . " WHERE " . $GLOBALS['i_uid_fk'] . "=" . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
	}
	public static function GetPriceListWithByCategory($catname)
	{
		$sql = "SELECT * FROM " . $GLOBALS["tbl_details_price"] . " WHERE " . $GLOBALS["dp_category"] . " ='" . $catname . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
	}
	public static function GetInvoiceDetails($uid, $start)
	{
		$sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_byhour'] . " WHERE " . $GLOBALS['i_uid_fk'] . "='" . $uid . "' AND " .
			$GLOBALS['istarttime'] . "='" . $start . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد"];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$conn->close();
			return ["status" => "error", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
		}
	}
	public static function UpdateInvoice($uid, $start, $end)
	{
		// $starttime = jDateTime::date("Y/m/d H:00:00");
		// $end = jDateTime::date("Y/m/d H:00:00", time() + 3600);
		$r = self::GetInvoiceDetails($uid, $start);
		$id = 0;
		if ($r["status"] == "success") {
			$sql = "INSERT INTO " . $GLOBALS['tbl_financial_invoice_byhour'] . " VALUES(0,0,0,0,0,0,'" . $start . "','" . $end . "','" . $uid . "')";
			$conn = GetConnection();
			$conn->query($sql);
			$id  =  $conn->insert_id;
			$conn->close();
			return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $id];
		} else {
			$id = $r["data"][0]["iid"];
			return ["status" => "duplicated", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $id];
		}
	}
	public static function UpdatePrice($cat, $price = 0, $invoiceid)
	{

		$sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_byhour'] . " SET " . $GLOBALS["i" . $cat]
			. "=(
            select sum(`fitprice`) from  tbl_financial_invoicetreebyhour
            where `fit_ifield`='" . $cat . "' and fit_iid_fk=" . $invoiceid . " )
            where iid =" . $invoiceid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
	}
	public static function GetCDNDataFromhistory($start)
	{
		//$sql = "SELECT * FROM `tbl_domains_logs`,tbl_domains  where dl_did_fk=domain_id and dl_plan!='free' and dl_start <='" . $start . "' ";
		$sql = "SELECT * FROM `tbl_domains_logs`,tbl_domains,tbl_users WHERE
            d_user_id_fk = uid and dl_did_fk=domain_id and `dl_start` <= '" . $start . "' and dl_plan!='free'
             and dlid IN (SELECT max(dlid ) as cls FROM tbl_domains_logs WHERE `dl_start` <= '" . $start . "'
             group by dl_did_fk); ";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return ["status" => "error", "message" => "اطلاعات با موفقیت دریافت شد"];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$conn->close();
			return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
		}
	}
	public static function GetCloudFromHistory($start)
	{
		$sql = "SELECT clid,cl_uid_fk,cldetails,cl_startdate,cl_enddate FROM
            `tbl_cloud_logs`, tbl_users WHERE cl_uid_fk= uid AND `cl_startdate` <= '" . $start . "'
			AND clid IN (SELECT max(clid) as  cls FROM tbl_cloud_logs  WHERE `cl_startdate` <= '" . $start . "' group by cl_uid_fk);";
		// $sql = "SELECT max(clid),`cl_uid_fk`,`cldetails`,`cl_startdate`,`cl_enddate`,`cl_comment`,clid
		//          FROM `tbl_cloud_logs`,tbl_users  WHERE cl_uid_fk=uid and `cl_startdate` <= '" . $start . "'
		//          group by cl_uid_fk order by clid desc; ";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$conn->close();
			return ["status" => "error", "message" => "اطلاعات با موفقیت دریافت شد"];
		}
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$i = 0;
		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
		$ssdprice = 0;
		$nvmeprice = 0;
		$sasprice = 0;
		$ramprice = 0;
		$cpuprice = 0;
		foreach ($pricelist["data"] as $ls) {
			switch ($ls["dp_category"]) {
				case "ssd":
					$ssdprice = intVal($ls["dp_price"]);
					break;
				case "nvme":
					$nvmeprice = intVal($ls["dp_price"]);
					break;
				case "sas":
					$sasprice = intVal($ls["dp_price"]);
					break;
				case "cpu":
					$cpuprice = intVal($ls["dp_price"]);
					break;
				case "ram":
					$ramprice = intVal($ls["dp_price"]);
					break;
			}
		}

		$servercount = 0;
		foreach ($listOfRecordType as $r) {

			$servicelist = json_decode($r["cldetails"], true);
			$listOfRecordType[$i]["cldetails"] = $servicelist;
			$listOfRecordType[$i]["cldetails"]["snapshots"] = [];
			foreach ($listOfRecordType[$i]["cldetails"]["server"] as $s) {
				if (!isset($listOfRecordType[$i]["cldetails"]["server"][$servercount]["ramprice"])) {
					$listOfRecordType[$i]["cldetails"]["server"][$servercount]["ramprice"] = 0;
					$listOfRecordType[$i]["cldetails"]["server"][$servercount]["cpuprice"] = 0;
					if ($listOfRecordType[$i]["cldetails"]["server"][$servercount] != "shutdown") {
						$listOfRecordType[$i]["cldetails"]["server"][$servercount]["ramprice"] = $s["cs_vcpu"] * $cpuprice;
						$listOfRecordType[$i]["cldetails"]["server"][$servercount]["cpuprice"] = $s["cs_ram"] * $ramprice;
					}
				}
				$servercount++;
			}
			$j = 0;
			$vls = [];
			foreach ($listOfRecordType[$i]["cldetails"]["volumes"] as $vl) {
				if ($vl["cv_is_snapshot"] == "1") {
					if (!isset($listOfRecordType[$i]["cldetails"]["snapshots"][$j]["volumeprice"])) {
						switch ($vl["cv_type"]) {
							case "ssd":
								$vl["price"] = $vl["cv_space"] * $ssdprice;
								break;
							case "nvme":
								$vl["price"]  = $vl["cv_space"] * $nvmeprice;
								break;
							case "sas":
								$vl["price"]  = $vl["cv_space"] * $sasprice;
								break;
						}
					}
					$listOfRecordType[$i]["cldetails"]["snapshots"][] = $vl;
				} else {
					if (!isset($listOfRecordType[$i]["cldetails"]["volumes"][$j]["volumeprice"])) {
						switch ($vl["cv_type"]) {
							case "ssd":
								$vl["price"] = $vl["cv_space"] * $ssdprice;
								break;
							case "nvme":
								$vl["price"]  = $vl["cv_space"] * $nvmeprice;
								break;
							case "sas":
								$vl["price"]  = $vl["cv_space"] * $sasprice;
								break;
						}
					}
					$vls[] = $vl;
				}
				$j++;
			}
			$listOfRecordType[$i]["cldetails"]["volumes"] = $vls;
			$i++;
		}
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
	}
	public static function RunJobForCalculateAndGenerateInvoiceForCloudServer($starttime, $endtime)
	{
		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
		$ssdprice = 0;
		$nvmeprice = 0;
		$sasprice = 0;
		$ramprice = 0;
		$cpuprice = 0;
		$ipprice = 0;
		foreach ($pricelist["data"] as $ls) {
			switch ($ls["dp_category"]) {
				case "ssd":
					$ssdprice = intVal($ls["dp_price"]);
					break;
				case "nvme":
					$nvmeprice = intVal($ls["dp_price"]);
					break;
				case "sas":
					$sasprice = intVal($ls["dp_price"]);
					break;
				case "cpu":
					$cpuprice = intVal($ls["dp_price"]);
					break;
				case "ram":
					$ramprice = intVal($ls["dp_price"]);
					break;
				case "ip":
					$ipprice = intVal($ls["dp_price"]);
					break;
			}
		}

		$begin = $starttime;
		$end = $starttime;

		$returnedArray = [];
		while ($starttime <= $endtime) {
			$percent = round(100 * ( jDateTime::diff($begin, $starttime) / jDateTime::diff($begin, $endtime) ));
			debug_msg("Getting Cloud history list ($percent%)", ' ' . console_text(sprintf('time: %s', $starttime), [CONSOLE['l_black']])) . "\n";

			$history_list = self::GetCloudFromHistory($starttime);

			if (empty($history_list["data"])) {
				// echo json_encode($history_list, JSON_PRETTY_PRINT) . "\n";

				debug_msg("No history was found for the specified range", '', -1);
				$starttime = jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1);
				continue;
			}

			$total_hourly = count($history_list["data"]);
			$current_hourly = 0;

			$end =  jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1);
			$usercalculated = [];

			foreach ($history_list["data"] as $a) {
				$uid = $a["cl_uid_fk"];
				$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];
				debug_msg("Applying updates to invoices per hour", ' ' . console_text(sprintf('user: %s, invoice: %s', $uid, $invoiceid), [CONSOLE['l_black']]), false);

				echo console_text(str_pad(round(100 * (++$current_hourly) / $total_hourly) . '%', 4, ' ', STR_PAD_LEFT), [CONSOLE['l_blue'], CONSOLE['inverse']]) . ' - ';

				echo console_text("Please wait", [CONSOLE['l_blue']]);

				foreach ($a["cldetails"]["server"] as $q) {
					$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
						$invoiceid,
						"سرور ابری IP :" . $q["cs_ip"],
						"cloud",
						$q["csid"],
						$q["cs_ip"],
						$starttime,
						$end
					)["id"];

					debug_msg("Applying updates to invoices per hour", ' ' . console_text(sprintf('user: %s,IP: %s, invoice: %s', $uid, $q["cs_ip"], $invoiceid), [CONSOLE['l_black']]), false);

					echo console_text(str_pad(round(100 * (++$current_hourly) / $total_hourly) . '%', 4, ' ', STR_PAD_LEFT), [CONSOLE['l_blue'], CONSOLE['inverse']]) . ' - ';

					echo console_text("Please wait", [CONSOLE['l_blue']]);

					echo ".";
					echo ".";

					FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
						$invoicetreeid,
						"مصرف IP",
						$ipprice,
						"IP",
						1,
						$q["csid"],
						$starttime,
						$end
					);
					echo ".";

					$ram = $q["cs_ram"];
					if (!isset($q["ramprice"])) {
						$q["ramprice"] = $ram * $ramprice;
					}
					FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
						$invoicetreeid,
						"مصرف " . $ram . "GB رم",
						$q["ramprice"],
						"RAM",
						$ram,
						$q["csid"],
						$starttime,
						$end
					);

					echo ".";

					$cpu = $q["cs_vcpu"];
					if (!isset($q["cpuprice"])) {
						$q["cpuprice"] = $ram * $cpuprice;
					}
					$s = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
						$invoicetreeid,
						"مصرف " . $cpu . "هسته پردازنده",
						$q["cpuprice"],
						"CPU",
						$cpu,
						$q["csid"],
						$starttime,
						$end
					);

					echo ".";

					$finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
					$fp = intVal($finalprice) * 0.09;
					$ffp = $fp + $finalprice;
					CREADITDETAILS_ADMIN::AddCreditDetails("سرور ابری IP :" . $q["cs_ip"] . "(" . $starttime . "-" . $end . ")", $ffp * (-1), $uid, 9);

					echo ".";

					echo "\r";
				}
				foreach ($a["cldetails"]["snapshots"] as $q) {
					$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

					$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
						$invoiceid,
						"نگهداری اسنپ شات",
						"cloud",
						0,
						"snapshots",
						$starttime,
						$end
					)["id"];

					echo ".";

					if (!isset($q["price"])) {
						switch ($q["cv_type"]) {
							case "ssd":
								$q["price"] = $q["cv_space"] * $ssdprice;
								break;
							case "nvme":
								$q["price"]  = $q["cv_space"] * $nvmeprice;
								break;
							case "sas":
								$q["price"]  = $q["cv_space"] * $sasprice;
								break;
						}
					}
					FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
						$invoicetreeid,
						"مصرف اسنپ شات " . explode("---", $q["cv_name"])[0] . "(" . $q["cv_type"] . ")",
						$q["price"],
						"storage",
						$q["cv_space"],
						0,
						$starttime,
						$end
					);
					$finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
					$fp = intVal($finalprice) * 0.09;
					$ffp = $fp + $finalprice;
					CREADITDETAILS_ADMIN::AddCreditDetails("مصرف snapshot :" . "(" . $starttime . "-" . $end . ")", $ffp * (-1), $uid, 9);

					echo ".";

					echo "\r";
				}
				foreach ($a["cldetails"]["volumes"] as $q) {
					$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

					$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
						$invoiceid,
						"مصرف فضای ذخیره سازی",
						"cloud",
						0,
						"volume",
						$starttime,
						$end
					)["id"];
					if (!isset($q["price"])) {
						switch ($q["cv_type"]) {
							case "ssd":
								$q["price"] = $q["cv_space"] * $ssdprice;
								break;
							case "nvme":
								$q["price"]  = $q["cv_space"] * $nvmeprice;
								break;
							case "sas":
								$q["price"]  = $q["cv_space"] * $sasprice;
								break;
						}
					}
					FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
						$invoicetreeid,
						"مصرف " . $q["cv_space"] . "GB فضای نگهداری Volume: " .
							explode("---", $q["cv_name"])[0] . "(" . $q["cv_type"] . ")",
						$q["price"],
						"Volume",
						$q["cv_space"],
						0,
						$starttime,
						$end
					);

					echo ".";

					$finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
					$fp = intVal($finalprice) * 0.09;
					$ffp = $fp + $finalprice;
					CREADITDETAILS_ADMIN::AddCreditDetails("مصرف snapshot :" . "(" . $starttime . "-" . $end . ")", $ffp * (-1), $uid, 9);

					echo ".";

					echo "\r";
				}
				self::UpdatePrice("cloud", $finalprice, $invoiceid);
				echo ".";

				echo "\r\e[0J"; // clear line and screen remainings

				$starttime = jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1);
				$arrDate = jDateTime::ReturnArrayOfOutput($starttime);
				$neededTime = jDateTime::ReturnDateTimeFromArray($arrDate["year"], $arrDate["month"], $arrDate["day"], "00", "00", "00");
				echo "\n";

				debug_msg("Calculating daily invoices from hourly invocies...", $neededTime, false);

				FINANCIAL_INVOICEBYDAY_ADMIN::RunJobForCalculateAndGenerateInvoiceForCDN(
					$neededTime,
					jDateTime::ReturnTimeafterCustomTime($neededTime, "days", 1)
				);
			}
		}

		return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CloudInvoiceHourly", $end);
	}
	public static function RunJobForCalculateAndGenerateInvoiceForLiveStream()
	{
		$l = LIVE_STREAM_ADMIN::GetListOfActiveLive();

		$starttime =   jDateTime::date("Y/m/d H:00:00");
		$end =  jDateTime::date("Y/m/d H:00:00", time() + 3600);

		$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("LiveStream");
		$prc = [];
		foreach ($pricelist["data"] as $pr) {
			$prc[$pr["dp_category"]] = $pr["dp_price"];
		}

		foreach ($l["data"] as $a) {

			// $nowArr=explode(" ",$starttime);
			// $nwarr=explode(":",$a["lss_creationdate"]);
			// $m=60-$nwarr[1];
			// $s=60-$nwarr[2];

			//return [$a["lss_creationdate"],sprintf("%02d", $m).":".sprintf("%02d", $s)];

			$uid = $a["lsd_uid_fk"];
			$invoiceid = self::UpdateInvoice($uid, $starttime, $end)["data"];

			$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
				$invoiceid,
				"سرویس پخش زنده :" . $a["lssname"],
				"live",
				$a["lssid"],
				$a["lssname"],
				$starttime,
				$end
			)["id"];

			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"میزان 1 ساعت سرویس پحش بنده فعال ",
				$prc["ActiveStream"],
				"ActiveStream",
				1,
				$a["lssid"]
			);

			$TotalRequest = 2000; // $a["LiveTotalRequest"];
			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				" تعداد  " . $TotalRequest . " درخواست سرویس پخش زنده",
				$TotalRequest * $prc["LiveTotalRequest"],
				"LiveTotalRequest",
				$TotalRequest,
				$a["lssid"]
			);

			$LiveTotalTraffic = 1000; //$a["LiveTotalTraffic"];
			FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
				$invoicetreeid,
				"میزان  " . $LiveTotalTraffic . "بایت ترافیک مصرفی سرویس پخش بنده",
				$LiveTotalTraffic * $prc["LiveTotalTraffic"],
				"LiveTotalTraffic",
				$LiveTotalTraffic,
				$a["lssid"]
			);

			$s[$invoicetreeid] = $finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
			// CREADITDETAILS_ADMIN::AddCreditDetails("سرور ابری IP :" . $a["ServerIP"]."(".$starttime."-".$end .")",$finalprice*(-1),$uid ,9);
			self::UpdatePrice("live", $finalprice, $invoiceid);
		}
		return INVOICE_LOG_ADMIN::UpdateLastTimeLog("LiveStreamInvoiceHourly", $end);
	}
	public static function RunJobForCalculateAndGenerateInvoiceForCDN($starttime, $endtime)
	{
		$returnedArray = [];

		$begin = $starttime;

		while ($starttime <= $endtime) {
			$percent = round(100 * ( jDateTime::diff($begin, $starttime) / jDateTime::diff($begin, $endtime) ));
			debug_msg("Getting CDN history list ($percent%)", ' ' . console_text(sprintf('time: %s', $starttime), [CONSOLE['l_black']])) . "\n";
			$history_list = self::GetCDNDataFromhistory($starttime);
			// $history_list["data"] = $history_list;
			// $starttime = jDateTime::date("Y/m/d H:00:00"); // format example
			// $starttime = jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1);
			$end = jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1); // jDateTime::date("Y/m/d H:00:00", time() + 3600);
			$pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CDN");
			$prc = [];
			foreach ($pricelist["data"] as $pr) {
				$prc[$pr["dp_category"]] = $pr["dp_price"];
			}
			$pln = [];

			if (empty($history_list["data"])) {
				// echo json_encode($history_list, JSON_PRETTY_PRINT) . "\n";

				debug_msg("No history was found for the specified range", '', -1);
				$starttime = jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1);
				continue;
			}

			$total_hourly = count($history_list["data"]);
			$current_hourly = 0;

			foreach ($history_list["data"] as $a) {
				$uid = $a["d_user_id_fk"];
				$plan = $a["dl_plan"];
				// if ($plan != "free") {
				$invoiceids = self::UpdateInvoice($uid, $starttime, $end);

				// if ($invoiceids["status"] != "success")
				//     continue;

				$returnedArray[] = $invoiceids;

				$invoiceid = $invoiceids["data"];

				debug_msg("Applying updates to invoices per hour", ' ' . console_text(sprintf('user: %s, plan: %s, invoice: %s', $uid, $plan, $invoiceid), [CONSOLE['l_black']]), false);

				echo console_text(str_pad(round(100 * (++$current_hourly) / $total_hourly) . '%', 4, ' ', STR_PAD_LEFT), [CONSOLE['l_blue'], CONSOLE['inverse']]) . ' - ';

				echo console_text("Please wait", [CONSOLE['l_blue']]);

				echo ".";

				$invoicetreeid = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdateByInvoiceID(
					$invoiceid,
					"مصرف CDN دامنه  :" . $a["d_name"],
					"cdn",
					$a["domain_id"],
					$a["d_name"],
					$starttime,
					$end
				)["id"];

				echo ".";

				$prcf = intVal($prc[$plan]) * 0.09;
				$pff = intVal($prc[$plan]) + $prcf;
				$pln[$a["d_name"]] = $pff;
				$rc = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::AddInvoiceDetails(
					$invoicetreeid,
					"مصرف CDN دامنه : " . $a["d_name"],
					$pff,
					$plan,
					1,
					$a["domain_id"],
					$starttime,
					$end
				);

				echo ".";

				if ($rc["status"] == "success") {
					$finalprice = FINANCIAL_INVOICETREEHOUR_ADMIN::UpdatePriceFromDetails($invoicetreeid);
					$crc = CREADITDETAILS_ADMIN::AddCreditDetails(
						"مصرف CDN دامنه : " . $a["d_name"] . "(" . $starttime . "-" . $end . ")",
						intVal($pff) * (-1),
						$uid,
						9
					);
					self::UpdatePrice("cdn", $finalprice, $invoiceid);
				}
				// }

				echo ".";

				echo "\r";
			}

			echo "\r\e[0J"; // clear line and screen remainings

			$starttime = jDateTime::ReturnTimeafterCustomTime($starttime, "hours", 1);

			$arrDate = jDateTime::ReturnArrayOfOutput($starttime);
			$neededTime = jDateTime::ReturnDateTimeFromArray($arrDate["year"], $arrDate["month"], $arrDate["day"], "00", "00", "00");

			echo "\n";

			debug_msg("Calculating daily invoices from hourly invocies...", $neededTime, false);

			FINANCIAL_INVOICEBYDAY_ADMIN::RunJobForCalculateAndGenerateInvoiceForCDN(
				$neededTime,
				jDateTime::ReturnTimeafterCustomTime($neededTime, "days", 1)
			);
		}

		// return $crc;
		// return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CDNInvoiceHourly", $end);
	}
}
