<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class LIVESTREAM_STREAM_ADMIN
{
    public static function GetList($token, $lsid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید" ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        if (LIVE_STREAM_ADMIN::CheckDuplicatedName($uid, $lsid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید" ];
        }
        $sql = "SELECT " . $GLOBALS['lssid'] . " as StreamId," . $GLOBALS['lssname'] . " as StreamName," . $GLOBALS['lssframerate'] . " as FrameRate," .
            $GLOBALS['lssbitrate'] . " as BitRate," . $GLOBALS['lsshls'] . " as HLS," . $GLOBALS['lssdash'] . " as DASH ," . $GLOBALS['lssaccess'] . " Ips " .
            " FROM " . $GLOBALS["livestream_stream_tablename"] . " WHERE " . $GLOBALS['lss_lsdid_fk'] . "=" . $lsid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما استریم به این بخش اضافه نکرده اید", $sql];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOne($token, $lssid, $lsid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        if (LIVE_STREAM_ADMIN::CheckDuplicatedName($uid, $lsid)["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }
        $sql = "SELECT * FROM " . $GLOBALS["livestream_stream_tablename"] . " WHERE " . $GLOBALS['lssid'] . "=" . $lssid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی شما نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetNewPort()
    {
        $sql = "SELECT " . $GLOBALS['lssport'] . " as port FROM " . $GLOBALS["livestream_stream_tablename"] . " ORDER BY "
            . $GLOBALS['lssport'] . " ASC";
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            return 1936;
        } else {
            $ports = mysqli_fetch_all($result, MYSQLI_ASSOC);
            for ($i = 0; $i < count($ports); $i++) {
                if ($ports[$i]["port"] != 1936) {
                    return 1936;
                }
                if ($i > 0) {
                    $prvport = $ports[$i - 1]["port"];

                    if ($ports[$i]["port"] != ($prvport + 1)) {
                        return $prvport + 1;
                    } else {
                        if ($i == count($ports) - 1) {
                            return $ports[$i]["port"] + 1;
                        }
                    }
                } else {
                    if (count($ports) == 1) {
                        return 1937;
                    }
                }
            }
        }
        $result->free_result();

        $conn->close();
    }
    public static function CheckDuplicatedName($name, $lsid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["livestream_stream_tablename"] . " WHERE " .
            $GLOBALS['lssname'] . "='" . $name . "' AND " . $GLOBALS['lss_lsdid_fk'] . "=" . $lsid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddStream(
        $token,
        $domainid,
        $lssname,
        $framerate,
        $hls,
        $dash,
        $hlsresolution,
        $dashresolution,
        $type,
        $ip,
        $record,
        $pushurl,
        $hlsaudiobitrate,
        $dashaudiobitrate,
        $hlsbitrate,
        $dashbitrate,
        $protection,
        $useragent,
        $country,
        $referer
    ) {
        $now = jDateTime::date("Y/m/d H:i:s");


        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $streamDomainDetails = LIVE_STREAM_ADMIN::UserCanAccessToStreamDomain($uid, $domainid);
        if ($streamDomainDetails["status"] == "error") {
            return ["status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید",
                $streamDomainDetails
            ];
        }
        $name = TOOLS_ADMIN::seo_friendly_url($lssname);
        if (LIVESTREAM_STREAM_ADMIN::CheckDuplicatedName($name, $domainid)["status"] == "error") {
            return ["status" => "error", "message" => "نام درخواستی شما تکراری است و قابل ثبت نیست لطفا نام دیگری انتخاب نمایید"];
        }
        if (!in_array($framerate, range(24, 30))) {
            return ["status" => "error", "message" => "ّframe rate  ارسالی شما نامعتبر است شما میتوانید از رنج 24  تا 30 انتخاب نمایید"];
        }
        $hlsOrDashStatus = ["true", "false"];
        $resolution = ["360", "480", "720", "1080"];
        if (!in_array($hls, $hlsOrDashStatus)) {
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس HLS اشتباه است"];
        }
        if (!in_array($dash, $hlsOrDashStatus)) {
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس DASH اشتباه است"];
        }
        $hlsRes = [];
        if ($hls == "true") {
            $hlsRes = explode(",", $hlsresolution);
            if (count($hlsRes) == 0) {
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution HLS ارسال نکرده اید"];
            } else {
                foreach ($hlsRes as $m) {
                    if (!in_array($m, $resolution)) {
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution HLS اشتباه است ", "HLS-Resolution" => $m];
                    }
                }
            }
        } else {
            $hlsresolution = "";
        }
        $dashRes = [];

        if ($dash == "true") {
            $dashRes = explode(",", $dashresolution);
            if (count($dashRes) == 0) {
                return ["status" => "error", "message" => "ّشما مقداری برای Resolution DASH ارسال نکرده اید"];
            } else {
                foreach ($dashRes as $m) {
                    if (!in_array($m, $resolution)) {
                        return ["status" => "error", "message" => "ّمقدار ارسالی برای Resolution DASH اشتباه است ", "DASH-Resolution" => $m];
                    }
                }
            }
        } else {
            $dashresolution = "";
        }
        if (!in_array($record, $hlsOrDashStatus)) {
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس Record اشتباه است"];
        }

        $streamType = ["pull", "push"];
        if (!in_array($type, $streamType)) {
            return ["status" => "error", "message" => "ّمقدار ارسالی برای وضعیت سرویس Type اشتباه است"];
        }
        if ($type == "pull") {
            $pushurl = "";
        }
        if ($type == "push") {
            if (!filter_var($pushurl, FILTER_VALIDATE_URL)) {
                return ["status" => "error", "message" => "لینک ارسالی Push  شما اشتباه است"];
            } else {
                if (substr($pushurl, -5) != ".m3u8") {
                    return ["status" => "error", "message" => "لینک ارسالی Push  شما اشتباه است"];
                }
            }
        }
        $bitrateRes = ["350", "800", "1200", "1900"];

        $audioBitRateRange = ["64", "92", "128"];
        if ($dash == "true") {
            if (strpos($dashbitrate, ",")) {
                $hlsbitrates = explode(",", $hlsbitrate);
                if (count($hlsbitrates) == 0) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای HLS Bitrates نامعتبر است"];
                }
                foreach ($hlsbitrates as $a) {
                    if (!in_array($a, $bitrateRes)) {
                        return ["status" => "error", "message" => "مقدار ارسالی برای HLS Bitrates نامعتبر است",
                        ];
                    }
                }
            } else {
                if (!in_array($dashbitrate, $bitrateRes)) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای HLS Bitrates نامعتبر است",

                    ];
                }
            }
            if (strpos($hlsaudiobitrate, ",")) {
                $hlsaudiobitrates = explode(",", $hlsaudiobitrate);
                if (count($hlsaudiobitrates) == 0) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای HLS AudioBitrates نامعتبر است"];
                }
                foreach ($hlsaudiobitrates as $a) {
                    if (!in_array($a, $audioBitRateRange)) {
                        return ["status" => "error", "message" => "مقدار ارسالی برای HLS AudioBitrates نامعتبر است",
                        ];
                    }
                }
            } else {
                if (!in_array($hlsaudiobitrate, $audioBitRateRange)) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای HLS AudioBitrates نامعتبر است",

                    ];
                }
            }
        }
        if ($hls == "true") {
            if (strpos($hlsbitrate, ",")) {
                $hlsbitrates = explode(",", $hlsbitrate);
                if (count($hlsbitrates) == 0) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای HLS Bitrates نامعتبر است"];
                }
                foreach ($hlsbitrates as $a) {
                    if (!in_array($a, $bitrateRes)) {
                        return ["status" => "error", "message" => "مقدار ارسالی برای HLS Bitrates نامعتبر است",
                        ];
                    }
                }
            } else {
                if (!in_array($hlsbitrate, $bitrateRes)) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای DASH Bitrates نامعتبر است",

                    ];
                }
            }

            if (strpos($dashaudiobitrate, ",")) {
                $dashaudiobitrates = explode(",", $dashaudiobitrate);

                if (count($dashaudiobitrates) == 0) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای DASH Audiobitrate نامعتبر است"];
                }
                foreach ($dashaudiobitrates as $a) {
                    if (!in_array($a, $audioBitRateRange)) {
                        return ["status" => "error", "message" => "مقدار ارسالی برای DASH Audiobitrate نامعتبر است",
                            "value" => $a
                        ];
                    }
                }
            } else {
                if (!in_array($dashaudiobitrate, $audioBitRateRange)) {
                    return ["status" => "error", "message" => "مقدار ارسالی برای DASH Audiobitrate نامعتبر است",

                    ];
                }
            }
        }


        if ($hls=="false" && $dash=="false") {
            return ["status" => "error", "message" => "امکان غیر فعال نمودن همزمان HLS و DASH وجود ندارد"];
        }

        if ($hls == "true") {
            $hlsoutput = [];
            if (strpos($hlsresolution, ",")) {
                if (strpos($hlsaudiobitrate, ",")) {
                    if (strpos($hlsbitrate, ",")) {
                        $hlsArray = explode(",", $hlsresolution);
                        $hlsaudioArray = explode(",", $hlsaudiobitrate);
                        $hlsbitrateArray = explode(",", $hlsbitrate);
                        sort($hlsArray);
                        sort($hlsaudioArray);
                        sort($hlsbitrateArray);
                        if (count($hlsArray) == count($hlsbitrateArray) && count($hlsaudioArray) == count($hlsArray)) {
                            for ($i = 0; $i < count($hlsArray); $i++) {
                                //array_push($hlsoutput, $hlsArray[$i]);
                                $hlsoutput[ $hlsArray[$i]]=$hlsbitrateArray[$i].",".$hlsaudioArray[$i];
                            }
                        } else {
                            return ["status" => "error", "message" => "مقادیر ارسالی برای HLS اشتباه است"];
                        }
                    } else {
                        return ["status" => "error", "message" => "مقادیر ارسالی برای HLS اشتباه است"];
                    }
                } else {
                    return ["status" => "error", "message" => "مقادیر ارسالی برای HLS اشتباه است"];
                }
            } else {
                $hlsoutput[$hlsresolution]=$hlsbitrate.",".$hlsaudiobitrate;
            }
        }

        if ($dash == "true") {
            $dashoutput = [];
            if (strpos($dashresolution, ",")) {
                if (strpos($dashaudiobitrate, ",")) {
                    if (strpos($dashbitrate, ",")) {
                        $dashArray = explode(",", $dashresolution);
                        $dashaudioArray = explode(",", $dashaudiobitrate);
                        $dashbitrateArray = explode(",", $dashbitrate);
                        sort($dashArray);
                        sort($dashaudioArray);
                        sort($dashbitrateArray);
                        if (count($dashArray) == count($dashbitrateArray) && count($dashaudioArray) == count($dashArray)) {
                            for ($i = 0; $i < count($dashArray); $i++) {
                                //array_push($hlsoutput, $hlsArray[$i]);
                                $dashoutput[$dashArray[$i]]=$dashbitrateArray[$i].",".$dashaudioArray[$i];
                            }
                        } else {
                            return ["status" => "error", "message" => "مقادیر ارسالی برای HLS اشتباه است"];
                        }
                    } else {
                        return ["status" => "error", "message" => "مقادیر ارسالی برای HLS اشتباه است"];
                    }
                } else {
                    return ["status" => "error", "message" => "مقادیر ارسالی برای HLS اشتباه است"];
                }
            } else {
                $dashoutput[$dashresolution]=$dashaudiobitrate.",".$dashbitrate;
            }
        }





        if ($ip != "") {
            $ips = explode(",", $ip);

            $res = [];
            $stat = 1;
            $success_array = [];
            foreach ($ips as $ip) {
                if (strpos($ip, '/')) {
                    $nip = explode("/", $ip);
                    if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push(
                            $res,
                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                        );
                    } else {
                        array_push($success_array, ["ip" => $ip]);

                        array_push($res, [
                            "status" => "success", "ip" => $ip,
                            "message" => "درخواست شما با موفقیت انجام شد"
                        ]);
                    }
                } else {
                    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                        $stat = 0;
                        $out["status"] = "error";
                        array_push(
                            $res,
                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                        );
                    } else {
                        array_push($success_array, ["ip" => $ip]);

                        array_push($res, [
                            "status" => "success", "ip" => $ip,
                            "message" => "درخواست شما با موفقیت انجام شد"
                        ]);
                    }
                }
            }

            if ($stat == 0) {
                return ["status" => "error", "message" => "خطا در IP های ارسالی", "IP" => $out];
            }
        } else {
            $ip = "all";
        }
        $validrecstat = ["true", "false"];
        if (!in_array($record, $validrecstat)) {
            return ["status" => "error", "message" => "وضعیت ضبط درخواستی شما نامعتبر است"];
        }
        $countries = explode(",", $country);
        $country_array = [
            "AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
            "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
            "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
            "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
            "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
            "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
            "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
            "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
            "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
            "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
            "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
        ];
        foreach ($countries as $c) {
            if (!in_array(strtoupper($c), $country_array)) {
                return ["status" => "error", "message" => "کشور ارسالی نامعتبر است"];
            }
        }

        $recstat = ($record == "true" ? "1" : "0");
        $streamkey = USERS_ADMIN::GenerateHash(24);
        $port = self::GetNewPort();
        $sqlins = "INSERT INTO " .
            $GLOBALS["livestream_stream_tablename"] . "(" . $GLOBALS['lssid'] . "," .
            $GLOBALS['lssname'] . "," . $GLOBALS['lssframerate'] . "," .
            $GLOBALS['lsshls'] . "," .
            $GLOBALS['lssdash'] . "," . $GLOBALS['lssaccess'] . "," .
            $GLOBALS['record'] . "," . $GLOBALS['lsstype'] . "," .
            $GLOBALS['lsspushurl'] . "," . $GLOBALS['lssstreamkey'] . "," .
            $GLOBALS['lss_lsdid_fk'] . "," . $GLOBALS['lss_hlsbitrate'] . "," .
            $GLOBALS['lss_dashbitrate'] . "," .$GLOBALS['lss_hlsaudiobitrate'] . "," .
            $GLOBALS['lss_dashaudiobitrate'] . "," .$GLOBALS['lssport'] . "," .
            $GLOBALS['lssprotection'] . "," . $GLOBALS['lssuseragent'] . "," .
            $GLOBALS['lsscountry'] . "," . $GLOBALS['lss_creationdate'] . "," .
            $GLOBALS['lssreferer']  . ") VALUES (0,'" . $name . "','" .
            $framerate . "','" . $hlsresolution . "','" . $dashresolution . "','" .
            $ip . "','" . $recstat . "','" . $type . "','" . $pushurl . "','" .
            $streamkey . "','" . $domainid . "','" . $hlsbitrate . "','" . $dashbitrate . "'
            ,'" . $hlsaudiobitrate . "','" . $dashaudiobitrate . "','" .
             $port . "','" . $protection . "'
                   ,'" . $useragent . "','" . $country . "','" .
            $now . "','" . $referer . "')";
        $conn = GetConnection();

        $outputArray = [
            "domain" => $streamDomainDetails["data"][0]["lsdname"] . "."
                . $GLOBALS["liveStreamMainDomain"],
            "framerate" => $framerate,
             "access" => $ip,
            "record" => $record,
            "streamkey" => $streamkey,
            "port" => $port,
            "protection" => $protection,
            "referer" => $referer,
            "useragent" => $useragent,
            "country" => $country,

            //"streamtype" => [
            //     "type" => $type,
            //    "pushurl" => $pushurl
            //],
        ];
        if ($hls=="true") {
            $outputArray["hls"] = ["resolution" => $hlsoutput];
        }
        if ($dash=="true") {
            $outputArray["dash"] = ["resolution" => $dashoutput];
        }

        if ($conn->query($sqlins) === true) {
            $listOfRecordType = ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];
        } else {
            $listOfRecordType = [
                $sqlins,
                "status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",
            ];
        }
        API_LIVESTREAM_ADMIN::RunCreateAPILIVE($outputArray);
        $conn->close();
        return [$listOfRecordType, $outputArray];
    }
    public static function RemoveStream($token, $streamdomainid, $streamid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $CanAccessToStreamDomain = LIVE_STREAM_ADMIN::UserCanAccessToStreamDomain($uid, $streamdomainid);

        if ($CanAccessToStreamDomain["status"] == "success") {
            $sql = "DELETE FROM " . $GLOBALS["livestream_stream_tablename"] . " WHERE " . $GLOBALS["lss_lsdid_fk"] . "=" . $streamdomainid . " AND " . $GLOBALS["lssid"] . "=" . $streamid;
            $conn = GetConnection();
            if ($conn->query($sql) == true) {
                return ["status" => "success", "message" => "درخواست شما انجام شد "];
            } else {
                return ["status" => "error", "message" => "شما امکان انجام این درخواست را ندارید"];
            }
        }
        return ["status" => "error", "message" => "شما امکان انجام این درخواست را ندارید"];
    }
}
