<?php
 require_once 'vars.php';

class ParseZone {
	private $origin = '';
	private $lines = array();
	private $ttl =120;
	private $soa = array();
	private $records = array();
	public function __construct ($file, $origin = "") {
		if (!empty($origin)) $this->origin = $origin;
		$file = preg_replace("/(\r\n)|(\r)/", "\n", $file);
		$file = preg_replace_callback('/(\([^()]*\))/', function ($matches) {
			$a = explode("\n", $matches[0]);
			$b = array();
			if (strpos($matches[0], "DKIM") !== false || strpos($matches[0], "DMARC") !== false) {
				foreach ($a as $line) {					
					$line = preg_replace('/\s+/', ' ', $line);
					$line = substr($line, 0, strrpos($line, '"')+1); 
					$b[] = $line;
				}
			}
			else {
				foreach ($a as $line) {
					$line = preg_replace('/\s+/', ' ', $line);
					$line = preg_replace('/(\s+)?(;|#)([\s\S]+)?/i', '', $line);
					$b[] = $line;
				}
			}
			$line = implode("", $b);
			return str_replace(array("( ", "(", " )", ")"), "", $line);
		}, $file);

		$this->lines = explode("\n", $file);
		if (count($this->lines) > 1000) {
			throw new \Exception('zone file to big for parsing');
		}
	}

	public function parse () {
		foreach ($this->lines as $line) {
			$line = preg_replace('/\s+/', ' ', $line);
			if (strpos($line, "TXT") === false) {
				$line = preg_replace('/(\s+)?(;|#)([\s\S]+)?/i', '', $line);
			}
			if (empty($line)) continue;
			if (strpos($line, "RRSIG") !== false) continue;
			if (strpos($line, "NSEC") !== false) continue;
			if (strpos($line, "DNSKEY") !== false) continue;
			if (strpos($line, "SPF") !== false) continue;
			$this->parseORIGIN($line);
			$this->parseTTL($line);

    // 			if (strpos($line, "SOA") !== false) {
    // 				$this->parseSOA($line);
    // 				continue;
    // 			}
			$this->parseRR($line);
		}
	}
	public function parseORIGIN ($line) {
		if (preg_match('/\$ORIGIN ([*-a-z0-9.]+)/i', $line, $match)) {
			$origin = $match[1];
			if (empty($this->origin)) {
				$this->origin = $origin;
			}
			else {
				if ($this->origin != $origin) {
					throw new \Exception('parse error');
				}
			}
		}
	}
	public function parseTTL ($line) {
		if (preg_match('/\$TTL ([0-9]+)([a-z]+)?/i', $line, $match)) {
			if (isset($match[2])) {
				$this->ttl = $this->formatTime($match[1], $match[2]);
			}
			else {
				$this->ttl = $match[1];
			}
		}
	}
	public function parseRR ($line) {
		if (preg_match("/([*-a-z0-9.]+)? ([0-9]+)?(?: )?(IN)?(?: )?([a-z]+) ([\s\S]+)/i", $line, $matches)) {
			$record=array();
			if (!empty($this->origin) && $matches[1] == "@") {
				$record['name'] = $this->origin;
			}
			else {
				if (empty($matches[1])) {
					$record['name'] = $this->origin;
				}
				else {
					$record['name'] = $matches[1];
				}
			}
			if (empty($matches[2])) {
				$record['ttl'] = $this->ttl;
			}
			else {
				$record['ttl'] = $matches[2];
			}
			$record['type'] = $matches[4];
			if ($matches[4] == 'MX' || $matches[4] == 'SRV' || $matches[4] == 'DS') {
				$exp = explode(' ', $matches[5], 2);
				$record['aux'] = $exp[0];
				$record['data'] = $exp[1];
			}
			else {
				$record['aux'] = 0;
				$record['data'] = $matches[5];
			}

// 			if ($record['type'] == "TXT") {
// 				$record['data'] = substr($record['data'], 0, strrpos($record['data'], '"')+1); // strip everything after the last "
// 			}
			if (strpos($record['data'], "@") !== false && !empty($this->origin)) {
				/* replace the @ only on MX, CNAME and SRV records see: http://www.phpclasses.org/discuss/package/9033/thread/1/ */
				if ($record['type'] == "MX" || $record['type'] == "CNAME" || $record['type'] == "SRV") {
					$record['data'] = str_replace("@", $this->origin, $record['data']);
				}
			}
			$this->records[] = $record;
		}
	}
	public function parseSOA ($line) {
		if (preg_match("/([@a-z0-9.-]+) ([0-9]+)?([a-z]+)?(?: )?(IN)?(?: )?(?:[a-z]+) ([-a-z0-9.]+) ([@-a-z0-9.]+) ([0-9a-]+) ([0-9]+)([a-z]+)? ([0-9]+)([a-z]+)? ([0-9]+)([a-z]+)? ([0-9]+)([a-z]+)?/i", $line, $matches)) {
			if ($matches[1] == "@") {
				if (empty($this->origin)) {
					throw new \Exception('parse error');
				}
			}
			else {
				if (empty($this->origin)) {
					if (empty($matches[1])) {
						throw new \Exception('parse error');
					}
					else {
						$this->origin = $matches[1];
					}
				}
				else {
					if ($this->origin != $matches[1]) {
						throw new \Exception('parse error');
					}
				}
			}
			$this->soa['origin'] = $this->origin;
			$this->soa['ns'] = $matches[5];
			if (strpos($matches[6], "@") !== false) {
				$this->soa['mbox'] = str_replace("@", ".", $matches[6]);
			}
			else {
				$this->soa['mbox'] = $matches[6];
			}
			$this->soa['serial'] = $matches[7];
			if (isset($matches[9]) && !empty($matches[9])) {
				$this->soa['refresh'] =  $this->formatTime($matches[8], $matches[9]);
			}
			else {
				$this->soa['refresh'] =  $matches[8];
			}
			if (isset($matches[11]) && !empty($matches[11])) {
				$this->soa['retry'] = $this->formatTime($matches[10], $matches[11]);
			}
			else {
				$this->soa['retry'] = $matches[10];
			}
			if (isset($matches[13]) && !empty($matches[13])) {
				$this->soa['expire'] = $this->formatTime($matches[12], $matches[13]);
			}
			else {
				$this->soa['expire'] = $matches[12];
			}
			if (isset($matches[3]) && !empty($matches[3]) && $matches[3] != "IN" && $matches[3] != "SO") {
				$this->soa['minimum'] = $this->formatTime($matches[2], $matches[3]);
				$this->soa['ttl'] = $this->formatTime($matches[2], $matches[3]);
			}
			else {
				if (!empty($matches[2])) {
					$this->soa['minimum'] = $matches[2];
					$this->soa['ttl'] = $matches[2];
					$this->ttl = $this->soa['ttl'];
				}
				else {
					$this->soa['minimum'] = $this->ttl;
					$this->soa['ttl'] = $this->ttl;
				}
			}
		}
	}
	public function getParsedData () {
		return array('soa' => $this->soa, 'records' => $this->records);
	}
	public function formatTime ($time, $modifier = '') {
		if (!empty($modifier)) {
			switch($modifier) {
				case "y":
				case "Y":
					$multiplier=86400*365;
					break;
				case 'w':
				case 'W':
					$multiplier=86400*7;
					break;
				case "d":
				case "D":
					$multiplier=86400;
					break;
				case "h":
				case "H":
					$multiplier=3600;
					break;
				case "m":
				case "M":
					$multiplier=60;
					break;
				case "s":
				case "S":
				default:
					$multiplier=1;
					break;
			}
			return $time * $multiplier;
		}
		else {
			return $time;
		}
	}
}
