<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class CLOUD_FIREWALL_ADMIN
{

    public static function GetList($token, $idc, $internal = "internal", $uid = 0, $mail = 0)
    {
        if ($internal == "internal") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                                 return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
            }
            $uid = $usersDetails["userdetail"][0]["uid"];
            $mail = $usersDetails["userdetail"][0]["umail"];
        }

        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        CLOUD_PROJECT_ADMIN::CreateProject($token, $idc);
        //  CLOUD_PROJECT_ADMIN::GetUserByIDC($idc,$uid);
        self::GetDefaultFireWall($uid, $idc, $m);



        $sql = "SELECT cfid as id ,cf_name as name,  cf_description as description from " .
            $GLOBALS["tbl_cloud_firewalll"] . " WHERE " . $GLOBALS["cf_uid_fk"] . "=" . $uid . " AND " . $GLOBALS["cf_idcid_fk"] . "=" . $idc;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $i = 0;
        foreach ($listOfRecordType as $r) {
            $listOfRecordType[$i]["data"] = CLOUD_FIREWALLRULES_ADMIN::GetList($token, $r["id"]);
            $i++;
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }

    public static function GetListWithServer($token, $idc, $serverID)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];


        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        CLOUD_PROJECT_ADMIN::CreateProject($token, $idc);
        //  CLOUD_PROJECT_ADMIN::GetUserByIDC($idc,$uid);
        self::GetDefaultFireWall($uid, $idc, $m);



        $sql = "SELECT csa_serverid_fk as ServerID,cfid as id ,cf_name as name, cf_description as description
        from tbl_cloud_firewalll LEFT JOIN (SELECT * FROM tbl_cloud_securitygroups_attachedtoserver where csa_serverid_fk=" . $serverID . ")
        csf ON csa_securiygroupid_fk = cfid where cf_uid_fk=" . $uid . " AND cf_idcid_fk=" . $idc;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $i = 0;
        foreach ($listOfRecordType as $r) {
            $listOfRecordType[$i]["data"] = CLOUD_FIREWALLRULES_ADMIN::GetList($token, $r["id"]);
            $i++;
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }

    public static function UserCanAccessToFireWall($uid, $fwid)
    {
        $sql = "SELECT  *,count(cfid) as CountID from " .
            $GLOBALS["tbl_cloud_firewalll"] . " WHERE " . $GLOBALS["cf_uid_fk"] . "=" . $uid . " AND " . $GLOBALS["cfid"] . "=" . $fwid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        if ($listOfRecordType[0]["CountID"] == "0") {
            return ["status" => "error", $sql];
        } else if ($listOfRecordType[0]["CountID"] == "1") {
            return ["status" => "success", "data" => $listOfRecordType];
        } else {
            return ["status" => "error"];
        }
        return ["status" => ""];
    }

    public static function GetOneByID($fwid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tbl_cloud_firewalll"] . " WHERE "
            . $GLOBALS["cfid"] . "=" . $fwid;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
            return $result;
        } else {
            $listOfRecordType = ["status" => "success", "data" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetDefaultFireWall($uid, $idc, $m)
    {
        $sql = "SELECT * FROM " . $GLOBALS["tbl_cloud_firewalll"] . " WHERE "
            . $GLOBALS["cf_uid_fk"] . "=" . $uid . " AND " . $GLOBALS["cf_name"] . "='default' and " . $GLOBALS["cf_idcid_fk"] . "=" . $idc;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
                return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
            }
            $sql = "INSERT INTO " . $GLOBALS["tbl_cloud_firewalll"] .
                " VALUES (0,'default','Default Security Group','" . $uid . "','','" . $idc . "')";
            $conn = GetConnection();
            $conn->query($sql);
            $last_id = $conn->insert_id;
            $conn->close();
            $api = API_CLOUD_FIREWALL_ADMIN::RunGetSecurityGroup($m, $idc);

            $mn = json_decode($api, true);
            self::UpdateServerIDfromAPI($last_id, $mn[0]["id"]);
            CLOUD_PROJECT_ADMIN::SetDefaultSecurityGroup($uid, $idc, $mn[0]["id"]);

            // $i = str_replace("'", '"', $mn[0]["security_group_rules"]);
            // $i = str_replace("None", "\"None\"", $i);
            $rules =$mn[0]["security_group_rules"];// json_decode($i, true);
            $i = 0;
            foreach ($rules as $rule) {
                $trtype = "inbound";
                if ($rule["direction"] == "egress") {
                    $trtype = "outbound";
                }
                if (substr($rule["ethertype"], -1) == "6")
                    $ip = "::/0";
                else {
                    $ip = "0.0.0.0/0";
                }
                $port="any";
                if($rule["port_range_max"]!=null){
                    $port=$rule["port_range_min"]."-".$rule["port_range_max"];
                }
                $protocol="ANY";
                if(strtoupper($rule["protocol"])!=null){
                    $protocol=strtoupper($rule["protocol"]);
                }
                $out = CLOUD_FIREWALLRULES_ADMIN::AddAdminFireWallRules(
                    $trtype,
                    $protocol,
                    $port,
                    $ip,
                    $last_id,
                    substr($rule["ethertype"], -1)
                );
                CLOUD_FIREWALLRULES_ADMIN::UpdateServerIDFromAPI($out["id"], $rule["id"]);
            }
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

            $last_id=$listOfRecordType[0]["cfid"];
            $api = API_CLOUD_FIREWALL_ADMIN::RunGetSecurityGroup($m, $idc);
            return $api;
            // $mn = json_decode($api, true);
            // self::UpdateServerIDfromAPI($last_id, $mn[0]["id"]);
            // CLOUD_PROJECT_ADMIN::SetDefaultSecurityGroup($uid, $idc, $mn[0]["id"]);

            // // $i = str_replace("'", '"', $mn[0]["security_group_rules"]);
            // // $i = str_replace("None", "\"None\"", $i);
            // $rules =$mn[0]["security_group_rules"];// json_decode($i, true);
            // $i = 0;
            // foreach ($rules as $rule) {
            //     $trtype = "inbound";
            //     if ($rule["direction"] == "egress") {
            //         $trtype = "outbound";
            //     }
            //     if (substr($rule["ethertype"], -1) == "6")
            //         $ip = "::/0";
            //     else {
            //         $ip = "0.0.0.0/0";
            //     }
            //     $out = CLOUD_FIREWALLRULES_ADMIN::AddAdminFireWallRules(
            //         $trtype,
            //         "Any",
            //         "any",
            //         $ip,
            //         $last_id,
            //         substr($rule["ethertype"], -1)
            //     );
            //     CLOUD_FIREWALLRULES_ADMIN::UpdateServerIDFromAPI($out["id"], $rule["id"]);
            // }


            $listOfRecordType = ["status" => "success"];
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function GetCountOfFirewalls($uid, $idc)
    {
        $sql = "SELECT count(cfid) as cfCount  from " . $GLOBALS["tbl_cloud_firewalll"] . " WHERE " . $GLOBALS["cf_idcid_fk"] . "=" . $idc . " AND " .
            $GLOBALS["cf_uid_fk"] . "=" . $uid;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $result->free_result();
        $conn->close();
        return $r[0]["cfCount"];
    }
    public static function AddFireWall($token, $name, $description, $idc)
    {

        if ($name == "default") {
            return ["status" => "error", "message" => "نام درخواستی شما برای فایروال نامعتبر است"];
        }
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);
        $cntOfFirewall = self::GetCountOfFirewalls($uid, $idc);
        if ($cntOfFirewall >= 8) {
            return ["status" => "error", "message" => "شما امکان افزودن فایروال ندارید"];
        }
        self::GetDefaultFireWall($uid, $idc, $m);

        if (CLOUD_IDC_ADMIN::GetOneByID($idc)["status"] != "success") {
            return ["status" => "error", "message" => "دیتاسنتر مورد شما غیر فعال است و در حال حاضر امکان اعمال تغییرات بر روی آن وجود ندارد"];
        }
        $sql = "INSERT INTO " . $GLOBALS["tbl_cloud_firewalll"] . " VALUES (0,'" . $name . "','" . $description . "','" . $uid . "','','" . $idc . "')";
        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $conn->close();
        $api = API_CLOUD_FIREWALL_ADMIN::RunCreateAPIFIREWALL($name, $description, $m, $idc);
        $mn = json_decode($api, true);
        self::UpdateServerIDfromAPI($last_id, $mn["id"]);


        // $i = str_replace("'", '"', $mn["security_group_rules"]);
        // $i = str_replace("None", "\"None\"", $i);
        $rules = $mn["security_group_rules"];//json_decode($i, true);
        if (is_array($rules)) {
            foreach ($rules as $rule) {
                $trtype = "inbound";
                if ($rule["direction"] == "egress") {
                    $trtype = "outbound";
                }
                if (substr($rule["ethertype"], -1) == "6")
                    $ip = "::/0";
                else {
                    $ip = "0.0.0.0/0";
                }
                $out = CLOUD_FIREWALLRULES_ADMIN::AddAdminFireWallRules(
                    $trtype,
                    "Any",
                    "any",
                    $ip,
                    $last_id,
                    substr($rule["ethertype"], -1)
                );
                CLOUD_FIREWALLRULES_ADMIN::UpdateServerIDFromAPI($out["id"], $rule["id"]);

                $listOfRecordType = CLOUD_FIREWALLRULES_ADMIN::GetList($token, $last_id);

            }
            return [
                "status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", "id" => $last_id,
                "data" => $listOfRecordType, $cntOfFirewall
            ];
        } else {
            $out = CLOUD_FIREWALLRULES_ADMIN::UpdateServerIDFromAPI($out["id"], $rule["id"]);

            $listOfRecordType = CLOUD_FIREWALLRULES_ADMIN::GetList($token, $last_id);
            return [
                "status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", "id" => $last_id,
                "data" => $listOfRecordType,
            ];
            CLOUD_FIREWALLRULES_ADMIN::UpdateServerIDFromAPI($out["id"], $rule["id"]);
            return ["status" => "success", "message" => "اطلاعات با موفقیت ثبت شد"];

            // return ["status" => "error", "message" => "خطا در افزودن فایروال در سرور"];
        }
    }
    public static function UpdateServerIDfromAPI($id, $serverID)
    {
        $sql = "UPDATE " . $GLOBALS["tbl_cloud_firewalll"] . " SET " . $GLOBALS["cf_serverid"] . "='" . $serverID . "'
        WHERE " . $GLOBALS["cfid"] . "=" . $id;
        $conn = GetConnection();
        $conn->query($sql);
        $last_id = $conn->insert_id;
        $conn->close();
    }
    public static function DeleteFireWall($token, $fwid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $mail = $usersDetails["userdetail"][0]["umail"];
        $m = str_replace("@", "", $mail);
        $m = str_replace(".", "", $m);

        $c = self::UserCanAccessToFireWall($uid, $fwid);
        if ($c["status"] == "error") {
            return [$c, "status" => "error", "message" => "شما اجازه دسترسی به این فایروال را ندارید"];
        }
        if ($c["data"][0]["cf_name"] == "default") {
            return ["status" => "error", "message" => "شما امکان حذف فایروال پیش را ندارید"];
        }
        API_CLOUD_FIREWALL_ADMIN::RunDeleteFireWall($m, $c["data"][0]["cf_serverid"], $c["data"][0]["cf_idcid_fk"]);
        $firewallIsInUse = CLOUD_SECURITYGROUPSTOSERVER_ADMIN::CheckFirewallIsUsable($fwid);
        if ($firewallIsInUse != "0") {
            return ["status" => "error", "message" => "فایروال مورد نظر شما در سرور فعال است و امکان حذف آن نیست"];
        }
        CLOUD_FIREWALLRULES_ADMIN::RemoveAllRulesByFirewallID($fwid);
        $sql = "delete  from " . $GLOBALS["tbl_cloud_firewalll"] . " WHERE "
            . $GLOBALS['cfid'] . "=" . $fwid . " AND " . $GLOBALS["cf_uid_fk"] . "=" . $uid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }
}
