<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/userverification/usersverification_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/sms.php';

class USERSVERIFICATION_ADMIN
{

    public static function GetList()
    {
        $sql = "SELECT * FROM " . $GLOBALS["userverification_tablename"];
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetRecordWithParameter($fieldname, $fieldvalue)
    {
        /**
         * @param $activerecord
         * @return mixed
         */
        $sql = "SELECT * FROM " . $GLOBALS["userverification_tablename"] . " WHERE " . $GLOBALS[$fieldname] . " LIKE '%" . $fieldvalue . "%'";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["result" => "null"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneByID($uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["userverification_tablename"] . " WHERE " . $GLOBALS['uv_uid_fk'] . "=" . $uid;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();

        $conn->close();
        return ["status" => "success", $listOfRecordType[0], "data" => $listOfRecordType];
    }
    public static function CheckEmail($hash, $type, $token)
    {
        if ($type == "hash") {

            $sql = "SELECT * FROM " . $GLOBALS["userverification_tablename"] . " WHERE " .
                $GLOBALS['uvemail_code'] . "='" . $hash . "'";
            $conn = GetConnection();

            $result = mysqli_query($conn, $sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $conn->close();
                return ["status" => "error", "message" => "کد وارد شده اشتباه است"];
            } else {

                $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
                USERSVERIFICATION_ADMIN::ChangeUserStatus(
                    1,
                    $listOfRecordType[0]["uv_uid_fk"],
                    "email"
                );
                if ($listOfRecordType[0]["uvmobile_status"] == "1") {
                    USERS_ADMIN::ChangeUserStatus(1, $listOfRecordType[0]["uv_uid_fk"]);
                    self::DeleteRecord($listOfRecordType[0]["uv_uid_fk"]);
                    $verifystatus = ["mobile" => "verify", "email" => "verify"];
                }
                $verifystatus = ["mobile" => "notverify", "email" => "verify"];
            }
            $result->free_result();

            $conn->close();
            return ["status" => "success", "message" => "ایمیل شما با موفقیت تایید شد"];
        } else {
            $usExist = USERS_ADMIN::GetOneByToken($token);
            if ($usExist["status"] == "error") {
                return ["status" => "error", "message" => "توکن ارسالی اشتباه است لطفا مجدد وارد شوید"];
            } else {
                $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);
                $dbcode = ($vfc["data"][0]["uvemail_code"]);

                if ($hash == TOOLS_ADMIN::decrypt($dbcode)) {
                    USERSVERIFICATION_ADMIN::ChangeUserStatus(
                        1,
                        $usExist["userdetail"][0]["uid"],
                        "email"
                    );
                    $verifystatus = ["mobile" => "notverify", "email" => "verify"];
                    if ($vfc["data"][0]["uvmobile_status"] == "1") {
                        USERS_ADMIN::ChangeUserStatus(1, $usExist["userdetail"][0]["uid"]);
                        self::DeleteRecord($usExist["userdetail"][0]["uid"]);
                        $verifystatus = ["mobile" => "verify", "email" => "verify"];
                    }
                    $usExist = USERS_ADMIN::GetOneByToken($token);
                    return [
                        "status" => "success",
                        "message" => "اطلاعات ارسالی صحیح بود و کاربر تایید شد ", "data"
                        => $usExist,
                        "verifystatus" => $verifystatus
                    ];
                } else {

                    return ["status" => "error", "message" => "کد وارد شده اشتباه است"];
                }
            }
        }
    }
    public static function AddRecord($uid)
    {
        $conn = GetConnection();
        $sql = "INSERT INTO " . $GLOBALS['userverification_tablename'] . "(" . $GLOBALS['uv_uid_fk'] . "," .
            $GLOBALS['uvmobile_status'] . "," . $GLOBALS['uvmobile_code'] . "," .
            $GLOBALS['uvemail_status'] . "," . $GLOBALS['uvemail_code']
            . "," . $GLOBALS['uv_expire_date_verify'] . ") VALUES ('%s','%s','%s','%s','%s','%s')";

        $codeverify = rand(1000, 9999);
        $emailcode = rand(1000, 9999);
        // $emailhash = TOOLS_ADMIN::encrypt($emailcode);
        $datetime =  jDateTime::date("Y/m/d H:i:s", strtotime("+1 minutes"));

        $sql = sprintf($sql, $uid, '0', $codeverify, '1', $emailcode, $datetime);

        if ($conn->query($sql) === TRUE) {
            $response = [
                "status" => "success",
                "smscode" => $codeverify,
                "emailcode" => $emailcode,
                "emailhash" => $emailcode
            ];
            return $response;
        } else {
            $response = ["status" => "error", "message" =>  " " .  $conn->error];
            return $response;
        }

        $conn->close();
    }
    public static function ChangeUserStatus($status, $uid, $type)
    {
        $now = jDateTime::date("Y-m-d H:i:s");
        $sql = "UPDATE " . $GLOBALS["userverification_tablename"] .
            " SET " . $GLOBALS['uv' . $type . '_status'] . "=" . $status . "," .
            $GLOBALS['uv_' . $type . '_date_verify'] . "='" . $now
            . "'  WHERE " .
            $GLOBALS['uv_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }

    public static function CheckSMSVerifyCode($token, $vfcode)
    {
        $usExist = USERS_ADMIN::GetOneByToken($token);
        if ($usExist["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(401);
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "توکن ارسالی اشتباه است لطفا مجدد وارد شوید"];
        } else {
            $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);
            $dbcode = ($vfc["data"][0]["uvmobile_code"]);
            if ($dbcode == $vfcode) {
                USERSVERIFICATION_ADMIN::ChangeUserStatus(
                    1,
                    $usExist["userdetail"][0]["uid"],
                    "mobile"
                );
                $verifystatus = ["email" => "notverify", "mobile" => "verify"];
                if ($vfc["data"][0]["uvemail_status"] == "1") {
                    USERS_ADMIN::ChangeUserStatus(1, $usExist["userdetail"][0]["uid"]);
                    self::DeleteRecord($usExist["userdetail"][0]["uid"]);
                    $verifystatus = ["email" => "verify", "mobile" => "verify"];
                }
                $usExist["userdetail"][0]["usessionkey"] = $token;



                $mailTemplate = '
                        %s عزیز
                                        <br />
                            ثبت نام شما در میزبان کلود با موفقیت انجام شد؛
                            <br />
                            هم اکنون شما عضوی از خانواده میزبان کلود هستید،
                            <br />
                            از حسن انتخاب شما سپاسگزاریم!
                            <br />
                            از این پس می توانید با استفاده از جزئیات زیر وارد حساب کاربری خود در میزبان کلود شوید:
                            <br />
                            آدرس ایمیل: %s
                            <br />
                            رمز عبور: رمز عبور انتخای شما
                            <br />
                            آدرس ناحیه کاربری میزبان کلود: https://portal.mizbancloud.com
                            <br />
                            در صورت نیاز به راهنمایی و کسب اطلاعات در خصوص سرویس های میزبان کلود، از طریق راه های ارتباطی زیر با تیم پشتیبانی میزبان کلود در ارتباط باشید.
                            <br />
                                    ';
                $uname =$usExist["userdetail"][0]["uname"] . " " . $usExist["userdetail"][0]["ufamily"];
                $mailTemplate = sprintf($mailTemplate, $uname, $usExist["userdetail"][0]["umail"]);
                $params = [
                    "param1" => $uname,
                ];
                $o = EMAILCLASS::SendEmailPanel($usExist["userdetail"][0]["umail"], "به میزبان کلود خوش آمدید", $mailTemplate, "success", "ilamrdzppx", $params, $usExist["userdetail"][0]["umobile"]);






                return [
                    "status" => "success",
                    "message" => "اطلاعات ارسالی صحیح بود و کاربر تایید شد", "data" => $usExist,
                    "verifystatus" => $verifystatus
                ];
            } else {
                return ["status" => "error", "message" => "کد وارد شده اشتباه است"];
            }
        }
    }
    public static function DeleteRecord($uid)
    {
        $sql = "DELETE FROM   " . $GLOBALS["userverification_tablename"] .
            " WHERE " . $GLOBALS['uv_uid_fk'] . "=" . $uid;

        $conn = GetConnection();

        if ($conn->query($sql) === TRUE) {
            return "New record Updated  successfully";
        } else {
            return  "  " . $sql . "<br>" .  $conn->error;
        }

        $conn->close();
    }
    public static function ResendSMS($token)
    {
        $usExist = USERS_ADMIN::GetOneByToken($token);
        $now = jDateTime::date("Y/m/d H:i:s");

        if ($usExist["userdetail"][0]["ustatus"] == "error") {
            VARS_ADMIN::ReturnHeaders(401);
            return ["status" => "error", "message" => "توکن ارسالی اشتباه است لطفا مجدد وارد شوید"];
        } else {
            if ($usExist["userdetail"][0]["ustatus"] == 0) {

                $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);

                if ($vfc["status"] == "error") {
                    $s = self::AddRecord($usExist["userdetail"][0]["uid"]);
                    $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);

                    $codeverify = $vfc["data"][0]["uvmobile_code"];
                    SMSCLASS::SendSMSForVerifyUser(
                        $usExist["userdetail"][0]["umobile"],
                        '24cx5b0wio',
                        $codeverify
                    );
                    return ["status" => "success", "message" => "پیامک به شماره ثبت شده در پنل کاربری ارسال شد"];
                }
                if ($vfc[0]["uv_expire_date_verify"] > $now) {
                    VARS_ADMIN::ReturnHeaders(400);
                    return [
                        "status" => "error",
                        "dts" => $now, "xx" => $vfc[0]["uv_expire_date_verify"],
                        "message" => "حداقل فاصله زمانی دو ارسال پیامک 2دقیقه است"
                    ];
                } else {
                    $conn = GetConnection();
                    $sql = "UPDATE " . $GLOBALS['userverification_tablename'] . " SET " . $GLOBALS['uvmobile_code'] . "='%s'," .
                        $GLOBALS['uv_expire_date_verify'] . "='%s'     WHERE  " . $GLOBALS['uvid'] . "=%s";
                    $codeverify = rand(1000, 9999);

                    $datetime = jDateTime::date("Y/m/d H:i:s", strtotime("+1 minutes"));

                    $sql = sprintf($sql, $codeverify, $datetime, $vfc["data"][0]["uvid"]);
                    $conn->query($sql);
                    SMSCLASS::SendSMSForVerifyUser(
                        $usExist["userdetail"][0]["umobile"],
                        '24cx5b0wio',
                        $codeverify
                    );
                    VARS_ADMIN::ReturnHeaders(200);
                    return ["status" => "success", "message" => "پیامک به شماره ثبت شده در پنل کاربری ارسال شد"];
                }
            } else {
                VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "کاربر مورد نظر قبلا تایید شده است"];
            }
        }
    }
    public static function ResendEmail($token)
    {
        $usExist = USERS_ADMIN::GetOneByToken($token);
        $now = jDateTime::date("Y-m-d H:i:s");

        if ($usExist["userdetail"][0]["ustatus"] == "error") {
            VARS_ADMIN::ReturnHeaders(401);
            return ["status" => "error", "message" => "توکن ارسالی اشتباه است لطفا مجدد وارد شوید"];
        } else {
            if ($usExist["userdetail"][0]["ustatus"] == 0) {

                $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);

                if ($vfc["status"] == "error") {
                    $s = self::AddRecord($usExist["userdetail"][0]["uid"]);
                    $vfc = USERSVERIFICATION_ADMIN::GetOneByID($usExist["userdetail"][0]["uid"]);

                    $codehash = $vfc["data"][0]["uvemail_code"];
                    $codeverify = TOOLS_ADMIN::decrypt($vfc["data"][0]["uvemail_code"]);

                    $emailTemp = "لطفا جهت فعالسازی حساب کاربری خود از کد زیر استفاده نمایید <br /><br />";
                    $emailTemp .= $codeverify . "<br /><br />یا
                                    <a href='" . $GLOBALS["webdomain"] . "/verification/confirmed?code=" .
                        $codehash . "' target='_blank'>اینجا کلیک نمایید</a>";
                    EMAILCLASS::SendEmail($usExist["userdetail"][0]["umail"], $emailTemp);
                    return [
                        "status" => "success",
                        "message" => "ایمیل به ارسال شد"
                    ];
                }

                // if ($vfc["data"][0]["uv_expire_date_verify"] > $now) {
                //     VARS_ADMIN::ReturnHeaders(400);
                //     return ["status" => "error",
                //      "message" => "حداقل فاصله زمانی دو ارسال ایمیل 2دقیقه است"];
                // } else {
                $conn = GetConnection();
                $sql = "UPDATE " . $GLOBALS['userverification_tablename']
                    . " SET " . $GLOBALS['uvemail_code'] . "='%s'," .
                    $GLOBALS['uv_expire_date_verify'] . "='%s'     WHERE  " .
                    $GLOBALS['uvid'] . "=%s";

                $codeverify = rand(1000, 9999);

                $datetime = jDateTime::date("Y/m/d H:i:s", strtotime("+1 minutes"));
                // $hashCode=TOOLS_ADMIN::encrypt($codeverify);

                $sql = sprintf(
                    $sql,
                    $codeverify,
                    $datetime,
                    $vfc["data"][0]["uvid"]
                );
                $conn->query($sql);

                $emailTemp = "لطفا جهت فعالسازی حساب کاربری خود از کد زیر استفاده نمایید <br /><br />";
                $emailTemp .= $codeverify . "<br /><br />یا
                                       <a href='" . $GLOBALS["webdomain"] . "/verification/confirmed?code=" .
                    $codeverify . "' target='_blank'>اینجا کلیک نمایید</a>";
                EMAILCLASS::SendEmail($usExist["userdetail"][0]["umail"], $emailTemp);
                VARS_ADMIN::ReturnHeaders(200);
                return [
                    "status" => "success", "message" => "ایمیل ارسال شد",
                ];
                // }
            } else {
                VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "کاربر مورد نظر قبلا تایید شده است"];
            }
        }
    }
}
