<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/iframesubfolder/admin/iframesubfolder_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/hotlinkprotectionsubfolder/admin/hotlinkprotectionsubfolder_admin_class.php';

class SUBFOLDERRULES_ADMIN
{
    public static function CheckConnectionTimeOurForDownGrade($domainID, $currentPlan, $newPlan)
    {

        if (isset(ReturnPlans()[$currentPlan]["connectionTimeout"])) {
            if (!isset(ReturnPlans()[$newPlan]["connectionTimeout"])) {
                $sql = "SELECT * FROM `tbl_subdfolder_connection_timeout`,tbl_subfolder,tbl_websites,tbl_domains
                                WHERE
                                `sfmcto_sfid_fk` = subfolder_id AND
                                sf_ws_id_fk=wsid AND
                                ws_domainid_fk=domain_id
                                and domain_id=" . $domainID;
                $conn = GetConnection();

                $result = $conn->query($sql);
                if (!$result || mysqli_num_rows($result) == 0) {
                    $listOfRecordType = ["status" => "success"];
                    $conn->close();
                } else {
                    $r = mysqli_fetch_all($result, MYSQLI_ASSOC);

                    foreach ($r as $f) {
                        $websitename = $f["d_name"];
                        if ($f["d_name"] != $f["ws_recordname"]) {
                            $websitename = $f["ws_recordname"] . "." . $f["d_name"];
                        }
                        return ["status" => "error", "message" => "شما در سایت  " . $websitename .
                            "در آدرس فرعی " . $f["sf_name"] . " قانون Connection timeout ایجاد کرده اید"];
                    }
                    $conn->close();
                }
            }
        }
        return ["status" => "success"];
    }
    public static function CheckPageRuleForDownGrade($domainID, $currentPlan, $newPlan)
    {

        if (isset(ReturnPlans()[$currentPlan]["pagerule"])) {
            if (isset(ReturnPlans()[$newPlan]["pagerule"])) {
                $sql = "SELECT * FROM `tbl_subfolder`,tbl_websites,tbl_domains WHERE
                                domain_id=ws_domainid_fk and wsid=tbl_subfolder.sf_ws_id_fk
                                and domain_id=" . $domainID;
                $conn = GetConnection();

                $result = $conn->query($sql);
                if (!$result || mysqli_num_rows($result) == 0) {
                    $listOfRecordType = ["status" => "success"];
                    $conn->close();
                } else {
                    $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
                    if (count($r) > ReturnPlans()[$newPlan]["pagerule"]) {
                        return ["status" => "error", "message" => "تعداد قوانین صفحات درج شده برای این دامنه بیش تر از حد مجاز است"];
                    }
                    $conn->close();
                }
            }
        }
        return ["status" => "success"];
    }
    public static function GetOneSubFolder($websiteid, $token, $sfname)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }

        if (!preg_match('/^[a-z0-9\s][\w\-\._?=\-&\/]+$/i', $sfname)) {
            return [
                "status" => "error", "message" => "آدرس ارسالی شما نامعتبر است ",
            ];
        }
        $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . " WHERE " .
            $GLOBALS['sf_name'] . "='" . $sfname . "' AND "
            . $GLOBALS['sf_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "error", "message" => "آدرس درخواستی شما تکراری است"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetSubFolderRulesByDetails($token, $subfolderid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sbdet = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
        if ($sbdet["status"] == "error") {
            return [
                "status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"
            ];
        }
        $rules = explode(",", $sbdet["data"][0]["sf_rules"]);
        $RulesName = [
            "browser_cache_ttl" => "subfolderrules_browsercachettl_tablename",
            "Edge_cache_ttl" => "subfolderrules_servercachettl_tablename",
            "cache_level" => "subfolderrules_cachelevel_tablename",
            "waf" => "subfolderrules_waf_tablename",
            "add_header_to_client" => "subfolderrules_addheadertoclient_tablename",
            "add_header_to_server" => "subfolderrules_addheadertoserver_tablename",
            "remove_header" => "subfolderrules_removeheader_tablename",
            "redirect_url" => "subfolderrules_redirecturl_tablename",
            "autominify" => "subfolderrules_autominify_tablename",
            "forcehttps" => "subfolderrules_forcehttps_tablename",
            "securitylevel" => "subfolderrules_securitylevel_tablename",
            "ipmanagement" => "subfolderrules_ipmanagement_tablename",
            "countrymanagement" => "subfolderrules_countrymanagement_tablename",
            "iframe" => "iframetable",
            "ratelimit" => "ratelimit",
            "hotlink" => "hotlink",
            "connection_timeout" => "connection_timeout",
            "hostheader" => "hostheader",
            "ratelimit" => "ratelimit",
            "cachecontrol" => "cachecontrol",
        ];
        $rulesArray = [];
        foreach ($rules as $r) {
            if ($r == "browser_cache_ttl") {

                $rulesArray["browser_cache_ttl"] = SUBFOLDERRULES_ADMIN::GetlistOfBrowsercacheTTL($subfolderid);
            } else if ($r == "Edge_cache_ttl") {

                $rulesArray["Edge_cache_ttl"] = SUBFOLDERRULES_ADMIN::GetlistOfServercachettl($subfolderid);
            } else if ($r == "cache_level") {

                $rulesArray["cache_level"] = SUBFOLDERRULES_ADMIN::GetlistOfCacheLevel($subfolderid);
            } else if ($r == "waf") {

                $rulesArray["waf"] = SUBFOLDERRULES_ADMIN::GetlistOfWaf($subfolderid);
            } else if ($r == "add_header_to_client") {

                $rulesArray["add_header_to_client"] = SUBFOLDERRULES_ADMIN::GetlistOfHeaderToClient($subfolderid);
            } else if ($r == "add_header_to_server") {

                $rulesArray["add_header_to_server"] = SUBFOLDERRULES_ADMIN::GetlistOfHeaderToBackend($subfolderid);
            } else if ($r == "remove_header") {

                $rulesArray["remove_header"] = SUBFOLDERRULES_ADMIN::GetlistOfRemoveHeader($subfolderid);
            } else if ($r == "redirect_url") {

                $rulesArray["redirect_url"] = SUBFOLDERRULES_ADMIN::GetlistOfRedirectUrl($subfolderid);
            } else if ($r == "autominify") {

                $rulesArray["autominify"] = SUBFOLDERRULES_ADMIN::GetlistOfAutoMinify($subfolderid);
            } else if ($r == "forcehttps") {

                $rulesArray["forcehttps"] = SUBFOLDERRULES_ADMIN::GetlistOfForceHttps($subfolderid);
            } else if ($r == "securitylevel") {

                $rulesArray["securitylevel"] = SUBFOLDERRULES_ADMIN::GetlistOfSecurityLevel($subfolderid);
            } else if ($r == "ipmanagement") {

                $rulesArray["ipmanagement"] = SUBFOLDERRULES_ADMIN::GetlistOfIPManagement($subfolderid);
            } else if ($r == "countrymanagement") {

                $rulesArray["countrymanagement"] = SUBFOLDERRULES_ADMIN::GetlistOfCountryManagement($subfolderid);
            } else if ($r == "iframe") {
                $rulesArray["iframe"] = IFRAMESUBFOLDER_ADMIN::GetWebsiteIFRAME($token, $subfolderid);
            } else if ($r == "ratelimit") {
                $rulesArray["ratelimit"] = RATELIMITSUBFOLDER_NEW_ADMIN::GetWebsiteRateLimit($token, $subfolderid);
            } else if ($r == "hotlink") {
                $rulesArray["hotlink"] = HOTLINKPROTECTIONSUBFOLDER_ADMIN::GetWebsiteHotLinkProtection($token, $subfolderid);
            } else if ($r == "connection_timeout") {
                $rulesArray["connection_timeout"] = SUBFOLDERRULES_ADMIN::GetlistOfConnectionTimeOut($subfolderid);
            } else if ($r == "hostheader") {
                $rulesArray["hostheader"] = SUBFOLDERRULES_ADMIN::GetListOfHostHeader($subfolderid);
            } else if ($r == "ratelimit") {
                $rulesArray["ratelimit"] = RATELIMITSUBFOLDER_NEW_ADMIN::GetWebsiteRateLimit($token, $subfolderid);
            } else if ($r == "cachecontrol") {
                $rulesArray["cachecontrol"] = self::GetListOfCacheControl($subfolderid);
            }
        }
        $res = [
            "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
            "data" => $rulesArray
        ];
        return $res;
    }
    public static function GetlistOfConnectionTimeOut($subfolderid)
    {
        $sql = "SELECT sfmcto_connect as connectTime,sfmcto_send as sendTime,sfmcto_read as readTime from " . $GLOBALS['subfolderrules_connection_timeout_tablename'] . " WHERE "
            . $GLOBALS['sfmcto_sfid_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfBrowsercacheTTL($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfbct_value'] . " as value from " . $GLOBALS['subfolderrules_browsercachettl_tablename'] . " WHERE "
            . $GLOBALS['sfbct_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        // $browser_cache_ttl_array = [
        //         "10s" => "10s","-1" => "-1","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
        //         "30m" => "30", "1h" => "60",
        //         "2h" => "120", "3h" => "180", "6h" => "360",
        //         "12h" => "720",
        //         "1d" => "1440", "3d" => "4320", "7d" => "10800",
        //         "10d" => "14400", "15d" => "21600", "30d" => "43200",
        //         "180d" => "259200", "365" => "525600"
        //     ];
        $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
        $value = array_search($res[0]["value"], $browser_cache_ttl_array);
        return $res[0]["value"]; //$value;
    }
    public static function GetlistOfServercachettl($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfsct_value'] . " as value from " . $GLOBALS['subfolderrules_servercachettl_tablename'] . " WHERE "
            . $GLOBALS['sfsct_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        // $browser_cache_ttl_array =  [
        //         "10s" => "10s","-1" => "-1","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
        //         "30m" => "30", "1h" => "60",
        //         "2h" => "120", "3h" => "180", "6h" => "360",
        //         "12h" => "720",
        //         "1d" => "1440", "3d" => "4320", "7d" => "10800",
        //         "10d" => "14400", "15d" => "21600", "30d" => "43200",
        //         "180d" => "259200", "365" => "525600"
        //     ];
        $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
        // $value = array_search($res[0]["value"], $browser_cache_ttl_array);
        return $res[0]["value"]; //$value;
    }
    public static function GetlistOfCacheLevel($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfcl_level'] . " as value from " . $GLOBALS['subfolderrules_cachelevel_tablename'] . " WHERE "
            . $GLOBALS['sfcl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        $value = $res[0]["value"];
        return $value;
    }
    public static function GetlistOfWaf($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfwl_level'] . " as value from " . $GLOBALS['subfolderrules_waflevel_tablename'] . " WHERE "
            . $GLOBALS['sfwl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        $value = $res[0]["value"];
        return $value;
    }
    public static function GetListOfCacheControl($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfcc_sfid_fk'] . " as value from " . $GLOBALS['subfolderrules_cachecontrol_tablename'] . " WHERE "
            . $GLOBALS['sfcc_sfid_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        $value = 1;
        return $value;
    }

    public static function GetlistOfHeaderToClient($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfhtc_value'] . " as value,"
            . $GLOBALS['sfhtc_name'] . " as name from " .
            $GLOBALS['subfolderrules_headertoclient_tablename'] . " WHERE "
            . $GLOBALS['sfhtc_sfcl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfHeaderToBackend($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfhtb_value'] . " as value,"
            . $GLOBALS['sfhtb_name'] . " as name from " .
            $GLOBALS['subfolderrules_headertobackend_tablename'] . " WHERE "
            . $GLOBALS['sfhtb_sfcl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfRemoveHeader($subfolderid)
    {
        $sql = "SELECT "
            . $GLOBALS['sfrh_name'] . " as name from " .
            $GLOBALS['subfolderrules_removeheader_tablename'] . " WHERE "
            . $GLOBALS['sfrh_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfRedirectUrl($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfru_status'] . " as status,"
            . $GLOBALS['sfru_newurl'] . " as newurl from " .
            $GLOBALS['subfolderrules_redirecturl_tablename'] . " WHERE "
            . $GLOBALS['sfru_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfAutoMinify($subfolderid)
    {
        $sql = "SELECT "
            . $GLOBALS['sfam_value'] . " as value from " .
            $GLOBALS['subfolderrules_autominify_tablename'] . " WHERE "
            . $GLOBALS['sfam_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        if (count($res) > 0) {
            $val = explode(",", $res[0]["value"]);
            $output = [];
            foreach ($val as $l) {
                array_push($output, $l);
            }
            return $output;
        }
        return $res;
    }
    public static function GetlistOfForceHttps($subfolderid)
    {
        $sql = "SELECT "
            . $GLOBALS['sffh_value'] . " as value from " .
            $GLOBALS['subfolderrules_forcehttps_tablename'] . " WHERE "
            . $GLOBALS['sffh_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfSecurityLevel($subfolderid)
    {
        $sql = "SELECT "
            . $GLOBALS['sfsl_value'] . " as value from " .
            $GLOBALS['subfolderrules_securitylevel_tablename'] . " WHERE "
            . $GLOBALS['sfsl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetListOfHostHeader($subfolderid)
    {
        $sql = "SELECT "
            . $GLOBALS['sfh_host'] . " as value from " .
            $GLOBALS['subfolderrules_hostheader_tablename'] . " WHERE "
            . $GLOBALS['sfh_sfd_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        return $res;
    }
    public static function GetlistOfCountryManagement($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfcm_default'] . " as DefaultAction,"
            . $GLOBALS['sfcm_country'] . " as ListOfCountries from " .
            $GLOBALS['subfolderrules_countrymanagement_tablename'] . " WHERE "
            . $GLOBALS['sfcm_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $out["DefaultAction"] = $res[0]["DefaultAction"];
        $ips = explode(",", $res[0]["ListOfCountries"]);
        $listip = [];
        $i = 0;
        foreach ($ips as $j) {
            array_push($listip, $j);
            $i++;
        }
        $out["listofCountriess"] = $listip;
        return $out;
        return $res;
    }
    public static function GetlistOfIPManagement($subfolderid)
    {
        $sql = "SELECT " . $GLOBALS['sfim_default'] . " as DefaultAction,"
            . $GLOBALS['sfim_ip'] . " as ListOfIPs from " .
            $GLOBALS['subfolderrules_ipmanagement_tablename'] . " WHERE "
            . $GLOBALS['sfim_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $out["DefaultAction"] = $res[0]["DefaultAction"];
        $ips = explode(",", $res[0]["ListOfIPs"]);
        $i = 0;
        foreach ($ips as $j) {
            $out["listofIPS"][$i] = ["ip" => $j];
            $i++;
        }
        $out["listofIPS"] = $res[0]["ListOfIPs"];
        return $out;
    }

    public static function AddSubFolderRules($subfolderid, $token, $rules, $value)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                $usersDetails,
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        } else {
            $balance = $usersDetails["credit"];
            if ($balance < 0) {
                return [
                    "status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"
                ];
            }
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websiteaccess = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"
            ];
        }
        $pr = $websiteaccess["data"][0]["sf_priority"];
        $reservedHeader_array = [
            "mc-request-country", "mc-real-ip", "mc-css", "mc-js", "mc-request-country", "mc-edge",
            "server", "mc-cache", "mc-cache-status", "country", "request-Country",
            "request-IP", "mc-id", "mc-sid",  "Cache-Control", "x-real-ip", "x-forwarded-for", "host"
        ];
        $RulesName = [
            "browser_cache_ttl" => "subfolderrules_browsercachettl_tablename",
            "Edge_cache_ttl" => "subfolderrules_servercachettl_tablename",
            "cache_level" => "subfolderrules_cachelevel_tablename",
            "waf" => "subfolderrules_waf_tablename",
            "add_header_to_client" => "subfolderrules_addheadertoclient_tablename",
            "add_header_to_server" => "subfolderrules_addheadertoserver_tablename",
            "remove_header" => "subfolderrules_removeheader_tablename",
            "redirect_url" => "subfolderrules_redirecturl_tablename",
            "autominify" => "subfolderrules_autominify_tablename",
            "forcehttps" => "subfolderrules_forcehttps_tablename",
            "securitylevel" => "subfolderrules_securitylevel_tablename",
            "ipmanagement" => "subfolderrules_ipmanagement_tablename",
            "countrymanagement" => "subfolderrules_countrymanagement_tablename",
            "connection_timeout" => "subfolderrules_connection_timeout_tablename",
            "hostheader" => "subfolderrules_hostheader_tablename",
            "ratelimit" => "subfolderrules_ratelimit_tablename",
            "cachecontrol" => "subfolderrules_cachecontrol_tablename",
        ];
        $browsercachettl = TOOLS_ADMIN::ReturnCacheStaus();
        if (array_key_exists($rules, $RulesName)) {

            $out = [];
            if ($rules == "browser_cache_ttl") {
                if (array_key_exists("ttl", $value)) {
                    $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
                    //         [
                    //     "10s" => "10s","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
                    //     "30m" => "30", "1h" => "60",
                    //     "2h" => "120", "3h" => "180", "6h" => "360",
                    //     "12h" => "720",
                    //     "1d" => "1440", "3d" => "4320", "7d" => "10800",
                    //     "10d" => "14400", "15d" => "21600", "30d" => "43200",
                    //     "180d" => "259200", "1y" => "525600","-1" => "-1"
                    // ];

                    if (isset($browser_cache_ttl_array[$value["ttl"]])) {
                        // $planwebsite = $websiteaccess["data"][0]["d_plan"];
                        // $plans = ReturnPlans();
                        // if (isset($plans[$planwebsite])) {
                        //     if (isset($plans[$planwebsite]["mincache"])) {

                        //         if ($browsercachettl != "-1") {
                        //             if ($browser_cache_ttl_array[$value["ttl"]] < $browser_cache_ttl_array[$plans[$planwebsite]["mincache"]]) {
                        //                 return [
                        //                     "status" => "error", $browser_cache_ttl_array[$value["ttl"]],
                        //                     "type" => "browsercache",
                        //                     "message" => "شما امکان انتخاب این بازه زمانی را ندارید و باید پلان سایت خود را ارتقا دهید"
                        //                 ];
                        //             }
                        //         }
                        //     } else {
                        //         return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                        //     }
                        // } else {
                        //     return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                        // }

                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];

                        SUBFOLDERRULES_ADMIN::UpdateBrowserCacheTTLSubFolder(
                            $subfolderid,
                            $browser_cache_ttl_array[$value["ttl"]],
                            $pr,
                            $value["ttl"]
                        );
                        $values = $browser_cache_ttl_array[$value["ttl"]];
                    } else {
                        $out = ["status" => "error", "value" => $value, "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "Edge_cache_ttl") {
                //iNTERVALS: 30m/1h/2h/3h/4h/5h/8h/12h/16h/20h/
                //INTERVALS: 1d/2d/3d/4d/5d/8d/16d/24d/1m/2m/6m/1y
                if (array_key_exists("ttl", $value)) {
                    $Edge_cache_ttl_array =  TOOLS_ADMIN::ReturnCacheStaus();
                    //       [
                    //     "10s" => "10s","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
                    //     "30m" => "30", "1h" => "60",
                    //     "2h" => "120", "3h" => "180", "6h" => "360",
                    //     "12h" => "720",
                    //     "1d" => "1440", "3d" => "4320", "7d" => "10800",
                    //     "10d" => "14400", "15d" => "21600", "30d" => "43200",
                    //     "180d" => "259200", "1y" => "525600","-1" => "-1"
                    // ];

                    if (isset($Edge_cache_ttl_array[$value["ttl"]])) {
                        if ($value["ttl"] != "-1") {
                            $planwebsite = $websiteaccess["data"][0]["d_plan"];
                            $plans = ReturnPlans();
                            if (isset($plans[$planwebsite])) {
                                if (isset($plans[$planwebsite]["mincache"])) {
                                    if ($browsercachettl != "-1") {
                                        if ($Edge_cache_ttl_array[$value["ttl"]] < $Edge_cache_ttl_array[$plans[$planwebsite]["mincache"]]) {
                                            return [
                                                "status" => "error",
                                                "type" => "browsercache",
                                                "message" => "شما امکان انتخاب این بازه زمانی را ندارید و باید پلان سایت خود را ارتقا دهید"
                                            ];
                                        }
                                    }
                                } else {
                                    return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                                }
                            } else {
                                return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                            }
                        }

                        $out = ["status" => "success", $Edge_cache_ttl_array[$value["ttl"]], "message" => "درخواست شما با موفقیت انجام شد"];
                        $aa = SUBFOLDERRULES_ADMIN::UpdateServerCacheTTLSubFolder(
                            $subfolderid,
                            $Edge_cache_ttl_array[$value["ttl"]],
                            $pr,
                            $value["ttl"]
                        );
                        $values = $Edge_cache_ttl_array[$value["ttl"]];
                    } else {
                        $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "cache_level") {
                if (array_key_exists("level", $value)) {
                    $cachelevel_array = ["0", "1", "2", "3"];
                    if (in_array($value["level"], $cachelevel_array)) {
                        SUBFOLDERRULES_ADMIN::UpdateCacheLevelSubFolder(
                            $subfolderid,
                            $value["level"],
                            $pr
                        );
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                        $values = $value["level"];
                    } else {
                        $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "waf") {
                if (array_key_exists("level", $value)) {
                    $waf_array = ["1", "2", "3"];
                    if (in_array($value["level"], $waf_array)) {
                        if ($value["ttl"] != "-1") {
                            $planwebsite = $websiteaccess["data"][0]["d_plan"];
                            $plans = ReturnPlans();
                            if (isset($plans[$planwebsite])) {
                                if (isset($plans[$planwebsite]["waf"])) {
                                    if (intVal($plans[$planwebsite]["waf"]) < intVal($value["level"])) {
                                        return [
                                            "status" => "error",
                                            "type" => "browsercache",
                                            "message" => "شما امکان انتخاب این سرویس  را ندارید و باید پلان سایت خود را ارتقا دهید"
                                        ];
                                    }
                                } else {
                                    return ["status" => "error",  "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                                }
                            } else {
                                return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                            }
                        }
                        SUBFOLDERRULES_ADMIN::UpdateWafLevelSubFolder(
                            $subfolderid,
                            $value["level"],
                            $pr
                        );
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                        $values = $value["level"];
                    } else {
                        $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "add_header_to_client") {
                if (array_key_exists("name", $value) && array_key_exists("value", $value)) {
                    $name = strtolower($value["name"]);
                    $name = TOOLS_ADMIN::seo_friendly_url($name);


                    if (in_array($value["name"], $reservedHeader_array)) {
                        $out = ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
                    } else {
                        if (isset($value["name"]) && isset($value["value"])) {
                            SUBFOLDERRULES_ADMIN::UpdateHeaderToClientSubFolder(
                                $subfolderid,
                                $value["name"],
                                $value["value"],
                                $pr
                            );
                            $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                            $values = $value["value"];
                        } else {
                            $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                        }
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "add_header_to_server") {
                if (array_key_exists("name", $value) && array_key_exists("value", $value)) {
                    $name = strtolower($value["name"]);
                    $name = TOOLS_ADMIN::seo_friendly_url($name);




                    if (in_array($name, $reservedHeader_array)) {
                        $out = ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
                    } else {
                        if (isset($value["name"]) && isset($value["value"])) {
                            $headervalue = TOOLS_ADMIN::seo_friendly_url($value["value"]);
                            SUBFOLDERRULES_ADMIN::UpdateHeaderToBackendSubFolder(
                                $subfolderid,
                                $name,
                                $headervalue,
                                $pr
                            );
                            $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                            $values = $value["value"];
                        } else {
                            $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                        }
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "remove_header") {

                if (array_key_exists("name", $value)) {
                    if (isset($value["name"])) {
                        $name = strtolower($value["name"]);
                        $arr  = explode(",", $name);
                        $output = [];
                        foreach ($arr as $l) {
                            $m = TOOLS_ADMIN::seo_friendly_url($l);

                            if (in_array($m, $reservedHeader_array)) {
                                return ["status" => "error", "header" => $m, "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
                            } else {
                                array_push($output, $m);
                            }
                        }
                        $n = implode(",", $output);
                        SUBFOLDERRULES_ADMIN::UpdateRemoveHeaderSubFolder($subfolderid, $n, $pr);
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "redirect_url") {
                if (array_key_exists("status", $value) && array_key_exists("newurl", $value)) {
                    if (strlen($value["newurl"]) < 7) {
                        return ["status" => "error", "message" => "آدرس ارسالی اشتباه است"];
                    } else {
                        $nv = explode(".", $value["newurl"]);
                        if (substr($value["newurl"], 0, 7) != "http://") {
                            if (substr($value["newurl"], 0, 8) != "https://") {
                                return ["status" => "error", "message" => " آدرس ارسالی اشتباه است مثال : https://" . $value["newurl"]];
                            }
                            if (!CheckValidTLD($nv[count($nv) - 1]))
                                return ["status" => "error", $nv[count($nv) - 1], "message" => "آدرس ارسالی اشتباه است"];
                        } else {
                            if (!CheckValidTLD($nv[count($nv) - 1]))
                                return ["status" => "error", "message" => "آدرس ارسالی اشتباه است"];
                        }
                    }
                    $status_array = ["301", "302", "307"];
                    if (in_array($value["status"], $status_array)) {
                        SUBFOLDERRULES_ADMIN::UpdateRedirectUrlSubFolder(
                            $subfolderid,
                            $value["newurl"],
                            $value["status"],
                            $pr
                        );
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                        $values = $value["value"];
                    } else {
                        $out = ["status" => "error", "message" => "مقادیر ارسالی نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "autominify") {
                if (array_key_exists("value", $value)) {
                    $autominify_array = ["css", "js", "html"];
                    $s = 1;
                    $sendeddata = explode(",", $value["value"]);
                    foreach ($sendeddata as $l) {
                        if (in_array($l, $autominify_array)) {
                            $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                            $values = $value["value"];
                        } else {
                            $s = 0;
                            $out = ["status" => "error", "message" => "مقادیر ارسالی نامعتبر است"];
                        }
                    }
                    if ($s == 1) {
                        SUBFOLDERRULES_ADMIN::UpdateAutoMinifySubFolder($subfolderid,  $values);
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "hostheader") {


                $planwebsite = $websiteaccess["data"][0]["d_plan"];
                $plans = ReturnPlans();
                if (!isset($plans[$planwebsite]["hostheader"]))
                    return ["status" => "error", $plans[$planwebsite], "message" => "شما در این پلان امکان استفاده از این بخش را ندارید و باید پلان دامنه خود را ارتقا دهید "];
                if (isset($plans[$planwebsite])) {
                    if (!isset($plans[$planwebsite]["hostheader"])) {
                        return [
                            "status" => "error",
                            "type" => "browsercache",
                            "message" => "شما امکان انتخاب این سرویس  را ندارید و باید پلان سایت خود را ارتقا دهید"
                        ];
                    }
                }




                if (array_key_exists("value", $value)) {
                    $nv = explode(".", $value["value"]);
                    if (!CheckValidTLD($nv[count($nv) - 1]))
                        return ["status" => "error", "message" => "آدرس ارسالی اشتباه است"];
                    SUBFOLDERRULES_ADMIN::UpdateHostHeaderSubFolder(
                        $subfolderid,
                        $value["value"],
                        $pr
                    );
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "forcehttps") {
                if (array_key_exists("value", $value)) {
                    //0 - disable
                    //1 - force https
                    //2 - force http

                    $r = SSLWEBSITES_ADMIN::GetSSLWebsiteByWebsiteID($token, $websiteaccess["data"][0]["wsid"]);
                    if ($r["state"] == "300") {
                        return ["status" => "error", "message" => "شما SSL فعال برای این سایت ندارید"];
                    }
                    $forcehttps_array = ["0", "1", "2"];
                    if (in_array($value["value"], $forcehttps_array)) {
                        SUBFOLDERRULES_ADMIN::UpdateRedirectHttpsSubFolder($subfolderid, $value["value"], $pr);
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                        $values = $value["value"];
                    } else {
                        $out = ["status" => "error", "message" => "مقادیر ارسالی نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "cachecontrol") {
                if (array_key_exists("value", $value)) {
                    $forcehttps_array = ["0", "1"];

                    $planwebsite = $websiteaccess["data"][0]["d_plan"];
                    $plans = ReturnPlans();
                    if (!isset($plans[$planwebsite]["cachecontrol"]))
                        return ["status" => "error", "message" => "شما در این پلان امکان استفاده از این بخش را ندارید و باید پلان دامنه خود را ارتقا دهید "];
                    if (isset($plans[$planwebsite])) {
                        if (!isset($plans[$planwebsite]["cachecontrol"])) {
                            return [
                                "status" => "error",
                                "type" => "browsercache",
                                "message" => "شما امکان انتخاب این سرویس  را ندارید و باید پلان سایت خود را ارتقا دهید"
                            ];
                        }
                    }
                    if (in_array($value["value"], $forcehttps_array)) {
                        SUBFOLDERRULES_ADMIN::UpdateCacheControlSubFolder($subfolderid, $value["value"], $pr);
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                        $values = $value["value"];
                    } else {
                        $out = ["status" => "error", $value["value"], "message" => "مقادیر ارسالی نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "ratelimit") {
                if (array_key_exists("value", $value)) {
                    $out = RATELIMITSUBFOLDER_NEW_ADMIN::UpdateWebsiteRateLimit(
                        $token,
                        $subfolderid,
						$value["requestcount"],
						$value["timerate"],
						$value["timeformat"],
						$value["blockedbytimerange"],
						$value["ips"],
						$value["blockedbytimeformat"],
						$value["description"],
                        $pr
                    );
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "securitylevel") {
                if (array_key_exists("value", $value)) {
                    //0 - disable
                    //1 - JS
                    //2 - Cookie
                    //3 - Capthca

                    $securitylevel_array = ["0", "1", "2", "3"];
                    if (in_array($value["value"], $securitylevel_array)) {

                        $planwebsite = $websiteaccess["data"][0]["d_plan"];
                        $plans = ReturnPlans();
                        if (!isset($plans[$planwebsite]["ddospagerule"]))
                            return ["status" => "error", "message" => "شما در این پلان امکان استفاده از این بخش را ندارید و باید پلان دامنه خود را ارتقا دهید "];
                        if (isset($plans[$planwebsite])) {
                            if (isset($plans[$planwebsite]["ddos"])) {
                                if (intVal($plans[$planwebsite]["ddos"]) < intVal($value["value"])) {
                                    return [
                                        "status" => "error",
                                        "type" => "browsercache",
                                        "message" => "شما امکان انتخاب این سرویس  را ندارید و باید پلان سایت خود را ارتقا دهید"
                                    ];
                                }
                            } else {
                                return ["status" => "error",  "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                            }
                        } else {
                            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                        }

                        $ot = SUBFOLDERRULES_ADMIN::UpdateSecurityLevelSubFolder($subfolderid, $value["value"], $websiteaccess, $pr);
                        $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                        $values = $value["value"];
                    } else {
                        $out = ["status" => "error", "message" => "مقادیر ارسالی نامعتبر است"];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "ipmanagement") {
                if (array_key_exists("default", $value)) {
                    $out["status"] = "success";
                    $arraydefault_array = ["allow", "deny"];
                    if ($value["ip"] == "") {
                        return ["status" => "error", "message" => "مقدار IP خالی میباشد"];
                    }
                    if (in_array($value["default"], $arraydefault_array)) {
                        if (!array_key_exists("ip", $value)) {
                            return [
                                "status" => "error", "message" => "مقادیر ارسالی نامعتبر است",
                            ];
                        }
                        $ips = explode(",", $value["ip"]);
                        $res = [];
                        $stat = 1;
                        $success_array = [];
                        foreach ($ips as $ip) {
                            if (strpos($ip, '/')) {
                                $nip = explode("/", $ip);
                                if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                                    $stat = 0;
                                    $out["status"] = "error";
                                    array_push(
                                        $res,
                                        ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                                    );
                                } else {
                                    array_push($success_array, ["ip" => $ip]);

                                    array_push($res, [
                                        "status" => "success", "ip" => $ip,
                                        "message" => "درخواست شما با موفقیت انجام شد"
                                    ]);
                                }
                            } else {
                                if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                                    $stat = 0;
                                    $out["status"] = "error";
                                    array_push(
                                        $res,
                                        ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                                    );
                                } else {

                                    array_push($success_array, ["ip" => $ip]);
                                    $out["message"] = "درخواست شما با موفقیت انجام شد";
                                    array_push($res, [
                                        "status" => "success", "ip" => $ip,
                                        "message" => "درخواست شما با موفقیت انجام شد"
                                    ]);
                                }
                            }
                        }
                        if ($stat == 1) {
                            $value["ip"] = str_replace(",", "-", $value["ip"]);

                            $ipscount = count(explode("-", $value["ip"]));
                            $planwebsite = $websiteaccess["data"][0]["d_plan"];
                            $plans = ReturnPlans();
                            if (isset($plans[$planwebsite])) {
                                if (isset($plans[$planwebsite]["maxipinfirewall"])) {
                                    if (intVal($plans[$planwebsite]["maxipinfirewall"]) < intVal($ipscount)) {
                                        return [
                                            "status" => "error",
                                            "type" => "maxipinfirewall",
                                            "message" => "حداکثر تعداد IP فایل انسداد در پلان فعلی شما : " . $plans[$planwebsite]["maxipinfirewall"] . " است  و باید پلان سایت خود را ارتقا دهید IP"
                                        ];
                                    }
                                } else {
                                    return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                                }
                            } else {
                                return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                            }

                            SUBFOLDERRULES_ADMIN::UpdateIpManagementSubFolder(
                                $subfolderid,
                                $value["ip"],
                                $value["default"],
                                $pr
                            );
                        }

                        $out["data"] = $value["ip"];
                    } else {
                        $out = [
                            "status" => "error", "message" => "مقادیر ارسالی نامعتبر است",
                        ];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "countrymanagement") {

                $country_array = [
                    "AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
                    "BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
                    "CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
                    "EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
                    "GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
                    "KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
                    "MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
                    "NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
                    "BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
                    "SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
                    "TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
                ];
                if (array_key_exists("default", $value)) {
                    $out["status"] = "error";
                    $arraydefault_array = ["allow", "deny"];
                    if (!array_key_exists("country", $value)) {
                        return [
                            "status" => "error", "message" => "مقادیر ارسالی نامعتبر است",
                        ];
                    }
                    if (in_array($value["default"], $arraydefault_array)) {
                        $countries = explode(",", $value["country"]);
                        $res = [];
                        $stat = 1;
                        $success_array = [];
                        foreach ($countries as $country) {
                            if (!in_array(strtoupper($country), $country_array)) {
                                $stat = 0;
                                array_push(
                                    $res,
                                    [
                                        "status" => "error", "country" => $country,
                                        "message" => "کشور  نامعتبر است"
                                    ]
                                );
                            } else {
                                $out["status"] = "success";
                                array_push($success_array, ["country" => $country]);
                            }
                        }
                        if ($stat == 1) {

                            $ipscount = count(explode(",", $value["country"]));
                            $planwebsite = $websiteaccess["data"][0]["d_plan"];
                            $plans = ReturnPlans();
                            if (isset($plans[$planwebsite])) {
                                if (isset($plans[$planwebsite]["maxipinfirewall"])) {
                                    if (intVal($plans[$planwebsite]["maxipinfirewall"]) < intVal($ipscount)) {
                                        return [
                                            "status" => "error",
                                            "type" => "browsercache",
                                            "message" => "حداکثر تعداد کشور فایل انسداد در پلان فعلی شما :" . $plans[$planwebsite]["maxipinfirewall"] . " است  و باید پلان سایت خود را ارتقا دهید کشور"
                                        ];
                                    }
                                } else {
                                    return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                                }
                            } else {
                                return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                            }

                            SUBFOLDERRULES_ADMIN::UpdateCouontryManagementSubFolder(
                                $subfolderid,
                                $value["country"],
                                $value["default"],
                                $pr
                            );

                            $out =  [
                                "status" => "success",
                                "message" => "درخواست شما با موفقیت انجام شد",

                            ];
                        } else {
                            $out = [
                                "status" => "error",
                                "message" => "خطا در ارسال درخواست", "countries" => $res
                            ];
                        }
                    } else {
                        $out = [
                            "status" => "error", "message" => "مقادیر ارسالی نامعتبر است",
                        ];
                    }
                } else {
                    $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                }
            } else if ($rules == "connection_timeout") {

                if (array_key_exists("send", $value)) {
                    if (intVal($value["send"]) < 1 || intVal($value["send"]) > 500) {
                        return ["status" => "error", "message" => "زمان ارسالی باید حداقل 10 و حداکثر 500 ثانیه باشد"];
                    }
                } else {
                    return ["status" => "error", "message" => "ارسال تمامی مقادیر الزامی است"];
                }
                if (array_key_exists("connect", $value)) {

                    if (intVal($value["connect"]) < 1 || intVal($value["connect"]) > 500) {
                        return ["status" => "error", "message" => "زمان ارسالی باید حداقل 1 و حداکثر 500 ثانیه باشد"];
                    }
                } else {
                    return ["status" => "error", "message" => "ارسال تمامی مقادیر الزامی است"];
                }
                if (array_key_exists("read", $value)) {

                    if (intVal($value["read"]) < 1 || intVal($value["read"]) > 500) {
                        return ["status" => "error",  "message" => "زمان ارسالی باید حداقل 1 و حداکثر 500 ثانیه باشد"];
                    }
                } else {
                    return ["status" => "error", "message" => "ارسال تمامی مقادیر الزامی است"];
                }
                $planwebsite = $websiteaccess["data"][0]["d_plan"];
                $plans = ReturnPlans();
                if (isset($plans[$planwebsite])) {
                    if (isset($plans[$planwebsite]["connectionTimeout"])) {
                    } else {
                        return ["status" => "error", $planwebsite, "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                    }
                } else {
                    return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
                }
                SUBFOLDERRULES_ADMIN::UpdateConnectionTimeoutSubFolder(
                    $subfolderid,
                    intVal($value["connect"]),
                    intVal($value["send"]),
                    intVal($value["read"]),
                    $pr
                );

                $out =  [
                    "status" => "success",
                    "message" => "درخواست شما با موفقیت انجام شد",

                ];
            } else {
                return ["status" => "error", "message" => "قانون ارسالی شما نامعتبر است"];
            }
            if ($out["status"] == "success") {
                //return [$out, SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "add", $rules)];
                SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "add", $rules);
                return $out;
            }
            return $out;
        }
    }

    public static function GetOneByWebsiteID($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT cdnw_sslstatus as sslstatus,
                cdnw_server_cache_ttl as cache_server_ttl,
                cdnw_hotlink_protection as hotlink_protection,
                cdnw_developermode as developermode,
                cdnw_cache_ttl as browser_cache_ttl,
                cdnw_html_minify as html_minify,
                cdnw_js_minify as js_minify,
                cdnw_css_minify as css_minify,
                cdnw_always_online  as always_online,
                cdnw_cache_level as cache_level
                FROM " . $GLOBALS['domains_tablename'] . "," . $GLOBALS['websites_tablename'] . "
        ," . $GLOBALS['cdn_tablename'] . " WHERE
        " . $GLOBALS['ws_domainid_fk'] . "=" . $GLOBALS['domain_id'] . "  and " . $GLOBALS['cdnw_wid_fk'] . "=" . $GLOBALS['wsid'] . "
        and " . $GLOBALS['d_user_id_fk'] . "=" . $uid . " AND " . $GLOBALS['wsid'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این وبسایت را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $ttl_array =  [
                "10s" => "10s", "-1" => "-1", "30s" => "30s", "1m" => "1", "2m" => "2", "5m" => "5", "10m" => "10", "20m" => "20",
                "30m" => "30", "1h" => "60",
                "2h" => "120", "3h" => "180", "6h" => "360",
                "12h" => "720",
                "1d" => "1440", "3d" => "4320", "7d" => "10800",
                "10d" => "14400", "15d" => "21600", "30d" => "43200",
                "180d" => "259200", "365" => "525600"
            ];

            $browser_cache_ttl = array_search($list[0]["browser_cache_ttl"], $ttl_array);
            $cache_server_ttl = array_search($list[0]["cache_server_ttl"], $ttl_array);
            $list[0]["cache_server_ttl"] = $cache_server_ttl;

            $list[0]["browser_cache_ttl"] = $browser_cache_ttl;
            $listOfRecordType = ["status" => "success", "data" => $list[0]];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }

    public static function UpdateCdn($token, $filedID, $value, $websiteid)
    {

        $fileds = [
            'cache_level' => 'cdnw_cache_level',
            'always_online' => 'cdnw_always_online',
            'css_minify' => 'cdnw_css_minify',
            'js_minify' => 'cdnw_js_minify',
            'html_minify' => 'cdnw_html_minify',
            'browser_cache_ttl' => 'cdnw_cache_ttl',
            'developermode' => 'cdnw_developermode',
            'hotlink_protection' => 'cdnw_hotlink_protection',
            'server_cache_ttl' => 'cdnw_server_cache_ttl',
            'sslstatus' => 'cdnw_sslstatus'
        ];
        if (array_key_exists($filedID, $fileds)) {
            if ($filedID == "cache_level") {
                $cachelevel_array = ["0", "1", "2", "3"];
                if (in_array($value, $cachelevel_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "always_online") {
                $always_online_array = ["0", "1"];
                if (in_array($value, $always_online_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "css_minify") {
                $css_minify_array = ["0", "1"];
                if (in_array($value, $css_minify_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "js_minify") {
                $js_minify_array = ["0", "1"];
                if (in_array($value, $js_minify_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "html_minify") {
                $html_minify_array = ["0", "1"];
                if (in_array($value, $html_minify_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "browser_cache_ttl") {
                //iNTERVALS: 30m/1h/2h/3h/4h/5h/8h/12h/16h/20h/
                //INTERVALS: 1d/2d/3d/4d/5d/8d/16d/24d/1m/2m/6m/1y
                $browser_cache_ttl_array = [
                    "10s" => "10s", "-1" => "-1", "30s" => "30s", "1m" => "1", "2m" => "2", "5m" => "5", "10m" => "10", "20m" => "20",
                    "30m" => "30", "1h" => "60",
                    "2h" => "120", "3h" => "180", "6h" => "360",
                    "12h" => "720",
                    "1d" => "1440", "3d" => "4320", "7d" => "10800",
                    "10d" => "14400", "15d" => "21600", "30d" => "43200",
                    "180d" => "259200", "365" => "525600"
                ];
                if (isset($browser_cache_ttl_array[$value])) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    $value = $browser_cache_ttl_array[$value];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "developermode") {
                $developermode_array = ["0", "1"];
                if (in_array($value, $developermode_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "hotlink_protection") {
                $hotlink_protection_array = ["0", "1"];
                if (in_array($value, $hotlink_protection_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "server_cache_ttl") {
                //iNTERVALS: 30m/1h/2h/3h/4h/5h/8h/12h/16h/20h/
                //INTERVALS: 1d/2d/3d/4d/5d/8d/16d/24d/1m/2m/6m/1y
                $server_cache_ttl_array = [
                    "10s" => "10s", "-1" => "-1", "30s" => "30s", "1m" => "1", "2m" => "2", "5m" => "5", "10m" => "10", "20m" => "20",
                    "30m" => "30", "1h" => "60",
                    "2h" => "120", "3h" => "180", "6h" => "360",
                    "12h" => "720",
                    "1d" => "1440", "3d" => "4320", "7d" => "10800",
                    "10d" => "14400", "15d" => "21600", "30d" => "43200",
                    "180d" => "259200", "365" => "525600"
                ];
                if (isset($server_cache_ttl_array[$value])) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    $value = $server_cache_ttl_array[$value];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "sslstatus") {
                $sslstatus_array = ["0", "1"];
                if (in_array($value, $sslstatus_array)) {
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }

            if ($out["status"] == "success") {
                $usersDetails = USERS_ADMIN::GetOneByToken($token);
                if ($usersDetails["status"] == "error") {
                    VARS_ADMIN::ReturnHeadersState(301);
                    return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
                } else {
                    $balance = $usersDetails["credit"];
                    if ($usersDetails["credit"] < 0) {
                        return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
                    }
                }
                $uid = $usersDetails["userdetail"][0]["uid"];
                $canaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
                if ($canaccess["status"] == "error") {
                    return ["status" => "error", "message" => "شما مجوز دسترسی به این سایت را ندارید"];
                }
                $sql = "update " . $GLOBALS["cdn_tablename"] . " SET " . $GLOBALS[$fileds[$filedID]] . "=" . $value . "
                WHERE " . $GLOBALS["cdnw_wid_fk"] . "=" . $websiteid;
                $conn = GetConnection();
                if ($conn->query($sql) === TRUE) {
                    return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    return ["status" => "error", "message" => "خطا در انجام درخواست"];
                }
            }
            return $out;
        } else {
            return ["status" => "error", "message" => "خطا در مقادیر ارسالی نام فیلد ارسالی شما اشتباه است"];
        }
    }
    public static function CanAccessToPoolid($poolid, $uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid . " AND " . $GLOBALS['sp_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateArrayinDB($subfloderid, $action, $rules)
    {
        $FolderDetails = SUBFOLDER_ADMIN::GetOneID($subfloderid);
        if ($FolderDetails["status"] == "success") {
            $newruls = $FolderDetails["data"]["sf_rules"];
            $final = [];
            $arr = explode(",", $newruls);
            $i = 0;
            if ($action == "add") {
                foreach ($arr as $a) {
                    if ($a != $rules) {
                        array_push($final, $a);
                    }
                    if ($i == 0 && $a != $rules) {
                        array_push($final, $rules);
                        $i++;
                    }
                }
                if ($i == 0) {
                    array_push($final, $rules);
                }
                $final = array_unique($final);
                $final = array_filter($final);
                $f = implode(",", $final);
            } else if ($action == "remove") {
                foreach ($arr as $a) {
                    if ($a != $rules)
                        array_push($final, $a);
                }
            }

            $final = array_unique($final);
            $final = array_filter($final);
            $f = implode(",", $final);
            $o = SUBFOLDER_ADMIN::UpdateRules($subfloderid, $f);
            return $o;
        }
    }

    public static function RemoveubFolderRules($subfolderid, $token, $rules, $value, $internal = false)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websiteaccess = SUBFOLDER_ADMIN::CanAccessToSubFolder($subfolderid, $uid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "شما اجازه دسترسی به این فولدر را ندارید"
            ];
        }

        $pr = $websiteaccess["data"][0]["sf_priority"];
        $reservedHeader_array = [
            "server", "mc-cache", "mc-cache-status", "country", "request-Country",
            "request-IP", "mc-id", "mc-eid"
        ];

        $RulesName = [
            "browser_cache_ttl" => "subfolderrules_browsercachettl_tablename",
            "Edge_cache_ttl" => "subfolderrules_servercachettl_tablename",
            "cache_level" => "subfolderrules_cachelevel_tablename",
            "waf" => "subfolderrules_waf_tablename",
            "add_header_to_client" => "subfolderrules_headertoclient_tablename",
            "add_header_to_server" => "subfolderrules_headertobackend_tablename",
            "remove_header" => "subfolderrules_removeheader_tablename",
            "redirect_url" => "subfolderrules_redirecturl_tablename",
            "autominify" => "subfolderrules_autominify_tablename",
            "forcehttps" => "subfolderrules_forcehttps_tablename",
            "securitylevel" => "subfolderrules_securitylevel_tablename",
            "ipmanagement" => "subfolderrules_ipmanagement_tablename",
            "countrymanagement" => "subfolderrules_countrymanagement_tablename",
            "connection_timeout" => "subfolderrules_connection_timeout_tablename",
            "ratelimit" => "subfolderrules_ratelimit_tablename",
            "cachecontrol" => "subfolderrules_cachecontrol_tablename",
            "hostheader" => "subfolderrules_hostheader_tablename"
        ];

        if (array_key_exists($rules, $RulesName)) {

            $out = [];
            if ($rules == "browser_cache_ttl") {
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];

                SUBFOLDERRULES_ADMIN::RemoveBrowserCacheTTLSubFolder($subfolderid, $pr, $websiteaccess);
            } else if ($rules == "Edge_cache_ttl") {
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                SUBFOLDERRULES_ADMIN::RemovServerCacheTTLSubFolder($subfolderid);
            } else if ($rules == "cache_level") {
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                SUBFOLDERRULES_ADMIN::RemoveCacheLevelSubFolder($subfolderid);
            } else if ($rules == "waf") {
                SUBFOLDERRULES_ADMIN::RemoveWafLevelSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            } else if ($rules == "add_header_to_client") {
                if ($internal) {
                    $countofRecords = SUBFOLDERRULES_ADMIN::RemoveHeaderToClientSubFolder(
                        $subfolderid,
                        "allkeys",
                        $pr
                    );
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    if (array_key_exists("name", $value)) {
                        $name = strtolower($value["name"]);
                        $name = TOOLS_ADMIN::seo_friendly_url($name);
                        if (in_array($value["name"], $reservedHeader_array)) {
                            $out = ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
                        } else {
                            if (isset($value["name"])) {
                                $countofRecords = SUBFOLDERRULES_ADMIN::RemoveHeaderToClientSubFolder(
                                    $subfolderid,
                                    $name,
                                    $pr
                                );
                                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                            } else {
                                $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                            }
                        }
                    } else {
                        $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                    }
                }
            } else if ($rules == "add_header_to_server") {
                if ($internal) {
                    $countofRecords = SUBFOLDERRULES_ADMIN::RemoveHeaderToBackendSubFolder(
                        $subfolderid,
                        "allkeys",
                        $pr
                    );
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    if (array_key_exists("name", $value)) {
                        $name = strtolower($value["name"]);
                        $name = TOOLS_ADMIN::seo_friendly_url($name);
                        $reservedHeader_array = ["host", "x-real-ip", "x-forwarded-for"];
                        if (in_array($value["name"], $reservedHeader_array)) {
                            $out = ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
                        } else {

                            if (isset($value["name"])) {
                                $countofRecords = SUBFOLDERRULES_ADMIN::RemoveHeaderToBackendSubFolder(
                                    $subfolderid,
                                    $name,
                                    $pr
                                );
                                $out = ["status" => "success", $countofRecords, "message" => "درخواست شما با موفقیت انجام شد"];
                                // return $out;
                            } else {
                                $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                                // return $out;
                            }
                        }
                    } else {
                        $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                        return $out;
                    }
                }
            } else if ($rules == "remove_header") {
                if ($internal) {
                    $countofRecords = SUBFOLDERRULES_ADMIN::RemoveRemoveHeaderSubFolder(
                        $subfolderid,
                        "allkeys",
                        $pr
                    );
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    if (array_key_exists("name", $value)) {
                        $name = strtolower($value["name"]);
                        $name = TOOLS_ADMIN::seo_friendly_url($name);

                        if (in_array($value["name"], $reservedHeader_array)) {
                            $out = [
                                "status" => "error",
                                "message" => "مقدار ارسالی برای نام هدر نامعتبر است"
                            ];
                        } else {

                            if (isset($value["name"])) {
                                $countofRecords = SUBFOLDERRULES_ADMIN::RemoveRemoveHeaderSubFolder(
                                    $subfolderid,
                                    $name,
                                    $pr
                                );
                                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                                // if ($countofRecords > 0)
                                //     return $out;
                            } else {
                                $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                            }
                        }
                    } else {
                        $out = ["status" => "error", "message" => "پارمترهای ارسالی نامعتبر است"];
                    }
                }
            } else if ($rules == "redirect_url") {
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];

                SUBFOLDERRULES_ADMIN::RemoveRedirectUrlSubFolder($subfolderid, $pr);
            } else if ($rules == "autominify") {
                SUBFOLDERRULES_ADMIN::RemoveAutoMinifySubFolder($subfolderid);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            } else if ($rules == "forcehttps") {
                SUBFOLDERRULES_ADMIN::RemoveRedirectHttpsSubFolder($subfolderid);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            } else if ($rules == "securitylevel") {
                SUBFOLDERRULES_ADMIN::RemoveSecurityLevelSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            } else if ($rules == "ipmanagement") {
                SUBFOLDERRULES_ADMIN::RemoveIpManagementSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            } else if ($rules == "countrymanagement") {
                $s = SUBFOLDERRULES_ADMIN::RemoveCouontryManagementSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $s];
            } else if ($rules == "connection_timeout") {
                $s = SUBFOLDERRULES_ADMIN::RemoveConnectionTimeOutSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $s];
            } else if ($rules == "ratelimit") {
                $s = RATELIMITSUBFOLDER_NEW_ADMIN::RemoveRateLimit($token, $subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $s];
            } else if ($rules == "cachecontrol") {
                $s = self::RemoveCacheControlSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $s];
            } else if ($rules == "hostheader") {
                $s = self::RemoveHostHeaderSubFolder($subfolderid, $pr);
                $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $s];
            }
        } else {
            return ["status" => "error", "message" => "قانون ارسالی شما نامعتبر است"];
        }
        if ($out["status"] == "success") {

            return SUBFOLDERRULES_ADMIN::UpdateArrayinDB($subfolderid, "remove", $rules);
        }
        return $out;
    }

    ####StartUpdateCommands#####
    public static function UpdateConnectionTimeoutSubFolder($subfolderid, $connect, $send, $read, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_connection_timeout_tablename'] . " WHERE "
            . $GLOBALS['sfmcto_sfid_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_connection_timeout_tablename'] . "(" .
                $GLOBALS['sfmcto_sfid_fk'] . "," . $GLOBALS['sfmcto_connect'] . "," . $GLOBALS['sfmcto_send'] . "," . $GLOBALS['sfmcto_read'] . ") VALUES("
                . $subfolderid . "," . $connect . "," . $send . "," . $read . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_connection_timeout_tablename'] . " SET " .
                $GLOBALS['sfmcto_connect'] . "=" . $connect . "," . $GLOBALS['sfmcto_send'] . "=" . $send . "," . $GLOBALS['sfmcto_read'] . "=" . $read . " WHERE " .
                $GLOBALS['sfmcto_sfid_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = "/";
        }
        API_UPSTREAM_ADMIN::RunCreateConnectionTimeOut($dmn, $connect, $send, $read, $foldername, $priority);
        $conn->close();
        return $result;
    }
    public static function UpdateBrowserCacheTTLSubFolder($subfolderid, $cacheValue, $priority, $ttl)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_browsercachettl_tablename'] . " WHERE "
            . $GLOBALS['sfbct_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_browsercachettl_tablename'] . "(" .
                $GLOBALS['sfbct_sf_id_fk'] . "," . $GLOBALS['sfbct_value'] . ") VALUES("
                . $subfolderid . ",'" . $ttl . "')";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_browsercachettl_tablename'] . " SET " .
                $GLOBALS['sfbct_value'] . "='" . $ttl . "' WHERE " . $GLOBALS['sfbct_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = null;
            CACHE_ADMIN::InternalUpdate($requiredData[0]["wsid"], "mc_browsercache_ttl", $ttl);
        }
        //          API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, self::ReturnDataForApi($browsercachettl)["time"], null,self::ReturnDataForApi($browsercachettl)["format"]);

        API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, CACHE_ADMIN::ReturnDataForApi($ttl)["time"], $foldername, $priority, CACHE_ADMIN::ReturnDataForApi($ttl)["format"]);
        $conn->close();
        return $sql2;
    }

    public static function ReturnAllNeededDataForAPI($subfolderid)
    {
        $sql = "SELECT *, IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain  FROM " . $GLOBALS["subfolder_tablename"] . "," . $GLOBALS["websites_tablename"]
            . "," . $GLOBALS["users_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE
        " . $GLOBALS["wsid"] . "=" . $GLOBALS["sf_ws_id_fk"] . "   and " . $GLOBALS["domain_id"] . "= " . $GLOBALS["ws_domainid_fk"] . "
        and " . $GLOBALS["d_user_id_fk"] . "=" . $GLOBALS["uid"] . " AND " . $GLOBALS['subfolder_id'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        return mysqli_fetch_all($result, MYSQLI_ASSOC);
    }
    public static function UpdateServerCacheTTLSubFolder($subfolderid, $cacheValue, $priority, $ttl)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_servercachettl_tablename'] . " WHERE "
            . $GLOBALS['sfsct_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_servercachettl_tablename'] . "(" .
                $GLOBALS['sfsct_sf_id_fk'] . "," . $GLOBALS['sfsct_value'] . ") VALUES("
                . $subfolderid . ",'" . $ttl . "')";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        } else {

            $sql2 = "Update " . $GLOBALS['subfolderrules_servercachettl_tablename'] . " SET " .
                $GLOBALS['sfsct_value'] . "='" . $ttl . "' WHERE " . $GLOBALS['sfsct_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" .  $requiredData[0]["sf_name"];
        }
        if ($requiredData[0]["sf_name"] == "/") {
            $foldername = null;
            CACHE_ADMIN::InternalUpdate($requiredData[0]["wsid"], "mc_servercache_ttl", $ttl);
        }
        //         API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn,CACHE_ADMIN::ReturnDataForApi($ttl)["time"] ,$foldername,$priority,CACHE_ADMIN::ReturnDataForApi($ttl)["format"]);

        API_CAHCE_ADMIN::RunCreateAPIServerCacheTTL($dmn, CACHE_ADMIN::ReturnDataForApi($ttl)["time"], $foldername, $priority, CACHE_ADMIN::ReturnDataForApi($ttl)["format"]);
        $conn->close();
        return $sql2;
    }

    public static function UpdateCacheLevelSubFolder($subfolderid, $cacheLevel, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_cachelevel_tablename'] . " WHERE "
            . $GLOBALS['sfcl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_cachelevel_tablename'] . "(" .
                $GLOBALS['sfcl_level'] . "," . $GLOBALS['sfcl_sf_id_fk'] . ") VALUES("
                . $cacheLevel . "," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_cachelevel_tablename'] . " SET " .
                $GLOBALS['sfcl_level'] . "='" . $cacheLevel . "' WHERE " . $GLOBALS['sfcl_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $cacheTypes = ["nocache", "vqs", "wqs", "standard"];
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            CACHE_ADMIN::InternalUpdate($requiredData[0]["wsid"], "mc_type", intVal($cacheLevel) + 1);
        }
        API_CAHCE_ADMIN::RunCreateAPICacheLevel($dmn, $cacheTypes[$cacheLevel], $foldername, $priority);

        $conn->close();
        return $result;
    }

    public static function UpdateWafLevelSubFolder($subfolderid, $wafLevel, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_waflevel_tablename'] . " WHERE "
            . $GLOBALS['sfwl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_waflevel_tablename'] . "(" .
                $GLOBALS['sfwl_level'] . "," . $GLOBALS['sfwl_sf_id_fk'] . ") VALUES("
                . $wafLevel . "," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_waflevel_tablename'] . " SET " .
                $GLOBALS['sfwl_level'] . "=" . $wafLevel . " WHERE " . $GLOBALS['sfwl_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }

        if ($wafLevel == "2") {

            API_WAF_ADMIN::RunCreateAPIWAF($dmn, "1", $foldername, $priority);
            // API_WAF_ADMIN::RunDisableAPIWAF($dmn, "2", "null");
        } else if ($wafLevel == "3") {
            // API_WAF_ADMIN::RunCreateAPIWAF($dmn, $wafLevel, $foldername);
            // API_WAF_ADMIN::RunDisableAPIWAF($dmn, "1", "null",);
        } else if ($wafLevel == "1") {
            API_WAF_ADMIN::RunDisableAPIWAF($dmn,  "1", $foldername, $priority);
            // API_WAF_ADMIN::RunDisableAPIWAF($dmn, "2", "null");
        }

        $conn->close();
        return $result;
    }
    public static function UpdateHostHeaderSubFolder($subfolderid, $value, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_hostheader_tablename'] . " WHERE "
            . $GLOBALS['sfh_sfd_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_hostheader_tablename'] . "(" .
                $GLOBALS['sfh_sfd_fk'] . "," . $GLOBALS['sfh_host'] . ") VALUES("
                . $subfolderid . ",'" . $value . "')";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_hostheader_tablename'] . " SET " .
                $GLOBALS['sfh_host'] . "='" . $value . "' WHERE " . $GLOBALS['sfh_sfd_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }
        $name = "host_" . $value;
        // API_HEADERTOBACKEND_ADMIN::RunCreateAPIHEADERTOBACKEND($dmn, $name, $foldername, $priority);
        self::UpdateHeaderQueue($subfolderid, $priority);

        $conn->close();
        return $result;
    }
    public static function RemoveQueue($domain, $location, $action, $pririty)
    {
        $sql = "DELETE FROM  tbl_header_queue WHERE domain='" . $domain . "' and action='" . $action . "' and location='" . $location . "' and priority='" . $pririty . "'";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function AddToQueue($domain, $content, $location, $action, $priority)
    {
        if ($action == "HeaderToClient")
            API_HEADERTOCLIENT_ADMIN::RunCreateAPIHEADERTOCLIENT($domain, $content, $location, $priority);
        else if ($action == "HeaderToBackeEnd")
            API_HEADERTOBACKEND_ADMIN::RunCreateAPIHEADERTOBACKEND($domain, $content, $location, $priority);
        else if ($action == "RemoveHeader")
            API_HIDEHEADER_ADMIN::RunCreateAPIHIDEHEADER($domain, $content, $location, $priority);

        //   self::RemoveQueue($domain,$location,$action,$pririty);
        //   $sql="INSERT INTO tbl_header_queue (domain,content,action,location,priority) VALUES('".$domain."','".$content."','".$action."','".$location."','".$priority."')";
        //   $conn = GetConnection();
        //   $conn->query($sql);
        //   $conn->close();
    }
    public static function UpdateHeaderToClientSubFolder($subfolderid, $HeaderName, $HeaderValue, $priority)
    {
        $HeaderName = preg_replace('/[^A-Za-z0-9\-]/', '', $HeaderName);
        $HeaderValue = preg_replace('/[^A-Za-z0-9\-]/', '', $HeaderValue);

        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_headertoclient_tablename'] . " WHERE "
            . $GLOBALS['sfhtc_sfcl_sf_id_fk'] . "=" . $subfolderid . " AND " . $GLOBALS['sfhtc_name'] . "='" . $HeaderName . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {

            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_headertoclient_tablename'] . "(" .
                $GLOBALS['sfhtc_name'] . "," . $GLOBALS['sfhtc_value'] . "," . $GLOBALS['sfhtc_sfcl_sf_id_fk'] . ") VALUES('"
                . $HeaderName . "','" . $HeaderValue . "'," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "inserted"];
            } else {
                $result = ["status" => "error"];
            }
        } else {

            $sql2 = "Update " . $GLOBALS['subfolderrules_headertoclient_tablename'] . " SET " .
                $GLOBALS['sfhtc_value'] . "='" . $HeaderValue . "' WHERE " .
                $GLOBALS['sfhtc_sfcl_sf_id_fk'] . "=" . $subfolderid . "
        and " . $GLOBALS['sfhtc_name'] . "='" . $HeaderName . "'";
            $headers = self::GetlistOfHeaderToClient($subfolderid);
            $str = "";
            foreach ($headers as $h) {
                $str .= $h["name"] . "_" . $h["value"] . ",";
            }
            $str = substr($str, 0, strlen($str) - 1);
            //
            //  API_HEADERTOCLIENT_ADMIN::RunCreateAPIHEADERTOCLIENT($dmn, $str, $foldername,$priority);

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $listofContent = self::GetlistOfHeaderToClient($subfolderid);

        $m = "";
        foreach ($listofContent as $l) {
            $m .= $l["name"] . "_" . $l["value"] . ",";
        }
        $m = substr($m, 0, strlen($m) - 1);

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = "/";
        }
        // API_HEADERTOCLIENT_ADMIN::RunDisableAPIHEADERTOCLIENT($dmn,  $foldername);

        self::AddToQueue($dmn, $m, $foldername, "HeaderToClient", $priority);
        $conn->close();
        return ["status" => "error", $requiredData[0]["sf_name"], $foldername]; // $result;
    }
    public static function UpdateHeaderQueue($subfolderid, $priority)
    {

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $listofContent = self::GetlistOfHeaderToBackend($subfolderid);
        $m = "";
        foreach ($listofContent as $l) {
            $m .= $l["name"] . "_" . $l["value"] . ",";
        }
        $m = substr($m, 0, strlen($m) - 1);
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = "/";
        }

        $listofhost = SUBFOLDERRULES_ADMIN::GetListOfHostHeader($subfolderid);
        if (count($listofhost) > 0) {
            if(strlen($m)>1)
                $m .=  ",host_" . $listofhost[0]["value"];
            else
                $m .=  "host_" . $listofhost[0]["value"];
        }
        self::AddToQueue($dmn, $m, $foldername, "HeaderToBackeEnd", $priority);
    }
    public static function UpdateHeaderToBackendSubFolder($subfolderid, $HeaderName, $HeaderValue, $priority)
    {
        $HeaderName = preg_replace('/[^A-Za-z0-9\-]/', '', $HeaderName);
        $HeaderValue = preg_replace('/[^A-Za-z0-9\-]/', '', $HeaderValue);

        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_headertobackend_tablename'] . " WHERE "
            . $GLOBALS['sfhtb_sfcl_sf_id_fk'] . "=" . $subfolderid . " AND " . $GLOBALS['sfhtb_name'] . "='" . $HeaderName . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        if (!$result || mysqli_num_rows($result) == 0) {

            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_headertobackend_tablename'] . "(" .
                $GLOBALS['sfhtb_name'] . "," . $GLOBALS['sfhtb_value'] . "," . $GLOBALS['sfhtb_sfcl_sf_id_fk'] . ") VALUES('"
                . $HeaderName . "','" . $HeaderValue . "'," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "inserted"];
            } else {
                $result = ["status" => "error"];
            }
        } else {

            $sql2 = "Update " . $GLOBALS['subfolderrules_headertobackend_tablename'] . " SET " .
                $GLOBALS['sfhtb_value'] . "='" . $HeaderValue . "' WHERE " .
                $GLOBALS['sfhtb_sfcl_sf_id_fk'] . "=" . $subfolderid . "
        and " . $GLOBALS['sfhtb_name'] . "='" . $HeaderName . "'";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $conn->close();
        $listofContent = self::GetlistOfHeaderToBackend($subfolderid);

        $m = "";
        foreach ($listofContent as $l) {
            $m .= $l["name"] . "_" . $l["value"] . ",";
        }
        $m = substr($m, 0, strlen($m) - 1);
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = "/";
        }
        self::UpdateHeaderQueue($subfolderid, $priority);
        // self::AddToQueue($dmn, $m, $foldername, "HeaderToBackeEnd", $priority);

        return $result;
    }

    public static function UpdateRemoveHeaderSubFolder($subfolderid, $HeaderName, $priority)
    {

        // API_HIDEHEADER_ADMIN::RunCreateAPIHIDEHEADER($dmn, $HeaderName, $foldername);
        $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_removeheader_tablename'] . "(" .
            $GLOBALS['sfrh_name'] . "," . $GLOBALS['sfrh_sf_id_fk'] . ") VALUES('"
            . $HeaderName . "'," . $subfolderid . ")";
        $conn = GetConnection();
        $conn->query($sql2);
        $conn->close();
        $listofContent = self::GetlistOfRemoveHeader($subfolderid);

        $m = "";
        foreach ($listofContent as $l) {
            $m .= $l["name"] . ",";
        }
        $m = substr($m, 0, strlen($m) - 1);

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = "/";
        }
        self::AddToQueue($dmn, $m, $foldername, "RemoveHeader", $priority);

        return;
    }

    public static function UpdateRedirectUrlSubFolder($subfolderid, $NewUrl, $Status, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_redirecturl_tablename'] . " WHERE "
            . $GLOBALS['sfru_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_redirecturl_tablename'] . "(" .
                $GLOBALS['sfru_status'] . "," . $GLOBALS['sfru_newurl'] . "," . $GLOBALS['sfru_sf_id_fk'] . ") VALUES('"
                . $Status . "','" . $NewUrl . "'," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "inserted"];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_redirecturl_tablename'] . " SET " .
                $GLOBALS['sfru_newurl'] . "='" . $NewUrl . "'," .
                $GLOBALS['sfru_status'] . "=" . $Status . " WHERE " . $GLOBALS['sfru_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = "/";
        }
        API_REDIRECTSUBLINKTOHTTPS_ADMIN::RunCreateRedirectToURL(
            $dmn,
            $Status,
            $foldername,
            $NewUrl,
            $priority
        );
        $conn->close();
        return $result;
    }

    public static function UpdateAutoMinifySubFolder($subfolderid, $Value)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_autominify_tablename'] . " WHERE "
            . $GLOBALS['sfam_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_autominify_tablename'] . "(" .
                $GLOBALS['sfam_sf_id_fk'] . "," . $GLOBALS['sfam_value'] . ") VALUES("
                . $subfolderid . ",'" . $Value . "')";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
            return $result;
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_autominify_tablename'] . " SET " .
                $GLOBALS['sfam_value'] . "='" . $Value . "' WHERE " . $GLOBALS['sfam_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }
        $conn->close();
        return $result;
    }

    public static function UpdateCacheControlSubFolder($subfolderid, $Value, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_cachecontrol_tablename'] . " WHERE "
            . $GLOBALS['sfcc_sfid_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            if ($Value == "0") {
                return ["status" => "error"];
            }
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_cachecontrol_tablename'] . "( " . $GLOBALS['sfcc_sfid_fk'] . ") VALUES(" . $subfolderid . ")";
            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "success"];
            } else {
                $result = ["status" => "error"];
            }
            return $result;
        } else {

            $result = ["status" => "success"];
        }

        $conn->close();
        return $result;
    }

    public static function UpdateRedirectHttpsSubFolder($subfolderid, $Value, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_forcehttps_tablename'] . " WHERE "
            . $GLOBALS['sffh_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_forcehttps_tablename'] . "(" .
                $GLOBALS['sffh_sf_id_fk'] . "," . $GLOBALS['sffh_value'] . ") VALUES("
                . $subfolderid . "," . $Value . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
            return $result;
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_forcehttps_tablename'] . " SET " .
                $GLOBALS['sffh_value'] . "=" . $Value . " WHERE " . $GLOBALS['sffh_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }

        $conn->close();
        return $result;
    }

    public static function UpdateSecurityLevelSubFolder($subfolderid, $Value, $websiteininfo, $priority)
    {

        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_securitylevel_tablename'] . " WHERE "
            . $GLOBALS['sfsl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $res = $conn->query($sql);

        if (!$res || mysqli_num_rows($res) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_securitylevel_tablename'] . "(" .
                $GLOBALS['sfsl_sf_id_fk'] . "," . $GLOBALS['sfsl_value'] . ") VALUES("
                . $subfolderid . "," . $Value . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated", $websiteininfo];
            } else {
                $result = ["status" => "error"];
            }
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            $foldername = "";
            if ($requiredData[0]["sf_name"] != "/") {
                $foldername = "/" . $requiredData[0]["sf_name"];
            }
            API_UNDERATTACKMODE_ADMIN::RunCreateAPIUNDERATTACKMODE($dmn, $Value, $foldername, $priority, "14400");
        } else {

            $list = mysqli_fetch_all($res, MYSQLI_ASSOC);

            $sql2 = "Update " . $GLOBALS['subfolderrules_securitylevel_tablename'] . " SET " .
                $GLOBALS['sfsl_value'] . "=" . $Value . " WHERE " . $GLOBALS['sfsl_sf_id_fk'] . "=" . $subfolderid;
            $listOfRecordType = mysqli_fetch_all($res, MYSQLI_ASSOC);
            $dmn = TOOLS_ADMIN::ReturnDomainName($websiteininfo);

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated", $listOfRecordType, $websiteininfo];
            } else {
                $result = ["status" => "error"];
            }
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            $foldername = "";
            if ($requiredData[0]["sf_name"] != "/") {
                $foldername = "/" . $requiredData[0]["sf_name"];
            }
            if ($list[0]["sfsl_value"] != $Value) {
                if ($list[0]["sfsl_value"] != "0")
                    API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, $list[0]["sfsl_value"], $foldername, $priority);
                sleep(1);
                if ($Value != "0")
                    API_UNDERATTACKMODE_ADMIN::RunCreateAPIUNDERATTACKMODE($dmn, $Value, $foldername, $priority, "14400");
            }
        }

        $conn->close();
        return $result;
    }

    public static function UpdateIpManagementSubFolder($subfolderid, $ip, $default, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_ipmanagement_tablename'] . " WHERE "
            . $GLOBALS['sfim_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_ipmanagement_tablename'] . "(" .
                $GLOBALS['sfim_default'] . "," . $GLOBALS['sfim_ip'] . "," . $GLOBALS['sfim_sf_id_fk'] . ") VALUES('"
                . $default . "','" . $ip . "'," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated", $ip];
            } else {
                $result = ["status" => "error"];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_ipmanagement_tablename'] . " SET "
                . $GLOBALS['sfim_default'] . "='" . $default . "',"
                . $GLOBALS['sfim_ip'] . "='" . $ip . "'  where " . $GLOBALS['sfim_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated", $ip];
            } else {
                $result = ["status" => "error"];
            }
        }
        $df = "no";
        if ($default == "allow") {
            $df = "yes";
        }

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $outapi = self::ReturnGeoValueForLocation($subfolderid, "ip");
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }

        $df = "no";
        if ($default == "allow") {
            $df = "yes";
        }

        API_GEO_ADMIN::RunCreateAPIGEO(
            $dmn,
            $df,
            $outapi["allowedCountry"],
            $foldername,
            true,
            $priority,
            $outapi["BlockedCountry"],
            $outapi["allowedCountry"],
            $outapi["BlockedIP"],
            $outapi["allowedIP"]
        );

        $conn->close();
        return $outapi;
    }

    public static function UpdateCouontryManagementSubFolder($subfolderid, $country, $default, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_countrymanagement_tablename'] . " WHERE "
            . $GLOBALS['sfcm_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "INSERT INTO " . $GLOBALS['subfolderrules_countrymanagement_tablename'] . "(" .
                $GLOBALS['sfcm_default'] . "," . $GLOBALS['sfcm_country'] . "," . $GLOBALS['sfcm_sf_id_fk'] . ") VALUES('"
                . $default . "','" . $country . "'," . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error" . $conn->error];
            }
        } else {
            $sql2 = "Update " . $GLOBALS['subfolderrules_countrymanagement_tablename'] . " SET "
                . $GLOBALS['sfcm_default'] . "='" . $default . "',"
                . $GLOBALS['sfcm_country'] . "='" . $country . "'  where " . $GLOBALS['sfcm_sf_id_fk'] . "=" . $subfolderid;

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
        }

        $df = "no";
        if ($default == "allow") {
            $df = "yes";
        }

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $outapi = self::ReturnGeoValueForLocation($subfolderid, "country");
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }

        $df = "no";
        if ($default == "allow") {
            $df = "yes";
        }
        API_GEO_ADMIN::RunCreateAPIGEO(
            $dmn,
            $df,
            $outapi["allowedCountry"],
            $foldername,
            true,
            $priority,
            $outapi["BlockedCountry"],
            $outapi["allowedCountry"],
            $outapi["BlockedIP"],
            $outapi["allowedIP"]
        );

        $conn->close();
        return $result;
    }
    ####ENDUpdateCommands#####
    public static function ReturnGeoValueForLocation($subfolderid, $type)
    {

        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_ipmanagement_tablename'] . " WHERE "
            . $GLOBALS['sfim_sf_id_fk'] . "=" . $subfolderid;

        $conn = GetConnection();
        $result = $conn->query($sql);
        $rip = mysqli_fetch_all($result, MYSQLI_ASSOC);

        $sql2 = "SELECT * FROM " . $GLOBALS['subfolderrules_countrymanagement_tablename'] . " WHERE "
            . $GLOBALS['sfcm_sf_id_fk'] . "=" . $subfolderid;
        $result2 = $conn->query($sql2);
        $rip2 = mysqli_fetch_all($result2, MYSQLI_ASSOC);

        $default = "";
        $allowedCountry = "";
        $BlockedCountry = "";
        $allowedIP = "";
        $BlockedIP = "";

        if (isset($rip[0]["sfim_default"])) {
            if ($rip[0]["sfim_default"] == "deny") {
                $default = "deny";
                $s = explode(",", $rip[0]["sfim_ip"]);
                $aip = implode("-", $s);
                $allowedIP .= $aip;
            } else {
                $default = "allow";
                $s = explode(",", $rip[0]["sfim_ip"]);
                $aip = implode("-", $s);
                $BlockedIP .= $aip;
            }
        }
        if (isset($rip2[0]["sfcm_default"])) {
            if ($rip2[0]["sfcm_default"] == "deny") {
                $default = "deny";
                $s = explode(",", $rip2[0]["sfcm_country"]);
                $aip = implode("-", $s);

                $allowedCountry .= "-" . $aip;
            } else {
                $default = "allow";
                $s = explode(",", $rip2[0]["sfcm_country"]);
                $aip = implode("-", $s);
                $BlockedCountry .= "-" . $aip;
            }
        }

        $allowedCountry = str_replace("--", "-", $allowedCountry);
        $BlockedCountry = str_replace("--", "-", $BlockedCountry);
        if (substr($allowedCountry, -1) == "-")
            $allowedCountry = substr($allowedCountry, 0, strlen($allowedCountry) - 1);
        if (substr($allowedCountry, 0, 1) == "-")
            $allowedCountry = substr($allowedCountry, 1, strlen($allowedCountry));

        if (substr($BlockedCountry, -1) == "-")
            $BlockedCountry = substr($BlockedCountry, 0, strlen($BlockedCountry) - 1);
        if (substr($BlockedCountry, 0, 1) == "-")
            $BlockedCountry = substr($BlockedCountry, 1, strlen($BlockedCountry));

        $allowedIP = str_replace("--", "-", $allowedIP);
        $BlockedIP = str_replace("--", "-", $BlockedIP);
        if (substr($allowedIP, -1) == "-")
            $allowedIP = substr($allowedIP, 0, strlen($allowedIP) - 1);
        if (substr($allowedIP, 0, 1) == "-")
            $allowedIP = substr($allowedIP, 1, strlen($allowedIP));

        if (substr($BlockedIP, -1) == "-")
            $BlockedIP = substr($BlockedIP, 0, strlen($BlockedIP) - 1);
        if (substr($BlockedIP, 0, 1) == "-")
            $BlockedIP = substr($BlockedIP, 1, strlen($BlockedIP));

        $df = "no";
        if ($default == "allow") {
            $df = "yes";
        }
        $out["default"] = $df;
        $out["BlockedCountry"] = $BlockedCountry;
        $out["allowedCountry"] = $allowedCountry;
        $out["BlockedIP"] = $BlockedIP;
        $out["allowedIP"] = $allowedIP;
        // $out["kheyliout"] = [$rip2, $rip];
        return $out;
    }
    ####StartRemoveCommands#####
    public static function RemoveBrowserCacheTTLSubFolder($subfolderid, $priority, $websiteaccess)
    {

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }
        API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL(
            $dmn,
            CACHE_ADMIN::GetWebsiteCache("12", $websiteaccess["data"][0]["wsid"])["realdata"]["browserttl"],
            $websiteaccess["data"][0]["sf_name"],
            $websiteaccess["data"][0]["sf_priority"]
        );
        $sql = "SELECT * FROM " . $GLOBALS["subfolderrules_browsercachettl_tablename"] . " WHERE "
            . $GLOBALS["sfbct_sf_id_fk"] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $sql2 = "Delete FROM  " . $GLOBALS["subfolderrules_browsercachettl_tablename"] .
            " WHERE " . $GLOBALS["sfbct_sf_id_fk"] . "=" . $subfolderid;
        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }
        $conn->close();
        return $result;
    }
    public static function RemovServerCacheTTLSubFolder($subfolderid)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_servercachettl_tablename'] . " WHERE "
            . $GLOBALS['sfsct_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $sql2 = "Delete FROM  " . $GLOBALS['subfolderrules_servercachettl_tablename'] .
            " WHERE " . $GLOBALS['sfsct_sf_id_fk'] . "=" . $subfolderid;
        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }
        $conn->close();
        return $result;
    }
    public static function RemoveCacheControlSubFolder($subfolderid, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_cachecontrol_tablename'] . " WHERE "
            . $GLOBALS['sfcc_sfid_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_cachecontrol_tablename'] .
            " WHERE " . $GLOBALS['sfcc_sfid_fk'] . "=" . $subfolderid;
        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "success"];
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function RemoveCacheLevelSubFolder($subfolderid)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_cachelevel_tablename'] . " WHERE "
            . $GLOBALS['sfcl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
            $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_cachelevel_tablename'] .
                " WHERE " . $GLOBALS['sfcl_sf_id_fk'] . "=" . $subfolderid;
            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }
            return $result;
        }

        $conn->close();
        return $result;
    }
    public static function RemoveConnectionTimeOutSubFolder($subfolderid, $priority)
    {

        $sql2 = "DELETE FROM tbl_subdfolder_connection_timeout WHERE sfmcto_sfid_fk=" . $subfolderid;
        $conn = GetConnection();
        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "success"];
        } else {
            $result = ["status" => "error"];
        }

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }
        API_UPSTREAM_ADMIN::RunRemoveConnectionTimeOut($dmn, $foldername, $priority);
        $conn->close();
        return $result;
    }
    public static function RemoveWafLevelSubFolder($subfolderid, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_waflevel_tablename'] . " WHERE "
            . $GLOBALS['sfwl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $rs = $conn->query($sql);
        $result = ["status" => "Updated"];
        if (!$rs || mysqli_num_rows($rs) == 0) {
        } else {
            $r = mysqli_fetch_all($rs, MYSQLI_ASSOC);
            $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_waflevel_tablename'] .
                ", WHERE " . $GLOBALS['sfwl_sf_id_fk'] . "=" . $subfolderid . ")";

            if ($conn->query($sql2) === TRUE) {
                $result = ["status" => "Updated"];
            } else {
                $result = ["status" => "error"];
            }

            if ($r[0]["sfwl_level "] == "1") {
            }
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            $foldername = "";
            if ($requiredData[0]["sf_name"] != "/") {
                $foldername = "/" . $requiredData[0]["sf_name"];
            }
            API_WAF_ADMIN::RunDisableAPIWAF($dmn, "1", $foldername, $priority);
        }

        $conn->close();
        return $result;
    }
    public static function RemoveHeaderToClientSubFolder($subfolderid, $HeaderName, $priority)
    {
        $wherecond = " AND " .
            $GLOBALS['sfhtc_name'] . "='" . $HeaderName . "'";
        if ($HeaderName == "allkeys") {
            $wherecond = "";
        }
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_headertoclient_tablename'] . " WHERE "
            . $GLOBALS['sfhtc_sfcl_sf_id_fk'] . "=" . $subfolderid . $wherecond;
        $conn = GetConnection();
        $result = $conn->query($sql);

        $sql2 = " DELETE FROM " . $GLOBALS['subfolderrules_headertoclient_tablename'] . " WHERE "
            .   $GLOBALS['sfhtc_sfcl_sf_id_fk'] . "=" . $subfolderid . $wherecond;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "inserted"];
        } else {
            $result = ["status" => "error"];
        }

        $sql3 = "SELECT * FROM " . $GLOBALS['subfolderrules_headertoclient_tablename'] . " WHERE "
            . $GLOBALS['sfhtc_sfcl_sf_id_fk'] . "=" . $subfolderid;

        $result = $conn->query($sql3);
        $conn->close();

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = $requiredData[0]["sf_name"];
        }
        API_HEADERTOCLIENT_ADMIN::RunDisableAPIHEADERTOCLIENT($dmn, $foldername, $priority);
        return  mysqli_num_rows($result);
    }
    public static function RemoveHeaderToBackendSubFolder($subfolderid, $HeaderName, $priority)
    {
        $wherecond = " AND " .
            $GLOBALS['sfhtb_name'] . "='" . $HeaderName . "'";
        if ($HeaderName == "allkeys") {
            $wherecond = "";
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            // API_HEADERTOBACKEND_ADMIN::RunDisableAPIHEADERTOBACKEND($dmn, $HeaderName, $foldername);

        }
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_headertobackend_tablename'] . " WHERE "
            . $GLOBALS['sfhtb_sfcl_sf_id_fk'] . "=" . $subfolderid . $wherecond;

        $conn = GetConnection();
        $result = $conn->query($sql);

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_headertobackend_tablename'] . " WHERE " .
            $GLOBALS['sfhtb_sfcl_sf_id_fk'] . "=" . $subfolderid .
            $wherecond;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }

        $sql3 = "SELECT * FROM " . $GLOBALS['subfolderrules_headertobackend_tablename'] . " WHERE "
            . $GLOBALS['sfhtb_sfcl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql3);

        $conn->close();

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }

        API_HEADERTOCLIENT_ADMIN::RunDisableAPIHEADERTOCLIENT($dmn, $foldername, $priority);

        return $result;
    }
    public static function RemoveRemoveHeaderSubFolder($subfolderid, $HeaderName, $priority)
    {
        $wherecond = " AND " .
            $GLOBALS['sfrh_name'] . "='" . $HeaderName . "'";
        if ($HeaderName == "allkeys") {
            $wherecond = "";
        }
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_removeheader_tablename'] . " WHERE "
            . $GLOBALS['sfrh_sf_id_fk'] . "=" . $subfolderid . $wherecond;
        $conn = GetConnection();
        $result = $conn->query($sql);

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_removeheader_tablename'] . " WHERE "
            . $GLOBALS['sfrh_sf_id_fk'] . "=" . $subfolderid . $wherecond;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "inserted"];
        } else {
            $result = ["status" => "error"];
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }
        API_HIDEHEADER_ADMIN::RunDisableAPIHIDEHEADER($dmn, $HeaderName, $foldername, $priority);

        $sql3 = "SELECT * FROM " . $GLOBALS['subfolderrules_removeheader_tablename'] . " WHERE "
            . $GLOBALS['sfrh_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql3);

        $conn->close();
        return mysqli_num_rows($result);
    }
    public static function RemoveRedirectUrlSubFolder($subfolderid, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_redirecturl_tablename'] . " WHERE "
            . $GLOBALS['sfru_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $list = mysqli_fetch_all($result, MYSQLI_ASSOC);

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);

        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = $requiredData[0]["sf_name"];
        }

        API_REDIRECTSUBLINKTOHTTPS_ADMIN::RunRemoveRedirectToURL(
            $dmn,
            $list[0]["sfru_status"],
            $foldername,
            $list[0]["sfru_newurl"],
            $priority
        );

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_redirecturl_tablename'] . " WHERE " . $GLOBALS['sfru_sf_id_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function RemoveHostHeaderSubFolder($subfolderid, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_hostheader_tablename'] . " WHERE "
            . $GLOBALS['sfh_sfd_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $list = mysqli_fetch_all($result, MYSQLI_ASSOC);

        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);

        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        } else {
            $foldername = $requiredData[0]["sf_name"];
        }


        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_hostheader_tablename'] . " WHERE " . $GLOBALS['sfh_sfd_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }


        $conn->close();



        self::UpdateHeaderQueue($subfolderid, $priority);

        return $result;
    }
    public static function RemoveAutoMinifySubFolder($subfolderid)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_autominify_tablename'] . " WHERE "
            . $GLOBALS['sfam_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        $sql2 = "DELETE FROM  " . $GLOBALS['subfolderrules_autominify_tablename'] .
            " WHERE " . $GLOBALS['sfam_sf_id_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function RemoveRedirectHttpsSubFolder($subfolderid)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_forcehttps_tablename'] . " WHERE "
            . $GLOBALS['sffh_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_forcehttps_tablename']
            . " WHERE " . $GLOBALS['sffh_sf_id_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function RemoveSecurityLevelSubFolder($subfolderid, $pr)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_securitylevel_tablename'] . " WHERE "
            . $GLOBALS['sfsl_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
        } else {
            $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $Value = $res[0]["sfsl_value"];
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            //                                                 $foldername="";
            // if($requiredData[0]["sf_name"]!="/"){
            //   $foldername= "/" . $requiredData[0]["sf_name"];
            // }
            //             if ($Value == "1") {
            //                 API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, "1", $foldername);
            //             } else if ($Value == "2") {
            //                 API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, "2", $foldername);
            //             } else if ($Value == "3") {
            //                 API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, "1", $foldername);
            //                 API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, "2", $foldername);
            //             }
        }
        $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
        $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
        $foldername = "";
        if ($requiredData[0]["sf_name"] != "/") {
            $foldername = "/" . $requiredData[0]["sf_name"];
        }
        API_UNDERATTACKMODE_ADMIN::RunDisableAPIUNDERATTACKMODE($dmn, $Value, $foldername, $pr);
        sleep(1);

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_securitylevel_tablename']
            . " WHERE " . $GLOBALS['sfsl_sf_id_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }

        $conn->close();
        return $result;
    }
    public static function RemoveIpManagementSubFolder($subfolderid, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_ipmanagement_tablename'] . " WHERE "
            . $GLOBALS['sfim_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $rs = $conn->query($sql);

        $sql2 = "DELETE FROM  " . $GLOBALS['subfolderrules_ipmanagement_tablename'] .
            " WHERE " . $GLOBALS['sfim_sf_id_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error" . $conn->error];
        }
        if (!$rs || mysqli_num_rows($rs) == 0) {
        } else {
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            $outapi = self::ReturnGeoValueForLocation($subfolderid, "ip");
            $foldername = "";
            if ($requiredData[0]["sf_name"] != "/") {
                $foldername = "/" . $requiredData[0]["sf_name"];
            }

            $df = "no";
            // if ($default == "allow") {
            //     $df = "yes";
            // }
            if ($outapi["allowedCountry"] == "" && $outapi["BlockedCountry"] == "") {
                API_GEO_ADMIN::RunDisableAPIGEO($dmn, $foldername, 0, $priority);
            } else {
                API_GEO_ADMIN::RunCreateAPIGEO($dmn, $df, $outapi["allowedCountry"], $foldername, true, $priority, $outapi["BlockedCountry"], $outapi["allowedCountry"], $outapi["BlockedIP"], $outapi["allowedIP"]);
            }
        }
        $conn->close();
        return $result;
    }
    public static function RemoveCouontryManagementSubFolder($subfolderid, $priority)
    {
        $sql = "SELECT * FROM " . $GLOBALS['subfolderrules_countrymanagement_tablename'] . " WHERE "
            . $GLOBALS['sfcm_sf_id_fk'] . "=" . $subfolderid;
        $conn = GetConnection();
        $rs = $conn->query($sql);

        $sql2 = "DELETE FROM " . $GLOBALS['subfolderrules_countrymanagement_tablename']
            . " WHERE " . $GLOBALS['sfcm_sf_id_fk'] . "=" . $subfolderid;

        if ($conn->query($sql2) === TRUE) {
            $result = ["status" => "Updated"];
        } else {
            $result = ["status" => "error"];
        }
        if (!$rs || mysqli_num_rows($rs) == 0) {
        } else {
            $requiredData = SUBFOLDERRULES_ADMIN::ReturnAllNeededDataForAPI($subfolderid);
            $dmn = TOOLS_ADMIN::ReturnDomainNameForSubFolder($requiredData);
            $outapi = self::ReturnGeoValueForLocation($subfolderid, "ip");
            $foldername = "";
            if ($requiredData[0]["sf_name"] != "/") {
                $foldername = "/" . $requiredData[0]["sf_name"];
            }

            $df = "no";
            // if ($default == "allow") {
            //     $df = "yes";
            // }
            if ($outapi["allowedCountry"] == "" && $outapi["BlockedCountry"] == "") {
                API_GEO_ADMIN::RunDisableAPIGEO($dmn, $foldername, 0, $priority);
            } else {
                API_GEO_ADMIN::RunCreateAPIGEO($dmn, $df, $outapi["allowedCountry"], $foldername, true, $priority, $outapi["BlockedCountry"], $outapi["allowedCountry"], $outapi["BlockedIP"], $outapi["allowedIP"]);
            }
        }

        $conn->close();
        return $result;
    }
}
