<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/subfolder/subfolder_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/clusters/admin/clusters_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/location/location.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/cache/cache.php';

require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class SUBFOLDER_ADMIN
{
    public static function GetOneSubFolder($websiteid, $token, $sfname)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }

        $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . " WHERE " .
            $GLOBALS['sf_name'] . "='" . $sfname . "' AND "
            . $GLOBALS['sf_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "error", "message" => "آدرس درخواستی شما تکراری است"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }

    public static function InternalGetOneSubFolder($websiteid, $sfname)
    {

        $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . " WHERE " .
            $GLOBALS['sf_name'] . "='" . $sfname . "' AND "
            . $GLOBALS['sf_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "error", "message" => "آدرس درخواستی شما تکراری است"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function InternalAddSubFolder($websiteid, $sfname, $clusterid)
    {
        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite(0, $websiteid);

        $subfolerchecker = SUBFOLDER_ADMIN::InternalGetOneSubFolder($websiteid, $sfname);

        if ($subfolerchecker["status"] == "error") {
            $result = ["status" => "error", "message" => $subfolerchecker["message"]];
            return $result;
        } elseif ($subfolerchecker["status"] == "success") {

            $sql = "INSERT INTO " . $GLOBALS["subfolder_tablename"] . " (" . $GLOBALS['sf_name'] . "," .
                $GLOBALS['sf_cl_id_fk']
                . "," . $GLOBALS['sf_ws_id_fk'] . "," . $GLOBALS['sf_rules'] . ") VALUES('" . $sfname . "'," . $clusterid . "," . $websiteid . ",'')";
            $conn = GetConnection();
            if ($conn->query($sql) === TRUE) {
                if ($clusterid != "0") {
                    $cluster = CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid);
                    $cls = CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid);
                    $m = "";
                    $clustername = "";
                    $clusterprotocol = "";
                    if ($cls["status"] == "inuse") {
                        // return $cluster;
                        if (array_key_exists("data", $cls)) {
                            foreach ($cls["data"] as $l) {
                                $dmn = TOOLS_ADMIN::ReturnDomainNameForCluster($l);
                                $outValue = "";
                                foreach ($cluster["subcluster"] as $m) {
                                    $outValue .=  $m["weight"] . "-" . $m["source"] . "-" . $m["port"] . ";";
                                }
                                $det = substr($outValue, 0, -1);
                                $clusterprotocol = $l["cl_protocol"];
                                $clustername = $l["cl_name"];
                                API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $l["cl_name"], $det, $l["cl_method"], $clusterprotocol);
                            }
                        }
                    }
                }
                if ($clusterid == 0) {
                    $clusterprotocol = "scheme";
                    // $clusterprotocol = "0";
                }
                $clustername = "";
                $dmn = TOOLS_ADMIN::ReturnDomainName($websiteaccess);
                API_LOCATION_ADMIN::RunCreateAPILOCATION($dmn, "/" . $sfname, $clusterprotocol, $clustername);
                // API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, "vqs", "/" . $sfname);

                return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            } else {
                return [
                    "status" => "error", "message" => "خطا در انجام درخواست",
                ];
            }
        }
    }
    public static function GetLastPriority($websiteid)
    {
        $sql = "SELECT MAX(sf_priority ) as newpriority FROM tbl_subfolder where sf_ws_id_fk=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "error"
            ];
            return 5;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return intVal($list[0]["newpriority"]) + 5;
    }
    public static function GetByPriority($priority, $websiteid)
    {
        $sql = "SELECT * FROM tbl_subfolder where sf_ws_id_fk=" . $websiteid . " AND sf_priority=" . $priority;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "unique"
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "duplicate", "id" => $list[0]["subfolder_id"], "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function ChangePriority($token, $websiteid, $folderid, $priority)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        } else {
            $balance = $usersDetails["credit"];
            if ($balance < 0) {
                return [
                    "status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"
                ];
            }
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }

        if (self::GetByPriority($priority, $websiteid)["status"] == "duplicate") {
            return ["status" => "error", "message" => "الویت ارسالی تکراری است"];
        }
        $c = self::GetOneByID($token, $folderid)["data"][0]["sf_priority"];
        $b = self::GetAfterPriorityChange($websiteid, $c, $priority);
        $sfname = self::GetOneByID($token, $folderid)["data"][0]["sf_name"];
        if ($sfname == "/") {
            return ["status" => "error", "message" => "شما امکان تغییر این فولدر را ندارید"];
        }
        $sql = "UPDATE tbl_subfolder set sf_priority=" . $priority . " WHERE subfolder_id=" . $folderid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        $dmn = TOOLS_ADMIN::ReturnDomainName($websiteaccess);
        API_LOCATION_ADMIN::RunChangeAPILocationPriority($dmn, "/" . $sfname, $priority, $b, $c);

        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", $priority, $b, $c];
    }
    public static function AddSubFolder($websiteid, $token, $sfname, $clusterid = 0, $priority)
    {

        $slashcheck = true;
        if (strlen($sfname) != 1) {
            while ($slashcheck) {
                if (substr($sfname, -1) == '/') {
                    $sfname = substr($sfname, 0, strlen($sfname) - 1);
                } else {
                    break;
                }
            }
        }

        $slashcheck = true;
        while (strpos($sfname, '//')) {
            if (strpos($sfname, '//'))
                $sfname = str_replace("//", "/", $sfname);
            else
                $slashcheck = true;
        }
        while (strpos($sfname, "**")) {
            $sfname = str_replace("**", "*", $sfname);
        }

        // if (strpos($sfname, '/.*')) {
        //     $result = ["status" => "error", "message" => "آدرس ارسالی شما نامعتبر است"];
        //     return $result;
        // }
        if (strpos($sfname, './')) {
            $result = ["status" => "error", "message" => "آدرس ارسالی شما نامعتبر است"];
            return $result;
        }

        if (preg_match("/^[A-z0-9\.\*\?%&\/\-]+$/", $sfname)) {
        } else {
            $result = ["status" => "error", "message" => "آدرس ارسالی شما نامعتبر است"];
            return $result;
        }

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            return [
                "status" => "error", "w" => $websiteaccess, "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }
        if ($websiteaccess["data"][0]["d_name"] == $websiteaccess["data"][0]["ws_recordname"]) {
            $lengthofdomain = strlen($websiteaccess["data"][0]["d_name"]);
            if (substr($sfname, 0, $lengthofdomain) == $websiteaccess["data"][0]["d_name"]) {
                $sfname = substr($sfname, $lengthofdomain, strlen($sfname));
            }
        } else {
            $lengthofdomain = strlen($websiteaccess["data"][0]["d_name"] . "." . $websiteaccess["data"][0]["ws_recordname"]);
            if (substr($sfname, 0, $lengthofdomain) == $websiteaccess["data"][0]["d_name"] . "." . $websiteaccess["data"][0]["ws_recordname"]) {
                $sfname = substr($sfname, $lengthofdomain, strlen($sfname));
            }
        }

        if (self::GetByPriority($priority, $websiteid)["status"] == "duplicate") {
            return ["status" => "error", "message" => "الویت ارسالی تکراری است"];
        }

        $planwebsite = $websiteaccess["data"][0]["wsplan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (!isset($plans[$planwebsite]["pagerule"])) {
                return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
            } else {
                $countOfrules = self::GetListByWebsite($token, $websiteid)["count"];
                $countOfRulesInPanel = $plans[$planwebsite]["pagerule"];
                if (intVal($countOfrules) + 1 > intVal($countOfRulesInPanel)) {
                    return ["status" => "error", "message" => "تعداد قوانین مورد استفاده در پلان فعلی شما پایان یافته است و باید پلان خود را ارتقا دهید"];
                }
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }

        $m = "";
        $clustername = "";
        $clusterprotocol = "";


        if ($sfname == "")
            $sfname = "/";

        if ($sfname == "/*")
            $sfname = "*";
        if ($clusterid != "0") {
            $clusteraccess = CLUSTERS_ADMIN::ClusterOne($token, $clusterid);
            if ($clusteraccess["status"] == "error") {
                VARS_ADMIN::ReturnHeadersState(301);
                return [
                    "status" => "error", "message" => $clusteraccess["message"]
                ];
            }
        }

        $subfolerchecker = SUBFOLDER_ADMIN::GetOneSubFolder($websiteid, $token, $sfname);
        if ($subfolerchecker["status"] == "error") {
            $result = ["status" => "error", "message" => $subfolerchecker["message"]];
            return $result;
        } elseif ($subfolerchecker["status"] == "success") {
            if ($clusterid != "0") {
                $clusterDet = CLUSTERSDETAILS_ADMIN::GetClusterWithDetails($token, $clusterid);
                if ($clusterDet["status"] == "error") {
                    return $clusterDet;
                }
            }
            $sql = "INSERT INTO " . $GLOBALS["subfolder_tablename"] . " (" . $GLOBALS['sf_name'] . "," .
                $GLOBALS['sf_cl_id_fk']
                . "," . $GLOBALS['sf_ws_id_fk'] . "," . $GLOBALS['sf_rules'] . ", 	sf_priority ) VALUES('" . $sfname . "'," . $clusterid . "," . $websiteid . ",''," . $priority . ")";
            $conn = GetConnection();
            if ($conn->query($sql) === TRUE) {
                if ($clusterid != "0") {
                    $cluster = CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid);
                    $cls = CLUSTERS_ADMIN::CheckClusterIsInUse($clusterid);
                    $m = "";
                    $clustername = "";
                    $clusterprotocol = "";
                    if ($cls["status"] == "inuse") {
                        return $clusterDet;
                        if (array_key_exists("data", $cls)) {
                            foreach ($cls["data"] as $l) {
                                $dmn = TOOLS_ADMIN::ReturnDomainNameForCluster($l);
                                $outValue = "";
                                foreach ($clusterDet["subcluster"] as $m) {
                                    $outValue .=  $m["weight"] . "-" . $m["source"] . "-" . $m["port"] . ";";
                                }
                                $det = substr($outValue, 0, -1);
                                $clusterprotocol = $l["cl_protocol"];
                                $clustername = $l["cl_name"];
                                API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $l["cl_name"], $det, $l["cl_method"], $clusterprotocol);
                            }
                        }
                    }
                    $id = $conn->insert_id;
                }
                if ($clusterid == 0) {
                    $clusterprotocol = "scheme";
                    // $clusterprotocol = "0";
                }
                $dmn = TOOLS_ADMIN::ReturnDomainName($websiteaccess);
                $after = self::GetAfterPriority($websiteid, $priority);

                API_LOCATION_ADMIN::RunCreateAPILOCATION($dmn, "/" . $sfname, $clusterprotocol, $clustername, $priority, $after);
                // API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, "vqs", "/" . $sfname);

                return ["status" => "success", "priority" => $priority,  "message" => "درخواست شما با موفقیت انجام شد"];
            } else {
                return [
                    "status" => "error", "message" => "خطا در انجام درخواست",
                ];
            }
        }
    }
    public static function GetAfterPriorityChange($website, $current, $new)
    {
        $sql = "SELECT * FROM tbl_subfolder where  	sf_priority <" . $new . "    and sf_priority !=" . $new . " AND sf_priority !=" . $current . " AND sf_ws_id_fk =" . $website . " order by sf_priority desc limit 0,1";

        $conn = GetConnection();
        $result = $conn->query($sql);
        $l = 0;
        if (!$result || mysqli_num_rows($result) == 0) {
            $l = 0;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $l = $list[0]["sf_priority"];
        }
        $result->free_result();
        $conn->close();
        return $l;
    }
    public static function GetAfterPriority($website, $current)
    {
        $sql = "SELECT * FROM tbl_subfolder where  	sf_priority <" . $current . "    and	sf_ws_id_fk =" . $website . " order by sf_priority desc limit 0,1";

        $conn = GetConnection();
        $result = $conn->query($sql);
        $l = 0;
        if (!$result || mysqli_num_rows($result) == 0) {
            $l = 0;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $l = $list[0]["sf_priority"];
        }
        $result->free_result();
        $conn->close();
        return $l;
    }
    public static function GetOneByID($token, $subfolderid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . "," . $GLOBALS["websites_tablename"]
            . "," . $GLOBALS["users_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE
        " . $GLOBALS["wsid"] . "=" . $GLOBALS["sf_ws_id_fk"] . "   and " . $GLOBALS["domain_id"] . "= " . $GLOBALS["ws_domainid_fk"] . "
        and " . $GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " . $GLOBALS['subfolder_id'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این وبسایت را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetListByWebsite($token, $websiteID)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $accessToWebiste = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteID);
        if ($accessToWebiste["status"] == "error") {
            return [
                "status" => "error", "message" => "شما مجوز دسترسی به این سایت را ندارید  "
            ];
        }

        $UserCanAccessToWebsite
            = WEBSITES_ADMIN::UserCanAccessToWebsiteWithToken($_POST['websiteid'], $_POST['token']);
        if ($UserCanAccessToWebsite["status"] == "error") {
            return ["status" => "error", "count" => "0", "message" => "شما امکان دسترسی به این وب سایت را ندارید"];
        }

        $dmn = TOOLS_ADMIN::ReturnDomainName($accessToWebiste);
        $sql = "SELECT sf_priority as priority,ws_recordname as WebsiteName," . $GLOBALS['subfolder_id'] . " as subfolderid," .
            $GLOBALS['sf_name'] . " as URL, " . $GLOBALS['sf_cl_id_fk'] . " as ClusterName,"
            . $GLOBALS['sf_rules'] . " as ActiveRules FROM  tbl_websites," . $GLOBALS["subfolder_tablename"] . "
              WHERE   sf_ws_id_fk = wsid and
         " . $GLOBALS["sf_ws_id_fk"] . "=" . $websiteID . " order by sf_priority desc";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success", "count" => "0", "state" => "201", "message" => "قانونی آدرس فرعی ندارید",

            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $res = [];
            $i = 0;
            foreach ($list as $l) {
                if ($l["ActiveRules"] != "")
                    $m = explode(",", $l["ActiveRules"]);
                else
                    $m = "norules";

                $n = SUBFOLDERRULES_ADMIN::GetSubFolderRulesByDetails($token, $l["subfolderid"]);
                if ($l["URL"] != "/") {
                    $l["URL"] = "/" . $l["URL"];
                }
                $res[$i] = [
                    "subfolderid" => $l["subfolderid"],
                    "URL" =>  $l["URL"],
                    "priority" => $l["priority"],
                    "ClusterName" => $l["ClusterName"],
                    "ActiveRules" => $m,
                    "rulesDetails" => $n
                ];
                $i++;
            }
            $listOfRecordType = [
                "status" => "success", "state" => "200",
                "websitename" => $dmn,
                "count" => count($res),
                "data" => $res
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateFolder($token, $folderID, $sfname)
    {
        $slashcheck = true;

        while ($slashcheck) {
            if (substr($sfname, -1) == '/') {
                $sfname = substr($sfname, 0, strlen($sfname) - 1);
            } else {
                break;
            }
        }
        $slashcheck = true;
        while (strpos($sfname, '//')) {
            if (strpos($sfname, '//'))
                $sfname = str_replace("//", "/", $sfname);
            else
                $slashcheck = true;
        }
        if (strpos($sfname, '/.')) {
            $result = ["status" => "error", "message" => "آدرس ارسالی شما نامعتبر است"];
            return $result;
        }
        if (strpos($sfname, './')) {
            $result = ["status" => "error", "message" => "آدرس ارسالی شما نامعتبر است"];
            return $result;
        }

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $sql = "UPDATE " . $GLOBALS["subfolder_tablename"] . " SET " . $GLOBALS['sf_name'] . "='" . $sfname . "'
                  WHERE " . $GLOBALS["subfolder_id"] . "=" . $folderID;
        $conn = GetConnection();
        if ($conn->query($sql) === TRUE) {
            return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        } else {
            return ["status" => "error", "message" => "خطا در انجام درخواست"];
        }
    }
    public static function CanAccessToSubFolder($subfolderid, $uid)
    {
        $sql = "SELECT *,IF(d_name=ws_recordname, 'maindomain', 'subdomain') as subdomain  FROM " . $GLOBALS["subfolder_tablename"] . "," . $GLOBALS["websites_tablename"]
            . "," . $GLOBALS["users_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE
         " . $GLOBALS["wsid"] . "=" . $GLOBALS["sf_ws_id_fk"] . "   and " . $GLOBALS["domain_id"] . "= " . $GLOBALS["ws_domainid_fk"]
            . " AND " . $GLOBALS["d_user_id_fk"] . "=" . $GLOBALS["uid"] . "

         and " . $GLOBALS["uid"] . "=" . $uid . " AND " . $GLOBALS['subfolder_id'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "sql" => $sql, "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return  $listOfRecordType;
    }
    public static function GetOneID($subfolderid)
    {

        $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . " WHERE " .
            $GLOBALS['subfolder_id'] . "=" . $subfolderid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این وبسایت را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list[0]];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateRules($subfolderid, $rules)
    {

        $sql = "update " . $GLOBALS["subfolder_tablename"] . " SET " . $GLOBALS['sf_rules'] . "='" . $rules . "'
        WHERE " . $GLOBALS["subfolder_id"] . "=" . $subfolderid;
        $conn = GetConnection();
        if ($conn->query($sql) === TRUE) {
            return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        } else {
            return ["status" => "error", "message" => "خطا در انجام درخواست"];
        }
        $conn->close();
    }
    public static function GetListOfSubfolderWithCluster($websiteid, $clusterid)
    {
        $sql = "SELECT * FROM  " . $GLOBALS["subfolder_tablename"] . " WHERE " . $GLOBALS["sf_ws_id_fk"] . "=" . $websiteid . " AND " . $GLOBALS["sf_cl_id_fk"] . "=" . $clusterid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "notinuse"];
        } else {
            $result = ["status" => "inuse", mysqli_fetch_all($result, MYSQLI_ASSOC)];
        }
        $conn->close();
        return $result;
    }
    public static function RemoveSubFolder($websiteid, $token, $id)
    {
        $listOfRecordType = ["status" => "success", "message" => "درخواست شما انجام شد ", "data" => []];

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $accessToWebiste = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($accessToWebiste["status"] == "error") {
            return [
                "status" => "error", "message" => "شما مجوز دسترسی به این سایت را ندارید  "
            ];
        }
        $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . "," . $GLOBALS["websites_tablename"]
            . "," . $GLOBALS["users_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE d_user_id_fk=uid and
        " . $GLOBALS["wsid"] . "=" . $GLOBALS["sf_ws_id_fk"] . "   and " . $GLOBALS["domain_id"] . "= " . $GLOBALS["ws_domainid_fk"] . "
        and " . $GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " . $GLOBALS['subfolder_id'] . "=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "شما اجازه دسترسی به این وبسایت را ندارید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $ruleslist = [];
            //GetALL rules and send Remove
            $allRules = $list[0]["sf_rules"];
            $a = explode(",", $allRules);
            if (count($a) > 0) {
                foreach ($a as $b) {
                    $ruleslist[] = SUBFOLDERRULES_ADMIN::RemoveubFolderRules($id, $token, $b, "", true);
                }
            }



            $sql = "DELETE FROM " . $GLOBALS["subfolder_tablename"] . " WHERE " . $GLOBALS['subfolder_id'] . "=" . $id;
            $result = $conn->query($sql);
            $dmn = TOOLS_ADMIN::ReturnDomainName($accessToWebiste);

            API_LOCATION_ADMIN::RunDisableAPILOCATION($dmn, "/" . $list[0]["sf_name"], "", "", $list[0]["sf_priority"]);
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما انجام شد ", "data" => $list];
        }

        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateSubFolder($websiteid, $token, $id, $clusterid)
    {
        $stat="";
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $accessToWebiste = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);

        if ($accessToWebiste["status"] == "error") {
            return [
                "status" => "error", "message" => "شما مجوز دسترسی به این سایت را ندارید  ",
            ];
        }
        if ($clusterid != "null") {
            $cldet = CLUSTERS_ADMIN::CheckUserCanAccessToCluster($token, $clusterid);
            if ($cldet["status"] == "success") {
                VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "شما امکان استفاده از این کلاستر را ندارید"];
            }

            $planwebsite = $accessToWebiste["data"][0]["wsplan"];
            $plans = ReturnPlans();
            if (isset($plans[$planwebsite])) {
                if (!isset($plans[$planwebsite]["cluster"])) {
                    return ["status" => "error", "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
                }
            } else {
                return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
            }

            $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . "," . $GLOBALS["websites_tablename"]
                . "," . $GLOBALS["users_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE   d_user_id_fk=uid and
        " . $GLOBALS["wsid"] . "=" . $GLOBALS["sf_ws_id_fk"] . "   and " . $GLOBALS["domain_id"] . "= " . $GLOBALS["ws_domainid_fk"] . "
        and " . $GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " . $GLOBALS['subfolder_id'] . "=" . $id . " AND " . $GLOBALS["wsid"] . "=" . $websiteid;
            $conn = GetConnection();
            $result = $conn->query($sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $result = ["status" => "error", "message" => "شما اجازه دسترسی به این مسیر  را ندارید"];
                return $result;
            } else {
                $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت ثبت شد"];
                $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
                // if($list[0]["sf_name"]=="/"){
                //     $cs=self::CheckRecordHasCluster($websiteid);
                //     if($cs["status"]=="error"){
                //         return $cs;
                //     }
                // }

                $sql = "UPDATE " . $GLOBALS["subfolder_tablename"] . " SET " . $GLOBALS["sf_cl_id_fk"] . "=" . $clusterid . " WHERE " . $GLOBALS['subfolder_id'] . "=" . $id;
                $result = $conn->query($sql);
                $dmn = TOOLS_ADMIN::ReturnDomainName($accessToWebiste);
                if ($list[0]["sf_name"] == "/") {
                    CLUSTERSWEBSITE_ADMIN::AddClusterToWebSite($token, $clusterid, $websiteid);
                }

                $cls = CLUSTERS_ADMIN::CheckClusterIsInUseForWebsiteForSubFolderwithoutOwn($list[0]["sf_cl_id_fk"], $websiteid, $id);
                if ($cls["status"] == "notinuse") {
                    $stat = "oldClusterNotInuse";
                    // API_UPSTREAM_ADMIN::RunDisableAPIUPSTREAM($dmn, $cldet["data"]["cluster"][0]["name"]);
                }

                $cls = CLUSTERS_ADMIN::CheckClusterIsInUseForWebsiteForSubFolderwithoutOwn($clusterid, $websiteid, $id);
                $foldername = "";
                if ($cls["status"] == "inuse") {
                    if ($list[0]["sf_name"] != "/")
                        $foldername = "/" . $list[0]["sf_name"];
                    else
                        $foldername = "/";

                    $stat .= ">>>>>>NewClusterInuse";
                    API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION(
                        $dmn,
                        $cldet["data"]["cluster"][0]["name"],
                        $cldet["data"]["cluster"][0]["protocol"],
                        $foldername,
                        $list[0]["sf_priority"]
                    );
                } else {
                    $stat .= ">>>>>>NewClusterNotInuse";

                    $outValue = "";
                    foreach ($cldet["data"]["details"]["data"] as $m) {
                        $outValue .=  $m["weight"] . "-" . $m["source"] . "-" . $m["port"] . ";";
                    }
                    $outValue = substr($outValue, 0, -1);
                    API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, $cldet["data"]["cluster"][0]["name"], $outValue, $cldet["data"]["cluster"][0]["method"], $cldet["data"]["cluster"][0]["protocol"]);
                }
                if ($list[0]["sf_name"] != "/")
                    $foldername = "/" . $list[0]["sf_name"];
                else
                    $foldername = "/";
                API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION(
                    $dmn,
                    $cldet["data"]["cluster"][0]["name"],
                    $cldet["data"]["cluster"][0]["protocol"],
                    $foldername,
                    $list[0]["sf_priority"]
                );

                //API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn,$cldet["data"]["cluster"][0]["name"],$cldet["data"]["cluster"][0]["protocol"],"/".$list[0]["sf_name"]);
                $listOfRecordType = ["stat" => $stat,  "status" => "success", "message" => "درخواست شما با موفقیت ثبت شد ", "data" => $list];
            }
            $conn->close();
            return $listOfRecordType;
        } else {
            $sql = "SELECT * FROM " . $GLOBALS["subfolder_tablename"] . "," . $GLOBALS["websites_tablename"]
                . "," . $GLOBALS["users_tablename"] . "," . $GLOBALS["domains_tablename"] . " WHERE   d_user_id_fk=uid and
        " . $GLOBALS["wsid"] . "=" . $GLOBALS["sf_ws_id_fk"] . "   and " . $GLOBALS["domain_id"] . "= " . $GLOBALS["ws_domainid_fk"] . "
        and " . $GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " . $GLOBALS['subfolder_id'] . "=" . $id . " AND " . $GLOBALS["wsid"] . "=" . $websiteid;
            $conn = GetConnection();
            $result = $conn->query($sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $result = ["status" => "error", "message" => "شما اجازه دسترسی به این مسیر  را ندارید"];
                return $result;
            } else {
                $dmn = TOOLS_ADMIN::ReturnDomainName($accessToWebiste);

                $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
                if ($list[0]["sf_name"] != "/")
                    $foldername = "/" . $list[0]["sf_name"];
                else
                    $foldername = "/";

                $l = CLUSTERSWEBSITE_ADMIN::RemoveClusterFromWebSite($token, 0, $websiteid, "subfolder");

                if ($accessToWebiste["state"] == "withoutrecord") {
                    API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION(
                        $dmn,
                        "mizdef",
                        $accessToWebiste["data"][0]["dnr_value"],
                        $foldername,
                        $list[0]["sf_priority"]
                    );
                    // $m=API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, "mizdef", $websiteowner["data"][0]["dnr_value"] , null);
                } else {
                    API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION(
                        $dmn,
                        "mizdef",
                        "scheme",
                        $foldername,
                        $list[0]["sf_priority"]
                    );
                }
                //   API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn,
                //             "mizdef",
                //             "scheme",
                //             $foldername,
                //             $list[0]["sf_priority"]);

                $sql = "UPDATE " . $GLOBALS["subfolder_tablename"] . " SET " . $GLOBALS["sf_cl_id_fk"] . "=0 WHERE  " . $GLOBALS['subfolder_id'] . "=" . $id;
                $conn->query($sql);
                $conn->close();
                $listOfRecordType = ["stat" => $stat, "l" => $l,  "status" => "success", "message" => "درخواست شما با موفقیت ثبت شد ", "data" => $list];
                return $listOfRecordType;
            }
        }
    }
    public static function InternalUpdateSubFolder($websiteid, $clusterid)
    {
        $sql = "UPDATE " . $GLOBALS["subfolder_tablename"] . " SET " . $GLOBALS["sf_cl_id_fk"] . "=" . $clusterid . " WHERE  sf_ws_id_fk =" . $websiteid . " AND sf_name='/'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $conn->close();
    }
    public static function CheckRecordHasCluster($websiteid)
    {
        $sql = "SELECT * FROM tbl_clusters_websites WHERE cw_ws_id_fk=" . $websiteid;
        $conn = GetConnection();
        $re = $conn->query($sql);
        if (!$re || mysqli_num_rows($re) == 0) {
            return ["status" => "success"];
        } else {
            return ["status" => "error", "message" => "شما برای این دامنه کلاستر اضافه نموده اید و امکان ویرایش ندارید"];
        }
    }
}
