<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class SSLTLS_ADMIN
{
    public static function UpdateTLS($token, $websiteid, $tls)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return [$websitesOwner,"status"=>"error","message" => "شناسه سایت ارسالی نامعتبر است"];
        } else {
             $b=SSLWEBSITES_ADMIN::CheckWebSiteHasSSL($websiteid);
             if($b["status"]=="error"){
                 return ["status"=>"error",$b,"message"=>"شما SSL فعال برای این دامنه ندارید"];
             }
            $valistatus=["default","tlsv1","tlsv1.1","tlsv1.2","tlsv1.3"];
            if(!in_array($tls,$valistatus)){
                    return ["status" => "error", "message" => "وضعیت ارسالی نامعتبر است"];
            }
               $s= self::GetTLSStatus($token,$websiteid);
               $sql="";

               if($s["code"]=="201"){

                   $sql="insert into ".$GLOBALS["ssltls_tablename"]." VALUES(0,'".$websiteid."','".$tls."')";
               }
               else{
                $sql="UPDATE ".$GLOBALS["ssltls_tablename"]." SET ".$GLOBALS['st_status']."='".$tls."' WHERE ".$GLOBALS['st_wid_fk']."=".$websiteid;
               }
               $conn = GetConnection();

              $conn->query($sql);

               $conn->close();

            }

            $tlsvers="";
            if($tls=="default"){
                $tlsvers="1,1.1,1.2,1.3";
            }
                else{
                    $tlsvers=substr($tls,4,strlen($tls));
             }
                  $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
             API_SSL_ADMIN::RunCreateAPITLS($dmn,$tlsvers);
            return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد"];

    }
    public static function RemoveTLS($websiteid)
    {
        $sql="DELETE FROM ". $GLOBALS["ssltls_tablename"] . " WHERE "
            . $GLOBALS['st_wid_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function GetTLSStatus($token, $webid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT  st_status  as tls from " . $GLOBALS["ssltls_tablename"] . " WHERE "
            . $GLOBALS['st_wid_fk'] . "=" . $webid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success","code"=>"201","message"=>"اطلاعات با موفقیت دریافت شد","tls"=>"default"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(400);
            $listOfRecordType = ["status" => "success","code"=>"200", "message" => "اطلاعات با موفقیت دریافت شد", "tls" => $list[0]["tls"] ];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }

}
