<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class RATELIMIT_ADMIN
{
    public static function CheckRatelimitForDownGrade($domainID, $plan, $newplan)
    {

        if (isset(ReturnPlans()[$plan]["ratelimit"])) {
            if (!isset(ReturnPlans()[$newplan]["ratelimit"])) {
                $sql = "SELECT * FROM `tbl_ratelimit_main`,tbl_websites,tbl_domains WHERE rl_wid_fk=wsid and domain_id=ws_domainid_fk and domain_id=" . $domainID;
                $conn = GetConnection();
                $result = $conn->query($sql);
                $listOfrateLimit = mysqli_fetch_all($result, MYSQLI_ASSOC);
                // return $listOfrateLimit;
                if (count($listOfrateLimit) > 0) {
                    foreach ($listOfrateLimit as $l) {
                        $websitename = $l["d_name"];
                        if ($l["d_name"] != $l["ws_recordname"])
                            $websitename = $l["ws_recordname"] . "." . $l["d_name"];
                        return ["status" => "error", "message" => "شما برای سایت " .
                            $websitename .
                            " RateLimit ایجاد کرده اید که در پلان جدید امکان استفاده از آن را ندارید"];
                    }
                }
            }
        }
        return ["status" => "success"];
    }
    public static function GetWebsiteRateLimit($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["ratelimit_tablename"] .
            " WHERE " . $GLOBALS["rl_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $rangeips = $r[0]["rlipranges"];
            $rgip = [];
            $ips = explode(",", $rangeips);
            foreach ($ips as $ip) {
                array_push($rgip, $ip);
            }
            unset($r[0]["rlipranges"]);
            $r[0]["rangeips"] = $rgip;
            //  // array_push($r,$rgip);
            $listOfRecordType = [
                "status" => "success", "code" => "200",
                "data" => $r[0]
            ];
            $conn->close();
        }

        return $listOfRecordType;
    }
    public static function UpdateWebsiteRateLimit($token, $websiteid, $rtimeformat, $rate, $burst, $burstcount, $ipranges, $desc)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $planwebsite = $websitesOwner["data"][0]["wsplan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (!isset($plans[$planwebsite]["ratelimit"])) {
                return [
                    "status" => "error", "action" => "needtoupgrade",
                    "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید "
                ];
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }

        if ($rtimeformat == "s" ||   $rtimeformat == "m") {
            if (is_numeric($rate)) {
                if ($burst == "true" || $burst == "false") {
                    if (is_numeric($burstcount)) {
                        if ($ipranges != "") {
                            $ips = explode(",", $ipranges);
                            $ips=array_unique($ips);
                            $res = [];
                            $stat = 1;
                            $success_array = [];
                            foreach ($ips as $ip) {
                                if (strpos($ip, '/')) {
                                    $nip = explode("/", $ip);
                                    if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                                        $stat = 0;
                                        $out["status"] = "error";
                                        array_push(
                                            $res,
                                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                                        );
                                    }
                                } else {
                                    if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                                        $stat = 0;
                                        $out["status"] = "error";
                                        array_push(
                                            $res,
                                            ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                                        );
                                    }
                                }
                            }

                            if ($stat == 0) {
                                return ["status" => "error", "خطا در IPهای ارسالی ", "data" => $res];
                            }
                            $ipranges=implode(",",$ips);
                        }
                        $sql = "SELECT * FROM " . $GLOBALS["ratelimit_tablename"] .
                            " WHERE " . $GLOBALS["rl_wid_fk"] . "=" . $websiteid;
                        $conn = GetConnection();
                        $result = $conn->query($sql);
                        $rname = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"] . "_ratelimit";
                        if (!$result || mysqli_num_rows($result) == 0) {
                            $ins = "INSERT INTO " . $GLOBALS["ratelimit_tablename"] . " (" . $GLOBALS['rlname'] . "," . $GLOBALS['rltimerate'] . "," . $GLOBALS['rlrate'] . "," .
                                $GLOBALS['rlburst'] . "," . $GLOBALS['rlburstcount'] . "," . $GLOBALS['rlipranges'] . "," . $GLOBALS['rl_wid_fk'] . "," . $GLOBALS['rl_desc'] . ")
                                                            VALUE ('" . $rname . "','" . $rtimeformat . "'," . $rate . "," . $burst . "," . $burstcount . ",'" . $ipranges . "'," . $websiteid . ",'" . $desc . "')";
                        } else {
                            $ins = "UPDATE " . $GLOBALS["ratelimit_tablename"] . " SET " .
                                $GLOBALS['rlname'] . "='" . $rname . "'," . $GLOBALS['rltimerate'] . "='" . $rtimeformat . "'," .
                                $GLOBALS['rlrate'] . "=" . $rate . "," . $GLOBALS['rlburst'] . "=" . $burst . "," .
                                $GLOBALS['rlburstcount'] . "=" . $burstcount . "," . $GLOBALS['rlipranges'] . "='" . $ipranges . "'," . $GLOBALS['rl_desc'] . "='" . $desc . "' WHERE " . $GLOBALS['rl_wid_fk'] . "=" . $websiteid;
                            $listOfRecordType = [
                                "status" => "success", "code" => "201",
                                "message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
                            ];
                        }
                        $conn->query($ins);
                        $conn->close();
                        $ip = str_replace(",", ";", $ipranges);
                        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
                        $brs = 10;
                        if ($burst == "true")
                            $brs = $burstcount;

                        $rname = str_replace(".", "_", $rname);
                        API_RATELIMIT_ADMIN::RunCreateAPIRATELIMIT($dmn, $rname, $rate, $rtimeformat, $brs, "null", $ip,0);
                        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    } else {
                        return ["status" => "error", "message" => "مقدار ارسالی برای ایجاد محدودیت در تعداد درخواست همزمان باید عدد باشد "];
                    }
                } else {
                    return ["status" => "error", "message" => "مقدار ارسالی برای Burst اشتباه است "];
                }
            } else {
                return ["status" => "error", "message" => "مقدار ارسالی برای ایجاد محدودیت در تعداد درخواست باید عدد باشد "];
            }
        } else {
            return ["status" => "error", "message" => "مقدار ارسالی برای فرمت زمانی نامعتبر است"];
        }
    }
    public static function RemoveRateLimit($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["ratelimit_tablename"] .
            " WHERE " . $GLOBALS["rl_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $sql = "DELETE  FROM " . $GLOBALS["ratelimit_tablename"] .
                " WHERE " . $GLOBALS["rl_wid_fk"] . "=" . $websiteid;
            $result = $conn->query($sql);
            $conn->close();
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            $r[0]["rlname"] = str_replace(".", "_", $r[0]["rlname"]);
            API_RATELIMIT_ADMIN::RunDisableAPIRATELIMIT($dmn, $r[0]["rlname"],0);

            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        }

        return $listOfRecordType;
    }
}
