<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class RATELIMIT_NEW_ADMIN
{
	public static function CheckRatelimitForDownGrade($domainID, $plan, $newplan)
	{

		if (isset(ReturnPlans()[$plan]["ratelimit"])) {
			if (!isset(ReturnPlans()[$newplan]["ratelimit"])) {
				$sql = "SELECT * FROM `tbl_ratelimit_new`,tbl_websites,tbl_domains
				WHERE rln_wid_fk=wsid and domain_id=ws_domainid_fk and domain_id=" . $domainID;
				$conn = GetConnection();
				$result = $conn->query($sql);
				$listOfrateLimit = mysqli_fetch_all($result, MYSQLI_ASSOC);
				// return $listOfrateLimit;
				if (count($listOfrateLimit) > 0) {
					foreach ($listOfrateLimit as $l) {
						$websitename = $l["d_name"];
						if ($l["d_name"] != $l["ws_recordname"])
							$websitename = $l["ws_recordname"] . "." . $l["d_name"];
						return ["status" => "error", "message" => "شما برای سایت " .
							$websitename .
							" RateLimit ایجاد کرده اید که در پلان جدید امکان استفاده از آن را ندارید"];
					}
				}
			}
		}
		return ["status" => "success"];
	}
	public static function GetWebsiteRateLimit($token, $websiteid)
	{

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
		if ($websitesOwner["status"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}

		$sql = "SELECT * FROM " . $GLOBALS["newratelimit_tablename"] .
			" WHERE " . $GLOBALS["rln_wid_fk"] . "=" . $websiteid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$listOfRecordType = [
				"status" => "success", "code" => "201",
				"message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
			];
			$conn->close();
		} else {
			$r = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$rangeips = $r[0]["rln_ips"];
			$rgip = [];
			$ips = explode(",", $rangeips);
			foreach ($ips as $ip) {
				array_push($rgip, $ip);
			}
			unset($r[0]["rln_ips"]);
			$r[0]["rangeips"] = $rgip;
			//  // array_push($r,$rgip);
			$listOfRecordType = [
				"status" => "success", "code" => "200",
				"data" => $r[0]
			];
			$conn->close();
		}

		return $listOfRecordType;
	}
	public static function UpdateWebsiteRateLimit(
		$token,
		$websiteid,
		$rln_requestcount,
		$rln_timerate,
		$rln_timeformat,
		$rln_blockedbytimerange,
		$rln_ips,
		$rln_blockedbytimeformat,
		$rln_description
	) {
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$balance = $usersDetails["credit"];
		if ($balance < 0) {
			return [
				"status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"
			];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
		if ($websitesOwner["status"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}

		$planwebsite = $websitesOwner["data"][0]["wsplan"];
		$plans = ReturnPlans();
		if (isset($plans[$planwebsite])) {
			if (!isset($plans[$planwebsite]["ratelimit"])) {
				return [
					"status" => "error",
					"action" => "needtoupgrade",
					"message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید "
				];
			}
		} else {
			return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
		}

		if ($rln_timeformat != "s" &&  $rln_timeformat != "m" &&  $rln_timeformat != "h") {
			return ["status" => "error", "message" => "فرمت زمان ارسالی نامعتبر است"];
		}
		if (!is_numeric($rln_requestcount) || !is_numeric($rln_timerate) || !is_numeric($rln_blockedbytimerange)) {
			return ["status" => "error", "message" => "فرمت اعداد ارسالی نامعتبر است"];
		}
		$ips = explode(",", $rln_ips);
		$ips = array_unique($ips);
		$res = [];
		$stat = 1;
		$success_array = [];
		foreach ($ips as $ip) {
			if (strpos($ip, '/')) {
				$nip = explode("/", $ip);
				return ["status" => "error", "message" => "IP ارسالی نمی تواند شامل رنج باشد"];

				if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
					$stat = 0;
					$out["status"] = "error";
					return	["status" => "error", "message" => "IP نامعتبر است"];
				}
			} else {
				if (!filter_var($ip, FILTER_VALIDATE_IP)) {
					$stat = 0;
					return	["status" => "error", "message" => "IP نامعتبر است"];
				}
				$ipranges = implode(",", $ips);
			}
			$sql = "SELECT * FROM " . $GLOBALS["newratelimit_tablename"] .
				" WHERE " . $GLOBALS["rln_wid_fk"] . "=" . $websiteid;
			$conn = GetConnection();
			$result = $conn->query($sql);
			$ins = "UPDATE " . $GLOBALS["newratelimit_tablename"] . " SET " .
				$GLOBALS['rln_ips'] . "='" . $rln_ips . "'," . $GLOBALS['rln_description'] . "='" . $rln_description . "'," .
				$GLOBALS['rln_requestcount'] . "='" . $rln_requestcount . "'," . $GLOBALS['rln_timerate'] . "='" . $rln_timerate . "'," .
				$GLOBALS['rln_timeformat'] . "='" . $rln_timeformat . "'," . $GLOBALS['rln_blockedbytimerange'] . "='" . $rln_blockedbytimerange
				. "'," . $GLOBALS['rln_blockedbytimeformat'] . "='" . $rln_blockedbytimeformat . "' WHERE " . $GLOBALS['rln_wid_fk'] . "=" . $websiteid;

			if (!$result || mysqli_num_rows($result) == 0) {
				$ins = "INSERT INTO " . $GLOBALS["newratelimit_tablename"]
					. " (rln_id," .
					$GLOBALS['rln_ips'] . "," . $GLOBALS['rln_description'] . "," .
					$GLOBALS['rln_requestcount'] . "," . $GLOBALS['rln_timerate'] . "," .
					$GLOBALS['rln_timeformat'] . "," . $GLOBALS['rln_blockedbytimerange'] . "," .
					$GLOBALS['rln_blockedbytimeformat'] . "," . $GLOBALS['rln_wid_fk'] . ")
                VALUE (0,'" . $rln_ips . "','" . $rln_description . "','" . $rln_requestcount . "','" .
					$rln_timerate . "','" . $rln_timeformat . "','" . $rln_blockedbytimerange . "','" .
					$rln_blockedbytimeformat . "','" . $websiteid . "')";
			}
			$conn->query($ins);
			$conn->close();
			$ip = str_replace(",", ";", $ipranges);
			$dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
			$rate = $rln_requestcount . "r/" . $rln_timeformat;

			$blockedTime = $rln_blockedbytimerange;
			if ($rln_blockedbytimeformat != "s")
				$blockedTime = intVal($rln_blockedbytimerange) * 60;
			switch ($rln_blockedbytimeformat) {
				case "m":
					$blockedTime = intVal($rln_blockedbytimerange) * 60;
					break;
				case "h":
					$blockedTime = intVal($rln_blockedbytimerange) * 3600;
					break;
			}

			API_RATELIMIT_NEW_ADMIN::RunCreateAPIRATELIMIT(
				$dmn,
				$rate,
				$blockedTime,
				"null",
				$ip,
				0
			);
			return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
		}
	}
	public static function RemoveRateLimit($token, $websiteid)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			 			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
		if ($websitesOwner["status"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
		}

		$sql = "SELECT * FROM " . $GLOBALS["newratelimit_tablename"] .
			" WHERE " . $GLOBALS["rln_wid_fk"] . "=" . $websiteid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$listOfRecordType = [
				"status" => "success", "code" => "201",
				"message" => "شما تنظیماتی برای محدودیت تعداد درخواست ایجاد نکرده اید "
			];
			$conn->close();
		} else {
			$r = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$sql = "DELETE  FROM " . $GLOBALS["newratelimit_tablename"] .
				" WHERE " . $GLOBALS["rln_wid_fk"] . "=" . $websiteid;
			$result = $conn->query($sql);
			$conn->close();
			$dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
			// $r[0]["rlname"] = str_replace(".", "_", $r[0]["rlname"]);
			// API_RATELIMIT_ADMIN::RunDisableAPIRATELIMIT($dmn, $r[0]["rlname"], 0);
			API_RATELIMIT_ADMIN::RunDisableAPIRATELIMIT($dmn, "null", 0);

			$listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
		}

		return $listOfRecordType;
	}
}
