<?php
require_once '../../../include/vars.php';
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class HIDEHEADER_ADMIN
{

    public static function GetWebsiteHideHeader($token, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $sql = "SELECT hh_name as HeaderName,hh_id as HeaderID FROM " . $GLOBALS["hideheader_tablename"] .
            " WHERE " . $GLOBALS["hh_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعاتی جهت نمایش وجود ندارد"
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $r
            ];
            $conn->close();
        }
        return $listOfRecordType;
    }

    public static function UpdateWebsiteHideHeader($token, $websiteid, $headername)
    {
        $reservedHeader_array = [
            "server", "mc-cache", "mc-cache-status", "country", "request-Country",
            "request-IP", "mc-id", "mc-eid"
        ];
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $name = strtolower($headername);
        $name = TOOLS_ADMIN::seo_friendly_url($name);
        $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
        if (in_array($headername, $reservedHeader_array)) {
           return ["status" => "error", "message" => "مقدار ارسالی برای نام هدر نامعتبر است"];
        } else {
            $sql = "SELECT * FROM " . $GLOBALS["hideheader_tablename"] .
                " WHERE " . $GLOBALS["hh_name"] . "='" . $headername . "'";
            $conn = GetConnection();
            $result = $conn->query($sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $ins = "INSERT INTO " . $GLOBALS["hideheader_tablename"] . " (" . $GLOBALS['hh_name'] ."," . $GLOBALS['hh_wid_fk'] . ")
                                VALUE ('" . $headername . "','" . $websiteid . "')";
            } else {
              return ["status" => "error", "message" => "نام هدر ارسالی شما تکراری است"];
            }
            $conn->query($ins);
            $conn->close();
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_HIDEHEADER_ADMIN::RunCreateAPIHIDEHEADER($dmn,$headername,"null");
            return     ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
        }
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
    }

    public static function RemoveHideHeader($token, $websiteid, $headerid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        $sql = "SELECT * FROM " . $GLOBALS["hideheader_tablename"] .
            " WHERE " . $GLOBALS["hh_id"] . "=" . $headerid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $conn->close();
        } else {
            $res=mysqli_fetch_all($result,MYSQLI_ASSOC);
            $sql = "DELETE  FROM " . $GLOBALS["hideheader_tablename"] .
                " WHERE " . $GLOBALS["hh_id"] . "=" . $res[0]["hh_id"];
            $result = $conn->query($sql);
            $conn->close();
            $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);
            API_HIDEHEADER_ADMIN::RunDisableAPIHIDEHEADER($dmn, $res[0]["hh_name"],"null");
        }
        return $listOfRecordType;
    }
}
