<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/freessl/freessl_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/sslwebsites/admin/sslwebsites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';
class FREESSL_ADMIN
{
    public static function GetcertificateFromEdgeServers($websitename, $certificate, $privatekey, $expireDate)
    {
    }
    public static function DeleteFreeSSL($fsid)
    {
        $sql = "DELETE FROM tbl_freessl where freessl_id=" . $fsid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function DeleteGotErrorFreeSSL($fsid)
    {
        $sql = "SELECT * FROM tbl_freessl where freessl_id=" . $fsid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error",  "message" => "شما SSL ثبت نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = ["status" => "success", "message" => "لیست سایت ها با موفقیت دریافت شد", "data" => $list];
        }

        $result->free_result();

        SSLWEBSITES_ADMIN::HTTPToHTTPSStaus("12", $list[0]["fs_websiteid"], 'forcehttp');

        $sql = "DELETE FROM tbl_freessl where freessl_id=" . $fsid;
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function DeleteExpiredSSL()
    {
        $now = date("Y/m/d H:i:s");

        $sql = "DELETE FROM tbl_ssl_pools where   sp_expiredate < '" . $now . "'";
        return $sql;
    }
    public static function CheckCertificateValid($websiteid)
    {
        $sql = "SELECT * FROM tbl_freessl where fs_websiteid=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = [];
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success", "action" => "new"];
            return $result;
        } else {

            $l = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $m = [];
            $i = 0;
            foreach ($l as $c) {
                if ($c["fs_cert"] == " ") {
                    $date = strtotime($c["fs_expiredate"]);
                    $date = strtotime("+10 minutes", $date);
                    $r = date('Y/m/d H:i:s', $date);
                    $now =      date("Y/m/d H:i:s");

                    if ($now < $r) {
                        $listOfRecordType = [
                            "status" => "error", "expiredate" => $r,
                            "ssl" => $c["fs_expiredate"], "action" => "wait", "now" => $now, "ssltime" => $c["fs_expiredate"], "pplusseven" => $r, "c" => $c
                        ];
                    } else {
                        self::DeleteFreeSSL($c["freessl_id"]);
                        //   $m[$i]= ["action"=>"delete","now"=>$now,"ssltime"=>$c["fs_expiredate"],"pplusseven"=>$r,"c"=>$c];
                    }
                } else {
                    $date = strtotime($c["fs_expiredate"]);
                    $date = strtotime("-7 day", $date);
                    $r = date('Y/m/d H:i:s', $date);
                    $now =      date("Y/m/d H:i:s");

                    $m[$i] = ["action" => "ok", "now" => $now, "ssltime" => $c["fs_expiredate"], "pplusseven" => $r, "c" => $c];
                    if ($now < $r) {
                        $listOfRecordType =  $m[$i] = ["status" => "error", "action" => "verified", "expiredate" => $r, "ssl" => $c["fs_expiredate"], "l" => $c];
                    } else {
                        $listOfRecordType =  $m[$i] = ["status" => "success", "expiredate" => $r, "action" => "renew", "ssl" => $c["fs_expiredate"]];
                    }
                }
                $i++;
            }
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    private static function AddCertificateRequest($websiteid)
    {
        $expiredate =  date('Y-m-d H:i:s');
        $date =  date('Y-m-d');
        $exp =  date('Y-m-d  H:i:s', strtotime('-30 minutes'));
        $sql = "SELECT * FROM tbl_freessl_request where fsr_wid=" . $websiteid . " AND fsr_date LIKE '" . $date . "%'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $sql = "INSERT INTO  tbl_freessl_request VALUES (0," . $websiteid . ",'" . $expiredate . "')";
            $conn->query($sql);
            $listOfRecordType = ["status" => "success", $sql];
        } else {
            $l = mysqli_fetch_all($result, MYSQLI_ASSOC);
            if (count($l) < 3) {
                $sql = "SELECT * FROM tbl_freessl_request where fsr_wid=" . $websiteid . " AND fsr_date BETWEEN '" . $exp . "' and '" . $expiredate . "'";
                $rs = $conn->query($sql);
                if (!$rs || mysqli_num_rows($rs) == 0) {
                    $listOfRecordType = ["status" => "success", $sql];
                    $sql = "INSERT INTO  tbl_freessl_request VALUES (0," . $websiteid . ",'" . $expiredate . "')";
                    $conn->query($sql);
                } else if(mysqli_num_rows($rs)==1) {
					$listOfRecordType = ["status" => "success", $sql];
                    $sql = "INSERT INTO  tbl_freessl_request VALUES (0," . $websiteid . ",'" . $expiredate . "')";
                    $conn->query($sql);
				}else{
                    $listOfRecordType = ["status" => "error", "message" => "حداقل فاصله زمانی بین دو درخواست  30 دقیقه است"];
                }
            } else {
                $listOfRecordType = ["status" => "error", "message" => "تعداد دفعات مجاز درخواست شما بیش از حد میباشد  لطفا جهت دریافت SSL رایگان با بخش فنی در ارتباط باشید"];
            }
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CopyToFile($websiteid)
    {
        $sql = "SELECT * FROM tbl_freessl,tbl_websites  where wsid=fs_websiteid and fs_websiteid=" . $websiteid . " ORDER BY freessl_id desc LIMIT 0,1";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $l = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByWithoutID($websiteid);
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        $path =  $GLOBALS["RootFiles"] . '/ssl/' .   $dmn;
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $file = fopen($path . '/' .  $dmn  . ".crt", "w");
        fwrite($file, $l["fs_cert"]);
        fclose($file);

        $file = fopen($path . '/' .  $dmn  . ".key", "w");
        fwrite($file, $l["fs_privatekey"]);
        fclose($file);

        $file = fopen($path . '/' . $dmn . ".ca", "w");
        fwrite($file, $l["fs_cabundle"]);
        fclose($file);
    }
    public static function AddCertificateToPools($token, $websiteid)
    {
        $now =   date("Y/m/d H:i:s");
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["data"][0]["d_status"] != "1") {
            return ["status" => "error", "message" => "وضعیت دامنه شما فعال نیست و نمیتوانید از SSL رایگان استفاده نمایید"];
        }
        if ($websitesOwner["data"][0]["d_status"] != 1) {
            return ["status" => "error", "message" => "دامنه شما در وضعیت فعال نیست و امکان دریافت SSL رایگان ندارید"];
        }
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است "];
        } else {
            if ($websitesOwner["data"][0]["subdomain"] == "subdomain") {
                $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
                $alterdmn = "*." . $dmn;
            } elseif ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
                $dmn =  $websitesOwner["data"][0]["d_name"];
                $alterdmn = "*." . $dmn;
            }
            $b = self::CheckCertificateValid($websiteid);
            if (isset($b["c"]) &&  $b["c"]["fs_cert"] != " " && $b["status"] == "error") {
                $crtinfo = openssl_x509_parse($b["l"]["fs_cert"]);
                $certinfo = [
                    "data" => [[
                        "sp_domain" => $crtinfo["subject"]["CN"],
                        "sp_issuername" => $crtinfo["issuer"]["O"],
                        "sp_altdomain" => $crtinfo["extensions"]["subjectAltName"],
                        "sp_expiredate" => date("Y/m/d H:i:s", $crtinfo["validTo_time_t"]),

                    ]]
                ];
                $id = $b["l"]["fs_sp_id_fk"];
                $a = SSLWEBSITES_ADMIN::AddCertificateToWebSite($token, $id, $websiteid, "bothactive", 0);
                $s = SSLWEBSITES_ADMIN::ChangeSiteBetweenDedCertOrFree($websiteid, 0, "bothactive");
                $r = API_SSL_ADMIN::RunCreateAPISSL($dmn, $b["l"]["fs_privatekey"], $b["l"]["fs_cert"], $b["l"]["fs_cabundle"], $websiteid);
                return [
                    "status" => "success", "cert" => $certinfo, "message" => "درخواست شما با موفقیت انجام شد"
                ];
            }
            $canTry = self::AddCertificateRequest($websiteid);
            if ($canTry["status"] == "error") {
                return $canTry;
            }
            $spname = $websitesOwner["data"][0]["d_name"] . "(" . $now . ")"; //TOOLS_ADMIN::encrypt($websitesOwner["data"][0]["wsid"]);
            $domainid = $websitesOwner["data"][0]["domain_id"];
            $poolsdet = SSLPOOLS_ADMIN::AddFreeCertificateToPools(
                $uid,
                $spname,
                $websitesOwner["data"][0]["d_name"],
                $alterdmn,
                $domainid
            );
            $id = $poolsdet["id"];
            $sql = "INSERT INTO " . $GLOBALS["freessl_tablename"] . " (" .
                $GLOBALS['fs_websiteid'] . "," . $GLOBALS['fs_sp_id_fk'] . "," . $GLOBALS['fs_cert'] . "
                ," . $GLOBALS['fs_privatekey'] . "
                ," . $GLOBALS['fs_cabundle'] . "
                ," . $GLOBALS['fs_expiredate'] .
                ") VALUES(%s,%s,'%s','%s','%s','%s')";
            $sql = sprintf($sql, $websiteid, $id, ' ', ' ', ' ', $now);
            //  SSLWEBSITES_ADMIN::AddCertificateToWebSite($token,$id,$websiteid,"bothactive","0");
            $conn = GetConnection();
            $result = $conn->query($sql);
            $fsid = $conn->insert_id;
            $conn->close();
            $r = API_SSL_ADMIN::RunCreateAPIFREESSL($dmn, $id, $fsid, $websitesOwner["data"][0]["d_name"]);
            // $m = substr($r, 1, strlen($r) - 1);
            // $n = json_decode($m, true);
            // if ($n === null && json_last_error() !== JSON_ERROR_NONE) {
            //     return ["status" => "error", "message" => "خطا در ارتباط لطفا دقایقی دیگر تلاش نمایید"];
            // }
            // if ($n["status"] == "failed") {
            //     return ["status" => "error", "message" => "خطا در انجام درخواست شما"];
            // }
            $a = SSLWEBSITES_ADMIN::AddCertificateToWebSite($token, $id, $websiteid, "bothactive", 0);
            $listOfRecordType = ["status" => "success", "a" => $a, "message" =>
            "درخواست شما با موفقیت انجام شدو می توانید SSL را به سایت مد نظر خوداضافه نمایید"];
            return $listOfRecordType;
        }
    }
    public static function UpdateDataFromApi($cabundle, $cert, $privatekey, $poolid, $fsid, $expiredate)
    {

        // $expiredate =  date('Y-m-d  H:i:s', strtotime('+90 days'));
        $sql1 = "UPDATE " . $GLOBALS["freessl_tablename"] . " SET fs_cert='" . $cert . "',fs_privatekey='" . $privatekey . "',
        fs_cabundle='" . $cabundle . "',fs_expiredate='" . $expiredate . "' where freessl_id=" . $fsid;
        $conn = GetConnection();
        $conn->query($sql1);
        $conn->close();

        $sql2 = "UPDATE  tbl_ssl_pools SET sp_expiredate ='" . $expiredate . "'  where sslpoolsid=" . $poolid;
        $conn = GetConnection();
        $conn->query($sql2);

        $conn->close();

        $websiteid = self::GetOneByID($fsid)["data"]["fs_websiteid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByWithoutID($websiteid);
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }

        $path =  $GLOBALS["RootFiles"] . '/ssl/' . $dmn;
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        $file = fopen($path . '/' . $dmn . ".crt", "w");
        fwrite($file, $cert);
        fclose($file);

        $file = fopen($path . '/' . $dmn . ".key", "w");
        fwrite($file, $privatekey);
        fclose($file);

        $file = fopen($path . '/' . $dmn . ".ca", "w");
        fwrite($file, $cabundle);
        fclose($file);

        $a =  API_SSL_ADMIN::RunCreateAPISSL($dmn, $privatekey, $cert, $cabundle, $websiteid);
        $websiteid = self::GetOneByID($fsid)["data"]["fs_websiteid"];
        SSLWEBSITES_ADMIN::InternalAddCertificateToWebSite($poolid, $websiteid, "bothactive", 0);
        return [$a, self::GetOneByID($fsid), $websitesOwner, $dmn, $privatekey, $cert, $cabundle];
    }
    public static function GetOneByID($id)
    {
        $sql = "SELECT * FROM `tbl_freessl` WHERE freessl_id=" . $id;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success", $sql];
            return $result;
        } else {

            $l = mysqli_fetch_array($result, MYSQLI_ASSOC);

            $listOfRecordType = ["status" => "error", "data" => $l];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CheckPoolidExist($poolid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["freessl_tablename"] . " WHERE "
            . $GLOBALS['fs_websiteid'] . "=" . $poolid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success", $sql];
            return $result;
        } else {

            $listOfRecordType = ["status" => "error"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function CanAccessToPoolid($poolid, $uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid . " AND " . $GLOBALS['sp_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
}
