<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/domains/domains_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/usernameservers/admin/usernameservers_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/getdomainsrecord/admin/getdomainsrecord_admin_class.php';

class DOMAINS_ADMIN
{
	public static function GetListOfDomainsForUsers($uid)
	{
		if (count($uid) == 0) {
			return;
		} else {
			$where = "";
			$i = 0;
			foreach ($uid as $u) {
				if ($i == 0)
					$where .= " AND (uid=" . $u["uid"];
				else
					$where .= " OR uid=" . $u["uid"];
				$i++;
			}
			$sql = "SELECT * FROM tbl_domains,tbl_users WHERE d_user_id_fk=uid AND d_status!=2 " . $where . ")";
			$conn = GetConnection();
			$result = $conn->query($sql);
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			return $listOfRecordType;
		}
	}
	public static function GetListOfDomainsbyuid($uid)
	{
		$sql = "SELECT * FROM tbl_domains,tbl_users WHERE d_user_id_fk=uid AND d_status!=2 AND uid= " . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		return $listOfRecordType;
	}
	public static function CheckDomainIDandName($domainid, $domainname, $domaintoken)
	{
		$sql = "SELECT * FROM " . $GLOBALS['domains_tablename'] ." WHERE domain_id='" .	$domainid ."'";//" AND d_status=3";
		$conn = GetConnection();

		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$result->free_result();
		$conn->close();
		if (count($listOfRecordType )== 0) {
			// VARS_ADMIN::ReturnHeaders(200);
			$response = ["status" => "error", ];
		} else {
			$response = ["status" => "success",];
		}
		return $response;
	}
	public static function UpdateSec($id, $sec, $pubkey)
	{

		$sql = "UPDATE " . $GLOBALS["tbl_dns_dnssec"] .
			" SET ddsec='" . $sec . "', dd_publickey='" . $pubkey . "' WHERE " . $GLOBALS["dd_did_fk"] . "= " . $id;
		$conn = GetConnection();
		$conn->query($sql);

		$conn->close();
		return  $sql;
	}
	public static function GetStatusDNSSecInternal($domainid, $token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(301);
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$s = self::CheckDomainOwnerID($domainid, $uid);
		if ($s["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"];
		}
		$sql = "SELECT ddsec  as seckey,ddid as id, dd_status  as status,dd_publickey as pubkey FROM " . $GLOBALS["tbl_dns_dnssec"] .
			" WHERE " . $GLOBALS["dd_did_fk"] . "= " . $domainid;
		$conn = GetConnection();

		$result = $conn->query($sql);

		if (!$result || mysqli_num_rows($result) == 0) {
			$expsession = jDateTime::date("Y/m/d H:i:s");
			//  $s = CLOUD_LOG_ADMIN::ADDLog($expsession." : " . $sql . "; " .   "get sec");
			// $s = CLOUD_LOG_ADMIN::ADDLog($expsession . "  : " . $sql . "; ",  "get sec");

			return ["status" => "error"];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

			//iranmizbanhost.net. IN DS 27691 13 2 4d22efe41ac17d7e05b6d5f5ccd398cf8a704afd185aa723071cfe36421cf088
			$out = [];
			$m = explode(" ", $listOfRecordType[0]["seckey"]);
			// if(count($m)!=8){
			//     return ["status"=>"error",$m,"message"=>"خطا در مقادیر ورودی"];
			// }
			$out["DS"] = $listOfRecordType[0]["seckey"];
			$out["Digest"] = $m[6] ?? "";
			$out["Digest_Type"] = $m[5] ?? "";
			$out["Algorithm"] = "SHA-256";
			$out["Public_Key"] = $listOfRecordType[0]["pubkey"];
			$out["Key_Tag"] = $m[4] ?? "";
			$out["Flags"] = "257 (KSK)";
			$out["seckey"] = $listOfRecordType[0]["pubkey"];
			$out["status"] = $listOfRecordType[0]["status"];

			return [
				"status" => "success",
				"message" => "درخواست شما با موفقیت انجام شد",

				"data" => $out
			];
		}
		$conn->close();
	}
	public static function GetStatusDNSSec($domainid, $token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(301);
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$s = self::CheckDomainOwnerID($domainid, $uid);
		if ($s["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"];
		}
		$sql = "SELECT ddsec  as seckey,ddid as id, dd_status  as status,dd_publickey as pubkey from " . $GLOBALS["tbl_dns_dnssec"] .
			" WHERE " . $GLOBALS["dd_did_fk"] . "= " . $domainid;
		$conn = GetConnection();

		$result = $conn->query($sql);

		if (!$result || mysqli_num_rows($result) == 0) {
			$expsession = jDateTime::date("Y/m/d H:i:s");
			//  $s = CLOUD_LOG_ADMIN::ADDLog($expsession." : " . $sql . "; " .   "get sec");
			// $s = CLOUD_LOG_ADMIN::ADDLog($expsession . "  : " . $sql . "; ",  "get sec");

			return [
				"status" => "success", "d" => "deleted", "data" =>
				[
					"DS" => "updating", "Digest" => "", "Digest_Type" => "", "Algorithm" => "SHA-256", "Public_Key" => "updating", "Key_Tag" => "", "Flags" => "257 (KSK)",
					"seckey" => "updating", "status" => "1"
				]
			];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

			//iranmizbanhost.net. IN DS 27691 13 2 4d22efe41ac17d7e05b6d5f5ccd398cf8a704afd185aa723071cfe36421cf088
			$out = [];
			$m = explode(" ", $listOfRecordType[0]["seckey"]);
			// if(count($m)!=8){
			//     return ["status"=>"error",$m,"message"=>"خطا در مقادیر ورودی"];
			// }
			$out["DS"] = $listOfRecordType[0]["seckey"];
			$out["Digest"] = $m[6] ?? "";
			$out["Digest_Type"] = $m[5] ?? "";
			$out["Algorithm"] = "SHA-256";
			$out["Public_Key"] = $listOfRecordType[0]["pubkey"];
			$out["Key_Tag"] = $m[4] ?? "";
			$out["Flags"] = "257 (KSK)";
			$out["seckey"] = $listOfRecordType[0]["pubkey"];
			$out["status"] = $listOfRecordType[0]["status"];

			return [
				"status" => "success",
				"message" => "درخواست شما با موفقیت انجام شد",

				"data" => $out
			];
		}
		$conn->close();
	}
	public static function UpdateDNSDNSSec($token, $domainid, $status)
	{
		$d = self::GetStatusDNSSec($domainid, $token);

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			// VARS_ADMIN::ReturnHeaders(301);
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$s = self::CheckDomainOwnerID($domainid, $uid);
		if ($s["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این بخش را ندارید"];
		}
		$dname = $s["data"][0]["d_name"];

		if ($status == "2") {
			$sql = "DELETE FROM   " . $GLOBALS["tbl_dns_dnssec"] .
				" WHERE dd_did_fk=" . $domainid;
			$conn = GetConnection();

			$result = $conn->query($sql);
			$id = $conn->insert_id;
			$conn->close();

			API_DOMAIN_ADMIN::SendDeleteDNSSecRequest($dname);
			return [
				"status" => "success",
				"message" => "درخواست شما با موفقیت انجام شد",
				"data" =>
				[
					"data" => [
						"status" => "1",
						"DS" => "DNSSEC is disabled"
					]
				]
			];
		} else {
			$sql = "INSERT INTO  " . $GLOBALS["tbl_dns_dnssec"] .
				" VALUES(0, 'updating'," . $domainid . ",1, 'updating')";
			$dr = explode(".", $dname);
			if ($dr[count($dr) - 1] == "ir")
				return ["status" => "error", "message" => "دامنه های ملی امکان فعالسازی DNS SEC را ندارد"];

			$conn = GetConnection();

			$result = $conn->query($sql);
			$id = $conn->insert_id;
			$conn->close();

			API_DOMAIN_ADMIN::SendDNSSecRequest($dname, $domainid);
		}
		$expsession = jDateTime::date("Y/m/d H:i:s");
		//  $s = CLOUD_LOG_ADMIN::ADDLog($expsession." : " . $sql . "; " .   "get sec");
		// $s = CLOUD_LOG_ADMIN::ADDLog($expsession . "  : " . $sql . "; ",  "get sec");

		return [
			"status" => "success",
			"message" => "درخواست شما با موفقیت انجام شد",
			"data" => self::GetStatusDNSSec($domainid, $token)
		];
	}
	public static function ADMIN_ReturnAllDomains()
	{
		$sql = "SELECT * FROM tbl_users," . $GLOBALS["domains_tablename"] .
			" WHERE " . $GLOBALS["d_status"] . "!=2 and d_plan!='free' and uid=d_user_id_fk  ORDER BY d_status";
		$conn = GetConnection();

		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function ADMIN_ReturnAllPricedDomains()
	{
		$sql = "SELECT * FROM tbl_users," . $GLOBALS["domains_tablename"] .
			" WHERE " . $GLOBALS["d_status"] . "!=2 and uid=d_user_id_fk and d_plan!='free'
             ORDER BY d_status";
		$conn = GetConnection();

		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function GetDomainInfo($domainid)
	{
		$sql = "SELECT * FROM tbl_domains,tbl_users WHERE d_user_id_fk=uid AND d_status!=2 AND domain_id= " . $domainid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		return $listOfRecordType;
	}
	public static function CreateNameserver($token, $domainid, $ns1, $ns2)
	{
		$dmnr = self::GetDomainMainRecord($token, $domainid);
		if ($dmnr["status"] == "error") {
			return $dmnr;
		}

		$usersDetails = USERS_ADMIN::GetOneByToken($token);

		if ($usersDetails["credit"] < 0) {
			return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
		}

		$domainname = $dmnr["data"][0]["domain_name"];

		$website = WEBSITES_ADMIN::getmainrecord($token, $domainid);
		if ($website["status"] == "error") {
			return $website;
		}
		if ($ns2 == $ns1) {
			return ["status" => "error", "message" => "نیم سرور اول و دوم نباید یکسان باشد"];
		}
		$domaininfo = self::GetDomainInfo($domainid);
		$planwebsite = $domaininfo[0]["d_plan"]; // $website["data"][$domainname]["plan"];
		$plans = ReturnPlans();
		if (!isset($plans[$planwebsite]))
			return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];

		if (!isset($plans[$planwebsite]["ddns"]))
			return ["status" => "error", "action" => "needtoupgrade", "message" => "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];

		if (stripos($ns1, "mizbancloud") !== false || stripos($ns2, "mizbancloud") !== false)
			return ["status" => "error", "message" => "شما امکان استفاده از این نیم سرور را ندارید"];

		$oldips = USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token);
		$nsip1 = $oldips["data"][0]["nsip1"];
		$nsip2 = $oldips["data"][0]["nsip2"];
		if ($dmnr["data"][0]["d_ddns"] != 0) {
			NAMESERVERS_ADMIN::RemoveDedicatedNs($dmnr["data"][0]["d_ddns"]);
			$nsid = NAMESERVERS_ADMIN::CreateDedicatedNs($ns1, $ns2, $nsip1, $nsip2);
		} else {
			$nsid = NAMESERVERS_ADMIN::CreateDedicatedNs($ns1, $ns2, $nsip1, $nsip2);
		}
		$sql = "UPDATE tbl_domains set d_ddns=" . $nsid . " WHERE domain_id=" . $domainid;
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		$postedata["ns1"] = $ns1;
		$postedata["ns2"] = $ns2;
		$postedata["type"] = "NS-ADMIN";
		DOMAINNSRECORD_ADMIN::CreateRecordForUpdate($postedata, $domainname, 0);
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];

		// if(isset($website["data"][$domainname]["plan"])){
		//     $plan=$website["data"][$domainname]["plan"];
		//     if($plan=="pro" || $plan=="org"){
		//          if(!strpos($ns1,"mizbancloud") ){
		//               if(!strpos($ns2,"mizbancloud") ){
		//                   $oldips= USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token);
		//                   $nsip1=$oldips["data"][0]["nsip1"];
		//                   $nsip2=$oldips["data"][0]["nsip2"];
		//                 if($dmnr["data"][0]["d_ddns"]!=0){
		//                           NAMESERVERS_ADMIN::RemoveDedicatedNs($dmnr["data"][0]["d_ddns"]);
		//                     $nsid =NAMESERVERS_ADMIN::CreateDedicatedNs($ns1,$ns2,$nsip1,$nsip2);

		//                 }
		//                   else{
		//                       $nsid =NAMESERVERS_ADMIN::CreateDedicatedNs($ns1,$ns2,$nsip1,$nsip2);
		//                   }
		//                   $sql="Update tbl_domains set d_ddns=".$nsid." where domain_id=".$domainid;
		//                   $conn = GetConnection();
		//                   $conn->query($sql);
		//                   $conn->close();
		//                   return ["status"=>"success","message"=>"درخواست شما با موفقیت انجام شد"];
		//              }
		//              else{
		//                 return ["status" => "error", "message" => "شما امکان استفاده از این نیم سرور را ندارید"];
		//              }
		//          }
		//          else{
		//             return ["status" => "error", "message" => "شما امکان استفاده از این نیم سرور را ندارید"];
		//          }
		//      }
		//      else{
		//             return ["status" => "error", "message" => "برای دسترسی به این بخش باید پلان سایت اصلی این دامنه شما حرفه ای یا بالاتر باشد"];
		//      }
		//  }
		//  else{
		//      return ["status" => "error", "message" => "برای دسترسی به این بخش باید پلان سایت اصلی این دامنه شما حرفه ای یا بالاتر باشد"];
		//  }
	}
	public static function GetListOfRecord($d_status)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] .
			" WHERE " . $GLOBALS["d_status"] . "=" . $d_status;
		$conn = GetConnection();

		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function GetListOfAllRecordForMainPage($uid)
	{
		$sql = "SELECT domain_id as domainid,d_plan as plan, d_name as domainName, d_reg_date as registertime,
            (
            CASE
            WHEN d_status = 1 THEN 'دامنه فعال است'
            WHEN d_status = 0 THEN 'در انتظار تغییر NS'
			WHEN d_status = 6 THEN 'دامنه مسدود شده است'
            END) AS dnsStatus,
            IF(d_status = 1 , 'active','deactive') as status,
               d_name as sitename,
            IF(
                (
                    SELECT count(wid) FROM  tbl_waf WHERE domain_id = domain_id
                )
                = 1,'فعال','فعال'
            ) as cloudSecurity ,
            IF(
                (
                SELECT count(wid) FROM  tbl_waf WHERE w_ws_id_fk = domain_id
                )
                = 1,'enabled','enabled'
            ) as operation
            FROM  tbl_domains WHERE d_status!=2 AND d_user_id_fk=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعاتی جهت نمایش وجود ندارد"];
			return $result;
		} else {
			$ac = [];
			$m = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$i = 0;
			foreach ($m as $n) {
				array_push($ac, $n);
				WEBSITES_ADMIN::InternalGetWebsiteList($n["domainid"], 1, $n["domainName"]);
				$ac[$i]["webid"] = WEBSITES_ADMIN::InternalGetWebsiteList($n["domainid"], 1, $n["domainName"])["webid"];
				$i++;
			}
			$listOfRecordType = ["status" => "success", "websites" => $ac];
		}

		$conn->close();
		return $listOfRecordType;
	}
	public static function GetListOfAllRecord($uid)
	{
		$sql = "SELECT d_name as domainName, d_reg_date as registertime,
            (
            CASE
            WHEN d_status = 1 THEN 'دامنه فعال است'
            WHEN d_status = 0 THEN 'در انتظار تغییر NS'
            END) AS dnsStatus,
            IF(d_status = 0 , 'deactive','active') as status,
            IF(d_name=ws_recordname,d_name,CONCAT(ws_recordname,'.',d_name)) as sitename,
            IF(
                (
                    SELECT count(wid) FROM  tbl_waf WHERE w_ws_id_fk = wsid
                )
                = 1,'فعال','غیر فعال'
            ) as cloudSecurity ,
            IF(
                (
                SELECT count(wid) FROM tbl_waf WHERE w_ws_id_fk = wsid
                )
                = 1,'enabled','disabled'
               ) as operation
            FROM `tbl_websites`,tbl_domains WHERE d_status!=2 AND domain_id=ws_domainid_fk AND d_user_id_fk=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "اطلاعاتی جهت نمایش وجود ندارد"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "success", "websites" => mysqli_fetch_all($result, MYSQLI_ASSOC)];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function CheckBlockedDomain($dname)
	{
		$blockedDomain = [
			"mihanssl.com", "mizban.cloud", "mizban.live", "mizbancdn.com", "mizbancdn.net", "mizbancloud.com", "mizbancloud.net", "mizbanlive.com", "saba.host", "sabahost.net", "sabahost.org", "sabadns.com", "sabahost.co"
		];
		if (in_array($dname, $blockedDomain)) {
			return "blocked";
		} else {
			return "valid";
		}
	}
	public static function is_valid_domain_name($domain_name)
	{
		// FILTER_VALIDATE_URL checks length but... why not use it? so we don't move forward with its more expensive operations
		$domain_len = strlen($domain_name);
		if ($domain_len < 3 or $domain_len > 253)
			return FALSE;

		// getting rid of HTTP/S scheme just in case was passed.
		if (stripos($domain_name, 'http://') === 0)
			$domain_name = substr($domain_name, 7);
		elseif (stripos($domain_name, 'https://') === 0)
			$domain_name = substr($domain_name, 8);

		// we don't need the www either
		if (stripos($domain_name, 'www.') === 0)
			$domain_name = substr($domain_name, 4);

		// Checking for a '.' at least, not in the beginning nor end, since http://.abcd. is reported valid
		if (strpos($domain_name, '.') === FALSE or $domain_name[strlen($domain_name) - 1] == '.' or $domain_name[0] == '.')
			return FALSE;

		// now we use the FILTER_VALIDATE_URL, concatenating http so we can use it, and return BOOL
		return (filter_var('http://' . $domain_name, FILTER_VALIDATE_URL) === FALSE) ? FALSE : TRUE;

		return (preg_match("/^([a-zd](-*[a-zd])*)(.([a-zd](-*[a-zd])*))*$/i", $domain_name) // valid characters check
			&& preg_match("/^.{1,253}$/", $domain_name) // overall length check
			&& preg_match("/^[^.]{1,63}(.[^.]{1,63})*$/", $domain_name)); // length of every label
	}
	public static function GetOrderID()
	{
		return USERS_ADMIN::GenerateHash(12);
	}
	public static function AddOrder($uid)
	{
		$orderid = self::GetOrderID();
		$date = jDateTime::date("Y/m/d H:i:s");
		$sql = "INSERT INTO tbl_orders VALUES(0,'" . $uid . "','" . $date . "','" . $orderid . "')";
		$conn = GetConnection();
		mysqli_query($conn, $sql);
		$conn->close();
		return ["status" => "success", "orderid" => $orderid, $sql];
	}
	public static function AddDomain($d_name, $token)
	{
		$d_name = strtolower($d_name);
		$userExist = USERS_ADMIN::GetOneByToken($token);
		if ($userExist["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود کاربر به اتمام رسیده است لطفا مجدد وارد شوید "];
		}
		$d_user_id_fk = $userExist["userdetail"][0]["uid"];
		$ps = explode(".", $d_name);
		$out = "";
		for ($i = 1; $i < count($ps); $i++) {
			$out .= $ps[$i] . ".";
		}
		$out = substr($out, 0, strlen($out) - 1);
		if (self::CheckDomainExist($d_name)["status"] == "error") {
			return ["status" => "error", "message" => "دامنه وارد شده تکراری است"];
		}
		if (!CheckValidTLD($out)) {
			return ["status" => "error", "message" => "دامنه وارد شده شما نامعتبر است"];
		}
		if (self::CheckBlockedDomain($d_name) != "valid")
			return ["status" => "error", "message" => "دامنه وارد شده قابل ثبت نیست"];
		if ($out != "ac.ir") {
			// $dmnstat = json_decode(API_DOMAIN_ADMIN::checkDomainAvalibity($d_name), true);

			if (!self::is_valid_domain_name($d_name)) {
				return ["status" => "error", "message" => "دامنه وارد شده نامعتبر است"];
			}

			if (!preg_match('/^[A-z0-9\-]*$/', $ps[0])) {
				return ["status" => "error", "message" => "دامنه وارد شده نامعتبر است"];
			}

			// if($dmnstat["status"]=="failed")
			//     return ["status" => "error", "message" => "دامنه وارد شده نامعتبر است"];
		}
		$conn = GetConnection();

		$orderid = self::AddOrder($d_user_id_fk)["orderid"];
		$sql = "INSERT INTO " . $GLOBALS['domains_tablename'] . "(" . $GLOBALS['d_name'] . "," .
			$GLOBALS['d_user_id_fk'] . "," . $GLOBALS['d_status'] . "," . $GLOBALS['d_reg_date'] . "," . $GLOBALS['d_hash']
			. ",dnote ,d_orderid) VALUES (LOWER('%s'),%s,%s,'%s','%s',' 	{ \"adminnote\":\"\", \"suspendnote\":\"\"} 	','" . $orderid . "')";
		$now = jDateTime::date("Y-m-d H:i:s");

		$ns = USSERNAMESERVERS_ADMIN::AddUserNameServer(
			$d_user_id_fk,
			$userExist["userdetail"][0]["uindividual"] - 1
		);

		$mailTemplate = '
            %s عزیز،
            <br />
            بنا به درخواست شما، دامنه %s در تاریخ %s ساعت %s با موفقیت در میزبان کلود ثبت شد.
            <br />
            در حال حاضر دامنه ثبت شده در وضعیت "در انتظار تغییر NS" قرار دارد.
            <br />
            برای فعالسازی میبایست NS ها یا نیم سرورهای میزبان کلود را جایگزین NS های فعلی دامنه ثبت شده نمایید.
            <br />
            NSهای فعلی دامنه ثبت شده:
            <br />
            %s
            <br />
            %s
            <br />
            NSهای میزبان کلود:
            <br />
            %s
            <br />
            %s
            <br />
            ';
		$nowDate = jDateTime::date("Y/m/d");
		$nowTime = jDateTime::date("H:i:s");

		$a = json_decode(API_DOMAIN_ADMIN::GetNsRecord($d_name), true);
		if ($a["status"] == "success") {
			if (count($a["nslist"]) > 1) {
				$sql = sprintf($sql, $d_name, $d_user_id_fk, 3, $now, $token);
				if ($conn->query($sql) === TRUE) {
					// VARS_ADMIN::ReturnHeaders(200);

					unset($ns["organize"]);
					unset($ns["nsid"]);
					$last_id = $conn->insert_id;
					$mailTemplate = sprintf(
						$mailTemplate,
						$userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
						$d_name,
						$nowDate,
						$nowTime,
						$a["nslist"][0],
						$a["nslist"][1],
						$ns[0]["ns1"],
						$ns[0]["ns2"]
					);
					$params = [
						"param1" => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
						"param4" => $d_name,
					];
					// $o= EMAILCLASS::SendEmailPanel($userExist["userdetail"][0]["umail"],"ثبت دامنه جدید در میزبان کلود",$mailTemplate,"success","uiiercxqu9",$params,$userExist["userdetail"][0]["umobile"]);
					// $o= EMAILCLASS::SendEmailPanel("pnetco@gmail.com","ثبت دامنه جدید در میزبان کلود",$mailTemplate,"success","uiiercxqu9",$params,"09128953411");

					$fields = array(
						'mail' =>  $userExist["userdetail"][0]["umail"],
						'mobile' => $userExist["userdetail"][0]["umobile"],
						'template' => $mailTemplate,
						'smstemplate' => "uiiercxqu9",
						'dname' => $d_name,
						'name' => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
					);
					//  name=".$userExist["userdetail"][0]["uname"]." ".$userExist["userdetail"][0]["ufamily"]
					//url-ify the data for the POST
					$fields_string = http_build_query($fields);

					$curl = curl_init();
					curl_setopt($curl, CURLOPT_URL, $GLOBALS["apidomain"] . "/sender/sended/adddomain.php");
					curl_setopt($curl, CURLOPT_POST, TRUE);
					curl_setopt($curl, CURLOPT_POSTFIELDS, $fields_string);
					curl_setopt($curl, CURLOPT_USERAGENT, 'api');
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_HEADER, 0);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, false);
					curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
					curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
					curl_exec($curl);
					curl_close($curl);

					$webid =    WEBSITES_ADMIN::AddDefaultWebSite($d_name, $last_id);
					$response = [
						"status" => "success",
						"id" => $last_id . "",
						"webid" => $webid . "",
						"message" => "دامنه با موفقیت افزوده شد ",
						"data" => $ns
					];
					//
					// GETDOMAINRECORDS_ADMIN::GetListOfRecord($d_name, $token);
					// API_DOMAIN_ADMIN::RunAddAPI($d_name);
					WEBSITES_ADMIN::AddDefaultWebSite($d_name, $last_id);
					DOMAINNSRECORD_ADMIN::GenerateDNSFile($d_name);

					DNSBALANCER_ADMIN::AddDomainToQueue($d_name, "bind");

					API_DOMAIN_ADMIN::SendRequestToCloudflare($d_name, $last_id, $token);
				}
			} else {
				$sql = sprintf($sql, $d_name, $d_user_id_fk, 4, $now, $token);
				sleep(2);

				if ($conn->query($sql) === TRUE) {
					DOMAINNSRECORD_ADMIN::GenerateDNSFile($d_name);
					DNSBALANCER_ADMIN::AddDomainToQueue($d_name, "bind");
					// VARS_ADMIN::ReturnHeaders(200);
					$ns = USSERNAMESERVERS_ADMIN::AddUserNameServer(
						$d_user_id_fk,
						$userExist["userdetail"][0]["uindividual"] - 1
					);
					$mailTemplate = sprintf(
						$mailTemplate,
						$userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
						$d_name,
						$nowDate,
						$nowTime,
						"-",
						"-",
						$ns[0]["ns1"],
						$ns[0]["ns2"]
					);

					$params = [
						"param1" => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
						"param4" => $d_name,
					];

					//  $o= EMAILCLASS::SendEmailPanel($userExist["userdetail"][0]["umail"],"ثبت دامنه جدید در میزبان کلود",$mailTemplate,"success","uiiercxqu9",$params,$userExist["userdetail"][0]["umobile"]);
					//   $o= EMAILCLASS::SendEmailPanel("pnetco@gmail.com","ثبت دامنه جدید در میزبان کلود",$mailTemplate,"success","uiiercxqu9",$params,"09128953411");
					$fields = array(
						'mail' =>  $userExist["userdetail"][0]["umail"],
						'mobile' => $userExist["userdetail"][0]["umobile"],
						'template' => $mailTemplate,
						'smstemplate' => "uiiercxqu9",
						'dname' => $d_name,
						'name' => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
					);
					//  name=".$userExist["userdetail"][0]["uname"]." ".$userExist["userdetail"][0]["ufamily"]
					//url-ify the data for the POST
					$fields_string = http_build_query($fields);

					$curl = curl_init();
					curl_setopt($curl, CURLOPT_URL, $GLOBALS["apidomain"] . "/sender/sended/adddomain.php");
					curl_setopt($curl, CURLOPT_POST, TRUE);
					curl_setopt($curl, CURLOPT_POSTFIELDS, $fields_string);
					curl_setopt($curl, CURLOPT_USERAGENT, 'api');
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_HEADER, 0);
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, false);
					curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
					curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
					curl_exec($curl);
					curl_close($curl);
					unset($ns["organize"]);
					unset($ns["nsid"]);
					$last_id = $conn->insert_id;
					$webid =    WEBSITES_ADMIN::AddDefaultWebSite($d_name, $last_id);
					$response = [
						"status" => "success",
						"id" => $last_id . "",
						"webid" => $webid . "",
						"message" => "دامنه با موفقیت افزوده شد ",
						"data" => $ns
					];
				}
			}
		} else {
			$sql = sprintf($sql, $d_name, $d_user_id_fk, 4, $now, $token);
			if ($conn->query($sql) === TRUE) {
				// VARS_ADMIN::ReturnHeaders(200);

				unset($ns["organize"]);
				unset($ns["nsid"]);
				$last_id = $conn->insert_id;
				$mailTemplate = sprintf(
					$mailTemplate,
					$userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
					$d_name,
					$nowDate,
					$nowTime,
					"-",
					"-",
					$ns[0]["ns1"],
					$ns[0]["ns2"]
				);
				$params = [
					"param1" => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
					"param4" => $d_name,
				];
				//  $o= EMAILCLASS::SendEmailPanel($userExist["userdetail"][0]["umail"],"ثبت دامنه جدید در میزبان کلود",$mailTemplate,"success","uiiercxqu9",$params,$userExist["userdetail"][0]["umobile"]);
				//   $o= EMAILCLASS::SendEmailPanel("pnetco@gmail.com","ثبت دامنه جدید در میزبان کلود",$mailTemplate,"success","uiiercxqu9",$params,"09128953411");
				$fields = array(
					'mail' =>  $userExist["userdetail"][0]["umail"],
					'mobile' => $userExist["userdetail"][0]["umobile"],
					'template' => $mailTemplate,
					'smstemplate' => "uiiercxqu9",
					'dname' => $d_name,
					'name' => $userExist["userdetail"][0]["uname"] . " " . $userExist["userdetail"][0]["ufamily"],
				);
				//  name=".$userExist["userdetail"][0]["uname"]." ".$userExist["userdetail"][0]["ufamily"]
				//url-ify the data for the POST
				$fields_string = http_build_query($fields);

				$curl = curl_init();
				curl_setopt($curl, CURLOPT_URL, $GLOBALS["apidomain"] . "/sender/sended/adddomain.php");
				curl_setopt($curl, CURLOPT_POST, TRUE);
				curl_setopt($curl, CURLOPT_POSTFIELDS, $fields_string);
				curl_setopt($curl, CURLOPT_USERAGENT, 'api');
				curl_setopt($curl, CURLOPT_TIMEOUT, 1);
				curl_setopt($curl, CURLOPT_HEADER, 0);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, false);
				curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
				curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
				curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
				curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
				curl_exec($curl);
				curl_close($curl);

				$webid =    WEBSITES_ADMIN::AddDefaultWebSite($d_name, $last_id);
				$response = [
					"status" => "success",
					"id" => $last_id . "",
					"webid" => $webid . "",
					"message" => "دامنه با موفقیت افزوده شد ",
					"data" => $ns
				];
				WEBSITES_ADMIN::AddDefaultWebSite($d_name, $last_id);
				DOMAINNSRECORD_ADMIN::GenerateDNSFile($d_name);
				DNSBALANCER_ADMIN::AddDomainToQueue($d_name, "bind");
			}
		}
		$conn->close();
		$ss = LOGS_ADMIN::AddLog("افزودن دامنه " . $d_name, $d_user_id_fk, 0, "", "users");

		return $response;
		$response = ["status" => "success", "message" => "دامنه با موفقیت افزوده شد ", "data" => $ns];
	}
	public static function UpdateDefaultWebsite($domainid, $wid)
	{
		$sql = "UPDATE `tbl_domains` SET d_defaultwid=" . $wid . " WHERE domain_id=" . $domainid;
		$conn = GetConnection();
		mysqli_query($conn, $sql);
		$conn->close();
		return;
	}
	public static function UpdateDomainStatus($dstatus, $dname)
	{
		$conn = GetConnection();
		$now = date("Y/m/d H:i:s");

		$sql = "UPDATE " . $GLOBALS['domains_tablename'] . " SET " . $GLOBALS['d_status'] . "=%s,d_lastupdate='" . $now . "' WHERE " . $GLOBALS['d_name'] . "='%s' and d_status!=2";
		$sql = sprintf($sql, $dstatus, $dname);

		if ($conn->query($sql) === TRUE) {
			LOGS_ADMIN::AddLog("تغییر وضعیت دامنه " . $dname, 0, 0, "", "users");
			$response = ["status" => "success", "message" => "دامنه با موفقیت ویرایش شد"];
		} else {
			$response = ["status" => "error", "message" => "" .  $conn->error];
		}
		$conn->close();
		$uinfo = DOMAINS_ADMIN::ReturnUserInfoByDomainName($dname)[0];
		if ($dstatus == "1") {
			$mailTemplate = '
                    %s عزیز،
                    <br />
                    دامنه %s شما با موفقیت به وضعیت "فعال" تغییر یافت. از هم اکنون ترافیک سایت شما از cdn میزبان کلود عبور خواهد کرد.
                    <br />
                    در صورت نیاز به راهنمایی با کارشناسان میزبان کلود در تماس باشید
                    ';
			$mailTemplate = sprintf($mailTemplate, $uinfo["uname"] . " " . $uinfo["ufamily"], $dname);

			$o = EMAILCLASS::SendEmailPanel($uinfo["umail"], "فعال شدن دامنه در میزبان کلود", $mailTemplate, "success");
		} else if ($dstatus == "4") {
			$mailTemplate = '
                    %s عزیز،
                    <br />
                    نیم سرور های شما دیگر بر روی میزبان کلود نمی باشد  و ترافیک سایت شما مستفیم بر روی سرور شما خواهد بود
                    <br />
                    در صورت نیاز به راهنمایی با کارشناسان میزبان کلود در تماس باشید
                    ';
			$mailTemplate = sprintf($mailTemplate, $uinfo["uname"] . " " . $uinfo["ufamily"], $dname);

			$o = EMAILCLASS::SendEmailPanel($uinfo["umail"], "غیر فعال شدن دامنه در میزبان کلود", $mailTemplate, "success");
			DOMAINNSRECORD_ADMIN::RunDeActivateCDNforDomain($uinfo["domain_id"]);
		}

		return $response;
	}
	public static function ReturnUserInfoByDomainName($dname)
	{
		$sql = "SELECT * FROM tbl_domains,tbl_users WHERE uid=d_user_id_fk AND d_name='" . $dname . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return $listOfRecordType;
	}
	public static function GenerateCodeForResetPassword($domainid, $uid, $mobile)
	{
		$conn = GetConnection();
		$getInfo = USERRESETPASSWORD_ADMIN::GetOneByID($uid);
		if ($getInfo["result"] == "null") {
			$sql = "INSERT INTO " . $GLOBALS['userresetpassword_tablename'] . "(" . $GLOBALS['urphash'] . "," .
				$GLOBALS['urpsmscode'] . "," . $GLOBALS['urp_uid_fk'] . "," . $GLOBALS['urp_expiredate'] .
				") VALUES ('%s','%s','%s','%s')";
			$datetime = jDateTime::date("Y-m-d H:i:s", strtotime("+1 minutes"));

			$sessionkey = USERS_ADMIN::GenerateHash(64);
			$smscode = rand(1000, 9999);
			$sql = sprintf($sql, $domainid, $smscode, $uid, $datetime);
			if ($conn->query($sql) === TRUE) {
				$output = USERRESETPASSWORD_ADMIN::GetOneByID($uid);
				VARS_ADMIN::ReturnHeaders(200);
				$response = ["status" => "sended"];
				SMSCLASS::SendSMSForVerifyUser($mobile, '24cx5b0wio', $smscode);
			}
		} else {
			$now = jDateTime::date("Y-m-d H:i:s", strtotime("-1 minutes"));
			if ($getInfo["data"][0]["urp_expiredate"] < $now) {
				VARS_ADMIN::ReturnHeaders(200);
				$response = USERRESETPASSWORD_ADMIN::UpdateResetPassword($uid, $mobile, "11", $domainid);
				$response = ["status" => "sended"];
			} else {
				VARS_ADMIN::ReturnHeaders(400);
				$response = ["status" => "wait", "message" => " حداقل فاصله زمانی بین دو ارسال 1دقیقه است"];
			}
		}
		$conn->close();
		return $response;
	}
	public static function CheckCodeAndDeleteDomain($type, $code, $domainid)
	{
		if ($type == 1) {
			$field = "urphash";
		} else {
			$field = "urphash";
		}
		$Search = USERRESETPASSWORD_ADMIN::GetRecordWithParameter($field, $domainid);
		// return $Search["data"];
		if ($Search["result"] == "error") {
			VARS_ADMIN::ReturnHeaders(400);
			// USERRESETPASSWORD_ADMIN::DeleteUsedItems($Search["data"]["urpid"]);
			$response = ["status" => "error", "message" => "کد وارد شده نامعتبر است", "status" => "301"];
		} else {
			$now = date("Y-m-d H:i:s");
			if ($Search["data"]["urpsmscode"] != $code) {
				$response = ["status" => "error", "message" => "کد وارد شده نامعتبر است", "status" => "302"];
			} else {
				USERRESETPASSWORD_ADMIN::DeleteUsedItems($Search["data"]["urpid"]);
				return ["status" => "success"];
			}
		}

		return $response;
	}
	public static function UpdateDomainStatusWithToken($dstatus, $domainid, $token, $code = "12")
	{
		if ($token != "12") {
			$usersDetails = USERS_ADMIN::GetOneByToken($token);
			if ($usersDetails["status"] == "error") {
				// VARS_ADMIN::ReturnHeaders(301);
				return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
			}
			if (intVal($usersDetails["credit"]) < 0) {
				return ["status" => "error", "message" => "اعتبار شما منفی است و امکان حذف دامنه را ندارید"];
			}
			$uid = $usersDetails["userdetail"][0]["uid"];
		}

		$sql = "SELECT domain_id as id,d_name as domain_name,d_status as status,uname,ufamily,umobile,uid,umail from " . $GLOBALS["domains_tablename"] . ',' . $GLOBALS["users_tablename"]
			. ' WHERE ' . $GLOBALS["d_user_id_fk"] . "=" . $GLOBALS["uid"] . "  and " . $GLOBALS['domain_id'] . "=" . $domainid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			// VARS_ADMIN::ReturnHeaders(200);
			$response = ["status" => "error", "message" => "دامنه مورد نظر یافت  نشد"];
		} else {
			$uid = $listOfRecordType[0]["uid"];
			if ($listOfRecordType[0]["status"] == "6") {
				return ["status" => "error", "message" => "دامنه شما مسدود است و امکان حذف دامنه را ندارید"];
			}
			$now = date("Y/m/d H:i:s");
			if ($dstatus == "2" && $token != "12" && $listOfRecordType[0]["status"] == "1") {
				if ($code == "12") {
					$sendSMs = self::GenerateCodeForResetPassword($domainid, $usersDetails["userdetail"][0]["uid"], $usersDetails["userdetail"][0]["umobile"]);
					if ($sendSMs["status"] == "sended") {
						return ["status" => "wait", "message" => "کد تاییدیه جهت حذف دامنه به شماره شما ارسال شد"];
					} else if ($sendSMs["status"] == "wait") {
						return ["status" => "error", "message" => $sendSMs["message"]];
					}
				} else {

					$checkcc = self::CheckCodeAndDeleteDomain("1", $code, $domainid);
					if ($checkcc["status"] != "success") {
						return ["status" => "error", "message" => $checkcc["message"]];
					}
				}
			}

			if ($dstatus == 2) {
				$sql = "UPDATE " . $GLOBALS['domains_tablename'] . " SET " . $GLOBALS['d_status'] . "=%s, d_lastupdate='" . $now . "' WHERE " . $GLOBALS['domain_id'] . "=%s";
				$sql = sprintf($sql, $dstatus, $domainid);
			} else {
				$sql = "UPDATE " . $GLOBALS['domains_tablename'] . " SET " . $GLOBALS['d_status'] . "=%s,d_lastupdate='" . $now . "' WHERE " . $GLOBALS['domain_id'] . "=%s";
				$sql = sprintf($sql, $dstatus, $domainid);
			}

			if ($conn->query($sql) === TRUE) {

				API_DOMAIN_ADMIN::RunDeleteDomain($listOfRecordType[0]["domain_name"]);
				WEBSITES_ADMIN::DeleteAllWebSitesByDomain($domainid);

				$mailTemplate = '
                    %s عزیز،
                    <br />
                    بنا به درخواست شما، دامنه %s در تاریخ %s ساعت %s   در میزبان کلود حذف شد.
                    <br />
                    <br />
                ';
				$nowDate = jDateTime::date("Y/m/d");
				$nowTime = jDateTime::date("H:i:s");

				$mailTemplate = sprintf(
					$mailTemplate,
					$listOfRecordType[0]["uname"] . " " . $listOfRecordType[0]["ufamily"],
					$listOfRecordType[0]["domain_name"],
					$nowDate,
					$nowTime
				);

				$params = [
					"param1" => $listOfRecordType[0]["uname"] . " " . $listOfRecordType[0]["ufamily"],
					"param4" => $listOfRecordType[0]["domain_name"],
				];

				$o = EMAILCLASS::SendEmailPanel(
					$listOfRecordType[0]["umail"],
					"حذف دامنه در میزبان کلود",
					$mailTemplate,
					"success",
					"bckkd19tzr",
					$params,
					$listOfRecordType[0]["umobile"]
				);

				$response = [
					"status" => "success", $params, $o,
					"message" => "دامنه با موفقیت ویرایش شد",
					$listOfRecordType
				];

				USER_NEEDED_BALANCE_ADMIN::AddUserDetails($uid);
				return $response;
			} else {
				$response = ["status" => "error", "message" => "خطا در اطلاعات درخواستی"];
				return $response;
			}
		}

		$conn->close();

		return $response;
	}
	public static function ChangeDomainStatus($id, $status)
	{
		$now = date("Y/m/d H:i:s");
		$sql = "UPDATE " . $GLOBALS['domains_tablename'] . " SET " .
			$GLOBALS['d_status'] . "=" . $status . ",d_lastupdate='" . $now . "'  WHERE " .
			$GLOBALS['domain_id'] . "=" . $id . " AND d_status!=2";
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		return $sql;
	}
	public static function CheckDomainStatus($token, $domainid)
	{
		$userExist = USERS_ADMIN::GetOneByToken($token);
		if ($userExist["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود کاربر به اتمام رسیده است لطفا مجدد وارد شوید "];
		}

		$uid = $userExist["userdetail"][0]["uid"];
		$sql = "SELECT * FROM " . $GLOBALS['domains_tablename'] . " WHERE " . $GLOBALS['domain_id'] . "=" .
			$domainid . " AND " . $GLOBALS['d_user_id_fk'] . "=" . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			// VARS_ADMIN::ReturnHeaders(200);

			$response = ["status" => "error", "message" => "دامنه ای یافت نشد"];
		} else {
			// VARS_ADMIN::ReturnHeaders(200);

			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$now = jDateTime::date("Y/m/d H:i:s");
			$n = jDateTime::date("Y/m/d H:i:s", strtotime('-2 minutes')); //, strtotime($listOfRecordType[0]['d_reg_date'])));
			$dts = date("Y/m/d H:i:s", strtotime('+1 minutes', strtotime($listOfRecordType[0]['d_reg_date'])));
			$dts = str_replace("/", "", $dts);
			$dts = str_replace(" ", "", $dts);
			$dts = str_replace(":", "", $dts);

			$now = str_replace("/", "", $now);
			$now = str_replace(" ", "", $now);
			$now = str_replace(":", "", $now);

			if ($dts + 100 < $now) {
				//SEND API DIG
				API_DOMAIN_ADMIN::SENDToAPIDig($listOfRecordType[0]['d_name'], $domainid);
			}
			if ($dts + 150 < $now) {
				self::ChangeDomainStatus($domainid, 4);
			}
			$response = [
				"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
				"now" => $now,
				"n" => $n,
				"dts" => $dts,
				"domainstatus" => $listOfRecordType[0][$GLOBALS['d_status']]
			];
		}
		$result->free_result();
		$conn->close();

		return $response;
	}
	public static function GetCountOfRecords($uid)
	{
		$sql = "SELECT count(domain_id) as cnt FROM  " . $GLOBALS["domains_tablename"]
			. " WHERE d_status!=2 and  " . $GLOBALS['d_user_id_fk'] . "=" . $uid;
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$d = ["status" => "noresult", "message" => "رکوردی برای دامنه مورد نظر یافت نشد"];
			$conn->close();
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$d = ["status" => "success", "data" => $listOfRecordType];
			$conn->close();
		}
		return $d;
	}
	public static function GetUserDomainList($sessionkey, $page, $countofrecord, $uid = 1)
	{
		if ($sessionkey != "12") {
			$usersDetails = USERS_ADMIN::GetOneByToken($sessionkey);
			if ($usersDetails["status"] == "error") {
				//                  return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
			}

			$uid = $usersDetails["userdetail"][0]["uid"];
		}
		$expsession = jDateTime::date("Y/m/d H:i:s");
		$countOfRecord = self::GetCountOfRecords($uid)["data"][0]["cnt"];

		if ($countOfRecord == 0) {
			return  [
				"status" => "error",
				"currentpage" => 1,
				"countofpage" => 1,
				"message" => "دامنه ای یافت نشد"
			];
		}

		$fsr = ($page - 1) * $countofrecord;
		$enr = $page * $countofrecord;

		$countOfpageRecordInPage = $countofrecord;
		$a = $countOfRecord / $countOfpageRecordInPage;

		if ($countOfRecord > $countofrecord) {
			$countofpage = intdiv($countOfRecord, $countOfpageRecordInPage);
			if (!is_int($a))
				$countofpage = $countofpage + 1;
		} else {
			$countofpage = 1;
		}

		$limit =  " LIMIT " . $fsr . "," . $countOfpageRecordInPage;

		$expsession = jDateTime::date("Y/m/d H:i:s");

		$sql = "SELECT domain_id as id,d_name as domain_name,d_status as status,d_plan as plan FROM " .
			$GLOBALS["domains_tablename"]
			. ' WHERE d_status!=2 and ' . $GLOBALS["d_user_id_fk"] . "=" . $uid  . " " . $limit;
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			// VARS_ADMIN::ReturnHeaders(200);
			$response = [
				"status" => "error",
				"currentpage" => $page,
				"countofpage" => $countofpage,
				"message" => "دامنه ای یافت نشد"
			];
		} else {
			// VARS_ADMIN::ReturnHeaders(200);
			$response = [
				"status" => "success",
				"currentpage" => $page,
				"countofpage" => $countofpage,
				"message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType
			];
		}
		$result->free_result();
		$conn->close();

		return $response;
	}
	public static function GetDomainMainRecord($sessionkey, $domainid)
	{
		$sql = "";
		if ($sessionkey != "12") {
			$usersDetails = USERS_ADMIN::GetOneByToken($sessionkey);
			if ($usersDetails["status"] == "error") {
				//                  return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
			}

			$uid = $usersDetails["userdetail"][0]["uid"];

			$sql = "SELECT d_ddns,domain_id as id,d_name as domain_name,d_status as status from " .
				$GLOBALS["domains_tablename"]
				. ' WHERE d_status!=2 and ' . $GLOBALS["d_user_id_fk"] . "=" . $uid  . " AND domain_id= " . $domainid;
		} else {
			$sql = "SELECT d_ddns,domain_id as id,d_name as domain_name,d_status as status from " .
				$GLOBALS["domains_tablename"]     . " WHERE d_status!=2 AND domain_id= " . $domainid;
		}
		$conn = GetConnection();
		$result = $conn->query($sql);
		$page = 1;
		$countofpage = 15;
		if (!$result || mysqli_num_rows($result) == 0) {
			// VARS_ADMIN::ReturnHeaders(200);
			$response = [

				"status" => "error",
				"currentpage" => $page,
				"countofpage" => $countofpage,
				"message" => "دامنه ای یافت نشد"
			];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

			// VARS_ADMIN::ReturnHeaders(200);
			$response = [
				"status" => "success",
				"currentpage" => $page,
				"countofpage" => $countofpage,
				"message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType,
			];
		}

		$conn->close();

		return $response;
	}
	public static function SearchDomain($sessionkey, $phrase)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($sessionkey);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "SELECT domain_id as id,d_name as domain_name,d_status as status FROM " .
			$GLOBALS["domains_tablename"] .
			' WHERE ' . $GLOBALS["d_user_id_fk"] . "=" . $uid . " AND " .
			$GLOBALS['d_name'] . " LIKE '%" . $phrase . "%'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		if (!$result || mysqli_num_rows($result) == 0) {
			// VARS_ADMIN::ReturnHeaders(200);
			$response = ["status" => "error", "message" => "دامنه ای یافت نشد"];
		} else {
			$allWebsite = [];
			foreach ($listOfRecordType as $a) {
				$allWebsite[$a["domain_name"]] = WEBSITES_ADMIN::InternalGetWebsiteList(
					$a["id"],
					$a["status"]
				);
			}
			$response = [
				"status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
				"data" => $allWebsite
			];
			$conn->close();
		}
		return $response;
	}
	public static function CheckDomainExist($d_name)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] .
			" WHERE d_status!=2 and " . $GLOBALS["d_name"] . "='" . $d_name . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$r = ["status" => "success", "message" => "دامنه قابل ثبت است"];
		} else {
			$r = ["status" => "error", "message" => "دامنه قبلا ثبت شده است"];
		}
		$conn->close();
		return $r;
	}
	public static function GetDomainOwnerDetails($d_name, $uid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] .
			" WHERE d_status!=2 and " . $GLOBALS["d_name"] . "='" . $d_name . "' AND " .
			$GLOBALS["d_user_id_fk"] . "='" . $uid . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$r = ["status" => "error", "message" => "دامنه قابل ثبت است"];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

			$r = ["status" => "success", "data" => $listOfRecordType];
		}
		$conn->close();
		return $r;
	}
	public static function CheckDomainExistActive($d_name)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] .
			" WHERE d_status=0 and " . $GLOBALS["d_name"] . "='" . $d_name . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$r = ["status" => "success", "message" => "دامنه قابل ثبت است"];
		} else {
			$r = ["status" => "error", "message" => "دامنه قبلا ثبت شده است"];
		}
		$conn->close();
		return $r;
	}
	public static function CheckDomainOwnerID($d_id, $uid)
	{
		$expsession = jDateTime::date("Y/m/d H:i:s");
		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] .
			" WHERE d_status!=2 AND " . $GLOBALS["domain_id"] . "='" .
			$d_id . "' AND " . $GLOBALS['d_user_id_fk'] . "='" . $uid . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$r = ["status" => "error"];
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$r = ["status" => "success", "data" => $listOfRecordType];
		}

		$conn->close();
		return  $r;
	}
	public static function CheckDomainOwner($d_name, $token)
	{

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] .
			" WHERE d_status!=2 and " . $GLOBALS["d_name"] . "='" . $d_name . "' AND " .
			$GLOBALS["d_user_id_fk"] . "='" . $uid . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$r = ["status" => "error"];
		} else {
			$r = ["status" => "success"];
		}

		$conn->close();
		return  $r;
	}
	public static function GetDomainDetailsWithName($dname)
	{
		$sql = "SELECT * FROM " . $GLOBALS["domains_tablename"] . ' WHERE ' . $GLOBALS["d_name"] . "='" . $dname . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
}
