<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/dnsbalancer/dnsbalancer_filed_web.php';
class DNSBALANCER_ADMIN
{
	public static function GetListOfBalancersAndWrite($ns, $dname, $rid, $ttl, $recordname, $first = "second")
	{
		$sqldid = "SELECT * FROM " . $GLOBALS["dnsbalancer_tablename"] .
			" WHERE " . $GLOBALS["drb_drid_fk"] . "=" . $rid;
		$conn = GetConnection();

		$re = $conn->query($sqldid);
		if (!$re || mysqli_num_rows($re) == 0) {
			return  ["status" => "nobalance"];
		} else {
			$bl = self::GenerateDNSBalancerFile($ns, $dname, $rid, $ttl, $recordname);
		}
		if ($first == "first")
			self::GenerateDNSBalancerFile($ns, $dname, $rid, $ttl, $recordname);

		$conn->close();
		return ["status" => "balance", $bl];
	}
	public static function GenerateDNSBalancerFile($ns, $dname, $id, $ttl, $recordname, $first = "secord")
	{

		$requestedDomain = $recordname . "." . $dname;
		if ($recordname == $dname || $recordname == "@") {
			$requestedDomain = $recordname;
		}
		$my_file = $GLOBALS["RootFiles"] . "/dnsfiles/" . $requestedDomain . ".json";
		$handle = fopen($my_file, 'w') or die('Cannot open file:  ' . $my_file);
		$output = [];
		$output["ttl"] = $ttl;

		$output["records"][$requestedDomain] = [
			[
				"soa" => $ns . ",hostmaster." . $requestedDomain . ",2014090125,7200,3600,1209600,3600",
			],
			[
				"ns" => $ns
			]
		];

		$records = [];
		$records = self::GetListOfBalancers($id);

		$ouputRecords = [];
		$j = 0;
		$m = [];

		for ($i = 0; $i < count($records["data"]); $i++) {
			if ($records["data"][$i]["drb_country"] == "nocountry") {
				$records["data"][$i]["drb_country"] = "default";
			}
			if ($i > 0) {
				if ($records["data"][$i]["drb_weight"] == "0")
					$records["data"][$i]["drb_weight"] = "10";
				if ($records["data"][$i]["drb_country"] == $records["data"][$i - 1]["drb_country"]) {
					$o = ["a" => ["content" => $records["data"][$i]["drb_ip"], "weight" => $records["data"][$i]["drb_weight"]]];
					array_push($output["records"][strtolower($records["data"][$i]["drb_country"]) . "." . $requestedDomain], $o);
				} else {
					$o = ["a" => ["content" => $records["data"][$i]["drb_ip"], "weight" => $records["data"][$i]["drb_weight"]]];
					$output["records"][strtolower($records["data"][$i]["drb_country"]) . "." . $requestedDomain] = [$o];
				}
			} else {
				if ($records["data"][$i]["drb_weight"] == "0")
					$records["data"][$i]["drb_weight"] = "10";
				$o = ["a" => ["content" => $records["data"][$i]["drb_ip"], "weight" => $records["data"][$i]["drb_weight"]]];
				$output["records"][strtolower($records["data"][$i]["drb_country"]) . "." . $requestedDomain] = [$o];
			}

			// if($records["data"][$i]["drb_country"]=="nocountry"){
			//     $records["data"][$i]["drb_country"]="default";
			// }
			// if ($i > 0) {
			//     if ($i + 1 < count($records["data"])) {
			//         if ($records["data"][$i]["drb_country"] == $records["data"][$i - 1]["drb_country"]) {
			//             $o = ["a" => $records["data"][$i]["drb_ip"]];
			//             $output["records"][strtolower($records["data"][$i]["drb_country"]) . "444." . $requestedDomain]= [$o];
			//         } else {
			//             if ($records["data"][$i]["drb_country"] == $records["data"][$i + 1]["drb_country"]) {
			//                 $o = ["a" => $records["data"][$i]["drb_ip"]];
			//                 // $output["records"][strtolower($records["data"][$i]["drb_country"]) . "." . $requestedDomain] = [$o];
			//                                             $output["records"][strtolower($records["data"][$i]["drb_country"]) . "1111." . $requestedDomain] = [$o];

			//             } else {
			//                 if(array_key_exists($records["data"][$i]["drb_country"] . "." . $requestedDomain,$ouputRecords))
			//                 {
			//                 $o = ["a" => ["content" => $records["data"][$i]["drb_ip"],"weight" => $records["data"][$i]["drb_weight"]]];
			//                 $output["records"][strtolower($records["data"][$i]["drb_country"]) . "333." . $requestedDomain]= [$o];
			//                 }
			//                 else{
			//                     $o = ["a" => ["content" => $records["data"][$i]["drb_ip"],"weight" => $records["data"][$i]["drb_weight"]]];
			//                   $output["records"][strtolower($records["data"][$i]["drb_country"] ). "222." . $requestedDomain] = [$o];
			//                 }
			//             }
			//         }
			//     } else {
			//         if ($records["data"][$i]["drb_country"] == $records["data"][$i - 1]["drb_country"]) {
			//             $o = ["a" => $records["data"][$i]["drb_ip"]];
			//             $output["records"][strtolower($records["data"][$i]["drb_country"]) . "555." . $requestedDomain] = [$o];
			//         } else {
			//           $o = ["a" => ["content" => $records["data"][$i]["drb_ip"],"weight" => $records["data"][$i]["drb_weight"]]];
			//             $output["records"][strtolower($records["data"][$i]["drb_country"]) . "6666." . $requestedDomain] = [$o];
			//         }
			//     }
			// } else {
			//     $o = ["a" => ["content" => $records["data"][$i]["drb_ip"],"weight" => $records["data"][$i]["drb_weight"]]];
			//     $output["records"][strtolower($records["data"][$i]["drb_country"]) . "7777." . $requestedDomain] = [$o];
			// }

		}

		$services = [
			$requestedDomain => [
				"default" => [
					"%cc." . $requestedDomain,
					"default." . $requestedDomain
				]
			]
		];

		$output["services"] = $services;
		$out = json_encode($output);

		fwrite($handle, $out);
		if ($first == "first") {
			// DNSBALANCER_ADMIN::AddDomainToQueue($requestedDomain);
			//   API_DOMAIN_ADMIN::RunAddClusterDNS($requestedDomain);
		}
		DNSBALANCER_ADMIN::AddDomainToQueue($requestedDomain);
		//API_DOMAIN_ADMIN::RunAddClusterDNS($requestedDomain);
		return $records; //$output;
	}
	public static function GetListOfBalancers($rid)
	{
		$sqldid = "SELECT * FROM " . $GLOBALS["dnsbalancer_tablename"] .
			" WHERE " . $GLOBALS["drb_drid_fk"] . "=" . $rid . " ORDER BY drbid";
		$conn = GetConnection();

		$re = $conn->query($sqldid);
		if (!$re || mysqli_num_rows($re) == 0) {
			return  ["status" => "nobalance"];
		} else {
			$listOfRecordType = mysqli_fetch_all($re, MYSQLI_ASSOC);
		}
		if (count($listOfRecordType) > 0) {
			for ($i = 0; $i < count($listOfRecordType); $i++) {
				// if($listOfRecordType[$i]["drb_country"]=="default"){
				//     $listOfRecordType[$i]["drb_country"]="nocountry";
				//     $listOfRecordType[0]["drb_country"]="nocountry";
				// }
				// return ["data"=>$listOfRecordType[$i]];
				$listOfRecordType[$i]["drb_country"] = "nocountry";
			}
		}

		$conn->close();
		return ["status" => "balance", "data" => $listOfRecordType];
	}
	public static function GetListOfAllRecord($recordid, $domainname, $token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		if (DOMAINNSRECORD_ADMIN::UserCanAccessToRecord($uid, $recordid)["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این رکورد را ندارید"];
		}
		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);
		if ($canAccess["status"] == "error") {

			unset($canAccess["status"]);
			return  $canAccess;
		}
		return DNSBALANCER_ADMIN::GetListOfBalancers($recordid);
	}
	public static function AddInternalRecord($recordid, $ip, $token, $domainname)
	{
		return self::AddRecord($token, $domainname, $recordid, $ip, "default", "100", "120");
		// AddRecord($token, $domainname, $recordid, $ip, $country, $weight, $ttl)
		//  $sqldid = "SELECT * FROM " . $GLOBALS["dnsbalancer_tablename"] .
		//     " WHERE " . $GLOBALS["drb_drid_fk"] . "=" . $rid . " AND ".$GLOBALS['drb_ip']."='".$ip."'";
		// $conn = GetConnection();

		// $re = $conn->query($sqldid);
		// if (!$re || mysqli_num_rows($re) == 0) {
		//   $sql = "INSERT INTO " . $GLOBALS['dnsbalancer_tablename'] . " VALUES('0','" . $recordid . "','" . $ip . "','default','100','120')";
		// $conn = GetConnection();

		// $conn->query($sql);
		// $conn->close();
		// return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
		// }

	}
	public static function AddDomainToQueue($domain, $type = "balancer", $first = "no")
	{
		if ($type == "bind")
			return;
		$conn = GetConnection();
		$sql2 = "DELETE FROM `tbl_dns_queue` WHERE qname='" . $domain . "' and qtype='" . $type . "'";
		$conn->query($sql2);

		$sql = "insert into tbl_dns_queue(qname,qtype)VALUES('" . $domain . "','" . $type . "')";
		$conn->query($sql);
		$conn->close();

		// sleep(2);
		DOMAINNSRECORD_ADMIN::RunQueue();
		return $sql;
	}
	public static function AddRecordList($token, $domainname, $recordid, $list)
	{
		// return [$token,$domainname,$recordid,$list];
		$now = date("Y-m-d H:i:s");
		// return  self::GetListOfBalancers($recordid);// self::GenerateDNSBalancerFile($ns, $domainname, $recordid, $ttl, $rname);
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		// if ($usersDetails["credit"] < 0) {
		//     return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
		// }

		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);

		if ($canAccess["status"] == "error") {
			unset($canAccess["status"]);
			return $canAccess;
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$dt = DOMAINNSRECORD_ADMIN::UserCanAccessToRecord($uid, $recordid);
		if ($dt["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این رکورد را ندارید"];
		}
		// $l=json_decode($list,true);
		$l = @json_decode($list, true);
		if ($l === null && json_last_error() !== JSON_ERROR_NONE) {
			return ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		}
		foreach ($l as $b) {
			if (!isset($b["ip"])) {
				return ["status" => "error", "message" => "ارسال IP الزامی است"];
			}
			if (!isset($b["country"])) {
				return ["status" => "error", "message" => "ارسال IP الزامی است"];
			}
			if (!isset($b["weight"])) {
				return ["status" => "error", "message" => "ارسال IP الزامی است"];
			}
			if (!isset($b["ttl"])) {
				return ["status" => "error", "message" => "ارسال IP الزامی است"];
			}

			$country_array = [
				"DEFAULT",
				"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
				"BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
				"CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
				"EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
				"GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
				"KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
				"MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
				"NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
				"BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
				"SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
				"TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
			];

			if (!in_array(strtoupper($b["country"]), $country_array)) {
				return ["status" => "error", "message" => "کشور ارسالی نامعتبر است"];
			}
			if (!filter_var($b["ip"], FILTER_VALIDATE_IP)) {
				return  ["status" => "error", "ip" => $b["ip"], "message" => "IP نامعتبر است"];
			}
			if (filter_var($b["weight"], FILTER_VALIDATE_INT) === false) {
				return ["status" => "error", "message" => "وزن ارسالی شما نامعتبر است"];
			}
			if ($b["weight"] > 65535) {
				return ["status" => "error", "message" => "مقدار ارسالی برای وزن اشتباه است"];
			}
			if (filter_var($b["ttl"], FILTER_VALIDATE_INT) === false) {
				return ["status" => "error", "message" => "زمان ارسالی نامعتبر است"];
			}
			$sql = "INSERT INTO " . $GLOBALS['dnsbalancer_tablename'] . " VALUES('0','" . $recordid . "','" . $b["ip"] . "','" .
				$b["country"]  . "','" . $b["weight"] . "','" . $b["ttl"] . "')";
			$conn = GetConnection();
			$conn->query($sql);
			$balid = $conn->insert_id;
			$conn->close();
		}
		$rname = DOMAINNSRECORD_ADMIN::InternalGetOneRecordByID($recordid)["data"]["dnr_name"];
		$ns = USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token)["data"][0]["ns1"];
		if ($dt["data"][0]["dnr_name"] == $dt["data"][0]["d_name"]) {
			self::AddDomainToQueue($dt["data"][0]["d_name"]);
		} else {
			self::AddDomainToQueue($dt["data"][0]["dnr_name"] . "." . $dt["data"][0]["d_name"]);
		}
		$r = self::GenerateDNSBalancerFile($ns, $domainname, $recordid, "120", $rname);
		return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function AddRecord($token, $domainname, $recordid, $ip, $country, $weight, $ttl)
	{
		$now = date("Y-m-d H:i:s");
		// return  self::GetListOfBalancers($recordid);// self::GenerateDNSBalancerFile($ns, $domainname, $recordid, $ttl, $rname);
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}

		// if ($usersDetails["credit"] < 0) {
		//     return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
		// }

		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);

		if ($canAccess["status"] == "error") {
			unset($canAccess["status"]);
			return $canAccess;
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$dt = DOMAINNSRECORD_ADMIN::UserCanAccessToRecord($uid, $recordid);
		if ($dt["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این رکورد را ندارید"];
		}
		$country_array = [
			"DEFAULT",
			"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
			"BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
			"CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
			"EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
			"GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
			"KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
			"MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
			"NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
			"BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
			"SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
			"TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
		];

		if (!in_array(strtoupper($country), $country_array)) {
			return ["status" => "error", "message" => "کشور ارسالی نامعتبر است"];
		}
		if (!filter_var($ip, FILTER_VALIDATE_IP)) {
			return  ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"];
		}
		if (filter_var($weight, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "وزن ارسالی شما نامعتبر است"];
		}
		if ($weight > 65000) {
			return ["status" => "error", "message" => "مقدار ارسالی برای وزن اشتباه است"];
		}
		if (filter_var($ttl, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "زمان ارسالی نامعتبر است"];
		}
		$sql = "INSERT INTO " . $GLOBALS['dnsbalancer_tablename'] . " VALUES('0','" . $recordid . "','" . $ip . "','" .
			$country  . "','" . $weight . "','" . $ttl . "')";
		$conn = GetConnection();

		// $token, $id, $domainname, $recordid, $ip, $country, $weight, $ttl
		$rname = DOMAINNSRECORD_ADMIN::InternalGetOneRecordByID($recordid)["data"]["dnr_name"];

		$ns = USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token)["data"][0]["ns1"];

		if ($dt["data"][0]["dnr_name"] == $dt["data"][0]["d_name"]) {
			self::AddDomainToQueue($dt["data"][0]["d_name"]);
		} else {
			self::AddDomainToQueue($dt["data"][0]["dnr_name"] . "." . $dt["data"][0]["d_name"]);
		}

		$conn->query($sql);
		$balid = $conn->insert_id;
		$conn->close();
		$msn = DOMAINNSRECORD_ADMIN::ChangeCloudStatus($recordid, $token, 0, $canAccess["data"]["domain_id"], $domainname);
		self::GenerateDNSBalancerFile($ns, $domainname, $recordid, $ttl, $rname);
		return ["status" => "success",  "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function UpdateRecord($token, $id, $domainname, $recordid, $ip, $country, $weight, $ttl)
	{
		$now = date("Y-m-d H:i:s");

		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);
		if ($canAccess["status"] == "error") {
			unset($canAccess["status"]);
			return  $canAccess;
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$dt = DOMAINNSRECORD_ADMIN::UserCanAccessToRecord($uid, $recordid);
		if ($dt["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این رکورد را ندارید"];
		}
		$country_array = [
			"DEFAULT",
			"AF", "AX", "AL", "DZ", "AS", "AD", "AO", "AI", "AQ", "AG", "AR", "AM", "AW", "AU", "AT", "AZ", "BH", "BS", "BD", "BB", "BY", "BE", "BZ",
			"BJ", "BM", "BT", "BO", "BQ", "BA", "BW", "BV", "BR", "IO", "BN", "BG", "BF", "BI", "KH", "CM", "CA", "CV", "KY", "CF", "TD", "CL", "CN",
			"CX", "CC", "CO", "KM", "CG", "CD", "CK", "CR", "CI", "HR", "CU", "CW", "CY", "CZ", "DK", "DJ", "DM", "DO", "EC", "EG", "SV", "GQ", "ER",
			"EE", "ET", "FK", "FO", "FJ", "FI", "FR", "GF", "PF", "TF", "GA", "GM", "GE", "DE", "GH", "GI", "GR", "GL", "GD", "GP", "GU", "GT", "GG",
			"GN", "GW", "GY", "HT", "HM", "VA", "HN", "HK", "HU", "IS", "IN", "ID", "IR", "IQ", "IE", "IM", "IL", "IT", "JM", "JP", "JE", "JO", "KZ",
			"KE", "KI", "KP", "KR", "KW", "KG", "LA", "LV", "LB", "LS", "LR", "LY", "LI", "LT", "LU", "MO", "MK", "MG", "MW", "MY", "MV", "ML", "MT",
			"MH", "MQ", "MR", "MU", "YT", "MX", "FM", "MD", "MC", "MN", "ME", "MS", "MA", "MZ", "MM", "NA", "NR", "NP", "NL", "NC", "NZ", "NI", "NE",
			"NG", "NU", "NF", "MP", "NO", "OM", "PK", "PW", "PS", "PA", "PG", "PY", "PE", "PH", "PN", "PL", "PT", "PR", "QA", "RE", "RO", "RU", "RW",
			"BL", "SH", "KN", "LC", "MF", "PM", "VC", "WS", "SM", "ST", "SA", "SN", "RS", "SC", "SL", "SG", "SX", "SK", "SI", "SB", "SO", "ZA", "GS",
			"SS", "ES", "LK", "SD", "SR", "SJ", "SZ", "SE", "CH", "SY", "TW", "TJ", "TZ", "TH", "TL", "TG", "TK", "TO", "TT", "TN", "TR", "TM", "TC",
			"TV", "UG", "UA", "AE", "GB", "US", "UM", "UY", "UZ", "VU", "VE", "VN", "VG", "VI", "WF", "EH", "YE", "ZM", "ZW"
		];
		if (!in_array(strtoupper($country), $country_array)) {
			return ["status" => "error", "message" => "کشور ارسالی نامعتبر است"];
		}
		if (!filter_var($ip, FILTER_VALIDATE_IP)) {
			return  ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"];
		}
		if (filter_var($weight, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "وزن ارسالی شما نامعتبر است"];
		}
		if (filter_var($ttl, FILTER_VALIDATE_INT) === false) {
			return ["status" => "error", "message" => "زمان ارسالی نامعتبر است"];
		}
		$sql = "UPDATE " . $GLOBALS['dnsbalancer_tablename'] . " SET " . $GLOBALS['drb_ttl'] . "='" . $ttl . "'," . $GLOBALS['drb_weight'] . "='" .
			$weight . "'," . $GLOBALS['drb_country'] . "='" .   $country . "'," . $GLOBALS['drb_ip'] . "='" . $ip . "' where
        " . $GLOBALS['drb_drid_fk'] . "=" . $recordid . " AND " . $GLOBALS['drbid'] . "=" . $id;
		$conn = GetConnection();

		$conn->query($sql);
		$conn->close();
		// $token, $id, $domainname, $recordid, $ip, $country, $weight, $ttl
		$rname = DOMAINNSRECORD_ADMIN::InternalGetOneRecordByID($recordid)["data"]["dnr_name"];

		$ns = USSERNAMESERVERS_ADMIN::GetNameServerWithToken($token)["data"][0]["ns1"];

		if ($dt["data"][0]["dnr_name"] == ["data"][0]["d_name"]) {
			self::AddDomainToQueue($dt["data"][0]["d_name"]);
			self::GenerateDNSBalancerFile($ns, $domainname, $recordid, $ttl, $rname);
		} else {
			self::AddDomainToQueue($dt["data"][0]["dnr_name"] . "." . $dt["data"][0]["d_name"]);
			self::GenerateDNSBalancerFile($ns, $domainname, $recordid, $ttl, $rname);
		}
		return ["status" => "success", $now, "message" => "درخواست شما با موفقیت انجام شد"];
	}
	public static function DeleteRecord($token, $id, $domainname, $recordid, $action = "n")
	{
		$now = date("Y-m-d H:i:s");
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$canAccess = DOMAINNSRECORD_ADMIN::CheckUserCanAccessToDomain($domainname, $token);
		if ($canAccess["status"] == "error") {
			unset($canAccess["status"]);
			return  $canAccess;
		}

		$uid = $usersDetails["userdetail"][0]["uid"];
		$i = DOMAINNSRECORD_ADMIN::UserCanAccessToRecord($uid, $recordid);
		if ($i["status"] == "error") {
			return ["status" => "error", "message" => "شما اجازه دسترسی به این رکورد را ندارید"];
		}

		$c = DNSBALANCER_ADMIN::GetListOfAllRecord($recordid, $domainname, $token);
		if ($c["status"] == "nobalance")
			return  ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
		$n = [];
		foreach ($c["data"] as $b) {
			if ($b["drb_country"] == "default")
				$n = $b;
		}

		if ($i["data"][0]["dnr_name"] == $i["data"][0]["d_name"])
			API_DOMAIN_ADMIN::RunDeleteGeoAPI($i["data"][0]["d_name"]);
		else {
			API_DOMAIN_ADMIN::RunDeleteGeoAPI($i["data"][0]["dnr_name"] . "." . $i["data"][0]["d_name"]);
		}

		if ($action == "all") {
			$where = $GLOBALS['drb_drid_fk'] . "=" . $recordid;
			$sql  = "DELETE FROM  " . $GLOBALS['dnsbalancer_tablename'] . " WHERE " . $where;
			$conn = GetConnection();
			$conn->query($sql);
			$conn->close();
			return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
		}
		if (count($c["data"]) > 1 && $id != $n["drbid"]) {
			$where = $GLOBALS['drb_drid_fk'] . "=" . $recordid . " AND " . $GLOBALS['drbid'] . "=" . $id;
			if ($action == "all") {
				$where = $GLOBALS['drb_drid_fk'] . "=" . $recordid;
			}
			$sql = "DELETE FROM  " . $GLOBALS['dnsbalancer_tablename'] . " WHERE " . $where;

			$conn = GetConnection();
			$conn->query($sql);
			$conn->close();
			return ["status" => "success", $sql, "message" => "درخواست شما با موفقیت انجام شد"];
		} else if (count($c["data"]) > 1 &&  $id == $n["drbid"]) {
			return ["status" => "error", "message" => "شما امکان حذف مقدار پیش فرض را ندارید"];
		} else {

			$sql = "DELETE FROM  " . $GLOBALS['dnsbalancer_tablename'] . "  where
            " . $GLOBALS['drb_drid_fk'] . "=" . $recordid . " AND " . $GLOBALS['drbid'] . "=" . $id;
			$conn = GetConnection();

			$conn->query($sql);
			$conn->close();
			return ["status" => "success", $now, "message" => "درخواست شما با موفقیت انجام شد"];
		}
		return ["status" => "success", $now, "message" => "درخواست شما با موفقیت انجام شد"];
	}
}
