<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/users_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/creditdetails/creditdetails_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/creditbalance/admin/creditbalance_admin_class.php';

class CREADITDETAILS_ADMIN
{

    public static function GetList()
    {
        $sql = "SELECT * FROM " . $GLOBALS["creditdetails_tablename"] . "," .
        $GLOBALS["users_tablename"] . " WHERE "
            . $GLOBALS["uid"] . "=" . $GLOBALS["cd_uid_fk"];
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetRecordWithParameter($fieldname, $fieldvalue)
    {
        /**
         * @param $activerecord
         * @return mixed
         */
        $sql = "SELECT * FROM " . $GLOBALS["creditdetails_tablename"] . "," . $GLOBALS["users_tablename"]
            . " WHERE " . $GLOBALS["uid"] . "=" . $GLOBALS["cd_uid_fk"] . " AND " . $GLOBALS[$fieldname] . " LIKE '" . $fieldvalue . "'";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["result" => "null"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneByID($cd_id)
    {
        $sql = "SELECT * FROM " . $GLOBALS["creditdetails_tablename"] . " WHERE " . $GLOBALS['cd_id'] . "=" . $cd_id;
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["result" => "null"];
            return $result;
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        }
        $result->free_result();

        $conn->close();
        return $listOfRecordType;
    }
    public static function AddCreditDetails($cd_description, $cd_amount, $cd_uid_fk, $cd_type)
    {

        // self::CheckRecordDuplicated($cd_description, $cd_amount, $cd_uid_fk, $cd_type);
        if (self::CheckRecordDuplicated($cd_description, $cd_amount, $cd_uid_fk, $cd_type)["status"] == "success" && $cd_type == "9") {
            return self::CheckRecordDuplicated($cd_description, $cd_amount, $cd_uid_fk, $cd_type);
        }
        $conn = GetConnection();
        $sql = "INSERT INTO " . $GLOBALS['creditdetails_tablename'] . "(" . $GLOBALS['cd_description'] . ","
            . $GLOBALS['cd_amount'] . "," . $GLOBALS['cd_uid_fk'] . "," . $GLOBALS['cd_date'] . "," . $GLOBALS['cd_type']
            . ") VALUES ('%s',%s,%s,'%s',%s)";
        $sql = sprintf($sql, $cd_description, $cd_amount, $cd_uid_fk, jDateTime::date("Y-m-d H:i:s"), $cd_type);

        if ($conn->query($sql) === TRUE) {
            $last_id = $conn->insert_id;
            $CREADITBALANCE_ADMIN = new CREADITBALANCE_ADMIN();
            $nb=$CREADITBALANCE_ADMIN->UpdateCreditBalance($cd_amount, $cd_uid_fk);
            self::UpadteLatestBalance($last_id,$nb["balance"]);
            $response = ["status" => "success", "balance"=>$nb,"message" => "New record created successfully"];

            return $response;
        } else {
            $response = ["status" => "error", "message" => $sql . " " . $conn->error];
            return $response;
        }

        $conn->close();
    }
    public static function UpadteLatestBalance($id, $balance){
        $sql="UPDATE " . $GLOBALS['creditdetails_tablename'] . " SET cd_current_balance='".$balance."' where cd_id=".$id;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function CheckRecordDuplicated($descriprion, $amount, $uid, $type)
    {
        $sql = "SELECT count(cd_id) as Cnt FROM `tbl_credit_details` WHERE
        cd_description='" . $descriprion . "' and cd_amount='" . $amount . "' and cd_uid_fk=" . $uid . " AND cd_type=" . $type;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        if ($listOfRecordType[0]["Cnt"] != "0") {
            return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
        } else {
            return ["status" => "error", $sql];
        }
    }
    public static function GetByUser($uid)
    {
        /**
         * @param $activerecord
         * @return mixed
         */
        $sql = "SELECT * FROM " . $GLOBALS["creditdetails_tablename"] . "," . $GLOBALS["users_tablename"]
            . " WHERE " . $GLOBALS["uid"] . "=" . $GLOBALS["cd_uid_fk"] . " AND " . $GLOBALS["cd_uid_fk"] . "=" . $uid." order by cd_id desc";
        $conn = GetConnection();

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "0", "message" => "record not found"];
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $result = ["status" => "1", "creditbalance" => $listOfRecordType];
        }

        $conn->close();
        return $result;
    }
    public static function GetCountOfRecord($uid){
        $sql = "SELECT count(cd_uid_fk) as cnt from " . $GLOBALS["creditdetails_tablename"]
            . " WHERE " . $GLOBALS["cd_uid_fk"] . "=" . $uid;
        $conn = GetConnection();
        $result = mysqli_query($conn, $sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

        return $listOfRecordType[0]["cnt"];
    }
    public static function GetByToken($token,$page,$countofrecord)
    {
        $usersDetails=USERS_ADMIN::GetOneByToken($token,"GetCredit");

        if($usersDetails["status"]=="error"){
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid=$usersDetails["userdetail"][0]["uid"];
        $expsession = jDateTime::date("Y/m/d H:i:s");
        $countOfRecord= self::GetCountOfRecord($uid);
        $fsr=($page-1)*$countofrecord;
        $enr=$page*$countofrecord;
        $countOfpageRecordInPage=$countofrecord;
        $a= $countOfRecord / $countOfpageRecordInPage;

        if( $countOfRecord > $countofrecord){
            $countofpage=intdiv($countOfRecord, $countOfpageRecordInPage);
            if(!is_int($a)) $countofpage=$countofpage+1;
        }
        else{
            $countofpage=1;
        }

        $sql = "SELECT * FROM " . $GLOBALS["creditdetails_tablename"]
            . " WHERE " . $GLOBALS["cd_uid_fk"] . "=".$uid." order by cd_id desc LIMIT ".$fsr.",".$countofrecord;
        $conn = GetConnection();

        $result = "[";

        $result = mysqli_query($conn, $sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            // VARS_ADMIN::ReturnHeaders(400);
            $result = ["status"=>"success","message" => "اطلاعاتی با درخواست ارسال وجود ندارد", "data"=>[] ];
            return $result;
        } else {
            // VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

            $sum = 0;
            $res = [];
            for ($i = 0; $i < count($listOfRecordType); $i++) {
                $sm = $listOfRecordType[$i]["cd_amount"] + $sum;
                $res[$listOfRecordType[$i]["cd_id"]] = array(
                    "id"=>$listOfRecordType[$i]["cd_id"],
                    "account_balance" => $sum,
                    "credit_description" => $listOfRecordType[$i]["cd_description"],
                    "amount" => $listOfRecordType[$i]["cd_amount"],
                    "date_of_transaction" => $listOfRecordType[$i]["cd_date"],
                    "latest_balance" => $listOfRecordType[$i]["cd_current_balance"] == '' ? "0":$listOfRecordType[$i]["cd_current_balance"] ,
                );
                //  $result.='{';
                // $result.='"account_balance":"'.$sum.'",';
                $sum = $listOfRecordType[$i]["cd_amount"] + $sum;

                // $result.='"credit_description":"'.$listOfRecordType[$i]["cd_description"].'",';
                // $result.='"amount":"'.$listOfRecordType[$i]["cd_amount"].'",';
                // $result.='"date_of_transaction":"'.$listOfRecordType[$i]["cd_date"].'",';
                // $result.='"latest_balance":"'.$sum.'"';
                // $result.='},
                // ';
            }
            // $result=substr($result, 0, -1);
            $result = ["status"=>"success", "message" => "اطلاعات با موفقیت دریافت شد",
            "currentpage"=>$page,
            "countofpage"=>$countofpage,
            "countofrecord"=>$countofrecord,
            "data" => $res];
            //$result.="]";
        }

        $conn->close();
        return $result;
    }
}
