<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/cdn/cdn_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class CDN_ADMIN
{
    public static function AddDefault($websiteid)
    {
        $rep = CDN_ADMIN::GetOneByWebsiteID("12", $websiteid);
        if ($rep["code"] == "200") {
            return;
        }
        $sql = "INSERT INTO " . $GLOBALS["cdn_tablename"] . " (" .
            $GLOBALS['cdnw_wid_fk'] . "," .
            $GLOBALS['cdnw_cache_level'] . "," . $GLOBALS['cdnw_always_online'] . "," .
            $GLOBALS['cdnw_css_minify'] . "," . $GLOBALS['cdnw_js_minify'] . "," .
            $GLOBALS['cdnw_html_minify'] . "," . $GLOBALS['cdnw_cache_ttl'] . "," .
            $GLOBALS['cdnw_developermode'] . "," . $GLOBALS['cdnw_hotlink_protection'] . "," .
            $GLOBALS['cdnw_server_cache_ttl'] . "," . $GLOBALS['cdnw_sslstatus'] . ")
                VALUES(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)";
        $sql = sprintf($sql, $websiteid, 1, 0, 0, 0, 0, 1440, 0, 0, 1440, 0);
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = ["status" => "success"];
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneByWebsiteID($token, $websiteid)
    {
        if($token!="12"){
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                // VARS_ADMIN::ReturnHeaders(301);
                return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید" ];
            }
            $uid = $usersDetails["userdetail"][0]["uid"];

        }
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, 0);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
        }

        $nsql = "SELECT * FROM tbl_cdn_log_websitebandwidth where clwb_did_fk=" . $websitesOwner["data"][0]["ws_domainid_fk"];
        $conn = GetConnection();
        $nresult = $conn->query($nsql);
        $nlist = mysqli_fetch_all($nresult, MYSQLI_ASSOC);
        $sql = "SELECT cdnw_sslstatus as sslstatus,
                cdnw_server_cache_ttl as cache_server_ttl,
                cdnw_hotlink_protection as hotlink_protection,
                cdnw_developermode as developermode,
                cdnw_cache_ttl as browser_cache_ttl,
                cdnw_html_minify as html_minify,
                cdnw_js_minify as js_minify,
                cdnw_css_minify as css_minify,
                cdnw_always_online  as always_online,
                cdnw_cache_level as cache_level
                FROM " . $GLOBALS['cdn_tablename'] . " WHERE
        " . $GLOBALS['cdnw_wid_fk'] . "=" .  $websiteid;

        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "success","code"=>"201", "bw"=>$nlist, "message" => "اطلاعات با موفقیت دریافت شد", "data" => [
                "sslstatus" => "0",
                "cache_server_ttl" => "30m",
                "hotlink_protection" => "0",
                "developermode" => "0",
                "browser_cache_ttl" => "30m",
                "html_minify" => "0",
                "js_minify" => "0",
                "css_minify" => "0",
                "always_online" => "0",
                "cache_level" => "1"
            ]];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $ttl_array = [
                "10s" => "10s","-1" => "-1","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
                "30m" => "30", "1h" => "60",
                "2h" => "120", "3h" => "180", "6h" => "360",
                "12h" => "720",
                "1d" => "1440", "3d" => "4320", "7d" => "10800",
                "10d" => "14400", "15d" => "21600", "30d" => "43200",
                "180d" => "259200", "365" => "525600"
            ];
            $browser_cache_ttl = array_search($list[0]["browser_cache_ttl"], $ttl_array);
            $cache_server_ttl = array_search($list[0]["cache_server_ttl"], $ttl_array);
            $list[0]["cache_server_ttl"] = $cache_server_ttl;

            $list[0]["browser_cache_ttl"] = $browser_cache_ttl;
            $listOfRecordType = ["status" => "success","code"=>"200", "message" => "اطلاعات با موفقیت دریافت شد","bw"=>$nlist,  "data" => $list[0]];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UpdateCdn($token, $filedID, $value, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(301);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید" ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $canaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($canaccess["status"] == "error") {
            return ["status" => "error", "message" => "شما مجوز دسترسی به این سایت را ندارید" ];
        }
        $dmn = TOOLS_ADMIN::ReturnDomainName($canaccess);
        $fileds = [
            'cache_level' => 'cdnw_cache_level',
            'always_online' => 'cdnw_always_online',
            'css_minify' => 'cdnw_css_minify',
            'js_minify' => 'cdnw_js_minify',
            'html_minify' => 'cdnw_html_minify',
            'browser_cache_ttl' => 'cdnw_cache_ttl',
            'developermode' => 'cdnw_developermode',
            'hotlink_protection' => 'cdnw_hotlink_protection',
            'server_cache_ttl' => 'cdnw_server_cache_ttl',
            'sslstatus' => 'cdnw_sslstatus'
        ];
        if (array_key_exists($filedID, $fileds)) {
            if ($filedID == "cache_level") {
                $cachelevel_array = ["1", "2", "3", "4"];
                //1 = standard
                //2 = With query String
                //3 = without query string
                //4 = No Cache
                if (in_array($value, $cachelevel_array)) {
//                  $cachelevelAPI_array = ["1" => "standard", "2" => "vqs", "3" => "wqa", "4" => "nocache"];
                    $cachelevelAPI_array = ["1" => "standard", "2" => "standard", "3" => "vqs", "4" => "nocache"];
                    API_CAHCE_ADMIN::RunCreateAPICacheLevel($dmn, $cachelevelAPI_array[$value], null);

                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "always_online") {
                $always_online_array = ["0", "1"];
                if (in_array($value, $always_online_array)) {
                    CDN_ADMIN::UpdateFields("cdnw_always_online",$value , $websiteid);
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    LOGS_ADMIN::AddLog("تغییر در وضعیت دسترسی همیشگی ".$dmn,$uid, 0, "", "users");
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "css_minify") {
                $css_minify_array = ["0", "1"];
                if (in_array($value, $css_minify_array)) {
                    if ($value == "0") {
                        API_MINIFYWEBSITE_ADMIN::RunDisableAPIMINIFYWEBSITE($dmn, "css", null);
                    } else if ($value == "1") {
                        API_MINIFYWEBSITE_ADMIN::RunCreateAPIMINIFYWEBSITE($dmn, "css", null);
                    }
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    LOGS_ADMIN::AddLog("تغییر در فشرده سازی CSS ".$dmn,$uid, 0, "", "users");
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "js_minify") {
                $js_minify_array = ["0", "1"];
                if (in_array($value, $js_minify_array)) {
                    if ($value == "0") {
                        API_MINIFYWEBSITE_ADMIN::RunDisableAPIMINIFYWEBSITE($dmn, "js", null);
                    } else if ($value == "1") {
                        API_MINIFYWEBSITE_ADMIN::RunCreateAPIMINIFYWEBSITE($dmn, "js", null);
                    }
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    LOGS_ADMIN::AddLog("تغییر در فشرده سازی JS ".$dmn,$uid, 0, "", "users");

                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "html_minify") {
                $html_minify_array = ["0", "1"];
                if (in_array($value, $html_minify_array)) {
                    if ($value == "0") {
                        API_MINIFYWEBSITE_ADMIN::RunDisableAPIMINIFYWEBSITE($dmn, "html", null);
                    } else if ($value == "1") {
                        API_MINIFYWEBSITE_ADMIN::RunCreateAPIMINIFYWEBSITE($dmn, "html", null);
                    }
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    LOGS_ADMIN::AddLog("تغییر در فشرده سازی HTML ".$dmn,$uid, 0, "", "users");

                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "browser_cache_ttl") {
                //iNTERVALS: 30m/1h/2h/3h/4h/5h/8h/12h/16h/20h/
                //INTERVALS: 1d/2d/3d/4d/5d/8d/16d/24d/1m/2m/6m/1y
                $browser_cache_ttl_array =  [
                "10s" => "10s","-1" => "-1","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
                "30m" => "30", "1h" => "60",
                "2h" => "120", "3h" => "180", "6h" => "360",
                "12h" => "720",
                "1d" => "1440", "3d" => "4320", "7d" => "10800",
                "10d" => "14400", "15d" => "21600", "30d" => "43200",
                "180d" => "259200", "365" => "525600"
            ];
                if (isset($browser_cache_ttl_array[$value])) {
                    API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, $browser_cache_ttl_array[$value], null);
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    LOGS_ADMIN::AddLog("تغییر در زمان اعتبار کش ".$dmn,$uid, 0, "", "users");

                    $value = $browser_cache_ttl_array[$value];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "developermode") {
                $developermode_array = ["0", "1"];
                if (in_array($value, $developermode_array)) {
                    if ($value == "0") {
                        CDN_ADMIN::UpdateFields("cdnw_developermode",$value , $websiteid);
                        API_CAHCE_ADMIN::RunCreateAPICacheLevel($dmn, "standard", null);
                    } else if ($value == "1") {
                        CDN_ADMIN::UpdateFields("cdnw_developermode",$value , $websiteid);
                        API_CAHCE_ADMIN::RunCreateAPICacheLevel($dmn, "nocache", null);
                    }
                    LOGS_ADMIN::AddLog("تغییر در وضعیت برنامه نویسی ".$dmn,$uid, 0, "", "users");
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "hotlink_protection") {
                $hotlink_protection_array = ["0", "1"];
                if (in_array($value, $hotlink_protection_array)) {
                    if ($value == "0") {
                        API_MINIFYWEBSITE_ADMIN::RunDisableAPIMINIFYWEBSITE($dmn, "css", null);
                    } else if ($value == "1") {
                        API_MINIFYWEBSITE_ADMIN::RunCreateAPIMINIFYWEBSITE($dmn, "css", null);
                    }
                    LOGS_ADMIN::AddLog("تغییر در وضعیت لینک امن ".$dmn,$uid, 0, "", "users");
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "server_cache_ttl") {
                //iNTERVALS: 30m/1h/2h/3h/4h/5h/8h/12h/16h/20h/
                //INTERVALS: 1d/2d/3d/4d/5d/8d/16d/24d/1m/2m/6m/1y
                $server_cache_ttl_array =  [
                "10s" => "10s","-1" => "-1","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
                "30m" => "30", "1h" => "60",
                "2h" => "120", "3h" => "180", "6h" => "360",
                "12h" => "720",
                "1d" => "1440", "3d" => "4320", "7d" => "10800",
                "10d" => "14400", "15d" => "21600", "30d" => "43200",
                "180d" => "259200", "365" => "525600"
            ];
                if (isset($server_cache_ttl_array[$value])) {
                    LOGS_ADMIN::AddLog("تغییر در زمان اعتبار کش ".$dmn,$uid, 0, "", "users");
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                    $value = $server_cache_ttl_array[$value];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }
            if ($filedID == "sslstatus") {
                $sslstatus_array = ["0", "1"];
                if (in_array($value, $sslstatus_array)) {
                    LOGS_ADMIN::AddLog("تغییر در وضعیت SSL  ".$dmn,$uid, 0, "", "users");
                    $out = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    $out = ["status" => "error", "message" => "مقدار ارسالی برای این بخش نامعتبر است"];
                }
            }

            if ($out["status"] == "success") {

                $sql = "update " . $GLOBALS["cdn_tablename"] . " SET " . $GLOBALS[$fileds[$filedID]] . "=" . $value .
                    " WHERE " . $GLOBALS["cdnw_wid_fk"] . "=" . $websiteid;
                $conn = GetConnection();
                if ($conn->query($sql) === TRUE) {
                    return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد"];
                } else {
                    return ["status" => "error", "message" => "خطا در انجام درخواست"];
                }
            }
            return $out;
        } else {
            return ["status" => "error", "message" => "خطا در مقادیر ارسالی نام فیلد ارسالی شما اشتباه است"];
        }
    }
    public static function UpdateFields($fields, $value, $websiteid)
    {
        CDN_ADMIN::AddDefault($websiteid);
        $ins = "UPDATE " . $GLOBALS["cdn_tablename"] . " SET  " .
            $GLOBALS[$fields] . "='" . $value . "' WHERE " .
            $GLOBALS["cdnw_wid_fk"] . "=" . $websiteid;
            $conn = GetConnection();
        $conn->query($ins);
        $conn->close();
    }
    public static function CanAccessToPoolid($poolid, $uid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["sslpools_tablename"] . " WHERE "
            . $GLOBALS['sslpoolsid'] . "=" . $poolid . " AND " . $GLOBALS['sp_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success", "data" => $list];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
}
