<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/cache/cache_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/cache/cache.php';

class CACHE_ADMIN
{
    public static function CheckCacheForDownGrade($domainID, $currentPlan, $newPlan)
    {

        $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
        // [
        //     "10s" => "10s", "-1" => "-1", "30s" => "30s", "1m" => "1", "2m" => "2", "5m" => "5", "10m" => "10", "20m" => "20",
        //     "30m" => "30", "45m" => "45", "1h" => "60",
        //     "2h" => "120", "3h" => "180", "6h" => "360",
        //     "12h" => "720",
        //     "1d" => "1440", "3d" => "4320", "7d" => "10800",
        //     "10d" => "14400", "15d" => "21600", "30d" => "43200",
        //     "180d" => "259200", "365" => "525600"
        // ];
        $currentValue = ReturnPlans()[$currentPlan]["mincache"];
        $NewValue = ReturnPlans()[$newPlan]["mincache"];
        $sql = "SELECT * FROM `tbl_main_cache`,tbl_websites,tbl_domains WHERE domain_id=ws_domainid_fk and `mc_wid_fk`=wsid and domain_id=" . $domainID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "success"];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            foreach ($r as $f) {
                $websitename = $f["d_name"];
                if ($f["d_name"] != $f["ws_recordname"])
                    $websitename = $f["ws_recordname"] . "." . $f["d_name"];
                if ($f["mc_browsercache_ttl"] < $browser_cache_ttl_array[$NewValue]) {
                    return ["status" => "error", "newvalue" => $NewValue, "cachetime" => $f["mc_browsercache_ttl"], "message" => "زمان کش انتخاب شده برای سایت " . $websitename . " کم تر از زمان مجاز پلان درخواستی شماست"];
                }
                if ($f["mc_servercache_ttl"] < $browser_cache_ttl_array[$NewValue]) {
                    return ["status" => "error", "message" => "زمان کش انتخاب شده برای سایت " . $websitename . " کم تر از زمان مجاز پلان درخواستی شماست"];
                }
            }
            $conn->close();
        }

        $sql = "SELECT * FROM `tbl_subfolder`,tbl_websites,tbl_domains,tbl_subdfolder_servercachettl WHERE
                                    domain_id=ws_domainid_fk and subfolder_id= 	sfsct_sf_id_fk AND 	sf_ws_id_fk =wsid and domain_id=" . $domainID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "success"];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            foreach ($r as $f) {

                $websitename = $f["d_name"];
                if ($f["d_name"] != $f["ws_recordname"])
                    $websitename = $f["ws_recordname"] . "." . $f["d_name"];
                if ($f["sfsct_value"] < $browser_cache_ttl_array[$NewValue]) {
                    return [
                        "status" => "error", "message" => "زمان کش انتخاب شده برای سایت " . $websitename . " در مسیر فرعی " . $f["sf_name"] . " کم تر از زمان مجاز پلان درخواستی شماست"
                    ];
                }
            }
            $conn->close();
        }
        $sql = "SELECT * FROM `tbl_subfolder`,tbl_websites,tbl_domains,tbl_subdfolder_browsercachettl WHERE
                                    domain_id=ws_domainid_fk and subfolder_id= 	sfbct_sf_id_fk AND 	sf_ws_id_fk =wsid and domain_id=" . $domainID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = ["status" => "success"];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            foreach ($r as $f) {
                $websitename = $f["d_name"];
                if ($f["d_name"] != $f["ws_recordname"])
                    $websitename = $f["ws_recordname"] . "." . $f["d_name"];
                if ($f["sfbct_value"] < $browser_cache_ttl_array[$NewValue]) {
                    return [
                        "status" => "error", "message" => "زمان کش انتخاب شده برای سایت " . $websitename . " در مسیر فرعی " . $f["sf_name"] . " کم تر از زمان مجاز پلان درخواستی شماست"
                    ];
                }
            }
            $conn->close();
        }
        return ["status" => "success"];
    }
    public static function GetWebsiteCache($token, $websiteid)
    {
        $uid = 0;

        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                //                  return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
            }
            $uid = $usersDetails["userdetail"][0]["uid"];
        }

        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
        //  [
        //         "-1" => "-1","10s" => "10s","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
        //         "30m" => "30", "1h" => "60",
        //         "2h" => "120", "3h" => "180", "6h" => "360",
        //         "12h" => "720",
        //         "1d" => "1440", "3d" => "4320", "7d" => "10800",
        //         "10d" => "14400", "15d" => "21600", "30d" => "43200",
        //         "180d" => "259200", "365" => "525600"
        //     ];
        $sql = "SELECT mc_type as cachetype,mc_servercache_ttl as serverttl,mc_browsercache_ttl as browserttl FROM " . $GLOBALS["cache_tablename"] .
            " WHERE " . $GLOBALS["mc_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $cacheTypes = ["nocache", "nocache", "wqs", "standard"];
        if (!$result || mysqli_num_rows($result) == 0) {
            self::UpdateWebsiteCache($token, $websiteid, 4, 0, 0);
            $listOfRecordType = [
                "status" => "success",
                "data" => [
                    "cachetype" => "4",
                    "serverttl" =>   "1h",
                    "browserttl" =>  "3h",
                ], "realdata" => [
                    "cachetype" => "standard",
                    "serverttl" =>   "1h",
                    "browserttl" =>  "3h",
                ]
            ];
            $conn->close();
        } else {

            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => [
                    "cachetype" => $r[0]["cachetype"],
                    "serverttl" =>  array_search($r[0]["serverttl"], $browser_cache_ttl_array),
                    "browserttl" =>  array_search($r[0]["browserttl"], $browser_cache_ttl_array),
                ], "realdata" => [
                    "cachetype" => $cacheTypes[intVal($r[0]["cachetype"]) - 1],
                    "serverttl" =>   $r[0]["serverttl"],
                    "browserttl" =>  $r[0]["browserttl"],
                ]
            ];
            $conn->close();
        }

        return $listOfRecordType;
    }
    public static function RemoveCachedFiles($token, $websiteid, $path)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        // if ($usersDetails["credit"] < 0) {
        //     return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        // }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        $lengthofdomain = strlen($dmn);

        $lengthofdomainwithhttp = $lengthofdomain + 8;
        $lengthofdomainwithhttps = $lengthofdomain + 9;
        if (substr($path, 0, $lengthofdomain) == $dmn) {
            $path = substr($path, $lengthofdomain, strlen($path));
        }
        if (substr($path, 0, $lengthofdomainwithhttp) == "http://" . $dmn . "/") {

            $path = substr($path, $lengthofdomainwithhttp, strlen($path));
        }
        if (substr($path, 0, $lengthofdomainwithhttps) == "https://" . $dmn . "/") {
            $path = substr($path, $lengthofdomainwithhttps, strlen($path));
        }
        API_CAHCE_ADMIN::RunPurgeCache($dmn, $path);
        LOGS_ADMIN::AddLog("پاک کردن کش در مسیر" . $dmn . $path, $uid, 0, "", "users");

        return ["status" => "success", $path, "message" => "درخواست شما انجام شد"];
    }
    public static function InternalUpdate($websiteid, $field, $value)
    {

        //  "cachetype" => "standard",
        // "serverttl" =>   "1h",
        // "browserttl" =>  "3h",
        $sql = "SELECT * FROM " . $GLOBALS["cache_tablename"] .
            " WHERE " . $GLOBALS["mc_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
        if($field!="mc_type"){
            $value=$browser_cache_ttl_array[$value];
        }

        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["cache_tablename"] . " (" . $GLOBALS['mc_wid_fk'] . "," . $GLOBALS['mc_type'] . "," . $GLOBALS['mc_browsercache_ttl'] . "," . $GLOBALS['mc_servercache_ttl'] . ")
                    VALUE (" . $websiteid . ",4,'12','10')";
            $conn->query($ins);
        }
        $ins = "UPDATE " . $GLOBALS["cache_tablename"] . " SET " . $GLOBALS[$field] . "='" . $value . "'  WHERE " . $GLOBALS['mc_wid_fk'] . "=" . $websiteid;





        $conn->query($ins);
        $conn->close();
        return $ins;
    }
    public static function UpdateWebsiteCache($token, $websiteid, $status, $browsercachettl, $servercachettl)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }

        if ($status == "") {
            return ["status" => "error", "message" => "امکان خالی بودن وضعیت وجود ندارد"];
        }
        $allowedstatus = ["1", "2", "3", "4"];
        $methods = explode(",", $status);
        $res = [];
        $stat = 1;
        foreach ($methods as $method) {
            if (!in_array(strtoupper($method), $allowedstatus)) {
                $stat = 0;
                array_push(
                    $res,
                    ["status" => "error", "status" => $status, "message" => "وضعیت نامعتبر است"]
                );
            }
        }
        if ($stat == 0) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی"];
        }
        $browser_cache_ttl_array = TOOLS_ADMIN::ReturnCacheStaus();
        // [
        //          "-1" => "-1","10s" => "10s","30s" => "30s","1m" => "1","2m" => "2","5m" => "5","10m" => "10","20m" => "20",
        //         "30m" => "30", "1h" => "60",
        //         "2h" => "120", "3h" => "180", "6h" => "360",
        //         "12h" => "720",
        //         "1d" => "1440", "3d" => "4320", "7d" => "10800",
        //         "10d" => "14400", "15d" => "21600", "30d" => "43200",
        //         "180d" => "259200", "365" => "525600"
        //     ];
        if (!array_key_exists($browsercachettl, $browser_cache_ttl_array)) {
            return ["status" => "error", "message" => "مقدار ارسالی برای زمان کش اطلاعات در مرورگر کاربر اشتباه است"];
        }
        if (!array_key_exists($servercachettl, $browser_cache_ttl_array)) {
            return ["status" => "error", "message" => "مقدار ارسالی برای زمان کش اطلاعات در سرور های CDN اشتباه است"];
        }
        $serverttl = $browser_cache_ttl_array[$servercachettl];
        $browserttl = $browser_cache_ttl_array[$browsercachettl];
        $planwebsite = $websitesOwner["data"][0]["wsplan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            // if ($browsercachettl != "-1") {
            //     if (intVal($browser_cache_ttl_array[$browsercachettl]) <  intVal($browser_cache_ttl_array[$plans[$planwebsite]["mincache"]])) {
            //         return [
            //             "status" => "error", $browser_cache_ttl_array[$browsercachettl], $browser_cache_ttl_array[$plans[$planwebsite]["mincache"]],
            //             "type" => "browsercache",
            //             "message" => "شما امکان انتخاب این بازه زمانی را ندارید و باید پلان سایت خود را ارتقا دهید"
            //         ];
            //     }
            // }
            if ($servercachettl != "-1") {
                if (intVal($browser_cache_ttl_array[$servercachettl])  <  intVal($browser_cache_ttl_array[$plans[$planwebsite]["mincache"]])) {
                    return [
                        "status" => "error", $browser_cache_ttl_array[$servercachettl],
                        "type" => "serverttl",
                        "message" => "شما امکان انتخاب این بازه زمانی را ندارید و باید پلان سایت خود را ارتقا دهید"
                    ];
                }
            }
        } else {
            return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
        }

        // return ["status"=>"error","srv"=>["br"=>$browsercachettl,"re"=>intVal($browser_cache_ttl_array[$browsercachettl]) ,"pl"=>intVal($browser_cache_ttl_array[$plans[$planwebsite]["mincache"]])]];

        if (CDN_ADMIN::GetOneByWebsiteID($token, $websiteid)["data"]["developermode"] == "1") {
            return ["status" => "error", "message" => "شما حالت برنامه نویسی را فعال نموده اید و برای اعمال تغییرات در کش باید ابتداآن را غیر فعال نمایید"];
        }
        $sql = "SELECT * FROM " . $GLOBALS["cache_tablename"] .
            " WHERE " . $GLOBALS["mc_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["cache_tablename"] . " (" . $GLOBALS['mc_wid_fk'] . "," . $GLOBALS['mc_type'] . "," . $GLOBALS['mc_browsercache_ttl'] . "," . $GLOBALS['mc_servercache_ttl'] . ")
                    VALUE (" . $websiteid . "," . $status . ",'11','9')";
        } else {
            $ins = "UPDATE " . $GLOBALS["cache_tablename"] . " SET " . $GLOBALS['mc_type'] . "=" . $status . "," .
                $GLOBALS['mc_browsercache_ttl'] . "='" . $browserttl . "'," .
                $GLOBALS['mc_servercache_ttl'] . "='" . $serverttl . "'
                            WHERE " . $GLOBALS['mc_wid_fk'] . "=" . $websiteid;
        }
        //   $cacheTypes = ["nocache", "vqs", "wqs","standard"];
        $cacheTypes = ["nocache",  "vqs", "standard", "standard"];
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        // $rules = explode(",", $sfid["data"][0]["sf_rules"]);
        // $reservedrules = ["cache_level", "browser_cache_ttl", "Edge_cache_ttl"];


        $conn->query($ins);
        $conn->close();
        $l = SUBFOLDER_ADMIN::GetListByWebsite($token, $websiteid);
        $stat = true;
        foreach ($l["data"] as $m) {
            if ($m["URL"] == "/") {
                $stat = false;
                $subfolderid = $m["subfolderid"];
                /**
                 * browser_cache_ttl,
                 * cache_level,
                 *  Edge_cache_ttl
                 * */
                $value["ttl"] = $browsercachettl;
                SUBFOLDERRULES_ADMIN::AddSubFolderRules($subfolderid, $token, "browser_cache_ttl", $value);
                $value["ttl"] = $servercachettl;
                SUBFOLDERRULES_ADMIN::AddSubFolderRules($subfolderid, $token, "Edge_cache_ttl", $value);
                $value["level"] = intVal($status)-1;
                $cl= SUBFOLDERRULES_ADMIN::AddSubFolderRules($subfolderid, $token, "cache_level", $value);
            }
        }
        if ($stat) {
            // if (!in_array("cache_level", $rules)) {
            API_CAHCE_ADMIN::RunCreateAPICacheLevel($dmn, $cacheTypes[$status - 1], null);
            // }
            // if (!in_array("browser_cache_ttl", $rules)) {  //  self::ReturnDataForApi($servercachettl);
            API_CAHCE_ADMIN::RunCreateAPIBrowserCacheTTL($dmn, self::ReturnDataForApi($browsercachettl)["time"], null, null, self::ReturnDataForApi($browsercachettl)["format"]);
            // }
            // if (!in_array("Edge_cache_ttl", $rules)) {
            API_CAHCE_ADMIN::RunCreateAPIServerCacheTTL($dmn, self::ReturnDataForApi($servercachettl)["time"], null, null, self::ReturnDataForApi($servercachettl)["format"]);
            // }
        }

        return [
            "status" => "success","cl"=>$cl,
            "message" => "درخواست شما با موفقیت انجام شد"
        ];
    }
    public static function ReturnDataForApi($ttl)
    {
        if ($ttl == "-1") {
            return ["time" => "-1", "format" => "s"];
        } else {

            $frm = substr($ttl, strlen($ttl) - 1, strlen($ttl));
            $tm = substr($ttl, 0, strlen($ttl) - 1);
            if ($frm == "h") {
                $tm = substr($ttl, 0, strlen($ttl) - 1) * 60;
                $frm = "m";
            }
            return ["time" => $tm, "format" => $frm];
        }
    }
}
