<?php

header("Content-Type: application/json; charset=UTF-8");

require_once '../../../include/vars.php';
require_once '../../../include/tools.php';

require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/usersorganize/admin/userorganize_admin_class.php';

$userip=TOOLS_ADMIN::getRealIpAddr();

if( !isset($_POST['name']) || !isset($_POST['family']) || !isset($_POST['mail']) || !isset($_POST['nationalid']) || !isset($_POST['individual']) || !isset($_POST['mobile']) || !isset($_POST['pass']) ) {
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["message" => "ارسال تمامی فیلد ها اجباری است"];
    echo json_encode($response);
    return;
}

if(strlen($_POST['name']) < 3 || strlen($_POST['family']) <3 || strlen($_POST['mail'])<5  || strlen($_POST['nationalid'])!= 10 || strlen($_POST['mobile'])!=11 || strlen($_POST['pass']) < 8 ) {
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["message" => "خطا در مقادیر ورودی"];
    echo json_encode($response);
    return;
}

$USERS_ADMIN = new USERS_ADMIN();
if(!$USERS_ADMIN::checknationalCode($_POST['nationalid'])){
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["status" => "error", "message" => "کد ملی وارد شده اشتباه است" ];
    echo json_encode($response);
    return;
}

if(!$USERS_ADMIN::CheckMobile($_POST['mobile'])){
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["status" => "error", "message" => "شماره موبایل وارد شده اشتباه است" ];
    echo json_encode($response);
    return;
}

$response=(USERS_ADMIN::GetRecordWithParameter('umobile',$_POST["mobile"]));
if(count($response,1)!=1){
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["status" => "error", "message" => "شماره موبایل وارد شده تکراری است" ];
    echo json_encode($response);
    return;
}

$response=(USERS_ADMIN::GetRecordWithParameter('unationalid',$_POST["nationalid"]));
if(count($response,1)!=1){
    // echo $response;
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["status" => "error", "message" => "کد ملی وارد شده تکراری است" ];
    echo json_encode($response);
    return;
}

$response=(USERS_ADMIN::GetRecordWithParameter('umail',$_POST["mail"]));
if(count($response,1)!=1){
    // echo $response;
    VARS_ADMIN::ReturnHeaders(400);
    $response = ["status" => "error", "message" => "ایمیل وارد شده تکراری است" ];
    echo json_encode($response);
    return;
}

if (!filter_var($_POST["mail"], FILTER_VALIDATE_EMAIL)) {

    VARS_ADMIN::ReturnHeaders(400);
    $response = ["status" => "error", "message" => "ایمیل وارد شده اشتباه است" ];
    echo json_encode($response);
    return;
}

if($_POST["individual"]=="2") {
    if (!isset($_POST['economic_number']) || !isset($_POST['national_code']) || !isset($_POST['company_name']) || !isset($_POST['register_number']) || !isset($_POST['address']) || !isset($_POST['postalcode'])) {

        VARS_ADMIN::ReturnHeaders(400);
        $response = ["status" => "error", "message" => "ارسال تمامی فیلدهای ثبت شرکت الزامی است"];
        echo json_encode($response);
        return;
    }

    if (strlen($_POST['economic_number']) < 2 ||
        strlen($_POST['national_code']) < 2 ||
        strlen($_POST['company_name']) < 2 ||
        strlen($_POST['register_number']) < 2 ||
        strlen($_POST['address']) < 20 ||
        strlen($_POST['postalcode']) != 10) {

        VARS_ADMIN::ReturnHeaders(400);
        $response = ["status" => "error", "message" => "خطا در مقادیر ورودی"];
        echo json_encode($response);
        return;
    }

    VARS_ADMIN::ReturnHeaders(200);
    $response=USERS_ADMIN::AddUsers($_POST["name"],$_POST["family"],
        $_POST["mail"],$_POST["nationalid"],
        $_POST["individual"],
        "0",
        $_POST["mobile"],
        $_POST['pass'],
        $userip);
    $Registeredid=$response["uid"];
    $Uorgan=USERSORGANIZE_ADMIN::AddUsers($_POST['economic_number'],
        $_POST['national_code'],
        $_POST['company_name'],$_POST['register_number'],
        $_POST['address'],$_POST['postalcode'],$Registeredid);
    $c=array_merge($response,$Uorgan);
    echo json_encode($c);
}

else{
    VARS_ADMIN::ReturnHeaders(200);
    $response=USERS_ADMIN::AddUsers($_POST["name"],$_POST["family"],
        $_POST["mail"],$_POST["nationalid"],
        $_POST["individual"],
        "0",
        $_POST["mobile"],
        $_POST['pass'],
        $userip);
    echo json_encode($response);
}
