import os
import datetime
from mysgi_middleware.settings.base import BASE_DIR
import environ
from rest_framework import status
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework.permissions import IsAuthenticated
from drf_spectacular.utils import extend_schema, OpenApiResponse, OpenApiExample, OpenApiParameter, OpenApiTypes
from rest_framework.decorators import action
from .serializers import *


env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))


class GetPersonnelCalenderView(APIView):

    def get(self, request):
        personnel_code = getattr(request, 'personnel_code', None)
        if personnel_code is None:
            return Response({"result": False, "message": "personnel code not found"}, status=status.HTTP_406_NOT_ACCEPTABLE)
        print(personnel_code)
        serializer = GetPersonnelCalenderSerializer(data=request.data)
        if serializer.is_valid():
            result = serializer.get_hours(request.data, personnel_code)
            if result[0] == True:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_200_OK)
            else:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_406_NOT_ACCEPTABLE)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class UpdateWorkingYearView(APIView):
    
    def get(self, request):
        serializer = UpdateWorkingYearSerializer(data=request.data)
        if serializer.is_valid():
            result = serializer.update_working_years(request.data)
            if result[0] == True:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_200_OK)
            else:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_406_NOT_ACCEPTABLE)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class GetPeriodsView(APIView):
    
    @extend_schema(
        request = GetPeriodsSerializer,
        responses={
            200: OpenApiResponse(response=GetPeriodsSerializer, description='Get Periods')
        },
    )
    def get(self, request):
        personnel_code = getattr(request, 'personnel_code', None)
        if personnel_code is None:
            return Response({"result": False, "message": "personnel code not found"}, status=status.HTTP_406_NOT_ACCEPTABLE)
        serializer = GetPeriodsSerializer(data=request.data)
        if serializer.is_valid():
            result = serializer.get_periods(request.data, personnel_code)
            if result[0] == True:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_200_OK)
            else:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_406_NOT_ACCEPTABLE)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class CreateIORequestView(APIView):
    
    @extend_schema(
        request = CreateIORequestSerializer,
        responses={
            200: OpenApiResponse(response=CreateIORequestSerializer, description='Add IO Sheet')
        },
    )
    def post(self, request):
        personnel_code = getattr(request, 'personnel_code', None)
        if personnel_code is None:
            return Response({"result": False, "message": "personnel code not found"}, status=status.HTTP_406_NOT_ACCEPTABLE)
        serializer = CreateIORequestSerializer(data=request.data)
        if serializer.is_valid():
            result = serializer.add_request(request.data, personnel_code, request)
            if result[0] == True:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_200_OK)
            else:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_406_NOT_ACCEPTABLE)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class GetIOArchiveView(APIView):
    
    @extend_schema(
        parameters=[
            OpenApiParameter(name='start_date', location=OpenApiParameter.QUERY, type=OpenApiTypes.STR, description='StartDate of IO Archives', required=False),
            OpenApiParameter(name='end_date', location=OpenApiParameter.QUERY, type=OpenApiTypes.STR, description='EndDate of IO Archives', required=False),
            OpenApiParameter(name='request_state', location=OpenApiParameter.QUERY, type=OpenApiTypes.INT, description='ReqState of IO Archives', required=False),
        ],
        request = GetIOArchiveSerializer,
        responses={
            200: OpenApiResponse(response=GetIOArchiveSerializer, description='IO Archive List')
        },
    )
    
    def get(self, request):
        personnel_code = getattr(request, 'personnel_code', None)
        if personnel_code is None:
            return Response({"result": False, "message": "personnel code not found"}, status=status.HTTP_406_NOT_ACCEPTABLE)
        print(personnel_code)
        serializer = GetIOArchiveSerializer(data=request.data)
        if serializer.is_valid():
            result = serializer.get_archives(request.data, personnel_code, request)
            if result[0] == True:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_200_OK)
            else:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_406_NOT_ACCEPTABLE)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)


class EditIORequestView(APIView):
    
    @extend_schema(
        request = EditIORequestSerializer,
        responses={
            200: OpenApiResponse(response=EditIORequestSerializer, description='Edit IO Sheet')
        },
    )
    def post(self, request, id):
        personnel_code = getattr(request, 'personnel_code', None)
        if personnel_code is None:
            return Response({"result": False, "message": "personnel code not found"}, status=status.HTTP_406_NOT_ACCEPTABLE)
        serializer = EditIORequestSerializer(data=request.data)
        if serializer.is_valid():
            result = serializer.edit_request(request.data, personnel_code, request, id)
            if result[0] == True:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_200_OK)
            else:
                return Response({"result": result[0], "message": result[1]}, status=status.HTTP_406_NOT_ACCEPTABLE)
        return Response(serializer.errors, status=status.HTTP_400_BAD_REQUEST)

