import os
from rest_framework import serializers
import environ
from mysgi_middleware.settings.base import BASE_DIR
from .helpers import ETS
from datetime import datetime
from khayyam import JalaliDate


env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))

class GetPersonnelCalenderSerializer(serializers.Serializer):
    
    def get_hours(self, validated_data, personnel_code):
        
        ets = ETS(personnel_code)
        ans, res = ets.get_calender()
        if ans:
            return True, res
        else:
            return False, res
        

class UpdateWorkingYearSerializer(serializers.Serializer):
    
    def update_working_years(self, validated_data):
        
        ets = ETS(400609)
        ans, res = ets.update_working_year()
        if ans:
            return True, res
        else:
            return False, res
        

class GetPeriodsSerializer(serializers.Serializer):
    
    def get_periods(self, validated_data, personnel_code):
        
        ets = ETS(personnel_code)
        ans, res = ets.get_periods()
        if ans:
            return True, res
        else:
            return False, res


class CreateIORequestSerializer(serializers.Serializer):
    
    request_datetime = serializers.DateTimeField(required=True)
    request_type = serializers.BooleanField(required=True)
    attachment_image = serializers.CharField(required=False)
    request_description = serializers.CharField(required=False)
    request_reason = serializers.CharField(required=False)
    attachments = serializers.CharField(required=False)
    
    def add_request(self, validated_data, personnel_code, request, id):
        ets = ETS(personnel_code)
        ans, res = ets.add_io_request(validated_data, personnel_code, request, id)
        if ans:
            return True, res
        else:
            return False, res


class GetIOArchiveSerializer(serializers.Serializer):
    
    def get_archives(self, validated_data, personnel_code, request):
        
        ets = ETS(personnel_code)
        stdate = ""
        endate = ""
        if request.GET.get('start_date') == None:
            if JalaliDate.today().month == 12 :
                if JalaliDate.today().day > 15:
                    stdate = str(JalaliDate.today().year)+"/12/16"
                    endate = str(JalaliDate.today().year)+"/12/30"
                else:
                    stdate = str(JalaliDate.today().year)+"/12/1"
                    endate = str(JalaliDate.today().year)+"/12/15"
            else:
                if JalaliDate.today().day > 20:
                    stdate = str(JalaliDate.today().year) +"/"+ str( JalaliDate.today().month)+"/21"
                    endate = str(JalaliDate.today().year) +"/"+ str( JalaliDate.today().month + 1)+"/20"
                else:
                    stdate = str(JalaliDate.today().year) +"/"+ str( JalaliDate.today().month-1)+"/21"
                    endate = str(JalaliDate.today().year) +"/"+ str( JalaliDate.today().month)+"/20"
        ans, res = ets.get_archives(request.GET.get('start_date', stdate), request.GET.get('end_date', endate), request.GET.get('request_state', None))
        if ans:
            return True, res
        else:
            return False, res


class EditIORequestSerializer(serializers.Serializer):
    
    request_datetime = serializers.DateTimeField(required=True)
    request_type = serializers.BooleanField(required=True)
    attachment_image = serializers.CharField(required=False)
    request_description = serializers.CharField(required=False)
    request_reason = serializers.CharField(required=False)
    attachments = serializers.CharField(required=False)
    
    def edit_request(self, validated_data, personnel_code, request):
        ets = ETS(personnel_code)
        ans, res = ets.edit_io_request(validated_data, personnel_code, request)
        if ans:
            return True, res
        else:
            return False, res

