<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/ipblacklist/ipblacklist_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class IPBLACKLIST_ADMIN
{
    public static function ADDIPToBlockList($token, $websiteid, $ip)
    {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                // VARS_ADMIN::ReturnHeaders(301);
                return [
                    "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "
                ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];

            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
            if ($websitesOwner["status"] == "error") {
                // // VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ",];
            }
        }

        if ($ip == "") {
            return ["status" => "error", "message" => "مقدار IP خالی میباشد "];
        }
        if (strpos($ip, '/')) {
            $nip = explode("/", $ip);
            if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                $stat = 0;
                $out["status"] = "error";
                return  ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"];
            }
        } else {
            if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                return   ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"];
            }
        }
        $sql = "INSERT INTO " . $GLOBALS["blacklist_tablename"] . " (" .
            $GLOBALS['biw_id'] . ","
            . $GLOBALS['biw_wid_fk'] . "," . $GLOBALS['biw_ip'] .  ") 
            VALUES(0,'%s','%s')";
        $sql = sprintf($sql, $websiteid, $ip);
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد "];
        $conn->close();
        return $listOfRecordType;
    }
    public static function GetOneByWebsiteID($token, $websiteid)
    {
        if ($token != "12") {
            $usersDetails = USERS_ADMIN::GetOneByToken($token);
            if ($usersDetails["status"] == "error") {
                // VARS_ADMIN::ReturnHeaders(301);
                return [
                    "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "
                ];
            }

            $uid = $usersDetails["userdetail"][0]["uid"];

            $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
            if ($websitesOwner["status"] == "error") {
                // // VARS_ADMIN::ReturnHeaders(400);
                return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
            }
        }

        $sql = "SELECT  " . $GLOBALS['biw_ip'] . " as ip," . $GLOBALS['biw_id'] . " as id, 
                  FROM " . $GLOBALS['blacklist_tablename'] . " WHERE 
         " . $GLOBALS['biw_id'] . "=" .  $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = [
                "status" => "success", "code" => "201",
                "message" => "شما IP بلاک نکرده اید "
            ];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);

            $listOfRecordType = [
                "status" => "success", "code" => "200",
                "message" => "اطلاعات با موفقیت دریافت شد ",  "data" => $list[0]
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function UnblockIP($token, $id, $websiteid)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(301);
            return [
                "status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "
            ];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $canaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($canaccess["status"] == "error") {
            return [
                "status" => "error", "message" => "شما مجوز دسترسی به این سایت را ندارید"
            ];
        }

        $sql = "DELETE FROM  " . $GLOBALS["blacklist_tablename"] . " WHERE  " .
            $GLOBALS['biw_id'] . "=" . $id . "
                  and  " . $GLOBALS["biw_wid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        if ($conn->query($sql) === TRUE) {
            return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد "];
        } else {
            return ["status" => "error", "message" => "خطا در انجام درخواست"];
        }
    }
}
