<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/gzip/gzip_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/gzip/gzip.php';



class BACKENDPROTOCOL_ADMIN
{

    public static function  GetWebsiteBACKENDPROTOCOL($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است "];
        }

        $sql = "SELECT gstatus as GzipStatus FROM " . $GLOBALS["backendprotocol_tablename"] .
            " where " . $GLOBALS["bpwid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "data" => ["backendstatus" => "http"]
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $r[0]
            ];
            $conn->close();
        }


        return $listOfRecordType;
    }


    public static function  UpdateWebsiteBackendProtocol($token, $websiteid, $status)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(403);
            return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
        }
        else{
            $balance=$usersDetails["credit"];
            if($balance<0){
                return ["status"=>"error",
                "message"=>"اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید "];
            }
        }
        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است "];
        }
        if ($status == "") {
            return ["status" => "error", "message" => "امکان خالی بودن وضعیت وجود ندارد"];
        }

        $allowedstatus = ["http", "https"];

        $methods = explode(",", $status);
        $res = [];
        $stat = 1;
        foreach ($methods as $method) {
            if (!in_array(strtoupper($method), $allowedstatus)) {
                $stat = 0;
                array_push(
                    $res,
                    ["status" => "error", "status" => $status, "message" => "وضعیت نامعتبر است"]
                );
            }
        }


        if ($stat == 0) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی", "backendprotocol" => $res];
        }

        $sql = "SELECT * FROM " . $GLOBALS["backendprotocol_tablename"] .
            " where " . $GLOBALS["bpwid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["backendprotocol_tablename"] . " (" . 
            $GLOBALS['bpwid_fk'] . "," . $GLOBALS['bpstatus'] . ")
                VALUE ('" . $websiteid . "','" . $status . "')";
        } else {
            $ins = "UPDATE " . $GLOBALS["backendprotocol_tablename"] . " SET " .
             $GLOBALS['bpstatus'] . "='" . $status . "'
                        WHERE " . $GLOBALS['bpwid_fk'] . "=" . $websiteid;
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای این بخش انجام نداده اید "
            ];
        }
        $conn->query($ins);
        $conn->close();
        $dmn = "";
        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }
        // API_GZIP_ADMIN::RunCreateAPIGZIP($dmn);
        return ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد "];
    }


    // public static function  RemoveGzip($token, $websiteid)
    // {
    //     $usersDetails = USERS_ADMIN::GetOneByToken($token);
    //     if ($usersDetails["status"] == "error") {
    //         // VARS_ADMIN::ReturnHeaders(403);
    //         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید "];
    //     }
    //     else{
    //         $balance=$usersDetails["credit"];
    //         if($balance<0){
    //             return ["status"=>"error",
    //             "message"=>"اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید "];
    //         }
    //     }
    //     $uid = $usersDetails["userdetail"][0]["uid"];
    //     $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
    //     if ($websitesOwner["status"] == "error") {
    //         // VARS_ADMIN::ReturnHeaders(400);
    //         return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است "];
    //     }

    //     $sql = "SELECT * FROM " . $GLOBALS["backendprotocol_tablename"] .
    //         " where " . $GLOBALS["bpwid_fk"] . "=" . $websiteid;
    //     $conn = GetConnection();
    //     $result = $conn->query($sql);
    //     if (!$result || mysqli_num_rows($result) == 0) {
    //         $listOfRecordType = [
    //             "status" => "success", "code" => "201",
    //             "message" => "شما تنظیماتی برای فشرده سازی ایجاد نکرده اید "
    //         ];
    //         $conn->close();
    //     } else {
    //         $sql = "DELETE  FROM " . $GLOBALS["backendprotocol_tablename"] .
    //             " where " . $GLOBALS["bpwid_fk"] . "=" . $websiteid;
    //         $result = $conn->query($sql);
    //         $conn->close();
    //         $listOfRecordType = ["satus" => "success", "message" => "درخواست شما با موفقیت انجام شد "];
    //         $dmn = "";
    //         if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
    //             $dmn = $websitesOwner["data"][0]["d_name"];
    //         } else {
    //             $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
    //         }
    //         API_GZIP_ADMIN::RunDisableAPIGZIP($dmn);
    //     }


    //     return $listOfRecordType;
    // }
}
