<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
class Themento_Image extends Widget_Base {

    public function get_name() {
        return 'themento_image';
    }

    public function get_title() {
        return __( 'Image', text_domain );
    }

    public function get_categories() {
        return [ text_domain ];
    }

    public function get_icon() {
        return 'eicon-image-bold';
	}
	
	public function get_keywords() {
		return [ 'image','photo'];
	}


    protected function register_controls() {
        $this->register_general_style_controls();
    }

    protected function register_general_style_controls() {
        $this->start_controls_section(
            'section_general_style_img',
            [
                'label' => __( 'Style', text_domain ),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

		$this->add_control(
		    'image',
			[
			   'label' => __( 'Choose Image', text_domain ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_responsive_control(
		    'width_img',
			[
				'label' => __( 'Width', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
			    'range' => [
					'px' => [
					   'min' => 0,
						'max' => 1000,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'height_img',
			[
				'label' => __( 'Height', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} img' => 'height: {{SIZE}}px;',
				],
			]
		);

		$this->add_control(
		    'border_radius_img',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'show_clip_path',
			[
				'label' => __( 'Show Clip Path', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
                'return_value' => 'yes',
			]
		);
		
		$this->add_responsive_control(
			'clip_path_img',
			[
				'label' => __( 'Broken', text_domain ),
				'description' => sprintf(__('For example: <b>%1s</b> or Go <a href="%2s" target="_blank">this link</a> and copy and paste the radius value.', text_domain), '91% 0%, 0% 0%, 0% 100%, 140% 100%', 'https://bennettfeely.com/clippy'),
				'type' => Controls_Manager::TEXTAREA,
				'default'     => '91% 0%, 0% 0%, 0% 100%, 140% 100%',
				'rows' => 2,
				'selectors'   => [
					'{{WRAPPER}} img' => 'clip-path: polygon({{VALUE}});',
				],
				'condition' => [
					'show_clip_path' => 'yes',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_img',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} img',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow_img',
				'label' => __( 'Box Shadow', text_domain ),
				'selector' => '{{WRAPPER}} img',
			]
	    );
		
        $this->end_controls_section();
    }


    protected function render() {
        $settings = $this->get_settings();
		echo '<img src="' . $settings['image']['url'] . '">';
    }
}
Plugin::instance()->widgets_manager->register( new Themento_Image );
