<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage vihan
 * @since 4.0.0
 */

?><!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>"/>
    <meta name="viewport" content="width=device-width, height=device-height">
    <link rel="profile" href="https://gmpg.org/xfn/11"/>
    <?php
    $mobile_color = TMT_Get_Setting('general-settings', 'mobile-color');
    $before_closing_head = TMT_Get_Setting('codes-settings', 'custom-before-head');

    echo "<meta name='theme-color' content='$mobile_color' />";
    if(!is_rtl()) {
        $font = TMT_Get_Setting('general-settings', 'ltr-font');
        $font = $font ? $font : 'Open Sans';
        $font_name = str_replace( ' ', '+', $font );
        $font = ':100,100italic,200,200italic,300,300italic,400,400italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic';
        $display_font = sprintf( 'https://fonts.googleapis.com/css?family='. $font_name .'%1$s%2$s', rawurlencode( $font ), '&display=auto' );
        echo '<link href="'. $display_font .'" rel="stylesheet" type="text/css">';
    }
    wp_head();
    if($before_closing_head){echo $before_closing_head;}
    echo '</head>';
    ?>
<body <?php body_class(); ?>>

<?php
$theme_option = get_option('tmt_theme_config_option', [] );
$id = $theme_option['tmt-header'];

if(!empty($id)) {
    $abs_header = TMT_Get_Setting('general-settings', 'abs-header');
    $enable_preloader = TMT_Get_Setting('general-settings', 'enable-preloader');
    $enable_preloader = $enable_preloader ? $enable_preloader : false;
    if($enable_preloader == true) {
        $preloader_logo = TMT_Get_Setting('general-settings', 'preloader-logo');
        $preloader_style = TMT_Get_Setting('general-settings', 'preloader-style');
        $title = wp_title('&raquo;',false);
        echo "<div class='tmt-preloader flex align-items-center justify-content-center'>"
            . "<div class='flex align-items-center justify-content-center flex-column'>";
                if(!empty($preloader_logo)) {echo "<img src='$preloader_logo' alt='$title' />";}
                if($preloader_style != 'none') {
                    switch($preloader_style) {
                        case 'style1' :
                            echo "<div class='tmt-loading $preloader_style'></div>";
                            break;
                        case 'style2' :
                            echo "<div class='tmt-loading $preloader_style'><div></div></div>";
                            break;
                        case 'style3' :
                            echo "<div class='tmt-loading $preloader_style'><div></div><div></div><div></div><div></div></div>";
                            break;
                        case 'style4' :
                            echo "<div class='tmt-loading $preloader_style'><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>";
                            break;
                        case 'style5' :
                            echo "<div class='tmt-loading $preloader_style'><div></div><div></div><div></div><div></div></div>";
                            break;
                        case 'style6' :
                            echo "<div class='tmt-loading $preloader_style'><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>";
                            break;
                        case 'style7' :
                            echo "<div class='tmt-loading $preloader_style'><div></div><div></div></div>";
                            break;
                    }
                }
            echo "</div>"
        . "</div>";
    }
    echo "<header ". ($abs_header == true ? 'class="position-header"' : '') ." >";
    TMT_Elementor::get_header_content();
    echo "</header>";

} else {
    echo "<header class='site-header flex align-items-center justify-content-between' style='padding: 50px;'>"
        . "<div class='header-titles'>"
            . "<h1>". get_bloginfo( 'name' ) ."</h1>"
            . "<p>". get_bloginfo( 'description' ) ."</p>"
        . "</div>"
        . "<nav class='header-manu'>"
            . "<ul class='flex'>";
                if ( has_nav_menu( 'main' ) ) {
                    $nav_menu_args = array(
                        'fallback_cb'    => false,
                        'container'      => false,
                        'menu_id'        => 'tmt-navmenu',
                        'menu_class'     => "main-menu flex tmt-icon-f107",
                        'theme_location' => 'main', // creating a fake location for better functional control
                        'echo'           => true,
                        'depth'          => 0,
                        'walker'		 => new \tmt_main_nav_walker(),
                    );
                    ?>
                    <div class="tmt-navbar-wrapper">
                    <?php echo "<div class='flex main-bar'><div class='bars'><i class='fas fa-bars'></i></div></div>"; ?>
                        <nav class="menu"><?php wp_nav_menu( apply_filters( 'widget_nav_menu_args', $nav_menu_args ) ); ?></nav>
                    </div>
                    <?php
                } else {
                    wp_list_pages(
                        array(
                            'match_menu_classes' => true,
                            'show_sub_menu_icons' => true,
                            'title_li' => false,
                        )
                    );
                }
            echo "</ul>"
        . "</nav>"
    . "</header>"; 
}