<?php

namespace Themento\Admin;

require_once wp_directory . "/admin/includes.php";

use Themento\Admin\Menu_Settings;

class Admin_Theme {

    public function __construct() {
		add_action('admin_menu', [$this, 'admin_menu']);
        add_action('admin_enqueue_scripts', [$this, 'tmt_admin_enqueue_scripts']);
        add_filter( 'wp_check_filetype_and_ext', [ $this, 'filter_fix_wp_check_filetype_and_ext' ], 10, 4 );
        add_filter( 'upload_mimes', [ $this, 'tmt_upload_mimes' ] );
		add_action( 'admin_head', [ $this, 'tmt_admin_font' ] );
		add_action( 'elementor/editor/before_enqueue_scripts', [ $this, 'tmt_admin_font' ]);
    }

	public function admin_menu() {
        add_menu_page(
            __('Theme Settings', text_domain),
            __('Theme Settings', text_domain),
            'manage_options',
            'tmt_theme_admin_panel',
            [$this, 'TMT_Theme_Settings'],
            $this->tmt_menu_icon(),
            59
        );
    }

	public function TMT_Theme_Settings() {
        $main_option = new Menu_Settings;
        $main_option->Main_options();
    }

	public function tmt_menu_icon() {
        return 'data:image/svg+xml;base64,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';
    }

    /**
	 * Enqueue Admin Style & Script Files
	 * @access public
	 */

	public function tmt_admin_enqueue_scripts() {

		$version = get_option('tmt_files_version');
		if(empty($version)) {
			$version = 100000;
		}
		
        wp_enqueue_media();
        wp_enqueue_style( 'wp-color-picker' );
        wp_register_script( 'wp-color-picker-alpha', wp_directory_uri . '/admin/assets/js/wp-color-picker-alpha.min.js', array( 'wp-color-picker' ), '1.0.0', true);
        wp_enqueue_script( 'wp-color-picker-alpha' );
		
		wp_enqueue_style('tmt-admin', wp_directory_uri . '/admin/assets/css/tmt-admin.css', [], $version);
        wp_enqueue_script('tmt-admin', wp_directory_uri . '/admin/assets/js/tmt-admin.js', ['jquery'], $version, true);
		wp_localize_script( 'tmt-admin', 'tmt_post_types_object', array( 'get_post_types' => $this->tmt_get_post_types() ) );
		wp_localize_script( 'tmt-admin', 'tmt_taxonomies_object', array( 'get_taxonomies' => $this->tmt_get_taxonomies() ) );
	}

	public function tmt_get_post_types() {
        $args = [ 'public' => true ];
        $get_post_types = get_post_types( $args, 'objects' );

        return $get_post_types;
    }

	public function tmt_get_taxonomies() {
        $args = [ 'public' => true ];
        $get_taxonomies = get_taxonomies( $args, 'objects' );
        unset( $get_taxonomies['nav_menu'], $get_taxonomies['post_format']);

        return $get_taxonomies;
    }

    
    private function get_file_types() {
		return [
			'woff' => 'font/woff|application/font-woff|application/x-font-woff|application/octet-stream',
			'woff2' => 'font/woff2|application/octet-stream|font/x-woff2',
			'ttf' => 'application/x-font-ttf|application/octet-stream|font/ttf',
			'svg' => 'image/svg+xml|application/octet-stream|image/x-svg+xml',
			'eot' => 'application/vnd.ms-fontobject|application/octet-stream|application/x-vnd.ms-fontobject',
		];
	}

	public function filter_fix_wp_check_filetype_and_ext( $data, $file, $filename, $mimes ) {
		if ( ! empty( $data['ext'] ) && ! empty( $data['type'] ) ) {
			return $data;
		}

		$registered_file_types = $this->get_file_types();
		$filetype = wp_check_filetype( $filename, $mimes );

		if ( ! isset( $registered_file_types[ $filetype['ext'] ] ) ) {
			return $data;
		}
		// Fix incorrect file mime type
		$filetype['type'] = explode( '|', $filetype['type'] )[0];

		return [
			'ext' => $filetype['ext'],
			'type' => $filetype['type'],
			'proper_filename' => $data['proper_filename'],
		];
	}

    public function tmt_upload_mimes( $mine_types ) {
		foreach ( $this->get_file_types() as $type => $mine ) {
            if ( ! isset( $mine_types[ $type ] ) ) {
                $mine_types[ $type ] = $mine;
            }
        }

		return $mine_types;
	}

	public function tmt_admin_font() {
		echo "<style type='text/css'>@font-face {font-family: IRANSans;font-style: normal;font-weight: bold;src: url('". wp_directory_uri ."/assets/fonts/IRANSansWeb_Bold.eot');src: url('". wp_directory_uri ."/assets/fonts/IRANSansWeb_Bold.eot?#iefix') format('embedded-opentype'),url('". wp_directory_uri ."/assets/fonts/IRANSansWeb_Bold.woff2') format('woff2'),url('". wp_directory_uri ."/assets/fonts/IRANSansWeb_Bold.woff') format('woff'),url('". wp_directory_uri ."/assets/fonts/IRANSansWeb_Bold.ttf') format('truetype');}@font-face {font-family: IRANSans;font-style: normal;font-weight: normal;src: url('". wp_directory_uri ."/assets/fonts/IRANSansWeb.eot');src: url('". wp_directory_uri ."/assets/fonts/IRANSansWeb.eot?#iefix') format('embedded-opentype'),url('". wp_directory_uri ."/assets/fonts/IRANSansWeb.woff2') format('woff2'),url('". wp_directory_uri ."/assets/fonts/IRANSansWeb.woff') format('woff'),url('". wp_directory_uri ."/assets/fonts/IRANSansWeb.ttf') format('truetype');}body.rtl, #wpadminbar *:not([class='ab-icon']), .wp-core-ui, .media-menu, .media-frame *, .media-modal *,.rtl h1, .rtl h2, .rtl h3, .rtl h4, .rtl h5, .rtl h6,.elementor-panel,.elementor-button,body,input#elementor-template-library-save-template-name,input#elementor-panel-elements-search-input,.wp-picker-clear.button,.elementor-templates-modal .dialog-widget-content,select,textarea,.tipsy-inner,.elementor-add-section-drag-title,.elementor-add-section-drag-title,.elementor-safe-mode-toast .elementor-toast-content,.elementor-safe-mode-toast header h2,#elementor-finder__search__input,#elementor-template-library-filter-text,.elementor-element-title-wrapper .title,.elementor-add-section-drag-title,.elementor-select-preset-title,.elementor-color-picker__saved-colors-edit,input.pcr-clear,.elementor-color-picker__header,.elementor-color-picker__saved-colors-title,.yoast-title,#elementor-try-safe-mode .elementor-safe-mode-button,button.dialog-button.dialog-cancel.dialog-confirm-cancel,button.dialog-button.dialog-ok.dialog-confirm-ok,input.tooltip-target.elementor-control-tag-area,input.elementor-control-tag-area.elementor-input.ui-autocomplete-input,.elementor-panel-heading-title {font-family:IRANSans !important;}.php-error #adminmenuback, .php-error #adminmenuwrap {margin-top: 0 !important;}.elementor-loading-title{letter-spacing:0px!important;font-size:13px!important}#elementor-template-library-filter .select2-selection__rendered,#select2-elementor-template-library-filter-subtype-results .select2-results__option{text-align:right}.e-global__color-hex,.e-global-colors__color-value {font-family: Roboto,Arial,Helvetica,Verdana,sans-serif;}#sub-accordion-section-custom_codes textarea {direction: ltr;}</style>". PHP_EOL;
	}
}

new Admin_Theme;