<?php
function wpb_load_widget_cinematicket() {
    register_widget( 'wpb_widget_tab_cinematicket' );
}
add_action( 'widgets_init', 'wpb_load_widget_cinematicket' );

class wpb_widget_tab_cinematicket extends WP_Widget {
    private $json;
    function __construct() {
        parent::__construct(

            'wpb_widget_tab_cinematicket',

            __('🎥 امار فروش سینمای ایران 🎥', 'wpb_widget_tab_cinematicket_domain'),

            array( 'description' => __( 'نمایش امار فروش سینمای ایران از سینما تیکت', 'wpb_widget_tab_cinematicket_domain' ), )
        );
        
    }

    public function widget( $args, $instance ) {
        $title = apply_filters( 'widget_title', $instance['title'] );
        //$post = $instance['post'];
        //$count = $instance['count'];
        //$cat = $instance['cat'];
        echo $args['before_widget'];
        echo $args['before_title'] . $title . $args['after_title'];
        ?>
<div class="film_tbls">
    <span class="film_name_tbl">فیلم</span>
    <span class="film_sale_tbl">فروش (تومان)</span>
</div>
<style>
.pull-right.name {
    padding-right:  10px;
    font-weight:  bold;
    color: #673AB7;
}

.pull-left.sale {
    padding-left:0px;
    color: #009688;
    font-weight:  bold;
}
</style>
            <ul style="padding:10px;" class="collection" id="table_cinema">
                <li class="collection-item">در حال بارگیری ...</li>
            </ul>
        <?php
        //print_r($this->getjson());
        echo $args['after_widget'];
    }
    
    public function getjson(){
        //simple_html_dom
            $url = "http://salarstudio.com/30nama/30nama.php";
            $ch = curl_init();
            // set url
			curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 6.2) AppleWebKit/536.6 (KHTML, like Gecko) Chrome/20.0.1090.0 Safari/536.6');
            curl_setopt($ch, CURLOPT_URL, $url);
            //return the transfer as a string
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            // $output contains the output string
            $output = curl_exec($ch);
            // lose curl resource to free up system resources
            curl_close($ch);


            return $output;
      
    }
    
    function SetData(){
        $date_now = date("Y-m-d");
        $data_cinema_date = get_option('data_cinema_date',true);
        $data_cinema = get_option('data_cinema',true);
        if($data_cinema == '' || $data_cinema_date == ''){
            $d_d = date('Y-m-d', strtotime($date_now. ' + 7 days'));
            update_option('data_cinema',base64_encode($this->getjson()));
            update_option('data_cinema_date',$d_d);
        }elseif($data_cinema_date <= $date_now){
            $d_d = date('Y-m-d', strtotime($date_now. ' + 7 days'));
            update_option('data_cinema',base64_encode($this->getjson()));
            update_option('data_cinema_date',$d_d);
            if ( function_exists( 'rocket_clean_domain' ) ) {
                    rocket_clean_domain();
            }
        }else{
            return true;
        }

    }
    
    function GetDataHtml(){
        $this->SetData();
        $data_cinema = base64_decode(get_option('data_cinema',true));
        return $data_cinema;
    }
    
    public function to_fa($string){
        $persian_num = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
        $latin_num = range(0, 9);

        $string = str_replace($latin_num, $persian_num, $string);

        return $string;
    }

    public function form( $instance ) {
        $post = $instance[ 'post' ];
        $count = $instance[ 'count' ];
        $cat = $instance[ 'cat' ];

        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'wpb_widget_tab_cinematicket_domain' );
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['post'] = ( ! empty( $new_instance['post'] ) ) ? strip_tags( $new_instance['post'] ) : '';
        $instance['count'] = ( ! empty( $new_instance['count'] ) ) ? strip_tags( $new_instance['count'] ) : '';
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['cat'] = ( ! empty( $new_instance['cat'] ) ) ? strip_tags( $new_instance['cat'] ) : '';
        return $instance;
    }

}

new wpb_widget_tab_cinematicket();