<?php
function wpb_load_widget_popular() {
    register_widget( 'wpb_widget_tab_popular' );
}
add_action( 'widgets_init', 'wpb_load_widget_popular' );

class wpb_widget_tab_popular extends WP_Widget {

    function __construct() {
        parent::__construct(

            'wpb_widget_tab_popular',

            __('اخرین مطالب  *اختصاصی*', 'wpb_widget_tab_popular_domain'),

            array( 'description' => __( 'نمایش اخرین مطالب', 'wpb_widget_tab_popular_domain' ), )
        );
    }

    public function widget( $args, $instance ) {
        $title = apply_filters( 'widget_title', $instance['title'] );
        $post = $instance['post'];
        $count = $instance['count'];
        $cat = $instance['cat'];
        echo $args['before_widget'];
        echo $args['before_title'] . $title . $args['after_title'];
        ?>
            <ul class="collection">
                <?php
                $argsx = array(
                    'post_type' => $post,
                    'cat' => $cat,
                    'posts_per_page'=> $count
                );
                $wpb_all_query = new WP_Query($argsx); ?>

                <?php if ( $wpb_all_query->have_posts() ) : ?>
                    <!-- the loop -->
                    <?php while ( $wpb_all_query->have_posts() ) : $wpb_all_query->the_post(); ?>
                        <li class="collection-item">
                            <a title="<?php the_title(); ?>" href="<?php echo get_the_permalink(); ?>">
                                <img alt="<?php the_title(); ?>" class="lazy" data-src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'thumbnail');?>">
                                <span><?php the_title();?></span>
                            </a>
                        </li>
                    <?php endwhile; ?>
                    <!-- end of the loop -->
                    <?php wp_reset_postdata(); ?>

                <?php else : ?>
                    <li><?php _e( 'مطلبی یافت نشد' ); ?></li>
                <?php endif; ?>
            </ul>
        <?php
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $post = $instance[ 'post' ];
        $count = $instance[ 'count' ];
        $cat = $instance[ 'cat' ];

        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'wpb_widget_tab_popular_domain' );
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'count' ); ?>">تعداد نمایش</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'count' ); ?>" name="<?php echo $this->get_field_name( 'count' ); ?>" type="text" value="<?php echo esc_attr( $count ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'cat' ); ?>">ای دی دسته بندی</label>
            <input class="widefat" id="<?php echo $this->get_field_id( 'cat' ); ?>" name="<?php echo $this->get_field_name( 'cat' ); ?>" type="text" value="<?php echo esc_attr( $cat ); ?>" />
        </p>
        <p>
            <label for="<?php echo $this->get_field_id( 'post' ); ?>">پست تایپ</label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'post' ); ?>" name="<?php echo $this->get_field_name( 'post' ); ?>">
                <option value="post">post</option>
                <?php
                $args = array(
                    'public'   => true,
                    '_builtin' => false
                );
                $output = 'names'; // 'names' or 'objects' (default: 'names')
                $operator = 'and'; // 'and' or 'or' (default: 'and')
                $post_types = get_post_types( $args, $output, $operator );
                if ( $post_types ) { // If there are any custom public post types.
                    foreach ( $post_types  as $post_type ) {
                        if($post == $post_type){
                            echo '<option selected value="'.$post_type.'">' . $post_type . '</option>';
                        }else{
                            echo '<option value="'.$post_type.'">' . $post_type . '</option>';
                        }

                    }
                }
                ?>
            </select>
            <script>
                jQuery(document).ready(function(){
                    jQuery("#<?php echo $this->get_field_id( 'tab_type_base' ); ?> option").each(function(){
                        for (var i =0; i < 5; i++){
                            if('<?php echo esc_attr( $post ); ?>' === jQuery(this).val()){
                                jQuery(this).attr("selected","selected");
                                break;
                            }
                        }
                    });
                });

            </script>
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['post'] = ( ! empty( $new_instance['post'] ) ) ? strip_tags( $new_instance['post'] ) : '';
        $instance['count'] = ( ! empty( $new_instance['count'] ) ) ? strip_tags( $new_instance['count'] ) : '';
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['cat'] = ( ! empty( $new_instance['cat'] ) ) ? strip_tags( $new_instance['cat'] ) : '';
        return $instance;
    }

}

new wpb_widget_tab_popular();