<?php
function wpb_load_widget_ads_text() {
    register_widget( 'wpb_widget_tab_ads_text' );
}
add_action( 'widgets_init', 'wpb_load_widget_ads_text' );

class wpb_widget_tab_ads_text extends WP_Widget {

    function __construct() {
        parent::__construct(

            'wpb_widget_tab_ads_text',

            __('🔗 تبلیغات متنی 🔗', 'wpb_widget_tab_ads_text_domain'),

            array( 'description' => __( 'نمایش تبلیغات متنی', 'wpb_widget_tab_ads_text_domain' ), )
        );
    }

    public function widget( $args, $instance ) {

        $title = apply_filters( 'widget_title', $instance['title'] );
        $link = $instance['link'];
        ?>
        <li><a href="<?php echo $link;?>"><?php echo $title;?></a></li>
        <?php
    }

    public function form( $instance ) {
        $link = $instance['link'];

        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'wpb_widget_tab_ads_text_domain' );
        }
        ?>

        <p>
            <label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( '  عنوان:' ); ?></label>
            <input class="widefat"  id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo $title;?>">
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'link' ); ?>"><?php _e( 'لینک :' ); ?></label>
            <input class="widefat" align="left" dir="ltr" id="<?php echo $this->get_field_id( 'link' ); ?>" name="<?php echo $this->get_field_name( 'link' ); ?>" value="<?php echo $link;?>">
        </p>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['link'] = ( ! empty( $new_instance['link'] ) ) ? strip_tags( $new_instance['link'] ) : '';

        return $instance;
    }

}

new wpb_widget_tab_ads_text();