<?php
function wpb_load_widget_ads() {
    register_widget( 'wpb_widget_tab_ads' );
}
add_action( 'widgets_init', 'wpb_load_widget_ads' );

class wpb_widget_tab_ads extends WP_Widget {

    function __construct() {
        parent::__construct(

            'wpb_widget_tab_ads',

            __('📢 تبلیغات سراسری 📢', 'wpb_widget_tab_ads_domain'),

            array( 'description' => __( 'نمایش تبلیغات', 'wpb_widget_tab_ads_domain' ), )
        );
    }

    public function widget( $args, $instance ) {

        $title = apply_filters( 'widget_title', $instance['title'] );
        $ismobile = $instance['ismobile'];
        $col = $instance['col'];
        $img = $instance['img'];
        $link = $instance['link'];
        $code = $instance['code'];
        $iscode = $instance['iscode'];
        ($title == "" ? $title = "تبلیغات" : $title = $title);
        echo $args['before_widget'];
        if($args['id'] === "single_sidebar" || $args['id'] === "sidebar"){
            echo $args['before_title'].$title.$args['after_title'];
        }
        ?>
        <div class="<?php echo $col;?> <?php echo $ismobile;?>">
            <?php if ($iscode === "yes"){?>
                <?php echo $code;?>
            <?php }elseif($iscode === "none" || $iscode === "no"){ ?>
                <a href="<?php echo $link;?>">
                    <img class="responsive-img lazy" data-src="<?php echo $img;?>">
                </a>
            <?php } ?>
        </div>
        <script>
            function show_in_device(obj,status) {
                var ismobile = status;
                var width = window.innerWidth;
                if (width < 600){
                    if(ismobile === 'no_mobile'){
                        obj.style.display = "none";
                    }
                }
            }
        </script>
        <?php
        echo $args['after_widget'];
    }

    public function form( $instance ) {
        $ismobile = $instance[ 'ismobile' ];
        $col = $instance[ 'col' ];
        $img = $instance['img'];
        $link = $instance['link'];
        $code = $instance['code'];
        $iscode = $instance['iscode'];

        if ( isset( $instance[ 'title' ] ) ) {
            $title = $instance[ 'title' ];
        }
        else {
            $title = __( 'New title', 'wpb_widget_tab_ads_domain' );
        }
        ?>
        <p>
            <label for="<?php echo $this->get_field_id( 'ismobile' ); ?>"><?php _e( 'نمایش برای:' ); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'ismobile' ); ?>" name="<?php echo $this->get_field_name( 'ismobile' ); ?>">
                <option value="mobile">موبایل</option>
                <option value="no_mobile">غیر موبایل</option>
                <option value="both_device">هردو</option>
            </select>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'col' ); ?>"><?php _e( 'سایز بندی:' ); ?></label>
            <select class="widefat" id="<?php echo $this->get_field_id( 'col' ); ?>" name="<?php echo $this->get_field_name( 'col' ); ?>">
                <option value="col m12 l12 s12 center">بزرگ</option>
                <option value="col m6 l6 s12 center">متوسط</option>
                <option value="col m12 l3 s12 center">کوچک</option>
            </select>
        </p>

        <p>
            <label for="<?php echo $this->get_field_id( 'iscode' ); ?>"><?php _e( 'حالت کد:' ); ?></label>
            <select class="widefat code_mode" id="<?php echo $this->get_field_id( 'iscode' ); ?>" name="<?php echo $this->get_field_name( 'iscode' ); ?>">
                <option value="none">انتخاب کنید</option>
                <option value="no">خیر</option>
                <option value="yes">بله</option>
            </select>
        </p>

        <p id="show_in_code_mode_<?php echo $this->get_field_id( 'code' ); ?>" style="display: none;">
            <label for="<?php echo $this->get_field_id( 'code' ); ?>"><?php _e( '  کد را پیست کنید:' ); ?></label>
            <textarea rows="5" cols="5" class="widefat" id="<?php echo $this->get_field_id( 'code' ); ?>" name="<?php echo $this->get_field_name( 'code' ); ?>"><?php echo $code;?></textarea>
        </p>

        <p id="hide_in_code_mode_<?php echo $this->get_field_id( 'img' ); ?>" style="display: none;">
            <label for="<?php echo $this->get_field_id( 'img' ); ?>"><?php _e( 'تصویر:' ); ?></label>
            <input class="widefat img_url" id="<?php echo $this->get_field_id( 'img' ); ?>" name="<?php echo $this->get_field_name( 'img' ); ?>" value="<?php echo $img;?>">
            <input type="button" value="<?php _e( 'بارگزاری تصویر', 'theme name' ); ?>" class="button custom_media_upload" id="custom_image_uploader"/>
        </p>

        <p id="hide_in_code_mode_<?php echo $this->get_field_id( 'link' ); ?>" style="display: none;">
            <label for="<?php echo $this->get_field_id( 'link' ); ?>"><?php _e( 'لینک تصویر:' ); ?></label>
            <input class="widefat" align="left" dir="ltr" id="<?php echo $this->get_field_id( 'link' ); ?>" name="<?php echo $this->get_field_name( 'link' ); ?>" value="<?php echo $link;?>">
        </p>

        <script>
            jQuery(document).ready( function(){
                jQuery("#<?php echo$this->get_field_id( 'iscode' );?> > option").each(function(){
                    for (var i =0; i < 3; i++){
                        if('<?php echo esc_attr( $iscode ); ?>' === jQuery(this).val()){
                            jQuery(this).attr("selected","selected");
                            break;
                        }
                    }
                });
                jQuery("#<?php echo$this->get_field_id( 'ismobile' );?> > option").each(function(){
                    for (var i =0; i < 3; i++){
                        if('<?php echo esc_attr( $ismobile ); ?>' === jQuery(this).val()){
                            jQuery(this).attr("selected","selected");
                            break;
                        }
                    }
                });
                jQuery("#<?php echo$this->get_field_id( 'col' );?> > option").each(function(){
                    for (var i =0; i < 3; i++){
                        if('<?php echo esc_attr( $col ); ?>' === jQuery(this).val()){
                            jQuery(this).attr("selected","selected");
                            break;
                        }
                    }
                });
                if('<?php echo $iscode;?>' === 'yes'){
                    jQuery('#show_in_code_mode_<?php echo $this->get_field_id( 'code' ); ?>').show();
                    jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'img' ); ?>').hide();
                    jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'link' ); ?>').hide();
                }else if('<?php echo $iscode;?>' === 'no'){
                    jQuery('#show_in_code_mode_<?php echo $this->get_field_id( 'code' ); ?>').hide();
                    jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'img' ); ?>').show();
                    jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'link' ); ?>').show();
                }else if('<?php echo $iscode;?>' === 'none'){
                    jQuery('#show_in_code_mode_<?php echo $this->get_field_id( 'code' ); ?>').hide();
                    jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'img' ); ?>').hide();
                    jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'link' ); ?>').hide();
                }
                jQuery("#<?php echo $this->get_field_id('iscode');?> ",this).change(function(e){
                   var t =  jQuery(this).val();
                   var hide_code_part = jQuery('#show_in_code_mode_<?php echo $this->get_field_id( 'code' ); ?>');
                   var show_code_part = jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'img' ); ?>');
                   var show_code_part_link = jQuery('#hide_in_code_mode_<?php echo $this->get_field_id( 'link' ); ?>');
                   //alert(t);
                       if (t === "none"){
                           hide_code_part.hide();
                           show_code_part.hide();
                           show_code_part_link.hide();
                       }
                       if (t === "no"){
                           show_code_part.fadeIn();
                           show_code_part_link.fadeIn();
                           hide_code_part.fadeOut();
                       }
                       if (t === "yes"){
                            show_code_part.fadeOut();
                            show_code_part_link.fadeOut();
                            hide_code_part.fadeIn();
                       }
                });
                function media_upload( button_class) {
                    var _custom_media = true,
                        _orig_send_attachment = wp.media.editor.send.attachment;
                    jQuery('body').on('click',button_class, function(e) {
                        var button_id ='#'+jQuery(this).attr('id');
                        /* console.log(button_id); */
                        var self = jQuery(button_id);
                        var send_attachment_bkp = wp.media.editor.send.attachment;
                        var button = jQuery(button_id);
                        var id = button.attr('id').replace('_button', '');
                        var img = jQuery(".img_url");
                        _custom_media = true;
                        wp.media.editor.send.attachment = function(props, attachment){
                            if ( _custom_media  ) {
                                img.val(attachment.url);
                            } else {
                                return _orig_send_attachment.apply( button_id, [props, attachment] );
                            }
                        }
                        wp.media.editor.open(button);
                        return false;
                    });
                }
                media_upload( '.custom_media_upload');
            });
        </script>
        <?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
        $instance['ismobile'] = ( ! empty( $new_instance['ismobile'] ) ) ? strip_tags( $new_instance['ismobile'] ) : '';
        $instance['col'] = ( ! empty( $new_instance['col'] ) ) ? strip_tags( $new_instance['col'] ) : '';
        $instance['img'] = ( ! empty( $new_instance['img'] ) ) ? strip_tags( $new_instance['img'] ) : '';
        $instance['link'] = ( ! empty( $new_instance['link'] ) ) ? strip_tags( $new_instance['link'] ) : '';
        $instance['code'] = ( ! empty( $new_instance['code'] ) ) ? strip_tags( $new_instance['code'] ) : '';
        $instance['iscode'] = ( ! empty( $new_instance['iscode'] ) ) ? strip_tags( $new_instance['iscode'] ) : '';

        return $instance;
    }

}

new wpb_widget_tab_ads();